/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.BoatDirection;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PointOfSail;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PathGenerator1Turner360;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.PolarDiagramBase;
import com.sap.sailing.simulator.impl.SimulationParametersImpl;
import com.sap.sailing.simulator.impl.SparseSimulationDataException;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindField;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;

public class PathGeneratorOpportunistEuclidian360
extends PathGeneratorBase {
    private static Logger logger = Logger.getLogger("com.sap.sailing");
    int turns;
    boolean startLeft;
    boolean upwindLeg = false;

    public PathGeneratorOpportunistEuclidian360(SimulationParameters params) {
        PolarDiagramBase polarDiagramClone = new PolarDiagramBase((PolarDiagramBase)params.getBoatPolarDiagram());
        this.parameters = new SimulationParametersImpl(params.getCourse(), params.getStartLine(), params.getEndLine(), polarDiagramClone, params.getWindField(), params.getSimuStep(), params.getMode(), params.showOmniscient(), params.showOpportunist(), params.getLegType());
    }

    public void setEvaluationParameters(boolean startLeft) {
        this.startLeft = startLeft;
    }

    public int getTurns() {
        return this.turns;
    }

    public boolean isSameBaseDirection(BoatDirection direction1, BoatDirection direction2) {
        boolean result = this.isBaseDirectionLeft(direction1) && this.isBaseDirectionLeft(direction2);
        result |= this.isBaseDirectionRight(direction1) && this.isBaseDirectionRight(direction2);
        return result |= direction1 == BoatDirection.NONE || direction2 == BoatDirection.NONE;
    }

    public boolean isBaseDirectionLeft(BoatDirection direction) {
        return direction == BoatDirection.BEAT_LEFT || direction == BoatDirection.JIBE_LEFT || direction == BoatDirection.REACH_LEFT;
    }

    public boolean isBaseDirectionRight(BoatDirection direction) {
        return direction == BoatDirection.BEAT_RIGHT || direction == BoatDirection.JIBE_RIGHT || direction == BoatDirection.REACH_RIGHT;
    }

    @Override
    public Path getPath() throws SparseSimulationDataException {
        this.algorithmStartTime = MillisecondsTimePoint.now();
        WindFieldGenerator wf = this.parameters.getWindField();
        PolarDiagram polarDiagram = this.parameters.getBoatPolarDiagram();
        Position startPos = this.parameters.getCourse().get(0);
        Position endPos = this.parameters.getCourse().get(1);
        Bearing bearVrt = startPos.getBearingGreatCircle(endPos);
        List<Position> startLine = this.parameters.getStartLine();
        if (startLine != null) {
            Position startPositionRight;
            Position startPositionLeft;
            Bearing bearStartLine = startLine.get(0).getBearingGreatCircle(startLine.get(1));
            double diffStartLineVrt = bearVrt.getDifferenceTo(bearStartLine).getDegrees();
            if (diffStartLineVrt > 0.0 && diffStartLineVrt < 180.0) {
                startPositionLeft = startLine.get(0);
                startPositionRight = startLine.get(1);
            } else {
                startPositionLeft = startLine.get(1);
                startPositionRight = startLine.get(0);
            }
            startPos = this.startLeft ? startPositionLeft : startPositionRight;
            bearVrt = startPos.getBearingGreatCircle(endPos);
        }
        TimePoint startTime = wf.getStartTime();
        ArrayList<TimedPositionWithSpeed> path = new ArrayList<TimedPositionWithSpeed>();
        Position currentPosition = startPos;
        TimePoint currentTime = startTime;
        double currentHeight = startPos.getDistance(endPos).getMeters();
        BoatDirection prevDirection = BoatDirection.NONE;
        BoatDirection prevPrevDirection = BoatDirection.NONE;
        long turnLoss = polarDiagram.getTurnLoss();
        double fracFinishPhase = 0.05;
        Wind wndStart = wf.getWind(new TimedPositionWithSpeedImpl(startTime, startPos, null));
        logger.finest("wndStart speed:" + wndStart.getKnots() + " angle:" + wndStart.getBearing().getDegrees());
        polarDiagram.setWind((SpeedWithBearing)wndStart);
        Bearing bearStart = currentPosition.getBearingGreatCircle(endPos);
        path.add(new TimedPositionWithSpeedImpl(startTime, startPos, (SpeedWithBearing)wndStart));
        String pathStr = "0";
        long timeStep = this.parameters.getSimuStep() != null ? (this.parameters.getSimuStep().asMillis() > 2L * turnLoss ? this.parameters.getSimuStep().asMillis() : 2L * turnLoss) : wf.getTimeStep().asMillis() / 2L;
        logger.fine("Time step :" + timeStep);
        String legType = "none";
        if (this.parameters.getLegType() == null) {
            Bearing bearRCWind = wndStart.getBearing().getDifferenceTo(bearStart);
            legType = "downwind";
            this.upwindLeg = false;
            if (Math.abs(bearRCWind.getDegrees()) > 90.0 && Math.abs(bearRCWind.getDegrees()) < 270.0) {
                legType = "upwind";
                this.upwindLeg = true;
            }
        } else if (this.parameters.getLegType() == LegType.UPWIND) {
            legType = "upwind";
            this.upwindLeg = true;
        } else {
            legType = "downwind";
            this.upwindLeg = false;
        }
        int timeStepScale = 1;
        if (!this.upwindLeg) {
            timeStepScale = 2;
            timeStep /= (long)timeStepScale;
            turnLoss /= (long)timeStepScale;
        }
        logger.fine("Leg Direction: " + legType);
        this.turns = 0;
        while (currentHeight > startPos.getDistance(endPos).getMeters() * fracFinishPhase && path.size() < 500 && !this.isTimedOut()) {
            long nextTimeVal = currentTime.asMillis() + timeStep;
            MillisecondsTimePoint nextTime = new MillisecondsTimePoint(nextTimeVal);
            Bearing bearTarget = currentPosition.getBearingGreatCircle(endPos);
            Wind currentWind = wf.getWind(new TimedPositionWithSpeedImpl(currentTime, currentPosition, null));
            logger.finest("cWind speed:" + currentWind.getKnots() + " angle:" + currentWind.getBearing().getDegrees());
            polarDiagram.setWind((SpeedWithBearing)currentWind);
            Util.Pair<PointOfSail, BoatDirection> pointOfSailAndReachingSide = polarDiagram.getPointOfSail(bearTarget);
            PointOfSail pointOfSail = (PointOfSail)((Object)pointOfSailAndReachingSide.getA());
            BoatDirection reachingSide = (BoatDirection)((Object)pointOfSailAndReachingSide.getB());
            if (pointOfSail == PointOfSail.TACKING || pointOfSail == PointOfSail.JIBING) {
                MillisecondsTimePoint travelTimeRight;
                MillisecondsTimePoint travelTimeLeft;
                Bearing bearRight;
                Bearing bearLeft;
                if (pointOfSail == PointOfSail.TACKING) {
                    bearLeft = polarDiagram.optimalDirectionsUpwind()[0];
                    bearRight = polarDiagram.optimalDirectionsUpwind()[1];
                } else {
                    bearLeft = polarDiagram.optimalDirectionsDownwind()[1];
                    bearRight = polarDiagram.optimalDirectionsDownwind()[0];
                }
                SpeedWithBearing boatSpeedLeft = polarDiagram.getSpeedAtBearing(bearLeft);
                if (boatSpeedLeft.getKnots() == 0.0) {
                    logger.severe("Travel Speed for NextDirection 'L' is ZERO. This must NOT happen.");
                    throw new SparseSimulationDataException();
                }
                SpeedWithBearing boatSpeedRight = polarDiagram.getSpeedAtBearing(bearRight);
                if (boatSpeedRight.getKnots() == 0.0) {
                    logger.severe("Travel Speed for NextDirection 'R' is ZERO. This must NOT happen.");
                    throw new SparseSimulationDataException();
                }
                logger.finest("left boat speed:" + boatSpeedLeft.getKnots() + " angle:" + boatSpeedLeft.getBearing().getDegrees() + "  right boat speed:" + boatSpeedRight.getKnots() + " angle:" + boatSpeedRight.getBearing().getDegrees());
                if (this.isBaseDirectionLeft(prevDirection)) {
                    travelTimeLeft = new MillisecondsTimePoint(nextTimeVal);
                    travelTimeRight = new MillisecondsTimePoint(nextTimeVal - turnLoss);
                } else if (this.isBaseDirectionRight(prevDirection)) {
                    travelTimeLeft = new MillisecondsTimePoint(nextTimeVal - turnLoss);
                    travelTimeRight = new MillisecondsTimePoint(nextTimeVal);
                } else {
                    travelTimeLeft = new MillisecondsTimePoint(nextTimeVal);
                    travelTimeRight = new MillisecondsTimePoint(nextTimeVal);
                }
                Position nextBoatPositionLeft = boatSpeedLeft.travelTo(currentPosition, currentTime, (TimePoint)travelTimeLeft);
                Position nextBoatPositionRight = boatSpeedRight.travelTo(currentPosition, currentTime, (TimePoint)travelTimeRight);
                Distance targetDistanceLeft = nextBoatPositionLeft.getDistance(endPos);
                Distance targetDistanceRight = nextBoatPositionRight.getDistance(endPos);
                double targetDistanceMetersLeft = (double)Math.round(targetDistanceLeft.getMeters() * 1000.0) / 1000.0;
                double targetDistanceMetersRight = (double)Math.round(targetDistanceRight.getMeters() * 1000.0) / 1000.0;
                prevPrevDirection = prevDirection;
                if (prevDirection == BoatDirection.NONE && startLine == null) {
                    if (this.startLeft) {
                        if (pointOfSail == PointOfSail.TACKING) {
                            path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextBoatPositionLeft, (SpeedWithBearing)currentWind));
                            pathStr = String.valueOf(pathStr) + "L";
                            currentPosition = nextBoatPositionLeft;
                            prevDirection = BoatDirection.BEAT_LEFT;
                        } else {
                            path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextBoatPositionRight, (SpeedWithBearing)currentWind));
                            pathStr = String.valueOf(pathStr) + "r";
                            currentPosition = nextBoatPositionRight;
                            prevDirection = BoatDirection.JIBE_RIGHT;
                        }
                    } else if (pointOfSail == PointOfSail.TACKING) {
                        path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextBoatPositionRight, (SpeedWithBearing)currentWind));
                        pathStr = String.valueOf(pathStr) + "R";
                        currentPosition = nextBoatPositionRight;
                        prevDirection = BoatDirection.BEAT_RIGHT;
                    } else {
                        path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextBoatPositionLeft, (SpeedWithBearing)currentWind));
                        pathStr = String.valueOf(pathStr) + "l";
                        currentPosition = nextBoatPositionLeft;
                        prevDirection = BoatDirection.JIBE_LEFT;
                    }
                } else if (targetDistanceMetersLeft <= targetDistanceMetersRight) {
                    path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextBoatPositionLeft, (SpeedWithBearing)currentWind));
                    currentPosition = nextBoatPositionLeft;
                    if (this.isBaseDirectionRight(prevDirection)) {
                        ++this.turns;
                    }
                    if (pointOfSail == PointOfSail.TACKING) {
                        prevDirection = BoatDirection.BEAT_LEFT;
                        pathStr = String.valueOf(pathStr) + "L";
                    } else {
                        prevDirection = BoatDirection.JIBE_LEFT;
                        pathStr = String.valueOf(pathStr) + "l";
                    }
                } else {
                    path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextBoatPositionRight, (SpeedWithBearing)currentWind));
                    currentPosition = nextBoatPositionRight;
                    if (this.isBaseDirectionLeft(prevDirection)) {
                        ++this.turns;
                    }
                    if (pointOfSail == PointOfSail.TACKING) {
                        prevDirection = BoatDirection.BEAT_RIGHT;
                        pathStr = String.valueOf(pathStr) + "R";
                    } else {
                        prevDirection = BoatDirection.JIBE_RIGHT;
                        pathStr = String.valueOf(pathStr) + "r";
                    }
                }
            } else if (pointOfSail == PointOfSail.REACHING) {
                MillisecondsTimePoint travelTimeReach = this.isSameBaseDirection(reachingSide, prevDirection) ? new MillisecondsTimePoint(nextTimeVal) : new MillisecondsTimePoint(nextTimeVal - turnLoss);
                SpeedWithBearing boatSpeedTarget = polarDiagram.hasCurrent() ? polarDiagram.getSpeedAtBearingOverGround(bearTarget) : polarDiagram.getSpeedAtBearing(bearTarget);
                if (boatSpeedTarget.getKnots() == 0.0 && !polarDiagram.hasCurrent()) {
                    logger.severe("Travel Speed for NextDirection '" + (reachingSide == BoatDirection.REACH_LEFT ? "D" : "E") + "' is ZERO. This must NOT happen.");
                    throw new SparseSimulationDataException();
                }
                Position nextBoatPositionReach = boatSpeedTarget.travelTo(currentPosition, currentTime, (TimePoint)travelTimeReach);
                path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, nextBoatPositionReach, (SpeedWithBearing)currentWind));
                currentPosition = nextBoatPositionReach;
                if (!this.isSameBaseDirection(reachingSide, prevDirection)) {
                    ++this.turns;
                }
                prevPrevDirection = prevDirection;
                prevDirection = reachingSide;
                pathStr = reachingSide == BoatDirection.REACH_LEFT ? String.valueOf(pathStr) + "D" : String.valueOf(pathStr) + "E";
            }
            currentTime = nextTime;
            Position posHeight = currentPosition.projectToLineThrough(startPos, bearStart);
            currentHeight = startPos.getDistance(endPos).getMeters() - posHeight.getDistance(startPos).getMeters();
        }
        if (currentHeight < startPos.getDistance(endPos).getMeters() * fracFinishPhase / 2.0) {
            path.remove(path.size() - 1);
            currentTime = ((TimedPositionWithSpeed)path.get(path.size() - 1)).getTimePoint();
            currentPosition = ((TimedPositionWithSpeed)path.get(path.size() - 1)).getPosition();
            prevDirection = prevPrevDirection;
        } else {
            Bearing nextBearTarget = currentPosition.getBearingGreatCircle(endPos);
            Util.Pair<PointOfSail, BoatDirection> nextPointOfSailAndReachingSide = polarDiagram.getPointOfSail(nextBearTarget);
            PointOfSail nextPointOfSail = (PointOfSail)((Object)nextPointOfSailAndReachingSide.getA());
            if (nextPointOfSail == PointOfSail.REACHING) {
                path.remove(path.size() - 1);
                currentTime = ((TimedPositionWithSpeed)path.get(path.size() - 1)).getTimePoint();
                currentPosition = ((TimedPositionWithSpeed)path.get(path.size() - 1)).getPosition();
                prevDirection = prevPrevDirection;
            }
        }
        if (!this.isTimedOut()) {
            MillisecondsTimePoint rightTurningTime;
            TimePoint leftTurningTime;
            PathGenerator1Turner360 generator1Turner = new PathGenerator1Turner360(this.parameters);
            if (this.isBaseDirectionLeft(prevDirection)) {
                leftTurningTime = currentTime;
                rightTurningTime = new MillisecondsTimePoint(currentTime.asMillis() + turnLoss);
            } else {
                leftTurningTime = new MillisecondsTimePoint(currentTime.asMillis() + turnLoss);
                rightTurningTime = currentTime;
            }
            long finishTimeStep = Math.max(500L, timeStep / 10L);
            int finishStepsLeft = (int)Math.round((double)(5L * (((TimedPositionWithSpeed)path.get(path.size() - 1)).getTimePoint().asMillis() - ((TimedPositionWithSpeed)path.get(0)).getTimePoint().asMillis())) / (1.0 - fracFinishPhase) * fracFinishPhase / (double)finishTimeStep);
            generator1Turner.setEvaluationParameters(true, currentPosition, endPos, leftTurningTime, finishTimeStep, finishStepsLeft, 0.2, this.upwindLeg);
            Path leftPath = generator1Turner.getPath();
            int finishStepsRight = (int)Math.round((double)(5L * (((TimedPositionWithSpeed)path.get(path.size() - 1)).getTimePoint().asMillis() - ((TimedPositionWithSpeed)path.get(0)).getTimePoint().asMillis())) / (1.0 - fracFinishPhase) * fracFinishPhase / (double)finishTimeStep);
            generator1Turner.setEvaluationParameters(false, currentPosition, endPos, (TimePoint)rightTurningTime, finishTimeStep, finishStepsRight, 0.2, this.upwindLeg);
            Path rightPath = generator1Turner.getPath();
            if (leftPath.getPathPoints() != null && rightPath.getPathPoints() != null) {
                if (leftPath.getFinalTime().asMillis() <= rightPath.getFinalTime().asMillis()) {
                    path.addAll(leftPath.getPathPoints());
                } else {
                    path.addAll(rightPath.getPathPoints());
                }
            } else if (leftPath.getPathPoints() != null) {
                path.addAll(leftPath.getPathPoints());
            } else if (rightPath.getPathPoints() != null) {
                path.addAll(rightPath.getPathPoints());
            }
        }
        TimedPosition finalPosition = (TimedPosition)path.get(path.size() - 1);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(finalPosition.getTimePoint().asMillis() - startTime.asMillis());
        SimpleDateFormat racetimeFormat = new SimpleDateFormat("HH:mm:ss:SSS");
        racetimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String racetimeFormatted = racetimeFormat.format(cal.getTime());
        logger.fine("Start Condition: 0" + (this.startLeft ? "L" : "R") + "\nPath: " + pathStr + "\n      Time: " + racetimeFormatted + ", Distance: " + String.format("%.2f", (double)Math.round(finalPosition.getPosition().getDistance(endPos).getMeters() * 100.0) / 100.0) + " meters" + ", " + this.turns + " Turn" + (this.turns > 1 ? "s" : ""));
        return new PathImpl(path, (WindField)wf, this.getTurns(), this.algorithmTimedOut);
    }
}

