/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.Result;
import com.chargebee.internal.Request;
import com.chargebee.models.PortalSession;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiRequest;
import com.sap.sse.security.subscription.chargebee.ChargebeeInternalApiRequestWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChargebeeSelfServicePortalSessionRequest
extends ChargebeeApiRequest {
    private static final Logger logger = Logger.getLogger(ChargebeeSelfServicePortalSessionRequest.class.getName());
    private final String userId;
    private final OnResultListener listener;

    public ChargebeeSelfServicePortalSessionRequest(String userId, OnResultListener listener, SubscriptionApiRequestProcessor requestProcessor, SubscriptionApiBaseService chargebeeApiServiceParams) {
        super(requestProcessor, chargebeeApiServiceParams);
        this.userId = userId;
        this.listener = listener;
    }

    @Override
    protected ChargebeeInternalApiRequestWrapper createRequest() {
        logger.info(() -> "Fetch Chargebee Self-Service Portal session, user id: " + this.userId);
        PortalSession.CreateRequest request = PortalSession.create().customerId(this.userId);
        return new ChargebeeInternalApiRequestWrapper((Request<?>)request);
    }

    @Override
    protected void processResult(ChargebeeInternalApiRequestWrapper request) {
        Result result = request.getResult();
        PortalSession session = result != null ? result.portalSession() : null;
        this.onDone(session);
    }

    @Override
    protected void handleError(Exception e) {
        logger.log(Level.SEVERE, "Fetch Chargebee Self-Service Portal session failed, user id: " + this.userId, e);
        this.onDone(null);
    }

    private void onDone(PortalSession session) {
        if (this.listener != null) {
            this.listener.onSessionResult(session);
        }
    }

    public static interface OnResultListener {
        public void onSessionResult(PortalSession var1);
    }
}

