/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeItemPriceListRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ChargebeeFetchItemPricesTask
implements ChargebeeItemPriceListRequest.OnResultListener {
    private static final Logger logger = Logger.getLogger(ChargebeeFetchItemPricesTask.class.getName());
    private final SubscriptionApiRequestProcessor requestProcessor;
    private final OnResultListener listener;
    private Map<String, BigDecimal> itemPrices;
    private final SubscriptionApiBaseService chargebeeApiServiceParams;

    public ChargebeeFetchItemPricesTask(SubscriptionApiRequestProcessor requestProcessor, OnResultListener listener, SubscriptionApiBaseService chargebeeApiServiceParams) {
        this.requestProcessor = requestProcessor;
        this.listener = listener;
        this.chargebeeApiServiceParams = chargebeeApiServiceParams;
    }

    public void run() {
        this.fetchItemPriceList(null);
    }

    @Override
    public void onItemPriceResult(Map<String, BigDecimal> itemPrices, String nextOffset) {
        if (this.itemPrices == null) {
            this.itemPrices = new HashMap<String, BigDecimal>();
        }
        if (itemPrices != null) {
            this.itemPrices.putAll(itemPrices);
        }
        this.itemPrices.putAll(itemPrices);
        if (nextOffset == null || nextOffset.isEmpty()) {
            this.onDone();
        } else {
            this.fetchItemPriceList(nextOffset);
        }
    }

    private void fetchItemPriceList(String offset) {
        logger.info(() -> "Schedule fetch Chargebee ItemPrices, offset: " + (offset == null ? "" : offset));
        this.requestProcessor.addRequest(new ChargebeeItemPriceListRequest(offset, this, this.requestProcessor, this.chargebeeApiServiceParams));
    }

    private void onDone() {
        if (this.listener != null) {
            this.listener.onItemPriceResult(this.itemPrices);
        }
    }

    @FunctionalInterface
    public static interface OnResultListener {
        public void onItemPriceResult(Map<String, BigDecimal> var1);
    }
}

