/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription;

import com.sap.sse.security.SecurityService;
import com.sap.sse.security.subscription.SubscriptionApiService;
import com.sap.sse.security.subscription.SubscriptionUpdateTask;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class SubscriptionBackgroundUpdater {
    private static final Logger logger = Logger.getLogger(SubscriptionBackgroundUpdater.class.getName());
    private final ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
    private final ServiceTracker<SubscriptionApiService, SubscriptionApiService> subscriptionApiServiceTracker;

    public SubscriptionBackgroundUpdater(BundleContext context) {
        this.subscriptionApiServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, SubscriptionApiService.class);
    }

    public void start(CompletableFuture<SecurityService> securityService) {
        logger.info(() -> "Start subscription background update task");
        this.executor.schedule(new SubscriptionUpdateTask(securityService, this.subscriptionApiServiceTracker), 1L, TimeUnit.MINUTES);
    }
}

