/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.impl;

import com.sap.sse.ServerInfo;
import com.sap.sse.classloading.ServiceTrackerCustomizerForClassLoaderSupplierRegistrations;
import com.sap.sse.mail.MailService;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.rest.CORSFilterConfiguration;
import com.sap.sse.security.SecurityInitializationCustomizer;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SecurityServiceInitialLoadClassLoaderSupplier;
import com.sap.sse.security.UsernamePasswordRealm;
import com.sap.sse.security.impl.OSGIHasPermissionsProvider;
import com.sap.sse.security.impl.OSGISubscriptionPlanProvider;
import com.sap.sse.security.impl.ReplicatingCacheManager;
import com.sap.sse.security.impl.SecurityServiceImpl;
import com.sap.sse.security.interfaces.AccessControlStore;
import com.sap.sse.security.interfaces.UserStore;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.HasPermissionsProvider;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SubscriptionPlanProvider;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.UserGroupManagementException;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.UserStoreManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.PermissionAndRoleAssociation;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.subscription.SSESubscriptionPlan;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessorImpl;
import com.sap.sse.security.subscription.SubscriptionApiService;
import com.sap.sse.security.subscription.SubscriptionBackgroundUpdater;
import com.sap.sse.security.subscription.SubscriptionPlanBackgroundUpdater;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiService;
import com.sap.sse.security.subscription.chargebee.ChargebeeConfiguration;
import com.sap.sse.shared.classloading.ClassLoaderRegistry;
import com.sap.sse.util.ClearStateTestSupport;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.cache.CacheManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static BundleContext context;
    private static CompletableFuture<SecurityService> securityService;
    private ServiceRegistration<?> registration;
    private static UserStore testUserStore;
    private static AccessControlStore testAccessControlStore;
    private ServiceTracker<SecurityInitializationCustomizer, SecurityInitializationCustomizer> securityInitializationCustomizerTracker;
    private ServiceTracker<UserStore, UserStore> userStoreTracker;
    private ServiceTracker<AccessControlStore, AccessControlStore> accessControlStoreTracker;
    public static final String SHARED_ACROSS_SUBDOMAINS_OF_PROPERTY_NAME = "security.sharedAcrossSubdomainsOf";
    private final String sharedAcrossSubdomainsOf = System.getProperty("security.sharedAcrossSubdomainsOf");
    public static final String BASE_URL_FOR_CROSS_DOMAIN_STORAGE_PROPERTY_NAME = "security.baseUrlForCrossDomainStorage";
    private final String baseUrlForCrossDomainStorage = System.getProperty("security.baseUrlForCrossDomainStorage");
    private ServiceTracker<SecurityServiceInitialLoadClassLoaderSupplier, SecurityServiceInitialLoadClassLoaderSupplier> classLoaderSupplierServiceTracker;

    static {
        securityService = new CompletableFuture();
    }

    public static void setTestStores(UserStore theTestUserStore, AccessControlStore theTestAccessControlStore) {
        testUserStore = theTestUserStore;
        testAccessControlStore = theTestAccessControlStore;
        UsernamePasswordRealm.setTestStores(theTestUserStore, theTestAccessControlStore);
    }

    public static void setSecurityService(SecurityService securityService) {
        Activator.securityService.complete(securityService);
    }

    public static BundleContext getContext() {
        return context;
    }

    public static SecurityService getSecurityService() {
        try {
            return securityService.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.SEVERE, "Failure to get SecurityService", e);
            throw new RuntimeException(e);
        }
    }

    public Activator() {
        if (this.sharedAcrossSubdomainsOf == null != (this.baseUrlForCrossDomainStorage == null)) {
            logger.warning("This looks like an inconsistent configuration. The security service uses " + this.sharedAcrossSubdomainsOf + " as shared cookie domain but " + this.baseUrlForCrossDomainStorage + " as cross-domain storage origin. " + " Either leave both null or set both consistently, e.g., " + "to \"sapsailing.com\" and \"https://www.sapsailing.com\", respectively");
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        SubscriptionPlanProvider subscriptionPlanProvider = this.createAndOpenSubscriptionPlanProvider(bundleContext);
        this.createAndRegisterSubscriptionServices(subscriptionPlanProvider);
        if (testUserStore != null && testAccessControlStore != null) {
            this.createAndRegisterSecurityService(bundleContext, testUserStore, testAccessControlStore, subscriptionPlanProvider);
        } else {
            this.waitForUserStoreService(bundleContext, subscriptionPlanProvider);
        }
        context.registerService(ClearStateTestSupport.class, (Object)new ClearStateTestSupport(){

            public void clearState() throws Exception {
                Activator.this.clearState();
            }
        }, null);
    }

    private SubscriptionPlanProvider createAndOpenSubscriptionPlanProvider(BundleContext bundleContext) {
        ServiceTracker subscriptionPlanProviderTracker = new ServiceTracker(bundleContext, SubscriptionPlanProvider.class, null);
        subscriptionPlanProviderTracker.open();
        return new OSGISubscriptionPlanProvider((ServiceTracker<SubscriptionPlanProvider, SubscriptionPlanProvider>)subscriptionPlanProviderTracker);
    }

    private void createAndRegisterSubscriptionServices(SubscriptionPlanProvider subscriptionPlanProvider) {
        SubscriptionApiRequestProcessorImpl subscriptionApiRequestProcessor = new SubscriptionApiRequestProcessorImpl(ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor());
        ChargebeeApiService chargebeeApiService = new ChargebeeApiService(ChargebeeConfiguration.getInstance(), subscriptionApiRequestProcessor, subscriptionPlanProvider);
        Hashtable<String, String> chargebeeProviderProperties = new Hashtable<String, String>();
        ((Dictionary)chargebeeProviderProperties).put("provider-name", chargebeeApiService.getProviderName());
        context.registerService(SubscriptionApiService.class.getName(), (Object)chargebeeApiService, chargebeeProviderProperties);
    }

    protected void clearState() throws InterruptedException, UserGroupManagementException, UserManagementException {
        CacheManager cm = Activator.getSecurityService().getCacheManager();
        if (cm instanceof ReplicatingCacheManager) {
            ((ReplicatingCacheManager)cm).clear();
        }
        UserStore userStore = (UserStore)this.userStoreTracker.waitForService(0L);
        AccessControlStore accessControlStore = (AccessControlStore)this.accessControlStoreTracker.waitForService(0L);
        userStore.clear();
        accessControlStore.clear();
        userStore.ensureDefaultRolesExist();
        userStore.ensureServerGroupExists();
        Activator.getSecurityService().initialize();
        this.applyCustomizations();
    }

    private void createAndRegisterSecurityService(BundleContext bundleContext, UserStore userStore, AccessControlStore accessControlStore, SubscriptionPlanProvider subscriptionPlanProvider) {
        ServiceTracker hasPermissionsProviderTracker = new ServiceTracker(bundleContext, HasPermissionsProvider.class, null);
        hasPermissionsProviderTracker.open();
        SecurityServiceImpl initialSecurityService = new SecurityServiceImpl((ServiceTracker<MailService, MailService>)ServiceTrackerFactory.createAndOpen((BundleContext)context, MailService.class), (ServiceTracker<CORSFilterConfiguration, CORSFilterConfiguration>)ServiceTrackerFactory.createAndOpen((BundleContext)context, CORSFilterConfiguration.class), userStore, accessControlStore, new OSGIHasPermissionsProvider((ServiceTracker<HasPermissionsProvider, HasPermissionsProvider>)hasPermissionsProviderTracker), subscriptionPlanProvider, this.sharedAcrossSubdomainsOf, this.baseUrlForCrossDomainStorage);
        initialSecurityService.initialize();
        securityService.complete(initialSecurityService);
        this.registration = context.registerService(SecurityService.class, (Object)initialSecurityService, null);
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", initialSecurityService.getId().toString());
        context.registerService(Replicable.class.getName(), (Object)initialSecurityService, replicableServiceProperties);
        context.registerService(ClearStateTestSupport.class.getName(), (Object)initialSecurityService, null);
        context.registerService(HasPermissionsProvider.class, SecuredSecurityTypes::getAllInstances, null);
        context.registerService(SubscriptionPlanProvider.class, SSESubscriptionPlan::getAllInstances, null);
        this.classLoaderSupplierServiceTracker = ServiceTrackerCustomizerForClassLoaderSupplierRegistrations.createClassLoaderSupplierServiceTracker((BundleContext)bundleContext, SecurityServiceInitialLoadClassLoaderSupplier.class, (ClassLoaderRegistry)initialSecurityService.getInitialLoadClassLoaderRegistry());
        logger.info("Successfully created service tracker for class loader suppliers: " + this.classLoaderSupplierServiceTracker);
        context.registerService(SubscriptionPlanProvider.class, SSESubscriptionPlan::getAllInstances, null);
        Logger.getLogger(Activator.class.getName()).info("Security Service registered.");
    }

    private void applyCustomizations() {
        if (this.securityInitializationCustomizerTracker != null) {
            this.securityInitializationCustomizerTracker.close();
        }
        this.securityInitializationCustomizerTracker = new ServiceTracker(context, SecurityInitializationCustomizer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SecurityInitializationCustomizer, SecurityInitializationCustomizer>(){

            public SecurityInitializationCustomizer addingService(ServiceReference<SecurityInitializationCustomizer> reference) {
                SecurityInitializationCustomizer service = (SecurityInitializationCustomizer)context.getService(reference);
                Activator.getSecurityService().registerCustomizer(service);
                return service;
            }

            public void modifiedService(ServiceReference<SecurityInitializationCustomizer> reference, SecurityInitializationCustomizer service) {
            }

            public void removedService(ServiceReference<SecurityInitializationCustomizer> reference, SecurityInitializationCustomizer service) {
            }
        });
        this.securityInitializationCustomizerTracker.open();
    }

    private void waitForUserStoreService(final BundleContext bundleContext, final SubscriptionPlanProvider subscriptionPlanProvider) {
        context = bundleContext;
        this.userStoreTracker = new ServiceTracker(bundleContext, UserStore.class, null);
        this.accessControlStoreTracker = new ServiceTracker(bundleContext, AccessControlStore.class, null);
        this.userStoreTracker.open();
        this.accessControlStoreTracker.open();
        new Thread("ServiceTracker waiting for UserStore service"){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    logger.info("Waiting for UserStore service...");
                    UserStore userStore = (UserStore)Activator.this.userStoreTracker.waitForService(0L);
                    AccessControlStore accessControlStore = (AccessControlStore)Activator.this.accessControlStoreTracker.waitForService(0L);
                    logger.info("Obtained UserStore service " + userStore);
                    userStore.ensureDefaultRolesExist();
                    userStore.loadAndMigrateUsers();
                    accessControlStore.loadACLsAndOwnerships();
                    Activator.this.createAndRegisterSecurityService(bundleContext, userStore, accessControlStore, subscriptionPlanProvider);
                    Activator.this.applyCustomizations();
                    Activator.this.migrate(userStore, (SecurityService)securityService.get());
                    ReplicationMasterDescriptor masterDescriptor = ((SecurityService)securityService.get()).getMasterDescriptor();
                    if (masterDescriptor == null) {
                        Activator.this.startSubscriptionDataUpdateTask(bundleContext);
                        Activator.this.startSubscriptionPlanUpdateTask(bundleContext);
                    }
                }
                catch (UserStoreManagementException | InterruptedException | ExecutionException e) {
                    logger.log(Level.SEVERE, "Interrupted while waiting for UserStore service", e);
                }
            }
        }.start();
    }

    private void migrate(UserStore userStore, SecurityService securityService) {
        for (User user : userStore.getUsers()) {
            securityService.migrateUser(user);
        }
        for (UserGroup group : userStore.getUserGroups()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)group);
        }
        for (RoleDefinition role : userStore.getRoleDefinitions()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)role);
        }
        for (User user : securityService.getUserList()) {
            for (Role role : user.getRoles()) {
                TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((Role)role, (User)user);
                QualifiedObjectIdentifier associationQualifiedIdentifier = SecuredSecurityTypes.ROLE_ASSOCIATION.getQualifiedObjectIdentifier(associationTypeIdentifier);
                securityService.migrateOwnership(associationQualifiedIdentifier, associationTypeIdentifier.toString());
                if (!securityService.isInitialOrMigration()) continue;
                securityService.addToAccessControlList(associationQualifiedIdentifier, null, HasPermissions.DefaultActions.READ.name());
            }
            for (WildcardPermission permission : user.getPermissions()) {
                securityService.migratePermission(user, permission, this::getPermissionReplacement);
                TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((WildcardPermission)permission, (User)user);
                QualifiedObjectIdentifier associationQualifiedIdentifier = SecuredSecurityTypes.PERMISSION_ASSOCIATION.getQualifiedObjectIdentifier(associationTypeIdentifier);
                securityService.migrateOwnership(associationQualifiedIdentifier, associationTypeIdentifier.toString());
                if (!securityService.isInitialOrMigration()) continue;
                securityService.addToAccessControlList(associationQualifiedIdentifier, null, HasPermissions.DefaultActions.READ.name());
            }
        }
        securityService.migrateServerObject();
        securityService.checkMigration(SecuredSecurityTypes.getAllInstances());
    }

    public WildcardPermission getPermissionReplacement(WildcardPermission permission) {
        WildcardPermission replacement = "data_mining".equalsIgnoreCase(permission.toString()) ? SecuredSecurityTypes.SERVER.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})).getPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.DATA_MINING) : null;
        return replacement;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.securityInitializationCustomizerTracker != null) {
            this.securityInitializationCustomizerTracker.close();
            this.securityInitializationCustomizerTracker = null;
        }
        if (this.registration != null) {
            this.registration.unregister();
        }
        context = null;
    }

    private void startSubscriptionDataUpdateTask(BundleContext bundleContext) {
        new SubscriptionBackgroundUpdater(context).start(securityService);
    }

    private void startSubscriptionPlanUpdateTask(BundleContext bundleContext) {
        new SubscriptionPlanBackgroundUpdater(bundleContext).start(securityService);
    }
}

