/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.security.AbstractCompositeAuthorizingRealm;
import com.sap.sse.security.BearerAuthenticationToken;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.impl.Activator;
import com.sap.sse.security.interfaces.SimpleSaltedAuthenticationInfo;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.osgi.framework.BundleContext;

public class BearerTokenRealm
extends AbstractCompositeAuthorizingRealm {
    private static final Logger logger = Logger.getLogger(BearerTokenRealm.class.getName());
    private final Future<SecurityService> securityService = Activator.getContext() == null ? null : ServiceTrackerFactory.createServiceFuture((BundleContext)Activator.getContext(), SecurityService.class);

    public BearerTokenRealm() {
        this.setAuthenticationTokenClass(BearerAuthenticationToken.class);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        SimpleSaltedAuthenticationInfo sai;
        User user;
        BearerAuthenticationToken accessToken = (BearerAuthenticationToken)token;
        try {
            SecurityService mySecurityService;
            SecurityService securityService = mySecurityService = this.securityService == null ? null : this.securityService.get();
            if (mySecurityService != null) {
                if (mySecurityService.isClientIPLockedForBearerTokenAuthentication(accessToken.getClientIP())) {
                    throw new LockedAccountException("Authentication for client IP " + accessToken.getClientIP() + " with user agent " + accessToken.getUserAgent() + " is currently locked");
                }
            } else {
                logger.warning("Cannot check whether client IP/User-Agent is locked for bearer token-based authentication; security service not found");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        SimpleSaltedAuthenticationInfo result = (user = this.getUserStore().getUserByAccessToken(accessToken.getCredentials())) == null ? null : (sai = new SimpleSaltedAuthenticationInfo(user.getName(), accessToken.getCredentials(), null));
        return result;
    }
}

