/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl.fixtracker;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.racelogsensortracking.SensorFixMapperFactory;
import com.sap.sailing.domain.racelogtracking.impl.fixtracker.RaceLogFixTrackerManager;
import com.sap.sailing.domain.tracking.AbstractTrackedRegattaAndRaceObserver;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaListener;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.replication.OperationExecutionListener;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.OperationWithResultWithIdWrapper;
import com.sap.sse.replication.OperationsToMasterSender;
import com.sap.sse.replication.OperationsToMasterSendingQueue;
import com.sap.sse.replication.ReplicableWithObjectInputStream;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class RegattaLogFixTrackerRegattaListener
extends AbstractTrackedRegattaAndRaceObserver
implements TrackedRegattaListener,
ReplicableWithObjectInputStream<RegattaLogFixTrackerRegattaListener, OperationWithResult<RegattaLogFixTrackerRegattaListener, ?>> {
    private static final Logger log = Logger.getLogger(RegattaLogFixTrackerRegattaListener.class.getName());
    private final Map<RegattaAndRaceIdentifier, RaceLogFixTrackerManager> dataTrackers = new ConcurrentHashMap<RegattaAndRaceIdentifier, RaceLogFixTrackerManager>();
    private final FullyInitializedReplicableTracker<RacingEventService> racingEventServiceTracker;
    private final SensorFixMapperFactory sensorFixMapperFactory;
    private OperationsToMasterSendingQueue unsentOperationsToMasterSender;
    private final ConcurrentHashMap<OperationExecutionListener<RegattaLogFixTrackerRegattaListener>, OperationExecutionListener<RegattaLogFixTrackerRegattaListener>> operationExecutionListeners = new ConcurrentHashMap();
    private volatile boolean currentlyFillingFromInitialLoad;
    private ThreadLocal<Boolean> currentlyApplyingOperationReceivedFromMaster = ThreadLocal.withInitial(() -> false);
    private final Set<OperationWithResultWithIdWrapper<RegattaLogFixTrackerRegattaListener, ?>> operationsSentToMasterForReplication = new HashSet();
    private ReplicationMasterDescriptor master;

    public RegattaLogFixTrackerRegattaListener(FullyInitializedReplicableTracker<RacingEventService> racingEventServiceTracker, SensorFixMapperFactory sensorFixMapperFactory) {
        this.racingEventServiceTracker = racingEventServiceTracker;
        this.sensorFixMapperFactory = sensorFixMapperFactory;
        this.currentlyFillingFromInitialLoad = false;
    }

    public synchronized void regattaAdded(TrackedRegatta trackedRegatta) {
        if (!this.isReplica()) {
            super.regattaAdded(trackedRegatta);
        } else {
            log.warning("Regatta already known, not adding sensor twice");
        }
    }

    protected void onRaceAdded(RegattaAndRaceIdentifier raceIdentifier, DynamicTrackedRegatta trackedRegatta, DynamicTrackedRace trackedRace) {
        try {
            ((RacingEventService)this.racingEventServiceTracker.getInitializedService(0L)).getRaceTrackerByRegattaAndRaceIdentifier(raceIdentifier, raceTracker -> {
                try {
                    RaceLogFixTrackerManager trackerManager;
                    RaceLogFixTrackerManager oldInstance;
                    boolean added;
                    if (raceTracker != null && (added = raceTracker.add(new RaceTracker.Listener((RaceTracker)raceTracker, raceIdentifier){
                        private final /* synthetic */ RaceTracker val$raceTracker;
                        private final /* synthetic */ RegattaAndRaceIdentifier val$raceIdentifier;
                        {
                            this.val$raceTracker = raceTracker;
                            this.val$raceIdentifier = regattaAndRaceIdentifier;
                        }

                        public void onTrackerWillStop(boolean preemptive, boolean willBeRemoved) {
                            this.val$raceTracker.remove((RaceTracker.Listener)this);
                            RegattaLogFixTrackerRegattaListener.this.removeRaceLogSensorDataTracker(this.val$raceIdentifier, preemptive, willBeRemoved);
                        }
                    })) && (oldInstance = this.dataTrackers.put(raceIdentifier, trackerManager = new RaceLogFixTrackerManager(trackedRace, ((RacingEventService)this.racingEventServiceTracker.getInitializedService(0L)).getSensorFixStore(), this.sensorFixMapperFactory, true))) != null) {
                        oldInstance.stop(true, false);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void onRaceRemoved(DynamicTrackedRace trackedRace) {
        this.removeRaceLogSensorDataTracker(trackedRace.getRaceIdentifier());
    }

    private void removeRaceLogSensorDataTracker(RegattaAndRaceIdentifier raceIdentifier) {
        this.removeRaceLogSensorDataTracker(raceIdentifier, false, false);
    }

    private void removeRaceLogSensorDataTracker(RegattaAndRaceIdentifier raceIdentifier, boolean preemptive, boolean willBeRemoved) {
        RaceLogFixTrackerManager currentActiveDataTracker = this.dataTrackers.get(raceIdentifier);
        if (currentActiveDataTracker != null) {
            currentActiveDataTracker.stop(preemptive, willBeRemoved);
            this.trackerStopped(raceIdentifier, currentActiveDataTracker);
        }
    }

    private void trackerStopped(RegattaAndRaceIdentifier raceIdentifier, RaceLogFixTrackerManager trackerManager) {
        this.dataTrackers.remove(raceIdentifier, trackerManager);
    }

    public Serializable getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public ReplicationMasterDescriptor getMasterDescriptor() {
        return this.master;
    }

    public void startedReplicatingFrom(ReplicationMasterDescriptor master) {
        this.master = master;
    }

    public void stoppedReplicatingFrom(ReplicationMasterDescriptor master) {
        this.master = null;
    }

    public Iterable<OperationExecutionListener<RegattaLogFixTrackerRegattaListener>> getOperationExecutionListeners() {
        return this.operationExecutionListeners.keySet();
    }

    public void addOperationExecutionListener(OperationExecutionListener<RegattaLogFixTrackerRegattaListener> listener) {
        this.operationExecutionListeners.put(listener, listener);
    }

    public void removeOperationExecutionListener(OperationExecutionListener<RegattaLogFixTrackerRegattaListener> listener) {
        this.operationExecutionListeners.remove(listener);
    }

    public boolean isCurrentlyFillingFromInitialLoad() {
        return this.currentlyFillingFromInitialLoad;
    }

    public void setCurrentlyFillingFromInitialLoad(boolean currentlyFillingFromInitialLoad) {
        this.currentlyFillingFromInitialLoad = currentlyFillingFromInitialLoad;
    }

    public boolean isCurrentlyApplyingOperationReceivedFromMaster() {
        return this.currentlyApplyingOperationReceivedFromMaster.get();
    }

    public void setCurrentlyApplyingOperationReceivedFromMaster(boolean currentlyApplyingOperationReceivedFromMaster) {
        this.currentlyApplyingOperationReceivedFromMaster.set(currentlyApplyingOperationReceivedFromMaster);
    }

    public void addOperationSentToMasterForReplication(OperationWithResultWithIdWrapper<RegattaLogFixTrackerRegattaListener, ?> operationWithResultWithIdWrapper) {
        this.operationsSentToMasterForReplication.add(operationWithResultWithIdWrapper);
    }

    public boolean hasSentOperationToMaster(OperationWithResult<RegattaLogFixTrackerRegattaListener, ?> operation) {
        return this.operationsSentToMasterForReplication.remove(operation);
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return new ObjectInputStream(is);
    }

    public synchronized void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream objectOutputStream) throws IOException {
    }

    public synchronized void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
        this.removeAll();
    }

    private boolean isReplica() {
        return this.master != null;
    }

    public void setUnsentOperationToMasterSender(OperationsToMasterSendingQueue service) {
        this.unsentOperationsToMasterSender = service;
    }

    public <S, O extends OperationWithResult<S, ?>, T> void scheduleForSending(O operationWithResult, OperationsToMasterSender<S, O> sender) {
        if (this.unsentOperationsToMasterSender != null) {
            this.unsentOperationsToMasterSender.scheduleForSending(operationWithResult, sender);
        }
    }
}

