/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl.fixtracker;

import com.sap.sailing.domain.abstractlog.regatta.MappingEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMarkMappingEvent;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.racelog.tracking.FixReceivedListener;
import com.sap.sailing.domain.racelog.tracking.SensorFixMapper;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.racelogsensortracking.SensorFixMapperFactory;
import com.sap.sailing.domain.racelogtracking.DeviceMappingWithRegattaLogEvent;
import com.sap.sailing.domain.racelogtracking.impl.fixtracker.RegattaLogDeviceMappings;
import com.sap.sailing.domain.tracking.DynamicGPSFixTrack;
import com.sap.sailing.domain.tracking.DynamicSensorFixTrack;
import com.sap.sailing.domain.tracking.DynamicTrack;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackingDataLoader;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.DynamicGPSFixMovingTrackImpl;
import com.sap.sailing.domain.tracking.impl.OutlierFilter;
import com.sap.sailing.domain.tracking.impl.TimedComparator;
import com.sap.sailing.domain.tracking.impl.TrackedRaceStatusImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixLoaderAndTracker
implements TrackingDataLoader {
    private static final Logger logger = Logger.getLogger(FixLoaderAndTracker.class.getName());
    private static final ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.createForegroundTaskThreadPoolExecutor(FixLoaderAndTracker.class.getSimpleName());
    private final DynamicTrackedRace trackedRace;
    private final SensorFixStore sensorFixStore;
    private RegattaLogDeviceMappings<WithID> deviceMappings;
    private final Set<AbstractLoadingJob> loadingJobs = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap<UUID, Maneuver> lastNotifiedManeuverCache = new ConcurrentHashMap();
    private final SensorFixMapperFactory sensorFixMapperFactory;
    private final boolean removeOutliersFromCompetitorTracks;
    private AtomicBoolean preemptiveStopRequested = new AtomicBoolean(false);
    private AtomicBoolean willBeRemovedAfterStopping = new AtomicBoolean(false);
    private AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final AbstractRaceChangeListener raceChangeListener = new AbstractRaceChangeListener(){

        public void startOfTrackingChanged(TimePoint oldStartOfTracking, TimePoint newStartOfTracking) {
            if (newStartOfTracking != null) {
                if (oldStartOfTracking == null) {
                    FixLoaderAndTracker.this.loadFixesWhenStartOfTrackingIsReceived();
                } else if (newStartOfTracking.before(oldStartOfTracking)) {
                    FixLoaderAndTracker.this.loadFixesForExtendedTimeRange((TimeRange)new TimeRangeImpl(newStartOfTracking, oldStartOfTracking));
                }
            }
        }

        public void endOfTrackingChanged(TimePoint oldEndOfTracking, TimePoint newEndOfTracking) {
            if (FixLoaderAndTracker.this.trackedRace.getStartOfTracking() != null) {
                if (newEndOfTracking == null && oldEndOfTracking != null) {
                    FixLoaderAndTracker.this.loadFixesForExtendedTimeRange((TimeRange)new TimeRangeImpl(oldEndOfTracking, TimePoint.EndOfTime));
                } else if (newEndOfTracking != null && oldEndOfTracking != null && oldEndOfTracking.before(newEndOfTracking)) {
                    FixLoaderAndTracker.this.loadFixesForExtendedTimeRange((TimeRange)new TimeRangeImpl(oldEndOfTracking, newEndOfTracking));
                }
            }
        }

        public void regattaLogAttached(RegattaLog regattaLog) {
            FixLoaderAndTracker.this.deviceMappings.addRegattaLog(regattaLog);
        }
    };
    private final FixReceivedListener<Timed> listener = new FixReceivedListener<Timed>(){

        public Iterable<Util.Triple<RegattaAndRaceIdentifier, Boolean, Duration>> fixReceived(DeviceIdentifier device, final Timed fix, final boolean returnManeuverChanges, final boolean returnLiveDelay) {
            final HashSet<RegattaAndRaceIdentifier> maneuverChanged = new HashSet<RegattaAndRaceIdentifier>();
            final HashMap<RegattaAndRaceIdentifier, Duration> delayToLive = new HashMap<RegattaAndRaceIdentifier, Duration>();
            if (!FixLoaderAndTracker.this.preemptiveStopRequested.get() && FixLoaderAndTracker.this.trackedRace.getStartOfTracking() != null) {
                final TimePoint timePoint = fix.getTimePoint();
                FixLoaderAndTracker.this.deviceMappings.forEachMappingOfDeviceIncludingTimePoint(device, fix.getTimePoint(), new Consumer<DeviceMappingWithRegattaLogEvent<WithID>>(){

                    @Override
                    public void accept(DeviceMappingWithRegattaLogEvent<WithID> mapping) {
                        mapping.getRegattaLogEvent().accept(new MappingEventVisitor(){

                            public void visit(RegattaLogDeviceCompetitorSensorDataMappingEvent event) {
                                this.recordSensorFixForCompetitor((Competitor)event.getMappedTo(), (RegattaLogDeviceMappingEvent<?>)event);
                            }

                            public void visit(RegattaLogDeviceBoatSensorDataMappingEvent event) {
                                Boat boat = (Boat)event.getMappedTo();
                                Competitor competitor = FixLoaderAndTracker.this.trackedRace.getCompetitorOfBoat(boat);
                                if (competitor != null) {
                                    this.recordSensorFixForCompetitor(competitor, (RegattaLogDeviceMappingEvent<?>)event);
                                } else {
                                    logger.log(Level.FINE, () -> "Could not record fix for boat because no competitor could be determined. Boat: " + boat);
                                }
                            }

                            private void recordSensorFixForCompetitor(Competitor competitor, RegattaLogDeviceMappingEvent<?> event) {
                                SensorFixMapper mapper;
                                DynamicSensorFixTrack track;
                                if (!FixLoaderAndTracker.this.preemptiveStopRequested.get() && (track = (DynamicSensorFixTrack)(mapper = FixLoaderAndTracker.this.sensorFixMapperFactory.createCompetitorMapper(event.getClass())).getTrack(FixLoaderAndTracker.this.trackedRace, (WithID)competitor)) != null && FixLoaderAndTracker.this.trackedRace.isWithinStartAndEndOfTracking(fix.getTimePoint())) {
                                    mapper.addFix((DynamicTrack)track, (DoubleVectorFix)fix);
                                    if (returnLiveDelay) {
                                        delayToLive.put(FixLoaderAndTracker.this.trackedRace.getRaceIdentifier(), new MillisecondsDurationImpl(FixLoaderAndTracker.this.trackedRace.getDelayToLiveInMillis()));
                                    }
                                }
                            }

                            public void visit(RegattaLogDeviceCompetitorMappingEvent event) {
                                this.recordForCompetitor((Competitor)event.getMappedTo());
                            }

                            public void visit(RegattaLogDeviceBoatMappingEvent event) {
                                Boat boat = (Boat)event.getMappedTo();
                                Competitor comp = FixLoaderAndTracker.this.trackedRace.getCompetitorOfBoat(boat);
                                if (comp != null) {
                                    this.recordForCompetitor(comp);
                                } else {
                                    logger.log(Level.FINE, () -> "Could not record fix for boat because no competitor could be determined. Boat: " + boat);
                                }
                            }

                            private void recordForCompetitor(Competitor comp) {
                                if (!FixLoaderAndTracker.this.preemptiveStopRequested.get()) {
                                    if (fix instanceof GPSFixMoving) {
                                        if (FixLoaderAndTracker.this.trackedRace.recordFix(comp, (GPSFixMoving)fix)) {
                                            RegattaAndRaceIdentifier maneuverChangedAnswer;
                                            if (returnManeuverChanges && (maneuverChangedAnswer = FixLoaderAndTracker.this.detectIfManeuverChanged(comp)) != null) {
                                                maneuverChanged.add(maneuverChangedAnswer);
                                            }
                                            if (returnLiveDelay) {
                                                delayToLive.put(FixLoaderAndTracker.this.trackedRace.getRaceIdentifier(), new MillisecondsDurationImpl(FixLoaderAndTracker.this.trackedRace.getDelayToLiveInMillis()));
                                            }
                                        }
                                    } else {
                                        logger.log(Level.WARNING, String.format("Could not add fix for competitor (%s) in race (%s), as it is no GPSFixMoving, meaning it is missing COG/SOG values", comp, FixLoaderAndTracker.this.trackedRace.getRace().getName()));
                                    }
                                }
                            }

                            public void visit(RegattaLogDeviceMarkMappingEvent event) {
                                if (!FixLoaderAndTracker.this.preemptiveStopRequested.get()) {
                                    boolean forceFix;
                                    Mark mark = (Mark)event.getMappedTo();
                                    DynamicGPSFixTrack markTrack = FixLoaderAndTracker.this.trackedRace.getOrCreateTrack(mark);
                                    if (FixLoaderAndTracker.this.trackedRace.isWithinStartAndEndOfTracking(fix.getTimePoint())) {
                                        forceFix = false;
                                    } else {
                                        markTrack.lockForRead();
                                        try {
                                            GPSFix firstFixAtOrAfter;
                                            if (Util.isEmpty((Iterable)markTrack.getRawFixes()) || (firstFixAtOrAfter = (GPSFix)markTrack.getFirstFixAtOrAfter(timePoint)) != null && firstFixAtOrAfter.getTimePoint().equals(timePoint)) {
                                                forceFix = true;
                                            } else {
                                                GPSFix fixAfterEndOfTracking;
                                                GPSFix fixBeforeStartOfTracking;
                                                GPSFix fixAfterStartOfTracking;
                                                TimePoint startOfTracking = FixLoaderAndTracker.this.trackedRace.getStartOfTracking();
                                                TimePoint endOfTracking = FixLoaderAndTracker.this.trackedRace.getStartOfTracking();
                                                forceFix = startOfTracking != null ? ((fixAfterStartOfTracking = (GPSFix)markTrack.getFirstFixAtOrAfter(startOfTracking)) == null || !FixLoaderAndTracker.this.trackedRace.isWithinStartAndEndOfTracking(fixAfterStartOfTracking.getTimePoint()) ? (timePoint.before(startOfTracking) ? (fixBeforeStartOfTracking = (GPSFix)markTrack.getLastFixAtOrBefore(startOfTracking)) == null || fixBeforeStartOfTracking.getTimePoint().before(timePoint) : (endOfTracking != null && timePoint.after(endOfTracking) ? (fixAfterEndOfTracking = (GPSFix)markTrack.getFirstFixAtOrAfter(endOfTracking)) == null || fixAfterEndOfTracking.getTimePoint().after(timePoint) : false)) : false) : false;
                                            }
                                        }
                                        finally {
                                            markTrack.unlockAfterRead();
                                        }
                                    }
                                    FixLoaderAndTracker.this.trackedRace.recordFix(mark, (GPSFix)fix, !forceFix);
                                    if (returnLiveDelay) {
                                        delayToLive.put(FixLoaderAndTracker.this.trackedRace.getRaceIdentifier(), new MillisecondsDurationImpl(FixLoaderAndTracker.this.trackedRace.getDelayToLiveInMillis()));
                                    }
                                }
                            }
                        });
                    }
                });
            }
            return this.mergeManeuverChangedAndLiveDelayResult(maneuverChanged, delayToLive);
        }

        private Iterable<Util.Triple<RegattaAndRaceIdentifier, Boolean, Duration>> mergeManeuverChangedAndLiveDelayResult(Set<RegattaAndRaceIdentifier> maneuverChanged, Map<RegattaAndRaceIdentifier, Duration> delayToLive) {
            HashMap<RegattaAndRaceIdentifier, Util.Pair> preResult = new HashMap<RegattaAndRaceIdentifier, Util.Pair>();
            for (Map.Entry<RegattaAndRaceIdentifier, Duration> e2 : delayToLive.entrySet()) {
                preResult.put(e2.getKey(), new Util.Pair((Object)maneuverChanged.contains(e2.getKey()), (Object)e2.getValue()));
            }
            for (RegattaAndRaceIdentifier maneuverChanges : maneuverChanged) {
                if (preResult.containsKey(maneuverChanges)) continue;
                preResult.put(maneuverChanges, new Util.Pair((Object)true, null));
            }
            return Util.map(preResult.entrySet(), e -> new Util.Triple((Object)((RegattaAndRaceIdentifier)e.getKey()), (Object)((Boolean)((Util.Pair)e.getValue()).getA()), (Object)((Duration)((Util.Pair)e.getValue()).getB())));
        }
    };

    private RegattaAndRaceIdentifier detectIfManeuverChanged(Competitor comp) {
        Maneuver lastNotifiedManeuverOrNull;
        Maneuver lastDetectedManeuver;
        boolean changed = false;
        if (comp.getId() instanceof UUID && (lastDetectedManeuver = (Maneuver)Util.latest((Iterable)this.trackedRace.getManeuvers(comp, false))) != null && !lastDetectedManeuver.equals(lastNotifiedManeuverOrNull = this.lastNotifiedManeuverCache.get(comp.getId()))) {
            this.lastNotifiedManeuverCache.put((UUID)comp.getId(), lastDetectedManeuver);
            changed = true;
            logger.info(String.valueOf(comp.getName()) + " new maneuver is " + lastDetectedManeuver);
        }
        return changed ? this.trackedRace.getRaceIdentifier() : null;
    }

    public FixLoaderAndTracker(DynamicTrackedRace trackedRace, SensorFixStore sensorFixStore, SensorFixMapperFactory sensorFixMapperFactory, boolean removeOutliersFromCompetitorTracks) {
        this.sensorFixStore = sensorFixStore;
        this.sensorFixMapperFactory = sensorFixMapperFactory;
        this.trackedRace = trackedRace;
        this.removeOutliersFromCompetitorTracks = removeOutliersFromCompetitorTracks;
        this.startTracking();
    }

    private void loadFixesForNewlyCoveredTimeRanges(WithID item, Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> newlyCoveredTimeRanges, Consumer<Double> progressConsumer, BooleanSupplier stopCallback) {
        if (this.trackedRace.getStartOfTracking() != null) {
            Mark mark;
            DynamicGPSFixTrack track;
            GPSFix firstFixAfterStartOfTracking;
            TimeRange trackingTimeRange = this.getTrackingTimeRange();
            this.loadFixesInTrackingTimeRange(newlyCoveredTimeRanges, trackingTimeRange, progressConsumer, stopCallback);
            if (item instanceof Mark && ((firstFixAfterStartOfTracking = (GPSFix)(track = this.trackedRace.getOrCreateTrack(mark = (Mark)item)).getFirstFixAfter(trackingTimeRange.from())) == null || firstFixAfterStartOfTracking.getTimePoint().after(trackingTimeRange.to()))) {
                Iterable<GPSFix> betterFixesBeforeAndAfter = this.loadBetterFixesIfAvailable(trackingTimeRange, newlyCoveredTimeRanges);
                for (GPSFix betterFixBeforeAndAfter : betterFixesBeforeAndAfter) {
                    track.add((Timed)betterFixBeforeAndAfter, true);
                }
            }
        }
    }

    private void loadFixesInTrackingTimeRange(Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> newlyCoveredTimeRanges, TimeRange trackingTimeRange, Consumer<Double> progressConsumer, BooleanSupplier stopCallback) {
        MultiJobProgressUpdater progressUpdater = new MultiJobProgressUpdater(newlyCoveredTimeRanges.size());
        int currentJobNr = 0;
        for (Map.Entry<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> e : newlyCoveredTimeRanges.entrySet()) {
            int jobNr = currentJobNr++;
            MultiTimeRange timeRange = e.getValue();
            RegattaLogDeviceMappingEvent<WithID> event = e.getKey();
            this.loadFixesForMultiTimeRange(timeRange.intersection(trackingTimeRange), event, p -> {
                progressUpdater.updateProgress(jobNr, (double)p);
                progressConsumer.accept(progressUpdater.getProgress());
            }, stopCallback);
        }
    }

    private void loadFixesForMultiTimeRange(MultiTimeRange effectiveRangeToLoad, RegattaLogDeviceMappingEvent<WithID> event, Consumer<Double> progressConsumer, BooleanSupplier stopCallback) {
        if (!effectiveRangeToLoad.isEmpty()) {
            int currentJobNr = 0;
            int nrOfJobs = Util.size((Iterable)effectiveRangeToLoad);
            MultiJobProgressUpdater progressUpdater = new MultiJobProgressUpdater(nrOfJobs);
            for (TimeRange timeRange : effectiveRangeToLoad) {
                int jobNr = currentJobNr++;
                this.loadFixes(timeRange, event, p -> {
                    progressUpdater.updateProgress(jobNr, (double)p);
                    progressConsumer.accept(progressUpdater.getProgress());
                }, stopCallback);
            }
        }
    }

    public boolean containsMappingThatIntersectsTimeRange(Iterable<DeviceMappingWithRegattaLogEvent<WithID>> mappings, TimeRange timeRange) {
        for (DeviceMappingWithRegattaLogEvent<WithID> mapping : mappings) {
            if (!timeRange.intersects(mapping.getTimeRange())) continue;
            return true;
        }
        return false;
    }

    private void loadFixes(final TimeRange timeRangeToLoad, RegattaLogDeviceMappingEvent<? extends WithID> mappingEvent, final Consumer<Double> progressConsumer, final BooleanSupplier stopCallback) {
        if (timeRangeToLoad != null && !stopCallback.getAsBoolean()) {
            mappingEvent.accept(new MappingEventVisitor(){

                public void visit(RegattaLogDeviceCompetitorSensorDataMappingEvent event) {
                    Competitor competitor = (Competitor)event.getMappedTo();
                    this.loadSensorFixesForCompetitor(timeRangeToLoad, progressConsumer, stopCallback, (RegattaLogDeviceMappingEvent<?>)event, competitor);
                }

                public void visit(RegattaLogDeviceBoatSensorDataMappingEvent event) {
                    Boat boat = (Boat)event.getMappedTo();
                    Competitor competitor = FixLoaderAndTracker.this.trackedRace.getCompetitorOfBoat(boat);
                    if (competitor != null) {
                        this.loadSensorFixesForCompetitor(timeRangeToLoad, progressConsumer, stopCallback, (RegattaLogDeviceMappingEvent<?>)event, competitor);
                    } else {
                        logger.log(Level.WARNING, "Could not load fixes for boat because no competitor could be determined. Boat: " + boat);
                    }
                }

                private void loadSensorFixesForCompetitor(TimeRange timeRangeToLoad2, Consumer<Double> progressConsumer2, BooleanSupplier stopCallback2, RegattaLogDeviceMappingEvent<?> event, Competitor competitor) {
                    SensorFixMapper mapper = FixLoaderAndTracker.this.sensorFixMapperFactory.createCompetitorMapper(event.getClass());
                    DynamicTrack track = mapper.getTrack(FixLoaderAndTracker.this.trackedRace, (WithID)competitor);
                    if (track != null) {
                        try {
                            FixLoaderAndTracker.this.sensorFixStore.loadFixes(fix -> mapper.addFix(track, fix), event.getDevice(), timeRangeToLoad2.from(), timeRangeToLoad2.to(), false, stopCallback2, progressConsumer2);
                        }
                        catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                            logger.log(Level.WARNING, "Could not load track for competitor: " + event.getMappedTo() + "; device: " + event.getDevice());
                        }
                    }
                }

                public void visit(RegattaLogDeviceCompetitorMappingEvent event) {
                    this.loadForCompetitor((Competitor)event.getMappedTo(), (RegattaLogDeviceMappingEvent<?>)event);
                }

                public void visit(RegattaLogDeviceBoatMappingEvent event) {
                    Boat boat = (Boat)event.getMappedTo();
                    Competitor comp = FixLoaderAndTracker.this.trackedRace.getCompetitorOfBoat(boat);
                    if (comp != null) {
                        this.loadForCompetitor(comp, (RegattaLogDeviceMappingEvent<?>)event);
                    } else {
                        logger.log(Level.WARNING, "Could not load fixes for boat because no competitor could be determined. Boat: " + boat);
                    }
                }

                private void loadForCompetitor(Competitor competitor, RegattaLogDeviceMappingEvent<?> event) {
                    DynamicGPSFixTrack track = FixLoaderAndTracker.this.trackedRace.getTrack(competitor);
                    if (track != null) {
                        DynamicGPSFixMovingTrackImpl loadedFixes = new DynamicGPSFixMovingTrackImpl((Object)((Competitor)track.getTrackedItem()), track.getMillisecondsOverWhichToAverageSpeed());
                        loadedFixes.suspendValidityAndMaxSpeedCaching();
                        try {
                            DynamicGPSFixMovingTrackImpl filteredTrack;
                            FixLoaderAndTracker.this.sensorFixStore.loadFixes(arg_0 -> 3.lambda$1((DynamicGPSFixTrack)loadedFixes, arg_0), event.getDevice(), timeRangeToLoad.from(), timeRangeToLoad.to(), false, stopCallback, progressConsumer);
                            if (FixLoaderAndTracker.this.removeOutliersFromCompetitorTracks) {
                                Util.Pair filtered = new OutlierFilter().findAndRemoveInconsistenciesOnRawFixes((DynamicGPSFixTrack)loadedFixes);
                                loadedFixes.lockForRead();
                                try {
                                    logger.info("Filtered competitor track for outliers; " + filtered.getA() + " outliers removed in track with " + Util.size((Iterable)loadedFixes.getRawFixes()) + " fixes");
                                }
                                finally {
                                    loadedFixes.unlockAfterRead();
                                }
                                filteredTrack = (DynamicGPSFixTrack)filtered.getB();
                            } else {
                                filteredTrack = loadedFixes;
                            }
                            track.suspendValidityAndMaxSpeedCaching();
                            filteredTrack.lockForRead();
                            try {
                                for (GPSFixMoving fix : filteredTrack.getRawFixes()) {
                                    track.add((Timed)fix, true);
                                }
                            }
                            finally {
                                filteredTrack.unlockAfterRead();
                            }
                            track.resumeValidityAndMaxSpeedCaching();
                        }
                        catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                            logger.log(Level.WARNING, "Could not load competitor track " + competitor + "; device " + event.getDevice());
                        }
                    }
                }

                public void visit(RegattaLogDeviceMarkMappingEvent event) {
                    DynamicGPSFixTrack track = FixLoaderAndTracker.this.trackedRace.getOrCreateTrack((Mark)event.getMappedTo());
                    try {
                        FixLoaderAndTracker.this.sensorFixStore.loadFixes(fix -> {
                            boolean bl = track.add((Timed)fix, true);
                        }, event.getDevice(), timeRangeToLoad.from(), timeRangeToLoad.to(), false, stopCallback, progressConsumer);
                    }
                    catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                        logger.log(Level.WARNING, "Could not load mark track " + event.getMappedTo());
                    }
                }

                private static /* synthetic */ void lambda$1(DynamicGPSFixTrack dynamicGPSFixTrack, GPSFixMoving fix) {
                    boolean bl = dynamicGPSFixTrack.add((Timed)fix, true);
                }
            });
        }
    }

    private Iterable<GPSFix> loadBetterFixesIfAvailable(final TimeRange trackingTimeRange, Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> newlyCoveredTimeRanges) {
        final TreeSet fixesBefore = new TreeSet(TimedComparator.INSTANCE);
        TreeSet fixesAfter = new TreeSet(TimedComparator.INSTANCE);
        if (!this.preemptiveStopRequested.get()) {
            newlyCoveredTimeRanges.forEach((mappingEvent, coveredTimeRanges) -> mappingEvent.accept(new MappingEventVisitor((MultiTimeRange)coveredTimeRanges, fixesAfter){
                private final /* synthetic */ MultiTimeRange val$coveredTimeRanges;
                private final /* synthetic */ SortedSet val$fixesAfter;
                {
                    this.val$coveredTimeRanges = multiTimeRange;
                    this.val$fixesAfter = sortedSet2;
                }

                public void visit(RegattaLogDeviceCompetitorSensorDataMappingEvent event) {
                    throw new UnsupportedOperationException();
                }

                public void visit(RegattaLogDeviceBoatSensorDataMappingEvent event) {
                    throw new UnsupportedOperationException();
                }

                public void visit(RegattaLogDeviceCompetitorMappingEvent event) {
                    throw new UnsupportedOperationException();
                }

                public void visit(RegattaLogDeviceBoatMappingEvent event) {
                    throw new UnsupportedOperationException();
                }

                public void visit(RegattaLogDeviceMarkMappingEvent event) {
                    TimePoint to;
                    GPSFix firstFixAtOrAfterEndOfTracking;
                    TimePoint from;
                    GPSFix lastFixAtOrBeforeStartOfTracking;
                    DynamicGPSFixTrack track = FixLoaderAndTracker.this.trackedRace.getOrCreateTrack((Mark)event.getMappedTo());
                    TimePoint lastFixTimePointAtOrBeforeStartOfTracking = !fixesBefore.isEmpty() ? ((GPSFix)fixesBefore.last()).getTimePoint() : ((lastFixAtOrBeforeStartOfTracking = (GPSFix)track.getLastFixAtOrBefore(trackingTimeRange.from())) == null ? null : lastFixAtOrBeforeStartOfTracking.getTimePoint());
                    TimePoint timePoint = from = lastFixTimePointAtOrBeforeStartOfTracking != null ? lastFixTimePointAtOrBeforeStartOfTracking : TimePoint.BeginningOfTime;
                    if (from.before(trackingTimeRange.from())) {
                        MultiTimeRange beforeRange = this.val$coveredTimeRanges.intersection((TimeRange)new TimeRangeImpl(from, trackingTimeRange.from()));
                        Collection inverseTimeRanges = Util.addAll((Iterable)beforeRange, new TreeSet((timeRange1, timeRange2) -> -timeRange1.from().compareTo((Object)timeRange2.from())));
                        for (TimeRange timeRange : inverseTimeRanges) {
                            try {
                                if (!FixLoaderAndTracker.this.sensorFixStore.loadYoungestFix(fix -> {
                                    boolean bl = fixesBefore.add(fix);
                                }, event.getDevice(), timeRange)) continue;
                                break;
                            }
                            catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                                logger.log(Level.WARNING, "Could not load better fix for mark track " + event.getMappedTo());
                            }
                        }
                    }
                    TimePoint firstFixTimePointAfterEndOfTracking = !this.val$fixesAfter.isEmpty() ? ((GPSFix)this.val$fixesAfter.first()).getTimePoint() : ((firstFixAtOrAfterEndOfTracking = (GPSFix)track.getFirstFixAtOrAfter(trackingTimeRange.to())) == null ? null : firstFixAtOrAfterEndOfTracking.getTimePoint());
                    TimePoint timePoint2 = to = firstFixTimePointAfterEndOfTracking != null ? firstFixTimePointAfterEndOfTracking : TimePoint.EndOfTime;
                    if (to.after(trackingTimeRange.to())) {
                        MultiTimeRange afterRange = this.val$coveredTimeRanges.intersection((TimeRange)new TimeRangeImpl(trackingTimeRange.to(), to));
                        for (TimeRange timeRange : afterRange) {
                            try {
                                if (!FixLoaderAndTracker.this.sensorFixStore.loadOldestFix(fix -> {
                                    boolean bl = this.val$fixesAfter.add(fix);
                                }, event.getDevice(), timeRange)) continue;
                                break;
                            }
                            catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                                logger.log(Level.WARNING, "Could not load better fix for mark track " + event.getMappedTo());
                            }
                        }
                    }
                }
            }));
        }
        ArrayList<GPSFix> result = new ArrayList<GPSFix>();
        if (!fixesBefore.isEmpty()) {
            result.add((GPSFix)fixesBefore.last());
        }
        if (!fixesAfter.isEmpty()) {
            result.add((GPSFix)fixesAfter.first());
        }
        return result;
    }

    private TimeRange getTrackingTimeRange() {
        TimePoint startOfTracking = this.trackedRace.getStartOfTracking();
        TimePoint endOfTracking = startOfTracking != null && this.trackedRace.getEndOfTracking() != null && startOfTracking.after(this.trackedRace.getEndOfTracking()) ? startOfTracking : this.trackedRace.getEndOfTracking();
        return new TimeRangeImpl(startOfTracking == null ? TimePoint.BeginningOfTime : startOfTracking, endOfTracking == null ? TimePoint.EndOfTime : endOfTracking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean preemptive, boolean willBeRemoved) {
        this.preemptiveStopRequested.set(preemptive);
        this.willBeRemovedAfterStopping.set(willBeRemoved);
        this.stopRequested.set(true);
        this.trackedRace.removeListener((RaceChangeListener)this.raceChangeListener);
        this.deviceMappings.stop();
        Set<AbstractLoadingJob> set = this.loadingJobs;
        synchronized (set) {
            if (this.loadingJobs.isEmpty()) {
                this.setStatusAndProgress(willBeRemoved ? TrackedRaceStatusEnum.REMOVED : TrackedRaceStatusEnum.FINISHED, 1.0);
            }
        }
        this.sensorFixStore.removeListener(this.listener);
    }

    private void startTracking() {
        this.setStatusAndProgress(TrackedRaceStatusEnum.LOADING, 0.0);
        this.deviceMappings = new FixLoaderDeviceMappings(this.trackedRace.getAttachedRegattaLogs(), this.trackedRace.getRace().getName());
        this.trackedRace.addListener((RaceChangeListener)this.raceChangeListener);
        this.deviceMappings.updateMappings();
        this.updateStatusAndProgress();
    }

    private void loadFixesForExtendedTimeRange(TimeRange extendedTimeRange) {
        this.deviceMappings.forEachItemAndCoveredTimeRanges((item, mappingsAndCoveredTimeRanges) -> this.addLoadingJob(new LoadFixesInTrackingTimeRangeJob((Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange>)mappingsAndCoveredTimeRanges, extendedTimeRange)));
    }

    private void loadFixesWhenStartOfTrackingIsReceived() {
        this.deviceMappings.forEachItemAndCoveredTimeRanges((item, mappingsAndCoveredTimeRanges) -> this.addLoadingJob(new LoadFixesForNewlyCoveredTimeRangesJob((WithID)item, (Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange>)mappingsAndCoveredTimeRanges)));
    }

    private void setStatusAndProgress(TrackedRaceStatusEnum status, double progress) {
        this.trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)new TrackedRaceStatusImpl(status, progress));
    }

    private void updateStatusAndProgressWithErrorHandling() {
        try {
            this.updateStatusAndProgress();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while updating status and progress for FixLoaderAndTracker", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatusAndProgress() {
        Set<AbstractLoadingJob> set = this.loadingJobs;
        synchronized (set) {
            double progress;
            TrackedRaceStatusEnum status;
            if (!this.loadingJobs.isEmpty()) {
                double progressSum = 0.0;
                boolean allFinished = true;
                for (AbstractLoadingJob loadingJob : this.loadingJobs) {
                    allFinished &= loadingJob.isFinished();
                    progressSum += loadingJob.getProgress();
                }
                if (allFinished) {
                    this.loadingJobs.clear();
                    status = this.stopRequested.get() ? (this.willBeRemovedAfterStopping.get() ? TrackedRaceStatusEnum.REMOVED : TrackedRaceStatusEnum.FINISHED) : TrackedRaceStatusEnum.TRACKING;
                    progress = 1.0;
                } else {
                    progress = progressSum / (double)this.loadingJobs.size();
                    status = TrackedRaceStatusEnum.LOADING;
                }
            } else {
                status = this.stopRequested.get() ? (this.willBeRemovedAfterStopping.get() ? TrackedRaceStatusEnum.REMOVED : TrackedRaceStatusEnum.FINISHED) : TrackedRaceStatusEnum.TRACKING;
                progress = 1.0;
            }
            this.setStatusAndProgress(status, progress);
            this.loadingJobs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLoadingJob(AbstractLoadingJob job) {
        Set<AbstractLoadingJob> set = this.loadingJobs;
        synchronized (set) {
            this.loadingJobs.add(job);
            this.updateStatusAndProgress();
        }
        executor.execute(job);
    }

    public boolean isStopRequested() {
        return this.stopRequested.get();
    }

    private abstract class AbstractLoadingJob
    implements Runnable {
        volatile double currentProgress = 0.0;
        volatile boolean isFinished = false;

        private AbstractLoadingJob() {
        }

        @Override
        public final void run() {
            FixLoaderAndTracker.this.updateStatusAndProgressWithErrorHandling();
            try {
                try {
                    this.load(this::updateProgress, FixLoaderAndTracker.this.preemptiveStopRequested::get);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Error while loading fixes, this is most likely a critical error! ", e);
                    this.isFinished = true;
                    this.updateProgress(1.0);
                }
            }
            finally {
                this.isFinished = true;
                this.updateProgress(1.0);
            }
        }

        private void updateProgress(double newProgress) {
            this.currentProgress = newProgress;
            FixLoaderAndTracker.this.updateStatusAndProgressWithErrorHandling();
        }

        public boolean isFinished() {
            return this.isFinished;
        }

        public double getProgress() {
            return this.currentProgress;
        }

        protected abstract void load(Consumer<Double> var1, BooleanSupplier var2);
    }

    private class FixLoaderDeviceMappings
    extends RegattaLogDeviceMappings<WithID> {
        public FixLoaderDeviceMappings(Iterable<RegattaLog> initialRegattaLogs, String raceNameForLock) {
            super(initialRegattaLogs, raceNameForLock);
        }

        @Override
        protected void deviceIdAdded(DeviceIdentifier deviceIdentifier) {
            FixLoaderAndTracker.this.sensorFixStore.addListener(FixLoaderAndTracker.this.listener, deviceIdentifier);
        }

        @Override
        protected void deviceIdRemoved(DeviceIdentifier deviceIdentifier) {
            FixLoaderAndTracker.this.sensorFixStore.removeListener(FixLoaderAndTracker.this.listener, deviceIdentifier);
        }

        @Override
        protected void newTimeRangesCovered(WithID item, Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> newlyCoveredTimeRanges) {
            if (FixLoaderAndTracker.this.trackedRace.getStartOfTracking() != null) {
                FixLoaderAndTracker.this.addLoadingJob(new LoadFixesForNewlyCoveredTimeRangesJob(item, newlyCoveredTimeRanges));
            }
        }
    }

    private class LoadFixesForNewlyCoveredTimeRangesJob
    extends AbstractLoadingJob {
        private final WithID item;
        private final Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> newlyCoveredTimeRanges;

        public LoadFixesForNewlyCoveredTimeRangesJob(WithID item, Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> newlyCoveredTimeRanges) {
            this.item = item;
            this.newlyCoveredTimeRanges = newlyCoveredTimeRanges;
        }

        @Override
        protected void load(Consumer<Double> progressConsumer, BooleanSupplier stopCallback) {
            FixLoaderAndTracker.this.loadFixesForNewlyCoveredTimeRanges(this.item, this.newlyCoveredTimeRanges, progressConsumer, stopCallback);
        }
    }

    private class LoadFixesInTrackingTimeRangeJob
    extends AbstractLoadingJob {
        private final Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> newlyCoveredTimeRanges;
        private final TimeRange trackingTimeRange;

        public LoadFixesInTrackingTimeRangeJob(Map<RegattaLogDeviceMappingEvent<WithID>, MultiTimeRange> newlyCoveredTimeRanges, TimeRange trackingTimeRange) {
            this.newlyCoveredTimeRanges = newlyCoveredTimeRanges;
            this.trackingTimeRange = trackingTimeRange;
        }

        @Override
        protected void load(Consumer<Double> progressConsumer, BooleanSupplier stopCallback) {
            FixLoaderAndTracker.this.loadFixesInTrackingTimeRange(this.newlyCoveredTimeRanges, this.trackingTimeRange, progressConsumer, stopCallback);
        }
    }

    public class MultiJobProgressUpdater {
        volatile double[] currentProgress = new double[1];

        public MultiJobProgressUpdater(int nrOfJobs) {
            this.currentProgress = new double[nrOfJobs];
        }

        void updateProgress(int jobNr, double progress) {
            if (jobNr >= 0 && jobNr < this.currentProgress.length) {
                this.currentProgress[jobNr] = progress;
            }
        }

        public double getProgress() {
            double progress = 0.0;
            int i = 0;
            while (i < this.currentProgress.length) {
                progress += this.currentProgress[i] / (double)this.currentProgress.length;
                ++i;
            }
            return progress;
        }
    }
}

