/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogDenoteForTrackingEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RaceInformationFinder;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RaceLogTrackingStateAnalyzer;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.common.racelog.tracking.DoesNotHaveRegattaLogException;
import com.sap.sailing.domain.common.racelog.tracking.RaceLogTrackingState;
import com.sap.sailing.domain.common.racelog.tracking.RaceNotCreatedException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogRaceTracker;
import com.sap.sailing.domain.regattalike.HasRegattaLike;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.AbstractRaceTrackingConnectivityParameters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class RaceLogConnectivityParams
extends AbstractRaceTrackingConnectivityParameters {
    private static final long serialVersionUID = -2011714861990480270L;
    public static final String TYPE = "RACE_LOG_TRACKING";
    private final transient AbstractLogEventAuthor serverAuthor;
    private final RaceColumn raceColumn;
    private final Fleet fleet;
    private final Leaderboard leaderboard;
    private final long delayToLiveInMillis;
    private final Regatta regatta;
    private final transient DomainFactory domainFactory;

    public RaceLogConnectivityParams(AbstractLogEventAuthor serverAuthor, Regatta regatta, RaceColumn raceColumn, Fleet fleet, Leaderboard leaderboard, long delayToLiveInMillis, DomainFactory domainFactory, boolean trackWind, boolean correctWindDirectionByMagneticDeclination) throws RaceNotCreatedException {
        super(trackWind, correctWindDirectionByMagneticDeclination);
        this.serverAuthor = serverAuthor;
        this.regatta = regatta;
        this.raceColumn = raceColumn;
        this.fleet = fleet;
        this.leaderboard = leaderboard;
        this.delayToLiveInMillis = delayToLiveInMillis;
        this.domainFactory = domainFactory;
        if (!((RaceLogTrackingState)new RaceLogTrackingStateAnalyzer(this.getRaceLog()).analyze()).isForTracking()) {
            throw new RaceNotCreatedException(String.format("Racelog (%s) is not denoted for tracking", this.getRaceLog()));
        }
    }

    public String getTypeIdentifier() {
        return TYPE;
    }

    public RaceTracker createRaceTracker(TrackedRegattaRegistry trackedRegattaRegistry, WindStore windStore, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        return this.createRaceTracker(this.regatta, trackedRegattaRegistry, windStore, raceLogResolver, leaderboardGroupResolver, timeoutInMilliseconds, raceTrackingHandler, markPassingRaceFingerprintRegistry);
    }

    public RaceTracker createRaceTracker(Regatta regatta, TrackedRegattaRegistry trackedRegattaRegistry, WindStore windStore, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        if (regatta == null) {
            BoatClass boatClass = ((RaceLogDenoteForTrackingEvent)new RaceInformationFinder(this.getRaceLog()).analyze()).getBoatClass();
            regatta = trackedRegattaRegistry.getOrCreateDefaultRegatta(RegattaImpl.getDefaultName((String)"RaceLog-tracking default Regatta", (String)boatClass.getName()), boatClass.getName(), (Serializable)UUID.randomUUID());
        }
        if (regatta == null) {
            throw new RaceNotCreatedException("No regatta for race-log tracked race");
        }
        DynamicTrackedRegatta trackedRegatta = trackedRegattaRegistry.getOrCreateTrackedRegatta(regatta);
        return new RaceLogRaceTracker(trackedRegatta, this, windStore, raceLogResolver, this, trackedRegattaRegistry, raceTrackingHandler, markPassingRaceFingerprintRegistry);
    }

    public Object getTrackerID() {
        return this.getRaceLog().getId();
    }

    public long getDelayToLiveInMillis() {
        return this.delayToLiveInMillis;
    }

    public RaceLog getRaceLog() {
        return this.raceColumn.getRaceLog(this.fleet);
    }

    public RaceColumn getRaceColumn() {
        return this.raceColumn;
    }

    public Fleet getFleet() {
        return this.fleet;
    }

    public Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    public RegattaLog getRegattaLog() throws DoesNotHaveRegattaLogException {
        if (this.leaderboard instanceof HasRegattaLike) {
            return ((HasRegattaLike)this.leaderboard).getRegattaLike().getRegattaLog();
        }
        throw new DoesNotHaveRegattaLogException();
    }

    public AbstractLogEventAuthor getServerAuthor() {
        return this.serverAuthor;
    }

    public DomainFactory getDomainFactory() {
        return this.domainFactory;
    }

    public List<AbstractLog<?, ?>> getLogHierarchy() {
        ArrayList result = new ArrayList();
        result.add((AbstractLog<?, ?>)this.getRaceLog());
        if (this.leaderboard instanceof HasRegattaLike) {
            result.add((AbstractLog<?, ?>)((HasRegattaLike)this.leaderboard).getRegattaLike().getRegattaLog());
        }
        return result;
    }

    public Regatta getRegatta() {
        return this.regatta;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " for " + this.leaderboard.getName() + "/" + this.raceColumn.getName() + "/" + this.fleet.getName();
    }
}

