/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.QueueingConsumer;
import com.sap.sse.ServerInfo;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.OperationsToMasterSender;
import com.sap.sse.replication.OperationsToMasterSendingQueue;
import com.sap.sse.replication.RabbitMQConnectionFactoryHelper;
import com.sap.sse.replication.ReplicaDescriptor;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicablesProvider;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.ReplicationReceiver;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.replication.ReplicationStatus;
import com.sap.sse.replication.impl.Activator;
import com.sap.sse.replication.impl.OperationSerializerBuffer;
import com.sap.sse.replication.impl.OperationSerializerBufferImpl;
import com.sap.sse.replication.impl.OperationSerializerBufferPool;
import com.sap.sse.replication.impl.RabbitInputStreamProvider;
import com.sap.sse.replication.impl.ReplicationInstancesManager;
import com.sap.sse.replication.impl.ReplicationMasterDescriptorImpl;
import com.sap.sse.replication.impl.ReplicationMessageSender;
import com.sap.sse.replication.impl.ReplicationReceiverImpl;
import com.sap.sse.replication.impl.ReplicationServiceExecutionListener;
import com.sap.sse.replication.impl.UnsentOperationsSenderJob;
import com.sap.sse.replication.interfaces.impl.ReplicationStatusImpl;
import com.sap.sse.replication.persistence.MongoObjectFactory;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jpountz.lz4.LZ4BlockInputStream;
import org.osgi.util.tracker.ServiceTracker;

public class ReplicationServiceImpl
implements ReplicationService,
OperationsToMasterSendingQueue,
ReplicationMessageSender {
    private static final Logger logger = Logger.getLogger(ReplicationServiceImpl.class.getName());
    private final ReplicationInstancesManager replicationInstancesManager;
    private final ReplicablesProvider replicablesProvider;
    private ReplicationMasterDescriptor replicatingFromMaster;
    private final ConcurrentMap<ReplicationMasterDescriptor, String> replicaUUIDs;
    private Channel masterChannel;
    private final String exchangeName;
    private final String exchangeHost;
    private final int exchangePort;
    private final UUID serverUUID;
    private ReplicationReceiverImpl replicator;
    private final ConcurrentMap<String, ReplicationServiceExecutionListener<?>> executionListenersByReplicableIdAsString;
    private Thread replicatorThread;
    private static final long SEND_JOB_QUEUE_SIZE_THRESHOLD_IN_BYTES = Runtime.getRuntime().maxMemory() / 4L;
    private final BlockingDeque<Util.Pair<byte[], List<Class<?>>>> sendJobQueue = new LinkedBlockingDeque();
    private final AtomicLong totalSendJobsSize;
    private static final Duration DURATION_BETWTEEN_SEND_RETRIES = Duration.ONE_SECOND.times(5L);
    private final OperationSerializerBufferImpl outboundBufferForOperationsRequiringSynchronousExecution;
    private final OperationSerializerBufferPool outboundBufferPoolForOperationsAllowingForAsynchronousExecution;
    private final Timer timer = new Timer("ReplicationServiceImpl timer for delayed task sending", true);
    private final UnsentOperationsSenderJob unsentOperationsSenderJob;
    private static final Duration TRANSMISSION_DELAY = Duration.ofMillis((long)100L);
    private static final int TRIGGER_MESSAGE_SIZE_IN_BYTES = 0x100000;
    private long messageCount;
    private final Map<ReplicationMasterDescriptor, InitialLoadRequest> initialLoadChannels;
    private volatile boolean replicationStarting;
    private final Optional<MongoObjectFactory> mongoObjectFactory;
    private final Set<ReplicationService.ReplicationStartingListener> replicationStartingListeners;

    public ReplicationServiceImpl(String exchangeName, String exchangeHost, int exchangePort, ReplicationInstancesManager replicationInstancesManager, ReplicablesProvider replicablesProvider) throws Exception {
        this(Optional.empty(), exchangeName, exchangeHost, exchangePort, replicationInstancesManager, replicablesProvider);
    }

    public ReplicationServiceImpl(Optional<MongoObjectFactory> optionalMongoObjectFactory, String exchangeName, String exchangeHost, int exchangePort, ReplicationInstancesManager replicationInstancesManager, ReplicablesProvider replicablesProvider) throws Exception {
        this(null, optionalMongoObjectFactory, exchangeName, exchangeHost, exchangePort, replicationInstancesManager, replicablesProvider);
    }

    public ReplicationServiceImpl(Iterable<ReplicaDescriptor> replicasToAssumeConnectedToThisMaster, Optional<MongoObjectFactory> optionalMongoObjectFactory, String exchangeName, String exchangeHost, int exchangePort, ReplicationInstancesManager replicationInstancesManager, ReplicablesProvider replicablesProvider) throws Exception {
        this.outboundBufferForOperationsRequiringSynchronousExecution = new OperationSerializerBufferImpl(this, TRANSMISSION_DELAY, 0x100000, this.timer);
        this.outboundBufferPoolForOperationsAllowingForAsynchronousExecution = new OperationSerializerBufferPool(this, TRANSMISSION_DELAY, 0x100000, this.timer);
        this.totalSendJobsSize = new AtomicLong(0L);
        this.createSendJob().start();
        this.mongoObjectFactory = optionalMongoObjectFactory;
        this.replicationStartingListeners = new HashSet<ReplicationService.ReplicationStartingListener>();
        this.unsentOperationsSenderJob = new UnsentOperationsSenderJob();
        this.executionListenersByReplicableIdAsString = new ConcurrentHashMap();
        this.initialLoadChannels = new ConcurrentHashMap<ReplicationMasterDescriptor, InitialLoadRequest>();
        this.replicationInstancesManager = replicationInstancesManager;
        this.replicaUUIDs = new ConcurrentHashMap<ReplicationMasterDescriptor, String>();
        this.replicablesProvider = replicablesProvider;
        this.exchangeName = exchangeName;
        this.exchangeHost = exchangeHost;
        this.exchangePort = exchangePort;
        replicablesProvider.addReplicableLifeCycleListener((ReplicablesProvider.ReplicableLifeCycleListener)new LifeCycleListener());
        this.replicator = null;
        this.serverUUID = UUID.randomUUID();
        logger.info("Setting " + this.serverUUID.toString() + " as unique replication identifier.");
        if (replicasToAssumeConnectedToThisMaster != null) {
            for (ReplicaDescriptor replica : replicasToAssumeConnectedToThisMaster) {
                this.registerReplica(replica);
            }
        }
    }

    protected void finalize() {
        logger.info("terminating timer " + this.timer);
        this.timer.cancel();
    }

    protected ServiceTracker<Replicable<?, ?>, Replicable<?, ?>> getReplicableTracker() {
        return new ServiceTracker(Activator.getDefaultContext(), Replicable.class.getName(), null);
    }

    protected ReplicablesProvider getReplicablesProvider() {
        return this.replicablesProvider;
    }

    public ReplicationReceiver getReplicator() {
        return this.replicator;
    }

    private Channel createMasterChannelAndDeclareFanoutExchange() throws Exception {
        Channel result = this.createMasterChannel();
        if (!Util.hasLength((String)this.exchangeName)) {
            logger.severe("Replica seems registering at this master, but this master's exchange name is \"" + this.exchangeName + "\". Failing with an exception.");
            throw new IllegalStateException("Master's outbound replication exchange name is " + this.exchangeName + " but must be non-empty; " + "consider setting the REPLICATION_CHANNEL environment variable.");
        }
        result.exchangeDeclare(this.exchangeName, "fanout");
        logger.info("Created fanout exchange " + this.exchangeName + " successfully.");
        return result;
    }

    public Channel createMasterChannel() throws Exception {
        ConnectionFactory connectionFactory = RabbitMQConnectionFactoryHelper.getConnectionFactory();
        connectionFactory.setHost(this.exchangeHost);
        if (this.exchangePort != 0) {
            connectionFactory.setPort(this.exchangePort);
        }
        try {
            Channel result = connectionFactory.newConnection().createChannel();
            logger.info("Connected to " + connectionFactory.getHost() + ":" + connectionFactory.getPort());
            return result;
        }
        catch (ConnectException | TimeoutException ex) {
            logger.severe("Could not connect to messaging queue on " + connectionFactory.getHost() + ":" + connectionFactory.getPort() + "/" + this.exchangeName);
            throw ex;
        }
    }

    private Iterable<Replicable<?, ?>> getReplicables() {
        return this.replicablesProvider.getReplicables();
    }

    private Replicable<?, ?> getReplicable(String replicableIdAsString, boolean wait) {
        return this.replicablesProvider.getReplicable(replicableIdAsString, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReplica(ReplicaDescriptor replica) throws Exception {
        this.addAsListenerToReplicables(replica.getReplicableIdsAsStrings());
        ReplicationInstancesManager replicationInstancesManager = this.replicationInstancesManager;
        synchronized (replicationInstancesManager) {
            if (!this.replicationInstancesManager.hasReplicas()) {
                this.openOutboundReplicationChannel();
            }
            this.replicationInstancesManager.registerReplica(replica);
            this.recordRegisteredReplicaPersistently(replica);
        }
        logger.info("Registered replica " + replica);
    }

    private synchronized void openOutboundReplicationChannel() throws Exception {
        if (this.masterChannel == null) {
            this.masterChannel = this.createMasterChannelAndDeclareFanoutExchange();
        }
        this.outboundBufferPoolForOperationsAllowingForAsynchronousExecution.start();
    }

    private void recordRegisteredReplicaPersistently(ReplicaDescriptor replica) {
        this.mongoObjectFactory.ifPresent(mof -> mof.storeReplicaDescriptor(replica));
    }

    private void removeRegisteredReplicaPersistently(ReplicaDescriptor replica) {
        this.mongoObjectFactory.ifPresent(mof -> mof.removeReplicaDescriptor(replica));
    }

    private void addAsListenerToReplicables(String[] replicableIdsAsStringForReplicablesToReplicate) {
        String[] stringArray = replicableIdsAsStringForReplicablesToReplicate;
        int n = replicableIdsAsStringForReplicablesToReplicate.length;
        int n2 = 0;
        while (n2 < n) {
            String replicableIdAsStringForReplicableToReplicate = stringArray[n2];
            Replicable<?, ?> replicable = this.getReplicable(replicableIdAsStringForReplicableToReplicate, true);
            this.ensureOperationExecutionListener(replicable);
            ++n2;
        }
    }

    private <S> void ensureOperationExecutionListener(Replicable<S, ?> replicable) {
        if (!this.executionListenersByReplicableIdAsString.containsKey(replicable.getId().toString())) {
            ReplicationServiceExecutionListener<S> listener = new ReplicationServiceExecutionListener<S>(this, replicable);
            this.executionListenersByReplicableIdAsString.put(replicable.getId().toString(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicaDescriptor unregisterReplica(UUID replicaUuid) throws IOException {
        logger.info("Unregistering replica with ID " + replicaUuid);
        ReplicationInstancesManager replicationInstancesManager = this.replicationInstancesManager;
        synchronized (replicationInstancesManager) {
            boolean hadReplicas = this.replicationInstancesManager.hasReplicas();
            Iterable<String> oldReplicablesInReplication = this.replicationInstancesManager.getAllReplicableIdsAtLeastOneReplicaIsReplicating();
            this.removeRegisteredReplicaPersistently(this.replicationInstancesManager.getReplicaDescriptor(replicaUuid));
            ReplicaDescriptor unregisteredReplica = this.replicationInstancesManager.unregisterReplica(replicaUuid);
            Iterable<String> newReplicablesInReplication = this.replicationInstancesManager.getAllReplicableIdsAtLeastOneReplicaIsReplicating();
            for (String idAsStringOfReplicableNoReplicaIsInterestedInAnymore : Util.removeAll(newReplicablesInReplication, (Collection)Util.addAll(oldReplicablesInReplication, new HashSet()))) {
                this.removeAsListenerFromReplicable(idAsStringOfReplicableNoReplicaIsInterestedInAnymore);
            }
            if (hadReplicas && !this.replicationInstancesManager.hasReplicas()) {
                logger.info("Last replica got unregistered. Stopping to send out operations and closing outbound queue.");
                this.closeOutboundReplicationChannel();
            }
            return unregisteredReplica;
        }
    }

    public void unregisterReplica(ReplicaDescriptor replica) throws IOException {
        logger.info("Unregistering replica " + replica);
        this.unregisterReplica(replica.getUuid());
    }

    private void removeAsListenerFromReplicable(String idAsStringOfReplicableNoReplicaIsInterestedInAnymore) {
        ReplicationServiceExecutionListener listener = (ReplicationServiceExecutionListener)this.executionListenersByReplicableIdAsString.remove(idAsStringOfReplicableNoReplicaIsInterestedInAnymore);
        if (listener != null) {
            logger.info("Unsubscribed replication listener from replicable with ID " + idAsStringOfReplicableNoReplicaIsInterestedInAnymore);
            listener.unsubscribe();
        } else {
            logger.warning("Couldn't find a replication listener on replicable with ID " + idAsStringOfReplicableNoReplicaIsInterestedInAnymore);
        }
    }

    private void removeAsListenerFromReplicables() {
        for (ReplicationServiceExecutionListener listener : this.executionListenersByReplicableIdAsString.values()) {
            listener.unsubscribe();
        }
        this.executionListenersByReplicableIdAsString.clear();
    }

    <S, O extends OperationWithResult<S, ?>> void broadcastOperation(OperationWithResult<?, ?> operation, Replicable<S, O> replicable) throws IOException {
        OperationSerializerBuffer bufferToWriteTo = operation.requiresSynchronousExecution() ? this.outboundBufferForOperationsRequiringSynchronousExecution : this.outboundBufferPoolForOperationsAllowingForAsynchronousExecution;
        bufferToWriteTo.write(operation, replicable);
        if (++this.messageCount % 10000L == 0L) {
            logger.info("Handled " + this.messageCount + " messages for replication. Current outbound replication queue size: " + this.outboundBufferForOperationsRequiringSynchronousExecution.size());
        }
    }

    @Override
    public void send(byte[] message, List<Class<?>> typesInMessage) {
        if (this.totalSendJobsSize.get() < SEND_JOB_QUEUE_SIZE_THRESHOLD_IN_BYTES) {
            this.sendJobQueue.add(new Util.Pair((Object)message, typesInMessage));
            long newTotalSendJobsSize = this.totalSendJobsSize.addAndGet(message.length);
            logger.fine("Successfully handed " + typesInMessage.size() + " operations to broadcaster; new outbound send queue length " + this.sendJobQueue.size() + " (" + newTotalSendJobsSize + "B)");
        } else {
            logger.severe("Queue for outbound replication operations full (" + this.totalSendJobsSize.get() + "B. Dropping operations buffer with size " + message.length + "B");
        }
    }

    static InputStream createUncompressingInputStream(InputStream streamToWrap) {
        return new LZ4BlockInputStream(streamToWrap);
    }

    private Thread createSendJob() {
        Thread result = new Thread("Replicator send job for exchange " + this.exchangeHost + ":" + this.exchangePort + "/" + this.exchangeName){

            @Override
            public void run() {
                logger.info("Thread " + this.getName() + " started.");
                while (true) {
                    try {
                        while (true) {
                            logger.fine("Taking a message from the sendJobQueue");
                            Util.Pair messageAndTypesOfOperations = (Util.Pair)ReplicationServiceImpl.this.sendJobQueue.take();
                            logger.fine(() -> "Took a message with size " + ((byte[])messageAndTypesOfOperations.getA()).length + "B from the sendJobQueue");
                            boolean delivered = false;
                            do {
                                try {
                                    logger.fine(() -> "Trying to send message with size " + ((byte[])messageAndTypesOfOperations.getA()).length + "B");
                                    ReplicationServiceImpl.this.broadcastOperations((byte[])messageAndTypesOfOperations.getA(), (List)messageAndTypesOfOperations.getB());
                                    delivered = true;
                                    long newTotalSendJobsSize = ReplicationServiceImpl.this.totalSendJobsSize.addAndGet(-((byte[])messageAndTypesOfOperations.getA()).length);
                                    logger.fine(() -> "New send queue size " + ReplicationServiceImpl.this.sendJobQueue.size() + " (" + newTotalSendJobsSize + "B)");
                                }
                                catch (Exception ioe) {
                                    logger.log(Level.WARNING, "Exception trying to send out replication operations to RabbitMQ exchange " + ReplicationServiceImpl.this.exchangeHost + ":" + ReplicationServiceImpl.this.exchangePort + "/" + ReplicationServiceImpl.this.exchangeName + "; trying to re-establish a channel to the fanout exchange in " + DURATION_BETWTEEN_SEND_RETRIES, ioe);
                                    Thread.sleep(DURATION_BETWTEEN_SEND_RETRIES.asMillis());
                                    logger.info("Creating new channel to exchange in order to re-try sending");
                                    try {
                                        ReplicationServiceImpl.this.masterChannel = ReplicationServiceImpl.this.createMasterChannelAndDeclareFanoutExchange();
                                        logger.info("Channel established; retrying now.");
                                    }
                                    catch (Exception e) {
                                        logger.log(Level.SEVERE, "Re-establishing a connection to the fan-out exchange at " + ReplicationServiceImpl.this.exchangeHost + ":" + ReplicationServiceImpl.this.exchangePort + "/" + ReplicationServiceImpl.this.exchangeName + " didn't work. Will try to send again through old channel which will probably fail, then sleep and try again.", e);
                                    }
                                }
                            } while (!delivered);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Outbound replication message sender interrupted. Continuing...");
                        continue;
                    }
                    break;
                }
            }
        };
        result.setDaemon(true);
        return result;
    }

    private void broadcastOperations(byte[] bytesToSend, List<Class<?>> classesOfOperationsToSend) throws IOException {
        logger.fine("broadcasting " + classesOfOperationsToSend.size() + " operations as " + bytesToSend.length + " bytes");
        if (this.masterChannel != null) {
            logger.fine("buffer to broadcast has " + bytesToSend.length + " bytes (" + bytesToSend.length / 1024 / 1024 + "MB)");
            long startTime = System.currentTimeMillis();
            this.masterChannel.basicPublish(this.exchangeName, "", null, bytesToSend);
            logger.fine("successfully published " + bytesToSend.length + " bytes, taking " + (System.currentTimeMillis() - startTime) + "ms");
            this.replicationInstancesManager.log(classesOfOperationsToSend, bytesToSend.length);
        }
    }

    public Iterable<ReplicaDescriptor> getReplicaInfo() {
        return this.replicationInstancesManager.getReplicaDescriptors();
    }

    public ReplicationMasterDescriptor getReplicatingFromMaster() {
        return this.replicatingFromMaster;
    }

    public void startToReplicateFrom(final ReplicationMasterDescriptor master) throws Exception {
        if (this.initialLoadChannels.containsKey(master)) {
            logger.warning("An initial load from " + master + " is already running, replicating the following replicables: " + this.initialLoadChannels.get(master).getReplicables() + ". Not starting a second time.");
        } else {
            String queueName;
            Iterable replicables = master.getReplicables();
            logger.info("Starting to replicate from " + master);
            try {
                this.registerReplicaWithMaster(master);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "ERROR", ex);
                throw ex;
            }
            this.replicatingFromMaster = master;
            logger.info("Registered replica with master.");
            QueueingConsumer consumer = null;
            Timer timer = new Timer("RabbitMQ Connection Timeout Logger", true);
            int LOGGING_TIMEOUT_IN_SECONDS = 10;
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    logger.warning("RabbitMQ connection to " + master + " was not obtained in " + 10 + "s. Keeping trying...");
                }
            }, 10000L, 10000L);
            logger.info("Connecting to message queue " + master);
            try {
                try {
                    consumer = master.getConsumer();
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "ERROR", ex);
                    this.replicatingFromMaster = null;
                    throw ex;
                }
            }
            finally {
                timer.cancel();
            }
            logger.info("Connection to exchange successful.");
            URL initialLoadURL = master.getInitialLoadURL(replicables);
            logger.info("Initial load URL is " + initialLoadURL);
            this.replicator = new ReplicationReceiverImpl(master, this.replicablesProvider, true, consumer);
            for (Replicable r : replicables) {
                r.clearReplicaState();
                r.setUnsentOperationToMasterSender((OperationsToMasterSendingQueue)this);
                r.startedReplicatingFrom(master);
            }
            this.replicatorThread = new Thread((Runnable)this.replicator, "Replicator receiving from " + master.getMessagingHostname() + "/" + master.getExchangeName());
            this.replicatorThread.start();
            logger.info("Started replicator thread");
            URLConnection initialLoadConnection = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)initialLoadURL, (String)"POST", (String)master.getBearerToken());
            InputStream is = (InputStream)initialLoadConnection.getContent();
            Throwable throwable = null;
            Object var11_14 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)initialLoadConnection, (String)"UTF-8")));){
                queueName = bufferedReader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Channel channel = master.createChannel();
            this.initialLoadChannels.put(master, new InitialLoadRequest(channel, replicables, queueName));
            RabbitInputStreamProvider rabbitInputStreamProvider = new RabbitInputStreamProvider(channel, queueName);
            try {
                try {
                    LZ4BlockInputStream uncompressingInputStream = new LZ4BlockInputStream(rabbitInputStreamProvider.getInputStream());
                    for (Replicable replicable : replicables) {
                        logger.info("Starting to receive initial load for " + replicable.getId());
                        try {
                            replicable.initiallyFillFrom((InputStream)uncompressingInputStream);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Exception trying to receive initial load for " + replicable.getId(), e);
                            throw e;
                        }
                        logger.info("Done receiving initial load for " + replicable.getId());
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Error while receiving initial load from " + master + ". Cleaning up.", e);
                    this.deregisterReplicaWithMaster(master);
                    this.replicator.stop(false);
                    throw e;
                }
            }
            finally {
                logger.info("Closing channel " + channel + "'s connection " + channel.getConnection());
                channel.getConnection().close();
                logger.info("Resuming replicator to apply queues");
                this.replicator.setSuspended(false);
                AMQP.Queue.DeleteOk deleteOk = consumer.getChannel().queueDelete(queueName);
                logger.info("Deleted queue " + queueName + " used for initial load: " + deleteOk.toString());
                this.initialLoadChannels.remove(master);
            }
        }
    }

    private String registerReplicaWithMaster(ReplicationMasterDescriptor master) throws Exception {
        URL replicationRegistrationRequestURL = master.getReplicationRegistrationRequestURL(this.getServerIdentifier(), ServerInfo.getBuildVersion());
        logger.info("Replication registration request URL: " + replicationRegistrationRequestURL);
        URLConnection registrationRequestConnection = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)replicationRegistrationRequestURL, (String)"POST", (String)master.getBearerToken());
        InputStream content = (InputStream)registrationRequestConnection.getContent();
        StringBuilder uuid = new StringBuilder();
        byte[] buf = new byte[256];
        int read = content.read(buf);
        while (read != -1) {
            uuid.append(new String(buf, 0, read));
            try {
                read = content.read(buf);
            }
            catch (SocketException e) {
                read = -1;
            }
        }
        String replicaUUID = uuid.toString();
        logger.info("Obtained replica UUID " + replicaUUID + " from master");
        this.registerReplicaUuidForMaster(replicaUUID, master);
        return replicaUUID;
    }

    protected void deregisterReplicaWithMaster(ReplicationMasterDescriptor master) {
        try {
            URL replicationDeRegistrationRequestURL = master.getReplicationDeRegistrationRequestURL(this.getServerIdentifier());
            logger.info("Unregistering replica from master " + master + " using URL " + replicationDeRegistrationRequestURL);
            URLConnection deregistrationRequestConnection = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)replicationDeRegistrationRequestURL, (String)"POST", (String)master.getBearerToken());
            StringBuilder uuid = new StringBuilder();
            InputStream content = (InputStream)deregistrationRequestConnection.getContent();
            byte[] buf = new byte[256];
            int read = content.read(buf);
            while (read != -1) {
                uuid.append(new String(buf, 0, read));
                read = content.read(buf);
            }
            content.close();
            for (Replicable<?, ?> r : this.getReplicables()) {
                logger.info("Telling replicable " + r + " that it no longer replicates from master " + master);
                r.stoppedReplicatingFrom(master);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void registerReplicaUuidForMaster(String uuid, ReplicationMasterDescriptor master) {
        this.replicaUUIDs.put(master, uuid);
    }

    public Map<Class<? extends OperationWithResult<?, ?>>, Integer> getStatistics(ReplicaDescriptor replicaDescriptor) {
        return this.replicationInstancesManager.getStatistics(replicaDescriptor);
    }

    public double getAverageNumberOfOperationsPerMessage(ReplicaDescriptor replicaDescriptor) {
        return this.replicationInstancesManager.getAverageNumberOfOperationsPerMessage(replicaDescriptor);
    }

    public long getNumberOfMessagesSent(ReplicaDescriptor replica) {
        return this.replicationInstancesManager.getNumberOfMessagesSent(replica);
    }

    public long getNumberOfBytesSent(ReplicaDescriptor replica) {
        return this.replicationInstancesManager.getNumberOfBytesSent(replica);
    }

    public double getAverageNumberOfBytesPerMessage(ReplicaDescriptor replica) {
        return this.replicationInstancesManager.getAverageNumberOfBytesPerMessage(replica);
    }

    public Iterable<Replicable<?, ?>> getAllReplicables() {
        return this.getReplicablesProvider().getReplicables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopToReplicateFromMaster() throws IOException {
        ReplicationMasterDescriptor descriptor = this.getReplicatingFromMaster();
        if (descriptor != null) {
            InitialLoadRequest initialLoad = this.initialLoadChannels.get(descriptor);
            if (initialLoad != null) {
                try {
                    Channel channelForInitialLoad = initialLoad.getChannelForInitialLoad();
                    AMQP.Queue.DeleteOk deleteOk = channelForInitialLoad.queueDelete(initialLoad.getQueueName());
                    logger.info("Deleted queue " + initialLoad.getQueueName() + " used for initial load: " + deleteOk.toString());
                    this.initialLoadChannels.remove(descriptor);
                    channelForInitialLoad.getConnection().close();
                    channelForInitialLoad.close();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error trying to close initial load channel / connection to message queueing system", e);
                }
            }
            ConcurrentMap<ReplicationMasterDescriptor, String> concurrentMap = this.replicaUUIDs;
            synchronized (concurrentMap) {
                if (this.replicator != null) {
                    this.replicator.stop(true);
                    this.deregisterReplicaWithMaster(descriptor);
                    this.replicatingFromMaster = null;
                    this.replicaUUIDs.clear();
                    this.replicatorThread.interrupt();
                    this.replicator = null;
                }
            }
        }
    }

    public void stopAllReplicas() throws IOException {
        if (this.replicationInstancesManager.hasReplicas()) {
            this.replicationInstancesManager.removeAll();
            this.removeAsListenerFromReplicables();
            this.closeOutboundReplicationChannel();
            logger.info("Unregistered all replicas from this server!");
        }
    }

    private synchronized void closeOutboundReplicationChannel() throws IOException {
        if (this.masterChannel != null) {
            this.masterChannel.getConnection().close();
            this.masterChannel = null;
        }
        this.outboundBufferPoolForOperationsAllowingForAsynchronousExecution.stop();
    }

    public UUID getServerIdentifier() {
        return this.serverUUID;
    }

    public ReplicationMasterDescriptor createReplicationMasterDescriptor(String messagingHostname, String hostname, String exchangeName, int servletPort, int messagingPort, String queueName, String bearerToken, Iterable<Replicable<?, ?>> replicables) {
        return new ReplicationMasterDescriptorImpl(messagingHostname, exchangeName, messagingPort, queueName, hostname, servletPort, bearerToken, replicables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReplicationStartingListener(ReplicationService.ReplicationStartingListener listener) {
        Set<ReplicationService.ReplicationStartingListener> set = this.replicationStartingListeners;
        synchronized (set) {
            this.replicationStartingListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReplicationStartingListener(ReplicationService.ReplicationStartingListener listener) {
        Set<ReplicationService.ReplicationStartingListener> set = this.replicationStartingListeners;
        synchronized (set) {
            this.replicationStartingListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplicationStarting(boolean newReplicationStarting) {
        Set<ReplicationService.ReplicationStartingListener> set = this.replicationStartingListeners;
        synchronized (set) {
            if (this.replicationStarting != newReplicationStarting) {
                this.replicationStarting = newReplicationStarting;
                for (ReplicationService.ReplicationStartingListener listener : this.replicationStartingListeners) {
                    listener.onReplicationStartingChanged(newReplicationStarting);
                }
            }
        }
    }

    public boolean isReplicationStarting() {
        return this.replicationStarting;
    }

    public <S, O extends OperationWithResult<S, ?>, T> void scheduleForSending(O operationWithResult, OperationsToMasterSender<S, O> sender) {
        this.unsentOperationsSenderJob.scheduleForSending(operationWithResult, sender);
    }

    public synchronized ReplicationStatus getStatus() {
        long messageQueueLength;
        boolean stopped;
        ReplicationReceiver replicationReceiver = this.getReplicator();
        boolean isReplicationStarting = this.isReplicationStarting();
        boolean isReplica = isReplicationStarting || replicationReceiver != null;
        boolean suspended = replicationReceiver == null ? false : replicationReceiver.isSuspended();
        boolean bl = stopped = replicationReceiver == null ? false : replicationReceiver.isBeingStopped();
        if (replicationReceiver == null) {
            messageQueueLength = 0L;
        } else {
            try {
                messageQueueLength = replicationReceiver.getMessageQueueSize();
            }
            catch (IllegalAccessException e) {
                logger.warning("Unable to access replication message queue size: " + e.getMessage() + ". Reporting as -1");
                messageQueueLength = -1L;
            }
        }
        Map operationQueueLengths = replicationReceiver == null ? new HashMap() : replicationReceiver.getOperationQueueSizes();
        HashMap<String, Boolean> isInitialLoadRunning = new HashMap<String, Boolean>();
        for (Replicable<?, ?> replicable : this.getAllReplicables()) {
            isInitialLoadRunning.put(replicable.getId().toString(), replicable.isCurrentlyFillingFromInitialLoad());
        }
        return new ReplicationStatusImpl(isReplica, ServerInfo.getName(), isReplicationStarting, suspended, stopped, messageQueueLength, isInitialLoadRunning, operationQueueLengths, this.getReplicatingFromMaster(), this.getReplicaInfo(), this.exchangeName, this.exchangePort);
    }

    private static class InitialLoadRequest {
        private final Channel channelForInitialLoad;
        private final Iterable<Replicable<?, ?>> replicables;
        private final String queueName;

        public InitialLoadRequest(Channel channelForInitialLoad, Iterable<Replicable<?, ?>> replicables, String queueName) {
            this.channelForInitialLoad = channelForInitialLoad;
            this.replicables = replicables;
            this.queueName = queueName;
        }

        public Channel getChannelForInitialLoad() {
            return this.channelForInitialLoad;
        }

        public Iterable<Replicable<?, ?>> getReplicables() {
            return this.replicables;
        }

        protected String getQueueName() {
            return this.queueName;
        }
    }

    private class LifeCycleListener
    implements ReplicablesProvider.ReplicableLifeCycleListener {
        private LifeCycleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replicableAdded(Replicable<?, ?> replicable) {
            ReplicationInstancesManager replicationInstancesManager = ReplicationServiceImpl.this.replicationInstancesManager;
            synchronized (replicationInstancesManager) {
                if (Util.contains(ReplicationServiceImpl.this.replicationInstancesManager.getAllReplicableIdsAtLeastOneReplicaIsReplicating(), (Object)replicable.getId().toString())) {
                    ReplicationServiceImpl.this.ensureOperationExecutionListener(replicable);
                }
            }
        }

        public void replicableRemoved(String replicableIdAsString) {
            ReplicationServiceExecutionListener listener = (ReplicationServiceExecutionListener)ReplicationServiceImpl.this.executionListenersByReplicableIdAsString.remove(replicableIdAsString);
            if (listener != null) {
                listener.unsubscribe();
            }
        }
    }
}

