/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import com.sap.sse.common.Named;
import com.sap.sse.common.Util;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicablesProvider;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.ReplicationReceiver;
import com.sap.sse.replication.impl.OperationQueueByKeyExecutor;
import com.sap.sse.replication.impl.ReplicationServiceImpl;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ReplicationReceiverImpl
implements ReplicationReceiver,
Runnable {
    private static final Logger logger = Logger.getLogger(ReplicationReceiverImpl.class.getName());
    private static final long CHECK_INTERVAL_MILLIS = 5000L;
    private static final int CHECK_COUNT = Integer.MAX_VALUE;
    private final ReplicationMasterDescriptor master;
    private final ReplicablesProvider replicableProvider;
    private final Map<String, LinkedBlockingQueue<Util.Pair<String, OperationWithResult<?, ?>>>> queueByReplicableIdAsString = new HashMap();
    private QueueingConsumer consumer;
    private int checksPerformed = 0;
    private boolean suspended;
    private boolean stopped = false;
    private Field _queue;
    private int operationCounter;
    private final AtomicLong maximumDeliveryTagSoFar = new AtomicLong();
    long maximumDeliveryTagAcknowledged;
    private final AtomicInteger acknowledgeTaskScheduledButNotYetStarted = new AtomicInteger();
    private static final Object acknowledgementTaskLock = new Object();
    private static final Executor executor = ThreadPoolUtil.INSTANCE.createForegroundTaskThreadPoolExecutor(ReplicationReceiverImpl.class.getName());
    private final OperationQueueByKeyExecutor operationQueueByKeyExecutor;

    public ReplicationReceiverImpl(ReplicationMasterDescriptor master, ReplicablesProvider replicableProvider, boolean startSuspended, QueueingConsumer consumer) {
        this.master = master;
        this.replicableProvider = replicableProvider;
        this.suspended = startSuspended;
        this.consumer = consumer;
        this.operationQueueByKeyExecutor = new OperationQueueByKeyExecutor(executor);
        try {
            this._queue = QueueingConsumer.class.getDeclaredField("_queue");
            this._queue.setAccessible(true);
        }
        catch (Exception e) {
            this._queue = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long messageCount = 0L;
        long operationCount = 0L;
        boolean logsFine = logger.isLoggable(Level.FINE);
        while (!this.isBeingStopped()) {
            try {
                String replicableIdAsString;
                boolean legacyVersion;
                QueueingConsumer.Delivery delivery = this.consumer.nextDelivery();
                ++messageCount;
                this.acknowledgeAsync(this.consumer.getChannel(), delivery);
                if (this._queue != null) {
                    ReplicationReceiverImpl replicationReceiverImpl = this;
                    synchronized (replicationReceiverImpl) {
                        if (this.getInboundMessageQueue().isEmpty()) {
                            this.notifyAll();
                        }
                    }
                    if (logsFine || messageCount % 10L == 0L) {
                        try {
                            logger.log(messageCount % 10L == 0L ? Level.INFO : Level.FINE, "Received " + messageCount + " replication messages with " + operationCount + " operations in total. Inbound replication queue size: " + this.getMessageQueueSize());
                        }
                        catch (Exception e) {
                            logger.info("Received " + messageCount + " replication messages with " + operationCount + " operations in total.");
                        }
                    }
                }
                byte[] bytesFromMessage = delivery.getBody();
                this.checksPerformed = 0;
                InputStream uncompressingInputStream = ReplicationServiceImpl.createUncompressingInputStream(new ByteArrayInputStream(bytesFromMessage));
                DataInputStream dataInputStream = new DataInputStream(uncompressingInputStream);
                String replicableIdAsStringOrVersionIndicator = dataInputStream.readUTF();
                if (replicableIdAsStringOrVersionIndicator.equals("***")) {
                    legacyVersion = false;
                    int protocolVersion = dataInputStream.read();
                    logger.fine(() -> "Found protocol version " + protocolVersion);
                    replicableIdAsString = dataInputStream.readUTF();
                } else {
                    legacyVersion = true;
                    logger.fine("No protocol version indicator found; using legacy protocol");
                    replicableIdAsString = replicableIdAsStringOrVersionIndicator;
                }
                Replicable replicable = this.replicableProvider.getReplicable(replicableIdAsString, false);
                if (replicable != null) {
                    HashMap classLoaderCache = new HashMap();
                    ObjectInputStream ois = legacyVersion ? new ObjectInputStream(uncompressingInputStream) : replicable.createObjectInputStreamResolvingAgainstCache(uncompressingInputStream, classLoaderCache);
                    int operationsInMessage = 0;
                    try {
                        while (true) {
                            if (legacyVersion) {
                                byte[] serializedOperation = (byte[])ois.readObject();
                                if (Util.contains((Iterable)this.master.getReplicables(), (Object)replicable)) {
                                    this.readLegacyOperationAndApplyOrQueueIt(replicable, serializedOperation, classLoaderCache);
                                }
                            } else {
                                this.readOperationAndApplyOrQueueIt(replicable, ois);
                            }
                            if (Util.contains((Iterable)this.master.getReplicables(), (Object)replicable)) {
                                ++operationsInMessage;
                                if (++operationCount % 10000L != 0L) continue;
                                logger.info("Received " + operationCount + " operations so far");
                                continue;
                            }
                            logger.fine("Dropping operation for non-replicated replicable " + replicable.getId());
                        }
                    }
                    catch (EOFException eof) {
                        logger.fine("Reached EOF on replication message after having read " + operationsInMessage + " operations");
                        continue;
                    }
                }
                Stream<Named> sn = StreamSupport.stream(this.replicableProvider.getReplicables().spliterator(), false).map(r -> (Named & Serializable)() -> r.getId().toString());
                logger.warning("received replication message for replicable with ID " + replicableIdAsString + " which is unknnown by this replicator " + "which only knows " + Util.join((String)", ", sn::iterator));
            }
            catch (ConsumerCancelledException cce) {
                logger.info("Consumer has been shut down properly.");
                break;
            }
            catch (InterruptedException irr) {
                logger.info("Application requested shutdown.");
                break;
            }
            catch (ShutdownSignalException sse) {
                if (this.isBeingStopped()) break;
                if (sse.isInitiatedByApplication()) {
                    logger.severe("Application shut down messaging queue for " + this.toString());
                    break;
                }
                logger.severe("RabbitMQ channel was shut down: " + sse.getMessage() + "; trying to re-connect");
                if (this.checksPerformed <= Integer.MAX_VALUE) {
                    try {
                        Thread.sleep(5000L);
                        if (!this.consumer.getChannel().isOpen()) {
                            this.maximumDeliveryTagAcknowledged = 0L;
                            this.maximumDeliveryTagSoFar.set(0L);
                            try {
                                logger.info("Channel seems to be closed. Trying to reconnect consumer queue...");
                                this.consumer = this.master.getConsumer();
                                logger.info("OK - channel reconnected!");
                                Thread.sleep(5000L);
                                ++this.checksPerformed;
                            }
                            catch (IOException | TimeoutException bytesFromMessage) {}
                        }
                    }
                    catch (InterruptedException eir) {
                        logger.log(Level.WARNING, "Interrupted while trying to re-connect", eir);
                    }
                    ++this.checksPerformed;
                    continue;
                }
                logger.severe("Grace time (10737418235secs) is over. Terminating replication listener " + this.toString());
                break;
            }
            catch (Exception e) {
                logger.info("Exception while processing replica: " + e.getMessage());
                logger.log(Level.SEVERE, "run", e);
            }
        }
        logger.info("Stopped replicator thread. This server will no longer receive events from a master.");
        ReplicationReceiverImpl replicationReceiverImpl = this;
        synchronized (replicationReceiverImpl) {
            this.stopped = true;
            this.notifyAll();
        }
    }

    private <S, O extends OperationWithResult<S, ?>> void readLegacyOperationAndApplyOrQueueIt(Replicable<S, O> replicable, byte[] serializedOperation, Map<String, Class<?>> classLoaderCache) throws ClassNotFoundException, IOException {
        OperationWithResult operation = replicable.readOperation((InputStream)new ByteArrayInputStream(serializedOperation), classLoaderCache);
        this.applyOrQueue(operation, replicable);
    }

    private void acknowledgeAsync(Channel channel, QueueingConsumer.Delivery delivery) {
        long deliveryTag = delivery.getEnvelope().getDeliveryTag();
        this.maximumDeliveryTagSoFar.accumulateAndGet(deliveryTag, (lastMaxTag, newTag) -> newTag > lastMaxTag ? newTag : lastMaxTag);
        logger.finer(() -> "Asynchronously acknowledging message with delivery tag " + deliveryTag);
        if (this.acknowledgeTaskScheduledButNotYetStarted.get() == 0) {
            this.acknowledgeTaskScheduledButNotYetStarted.incrementAndGet();
            logger.finer(() -> "Scheduling background task to acknowledge delivery tag " + deliveryTag);
            ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().submit(() -> {
                Object object = acknowledgementTaskLock;
                synchronized (object) {
                    this.acknowledgeTaskScheduledButNotYetStarted.decrementAndGet();
                    long deliveryTagToAcknowledge = this.maximumDeliveryTagSoFar.get();
                    if (deliveryTagToAcknowledge > this.maximumDeliveryTagAcknowledged) {
                        try {
                            logger.fine(() -> "Sending acknowledgement for delivery tag " + deliveryTagToAcknowledge + ", scheduled at delivery tag " + deliveryTag);
                            channel.basicAck(deliveryTagToAcknowledge, true);
                            this.maximumDeliveryTagAcknowledged = deliveryTagToAcknowledge;
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Acknowledging message with delivery tag " + deliveryTagToAcknowledge + " cumulatively failed", e);
                        }
                    } else {
                        logger.fine(() -> "Not acknowledging " + deliveryTagToAcknowledge + " again because " + this.maximumDeliveryTagAcknowledged + " has already been acknowledged");
                    }
                }
            });
        }
    }

    public int getMessageQueueSize() throws IllegalAccessException {
        return this.getInboundMessageQueue().size();
    }

    public Map<String, Integer> getOperationQueueSizes() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, LinkedBlockingQueue<Util.Pair<String, OperationWithResult<?, ?>>>> e : this.queueByReplicableIdAsString.entrySet()) {
            result.put(e.getKey(), e.getValue().size());
        }
        return result;
    }

    private BlockingQueue<?> getInboundMessageQueue() throws IllegalAccessException {
        return (BlockingQueue)this._queue.get(this.consumer);
    }

    private <S, O extends OperationWithResult<S, ?>> void readOperationAndApplyOrQueueIt(Replicable<S, O> replicable, ObjectInputStream ois) throws ClassNotFoundException, IOException {
        OperationWithResult operation = replicable.readOperationFromObjectInputStream(ois);
        if (Util.contains((Iterable)this.master.getReplicables(), replicable)) {
            this.applyOrQueue(operation, replicable);
        }
    }

    private synchronized <S, O extends OperationWithResult<S, ?>> void applyOrQueue(O operation, Replicable<S, O> replicable) {
        if (this.isSuspended()) {
            this.queue(operation, replicable);
        } else {
            this.apply(operation, replicable);
        }
    }

    private synchronized <S, O extends OperationWithResult<S, ?>> void apply(O operation, Replicable<S, O> replicable) {
        int operationCount = ++this.operationCounter;
        logger.finer(() -> operationCount + ": Applying " + operation);
        Runnable runnable = () -> replicable.applyReceivedReplicated(operation);
        if (operation.requiresSynchronousExecution()) {
            runnable.run();
        } else {
            this.operationQueueByKeyExecutor.schedule(operation.getKeyForAsynchronousExecution(), runnable);
        }
        logger.finer(() -> operationCount + ": Done applying " + operation);
    }

    private void queue(OperationWithResult<?, ?> operation, Replicable<?, ?> replicable) {
        String replicableIdAsString = replicable.getId().toString();
        LinkedBlockingQueue<Object> queue = this.queueByReplicableIdAsString.get(replicableIdAsString);
        if (queue == null) {
            queue = new LinkedBlockingQueue();
            this.queueByReplicableIdAsString.put(replicableIdAsString, queue);
        }
        queue.add(new Util.Pair((Object)replicable.getId().toString(), operation));
        assert (!queue.isEmpty());
    }

    public synchronized void setSuspended(boolean suspended) {
        if (this.suspended != suspended) {
            if (!suspended) {
                this.applyQueues(true);
            } else {
                this.suspended = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyQueues(boolean resumeWhenDone) {
        logger.info("Applying queued replication messages received");
        for (Map.Entry<String, LinkedBlockingQueue<Util.Pair<String, OperationWithResult<?, ?>>>> r : this.queueByReplicableIdAsString.entrySet()) {
            Replicable replicable = this.replicableProvider.getReplicable(r.getKey(), false);
            LinkedBlockingQueue<Util.Pair<String, OperationWithResult<?, ?>>> queue = r.getValue();
            boolean queueEmpty = false;
            do {
                Util.Pair<String, OperationWithResult<?, ?>> replicableIdAsStringAndOperation;
                ReplicationReceiverImpl replicationReceiverImpl = this;
                synchronized (replicationReceiverImpl) {
                    replicableIdAsStringAndOperation = queue.poll();
                    if (resumeWhenDone && replicableIdAsStringAndOperation == null) {
                        queueEmpty = true;
                        this.suspended = false;
                        this.notifyAll();
                    }
                }
                if (replicableIdAsStringAndOperation == null) continue;
                try {
                    this.applyWithCast((OperationWithResult)replicableIdAsStringAndOperation.getB(), replicable);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error applying queued, replicated operation " + replicableIdAsStringAndOperation + ". Continuing with next queued operation.", e);
                }
            } while (!queueEmpty);
            assert (queue.isEmpty());
        }
        if (resumeWhenDone) {
            this.suspended = false;
        }
        this.notifyAll();
    }

    private <S, O extends OperationWithResult<S, ?>> void applyWithCast(O operation, Replicable<?, ?> replicable) {
        Replicable<?, ?> castReplicable = replicable;
        this.apply(operation, castReplicable);
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public synchronized void stop(boolean applyQueuedMessages) {
        if (applyQueuedMessages) {
            if (this.isSuspended()) {
                this.applyQueues(false);
            }
        } else {
            logger.info("Discarding queued replication messages received");
            for (LinkedBlockingQueue<Util.Pair<String, OperationWithResult<?, ?>>> queue : this.queueByReplicableIdAsString.values()) {
                queue.clear();
            }
        }
        logger.info("Signaled Replicator thread to stop asap.");
        this.stopped = true;
        this.master.stopConnection(false);
        this.notifyAll();
    }

    public synchronized boolean isBeingStopped() {
        return this.stopped;
    }

    public String toString() {
        long queueSize = this.queueByReplicableIdAsString.values().stream().mapToLong(l -> l.size()).sum();
        return "Replicator for master " + this.master + ", queue size: " + queueSize;
    }

    public boolean isQueueEmptyOrStopped() throws IllegalAccessException {
        return this.isBeingStopped() || (this._queue == null || this.getInboundMessageQueue().isEmpty()) && !this.queueByReplicableIdAsString.values().stream().anyMatch(q -> !q.isEmpty());
    }
}

