/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicablesProvider;
import com.sap.sse.replication.impl.AbstractReplicablesProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGiReplicableTracker
extends AbstractReplicablesProvider {
    private static final Logger logger = Logger.getLogger(OSGiReplicableTracker.class.getName());
    private final ServiceTracker<Replicable<?, ?>, Replicable<?, ?>> serviceTracker;
    private final Map<String, ServiceReference<Replicable<?, ?>>> serviceReferenceByIdAsString;
    private final Map<ServiceReference<Replicable<?, ?>>, String> idAsStringByServiceReference;
    private final BundleContext bundleContext;

    public OSGiReplicableTracker(final BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceReferenceByIdAsString = new HashMap();
        this.idAsStringByServiceReference = new HashMap();
        this.serviceTracker = new ServiceTracker(bundleContext, Replicable.class.getName(), new ServiceTrackerCustomizer<Replicable<?, ?>, Replicable<?, ?>>(){

            public Replicable<?, ?> addingService(ServiceReference<Replicable<?, ?>> reference) {
                Replicable result = (Replicable)bundleContext.getService(reference);
                OSGiReplicableTracker.this.serviceReferenceByIdAsString.put(result.getId().toString(), reference);
                OSGiReplicableTracker.this.idAsStringByServiceReference.put(reference, result.getId().toString());
                OSGiReplicableTracker.this.notifyReplicableLifeCycleListenersAboutReplicableAdded(result);
                return result;
            }

            public void removedService(ServiceReference<Replicable<?, ?>> reference, Replicable<?, ?> service) {
                OSGiReplicableTracker.this.serviceReferenceByIdAsString.remove(OSGiReplicableTracker.this.idAsStringByServiceReference.get(reference));
                OSGiReplicableTracker.this.idAsStringByServiceReference.remove(reference);
                OSGiReplicableTracker.this.notifyReplicableLifeCycleListenersAboutReplicableRemoved((String)reference.getProperty("ID"));
            }

            public void modifiedService(ServiceReference<Replicable<?, ?>> reference, Replicable<?, ?> service) {
            }
        });
        this.serviceTracker.open();
    }

    public Iterable<Replicable<?, ?>> getReplicables() {
        return Arrays.asList((Replicable[])this.serviceTracker.getServices((Object[])new Replicable[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Replicable<?, ?> getReplicable(String replicableIdAsString, boolean wait) {
        ServiceReference<Replicable<?, ?>> serviceReference = this.serviceReferenceByIdAsString.get(replicableIdAsString);
        Replicable[] foundReplicable = new Replicable[1];
        Object monitor = new Object();
        ReplicablesProvider.AddOnlyReplicableLifeCycleListener listener = replicable -> {
            if (replicable.getId().equals(replicableIdAsString)) {
                replicableArray[0] = replicable;
                Object object2 = monitor;
                synchronized (object2) {
                    monitor.notifyAll();
                }
            }
        };
        Object object = monitor;
        synchronized (object) {
            Replicable result;
            Replicable preResult;
            this.addReplicableLifeCycleListener((ReplicablesProvider.ReplicableLifeCycleListener)listener);
            Replicable replicable2 = preResult = serviceReference == null ? null : (Replicable)this.bundleContext.getService(serviceReference);
            if (preResult == null && wait) {
                while (foundReplicable[0] == null) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Exception while waiting for replicable " + replicableIdAsString + ". Continuing to wait...", e);
                    }
                }
                result = foundReplicable[0];
            } else {
                result = preResult;
            }
            this.removeReplicableLifeCycleListener((ReplicablesProvider.ReplicableLifeCycleListener)listener);
            return result;
        }
    }
}

