/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.sap.sse.common.Util;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicablesProvider;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.replication.impl.OSGiReplicableTracker;
import com.sap.sse.replication.impl.ReplicationInstancesManager;
import com.sap.sse.replication.impl.ReplicationMasterDescriptorImpl;
import com.sap.sse.replication.impl.ReplicationServiceImpl;
import com.sap.sse.replication.persistence.PersistenceFactory;
import com.sap.sse.security.util.RemoteServerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static final String PROPERTY_NAME_EXCHANGE_HOST = "replication.exchangeHost";
    private static final String PROPERTY_NAME_EXCHANGE_PORT = "replication.exchangePort";
    private static final String PROPERTY_NAME_EXCHANGE_NAME = "replication.exchangeName";
    public static final String ENV_VAR_NAME_REPLICATION_CHANNEL = "REPLICATION_CHANNEL";
    public static final String ENV_VAR_NAME_REPLICATION_HOST = "REPLICATION_HOST";
    public static final String ENV_VAR_NAME_REPLICATION_PORT = "REPLICATION_PORT";
    public static final String PROPERTY_NAME_REPLICATE_ON_START = "replicate.on.start";
    public static final String PROPERTY_NAME_RESTORE_REPLICAS = "replicate.restore.replicas";
    public static final String PROPERTY_NAME_REPLICATE_MASTER_SERVLET_HOST = "replicate.master.servlet.host";
    public static final String PROPERTY_NAME_REPLICATE_MASTER_SERVLET_PORT = "replicate.master.servlet.port";
    public static final String PROPERTY_NAME_REPLICATE_MASTER_QUEUE_HOST = "replicate.master.queue.host";
    public static final String PROPERTY_NAME_REPLICATE_MASTER_QUEUE_PORT = "replicate.master.queue.port";
    public static final String PROPERTY_NAME_REPLICATE_MASTER_EXCHANGE_NAME = "replicate.master.exchange.name";
    public static final String PROPERTY_NAME_REPLICATE_MASTER_USERNAME = "replicate.master.username";
    public static final String PROPERTY_NAME_REPLICATE_MASTER_PASSWORD = "replicate.master.password";
    public static final String PROPERTY_NAME_REPLICATE_MASTER_BEARER_TOKEN = "replicate.master.bearer_token";
    private ReplicationInstancesManager replicationInstancesManager;
    private ReplicationServiceImpl serverReplicationMasterService;
    private static BundleContext defaultContext;

    public void start(BundleContext bundleContext) throws Exception {
        boolean autoReplicationRequested;
        defaultContext = bundleContext;
        String exchangeName = bundleContext.getProperty(PROPERTY_NAME_EXCHANGE_NAME);
        String exchangeHost = bundleContext.getProperty(PROPERTY_NAME_EXCHANGE_HOST);
        String exchangePortAsString = bundleContext.getProperty(PROPERTY_NAME_EXCHANGE_PORT);
        if (exchangeName == null) {
            exchangeName = System.getenv(ENV_VAR_NAME_REPLICATION_CHANNEL) == null ? "sapsailinganalytics" : System.getenv(ENV_VAR_NAME_REPLICATION_CHANNEL);
        }
        if (exchangeHost == null) {
            exchangeHost = System.getenv(ENV_VAR_NAME_REPLICATION_HOST) == null ? "localhost" : System.getenv(ENV_VAR_NAME_REPLICATION_HOST);
        }
        if (exchangePortAsString == null) {
            exchangePortAsString = System.getenv(ENV_VAR_NAME_REPLICATION_PORT) == null ? "0" : System.getenv(ENV_VAR_NAME_REPLICATION_PORT);
        }
        int exchangePort = 0;
        try {
            exchangePort = Integer.valueOf(exchangePortAsString);
        }
        catch (NumberFormatException nfe) {
            logger.severe("Couldn't parse the replication port specification \"" + exchangePortAsString + "\". Using default.");
        }
        Iterable replicasToAssumeConnectedToThisMaster = Boolean.valueOf(System.getProperty(PROPERTY_NAME_RESTORE_REPLICAS, "true")) != false ? PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory().loadReplicaDescriptors() : null;
        this.replicationInstancesManager = new ReplicationInstancesManager();
        OSGiReplicableTracker replicablesProvider = new OSGiReplicableTracker(bundleContext);
        this.serverReplicationMasterService = new ReplicationServiceImpl(replicasToAssumeConnectedToThisMaster, Optional.of(PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory()), exchangeName, exchangeHost, exchangePort, this.replicationInstancesManager, replicablesProvider);
        String replicateOnStart = System.getProperty(PROPERTY_NAME_REPLICATE_ON_START);
        boolean bl = autoReplicationRequested = replicateOnStart != null && !replicateOnStart.isEmpty();
        if (autoReplicationRequested) {
            this.serverReplicationMasterService.setReplicationStarting(true);
        }
        bundleContext.registerService(ReplicationService.class, (Object)this.serverReplicationMasterService, null);
        logger.info("Registered replication service " + this.serverReplicationMasterService + " using exchange name " + exchangeName + " on host " + exchangeHost);
        if (autoReplicationRequested) {
            this.triggerAutomaticReplication(this.serverReplicationMasterService, replicateOnStart, exchangeName, replicablesProvider);
        }
    }

    private void triggerAutomaticReplication(ReplicationService serverReplicationMasterService, String replicateOnStart, String masterExchangeName, ReplicablesProvider replicablesProvider) {
        assert (replicateOnStart != null && !replicateOnStart.isEmpty());
        serverReplicationMasterService.setReplicationStarting(true);
        Object[] replicableIdsAsStrings = replicateOnStart.split(",");
        new Thread("ServiceTracker waiting for Replicables " + Arrays.toString(replicableIdsAsStrings), (String[])replicableIdsAsStrings, replicablesProvider, masterExchangeName, serverReplicationMasterService){
            private final /* synthetic */ String[] val$replicableIdsAsStrings;
            private final /* synthetic */ ReplicablesProvider val$replicablesProvider;
            private final /* synthetic */ String val$masterExchangeName;
            private final /* synthetic */ ReplicationService val$serverReplicationMasterService;
            {
                this.val$replicableIdsAsStrings = stringArray;
                this.val$replicablesProvider = replicablesProvider;
                this.val$masterExchangeName = string;
                this.val$serverReplicationMasterService = replicationService;
                super($anonymous0);
            }

            @Override
            public void run() {
                try {
                    logger.info("Waiting for Replicables " + Arrays.toString(this.val$replicableIdsAsStrings) + " before firing up replication automatically...");
                    ArrayList replicables = new ArrayList();
                    String[] stringArray = this.val$replicableIdsAsStrings;
                    int n = this.val$replicableIdsAsStrings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String replicableIdAsString = stringArray[n2];
                        logger.info("Trying to obtain Replicable " + replicableIdAsString + ", waiting if necessary");
                        Replicable replicable = this.val$replicablesProvider.getReplicable(replicableIdAsString, true);
                        logger.info("Obtained Replicable " + replicableIdAsString);
                        replicables.add(replicable);
                        ++n2;
                    }
                    logger.info("Configuration requested automatic replication for replicables " + Arrays.toString(this.val$replicableIdsAsStrings) + ". Starting it up...");
                    String replicateFromExchangeName = System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_EXCHANGE_NAME);
                    if (replicateFromExchangeName == null) {
                        replicateFromExchangeName = this.val$masterExchangeName;
                    }
                    String servletHost = System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_SERVLET_HOST);
                    int servletPort = Integer.valueOf(System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_SERVLET_PORT).trim());
                    String bearerToken = Util.hasLength((String)System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_BEARER_TOKEN)) ? System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_BEARER_TOKEN).trim() : RemoteServerUtil.resolveBearerTokenForRemoteServer((String)servletHost, (int)servletPort, (String)System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_USERNAME), (String)System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_PASSWORD));
                    ReplicationMasterDescriptorImpl master = new ReplicationMasterDescriptorImpl(System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_QUEUE_HOST), replicateFromExchangeName, Integer.valueOf(System.getProperty(Activator.PROPERTY_NAME_REPLICATE_MASTER_QUEUE_PORT).trim()), this.val$serverReplicationMasterService.getServerIdentifier().toString(), servletHost, servletPort, bearerToken, replicables);
                    try {
                        this.val$serverReplicationMasterService.startToReplicateFrom((ReplicationMasterDescriptor)master);
                        this.val$serverReplicationMasterService.setReplicationStarting(false);
                        logger.info("Automatic replication has been started.");
                    }
                    catch (IOException | ClassNotFoundException | InterruptedException e) {
                        logger.log(Level.SEVERE, "Error with automatic replication from " + master, e);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error starting automatic replication", e);
                }
            }
        }.start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.serverReplicationMasterService.getReplicatingFromMaster() != null) {
            this.serverReplicationMasterService.stopToReplicateFromMaster();
        }
        this.serverReplicationMasterService.stopAllReplicas();
    }

    public static BundleContext getDefaultContext() {
        return defaultContext;
    }
}

