/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.server;

import com.sap.sse.ServerInfo;
import com.sap.sse.common.Util;
import com.sap.sse.common.mail.MailException;
import com.sap.sse.security.Action;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.UnauthorizedException;
import com.sap.sse.security.shared.UserGroupManagementException;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.RoleDefinitionDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.dto.UserGroupDTO;
import com.sap.sse.security.shared.dto.WildcardPermissionWithSecurityDTO;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.PermissionAndRoleAssociation;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.impl.UserGroupImpl;
import com.sap.sse.security.ui.client.UserManagementWriteService;
import com.sap.sse.security.ui.oauth.client.CredentialDTO;
import com.sap.sse.security.ui.oauth.shared.OAuthException;
import com.sap.sse.security.ui.server.UserManagementServiceImpl;
import com.sap.sse.security.ui.shared.SuccessInfo;
import com.sap.sse.util.HttpRequestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;

public class UserManagementWriteServiceImpl
extends UserManagementServiceImpl
implements UserManagementWriteService {
    private static final long serialVersionUID = -8123229851467370537L;
    private static final Logger logger = Logger.getLogger(UserManagementWriteServiceImpl.class.getName());

    public OwnershipDTO setOwnership(String username, UUID userGroupId, QualifiedObjectIdentifier idOfOwnedObject, String displayNameOfOwnedObject) {
        SecurityUtils.getSubject().checkPermission(idOfOwnedObject.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP));
        User user = this.getSecurityService().getUserByName(username);
        Ownership result = this.getSecurityService().setOwnership(idOfOwnedObject, user, this.getSecurityService().getUserGroup(userGroupId), displayNameOfOwnedObject);
        return this.securityDTOFactory.createOwnershipDTO(result, new HashMap(), new HashMap());
    }

    public RoleDefinitionDTO createRoleDefinition(String roleDefinitionIdAsString, String name) {
        RoleDefinition role = (RoleDefinition)this.getSecurityService().setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(SecuredSecurityTypes.ROLE_DEFINITION, new TypeRelativeObjectIdentifier(new String[]{roleDefinitionIdAsString}), name, (Callable)new /* Unavailable Anonymous Inner Class!! */);
        return this.securityDTOFactory.createRoleDefinitionDTO(role, this.getSecurityService());
    }

    public void deleteRoleDefinition(String roleIdAsString) {
        RoleDefinition role = this.getSecurityService().getRoleDefinition(UUID.fromString(roleIdAsString));
        if (role != null) {
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)role, (Action)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateRoleDefinition(RoleDefinitionDTO roleDefinitionWithNewProperties) throws UnauthorizedException {
        SecurityUtils.getSubject().checkPermission(SecuredSecurityTypes.ROLE_DEFINITION.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)roleDefinitionWithNewProperties));
        RoleDefinition existingRole = this.getSecurityService().getRoleDefinition(roleDefinitionWithNewProperties.getId());
        if (existingRole == null) {
            throw new UnauthorizedException("Role does not exist");
        }
        HashSet addedPermissions = new HashSet(roleDefinitionWithNewProperties.getPermissions());
        addedPermissions.removeAll(existingRole.getPermissions());
        if (!this.getSecurityService().hasUserAllWildcardPermissionsForAlreadyRealizedQualifications(existingRole, addedPermissions)) {
            throw new UnauthorizedException("Not permitted to grant permissions for role " + roleDefinitionWithNewProperties.getName());
        }
        HashSet removedPermissions = new HashSet(existingRole.getPermissions());
        removedPermissions.removeAll(roleDefinitionWithNewProperties.getPermissions());
        if (!this.getSecurityService().hasUserAllWildcardPermissionsForAlreadyRealizedQualifications(existingRole, removedPermissions)) {
            throw new UnauthorizedException("Not permitted to revoke permissions for role " + roleDefinitionWithNewProperties.getName());
        }
        this.getSecurityService().updateRoleDefinition((RoleDefinition)roleDefinitionWithNewProperties);
    }

    public UserGroupDTO createUserGroup(String name) throws UnauthorizedException, UserGroupManagementException {
        UUID newTenantId = UUID.randomUUID();
        UserGroup userGroupByName = this.getSecurityService().getUserGroupByName(name);
        if (userGroupByName != null) {
            throw new UserGroupManagementException(String.format("A user group with the name '%s' already exists.", name));
        }
        UserGroup group = (UserGroup)this.getSecurityService().setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(SecuredSecurityTypes.USER_GROUP, UserGroupImpl.getTypeRelativeObjectIdentifier((UUID)newTenantId), name, () -> {
            UserGroup userGroup;
            try {
                userGroup = this.getSecurityService().createUserGroup(newTenantId, name);
            }
            catch (UserGroupManagementException e) {
                throw new UserGroupManagementException(e.getMessage());
            }
            return userGroup;
        });
        HashMap fromOriginalToStrippedDownUser = new HashMap();
        HashMap fromOriginalToStrippedDownUserGroup = new HashMap();
        return this.securityDTOFactory.createUserGroupDTOFromUserGroup(group, fromOriginalToStrippedDownUser, fromOriginalToStrippedDownUserGroup, this.getSecurityService());
    }

    public SuccessInfo deleteUserGroup(String userGroupIdAsString) throws UnauthorizedException {
        UUID userGroupId = UUID.fromString(userGroupIdAsString);
        UserGroup userGroup = this.getSecurityService().getUserGroup(userGroupId);
        if (userGroup != null) {
            return (SuccessInfo)this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)userGroup, () -> {
                try {
                    this.getSecurityService().deleteUserGroup(userGroup);
                    return new SuccessInfo(true, "Deleted user group: " + userGroup.getName() + ".", null, null);
                }
                catch (UserGroupManagementException e) {
                    return new SuccessInfo(false, "Could not delete user group.", null, null);
                }
            });
        }
        return new SuccessInfo(false, "Could not delete user group.", null, null);
    }

    public void addUserToUserGroup(String userGroupIdAsString, String username) throws UnauthorizedException, UserManagementException {
        User userByName;
        UserGroup tenant = this.getSecurityService().getUserGroup(UUID.fromString(userGroupIdAsString));
        if (SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.USER_GROUP.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)tenant))) {
            userByName = this.getSecurityService().getUserByName(username);
            if (userByName == null) {
                throw new UserManagementException("user '" + username + "' not found.");
            }
            if (!this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionsWithQualification(tenant.getRoleDefinitionMap().keySet(), new Ownership(null, tenant))) {
                throw new UnauthorizedException("Current user does not have all the meta permissions of the user group the user would be added to");
            }
        } else {
            throw new UnauthorizedException("Not permitted to add user to group");
        }
        this.getSecurityService().addUserToUserGroup(tenant, userByName);
    }

    public void removeUserFromUserGroup(String userGroupIdAsString, String username) throws UnauthorizedException {
        UserGroup userGroup = this.getSecurityService().getUserGroup(UUID.fromString(userGroupIdAsString));
        if (SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.USER_GROUP.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)userGroup))) {
            if (!this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionsWithQualification(userGroup.getRoleDefinitionMap().keySet(), new Ownership(null, userGroup))) {
                throw new UnauthorizedException("Current user does not have all the meta permissions of the user group the user would be removed from");
            }
        } else {
            throw new UnauthorizedException("Not permitted to remove user from group");
        }
        this.getSecurityService().removeUserFromUserGroup(userGroup, this.getSecurityService().getUserByName(username));
    }

    public void putRoleDefintionToUserGroup(String userGroupIdAsString, String roleDefinitionIdAsString, boolean forAll) throws UnauthorizedException {
        UserGroup userGroup = this.getSecurityService().getUserGroup(UUID.fromString(userGroupIdAsString));
        if (SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.USER_GROUP.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)userGroup))) {
            RoleDefinition roleDefinition = this.getSecurityService().getRoleDefinition(UUID.fromString(roleDefinitionIdAsString));
            if (roleDefinition != null) {
                if (!this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(roleDefinition, new Ownership(null, userGroup))) {
                    throw new UnauthorizedException("Not permitted to add role definition to group");
                }
                logger.info(String.valueOf(SecurityUtils.getSubject().getPrincipal().toString()) + " added role " + roleDefinition.getName() + " to user group " + userGroup.getName());
                this.getSecurityService().putRoleDefinitionToUserGroup(userGroup, roleDefinition, forAll);
            }
        } else {
            throw new UnauthorizedException("Not permitted to add role definition to group");
        }
    }

    public void removeRoleDefinitionFromUserGroup(String userGroupIdAsString, String roleDefinitionIdAsString) throws UnauthorizedException {
        UserGroup userGroup = this.getSecurityService().getUserGroup(UUID.fromString(userGroupIdAsString));
        if (SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.USER_GROUP.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)userGroup))) {
            RoleDefinition roleDefinition = this.getSecurityService().getRoleDefinition(UUID.fromString(roleDefinitionIdAsString));
            if (roleDefinition != null) {
                if (!this.getSecurityService().hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(roleDefinition, new Ownership(null, userGroup))) {
                    throw new UnauthorizedException("Not permitted to remove role definition from group");
                }
                logger.info(String.valueOf(SecurityUtils.getSubject().getPrincipal().toString()) + " removed role " + roleDefinition.getName() + " from user group " + userGroup.getName());
                this.getSecurityService().removeRoleDefintionFromUserGroup(userGroup, roleDefinition);
            }
        } else {
            throw new UnauthorizedException("Not permitted to remove role definition from group");
        }
    }

    public UserDTO createSimpleUser(String username, String email, String password, String fullName, String company, String localeName, String validationBaseURL) throws UserManagementException, MailException, UnauthorizedException {
        String clientIP = HttpRequestUtils.getClientIP((HttpServletRequest)this.getThreadLocalRequest());
        User user = this.getSecurityService().checkPermissionForUserCreationAndRevertOnErrorForUserCreation(username, (Callable)new /* Unavailable Anonymous Inner Class!! */);
        return this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService());
    }

    public void updateSimpleUserPassword(String username, String oldPassword, String passwordResetSecret, String newPassword) throws UserManagementException {
        User user = this.getSecurityService().getUserByName(username);
        if (!(this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)user, new HasPermissions.Action[]{SecuredSecurityTypes.UserActions.FORCE_OVERWRITE_PASSWORD}) || (oldPassword != null && this.getSecurityService().checkPassword(username, oldPassword) || passwordResetSecret != null && this.getSecurityService().checkPasswordResetSecret(username, passwordResetSecret)) && PermissionChecker.isPermitted((WildcardPermission)user.getPermissionType().getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.UPDATE}), (SecurityUser)user, (SecurityUser)this.getSecurityService().getAllUser(), (AbstractOwnership)(this.getSecurityService().getOwnership(user.getIdentifier()) == null ? null : (Ownership)this.getSecurityService().getOwnership(user.getIdentifier()).getAnnotation()), this.getSecurityService().getAccessControlList(user.getIdentifier()) == null ? null : (AccessControlList)this.getSecurityService().getAccessControlList(user.getIdentifier()).getAnnotation()))) {
            throw new UserManagementException("Invalid Credentials");
        }
        this.getSecurityService().updateSimpleUserPassword(username, newPassword);
        this.sendPasswordChangedMailAsync(username);
    }

    public UserDTO updateUserProperties(String username, String fullName, String company, String localeName, String defaultTenant) throws UserManagementException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getCurrentUser());
        this.getSecurityService().updateUserProperties(username, fullName, company, this.getLocaleFromLocaleName(localeName));
        this.getSecurityService().setDefaultTenantForCurrentServerForUser(username, UUID.fromString(defaultTenant));
        return this.securityDTOFactory.createUserDTOFromUser(this.getSecurityService().getUserByName(username), this.getSecurityService());
    }

    public void updateSimpleUserEmail(String username, String newEmail, String validationBaseURL) throws UserManagementException, MailException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getCurrentUser());
        this.getSecurityService().updateSimpleUserEmail(username, newEmail, validationBaseURL);
    }

    public void resetPassword(String username, String email, String passwordResetBaseURL) throws UserManagementException, MailException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getCurrentUser());
        if (username == null || username.isEmpty()) {
            username = this.getSecurityService().getUserByEmail(email).getName();
        }
        this.getSecurityService().resetPassword(username, passwordResetBaseURL);
    }

    public boolean validateEmail(String username, String validationSecret) throws UserManagementException {
        return this.getSecurityService().validateEmail(username, validationSecret);
    }

    public SuccessInfo deleteUser(String username) throws UnauthorizedException {
        User user = this.getSecurityService().getUserByName(username);
        if (user != null) {
            if (!this.getSecurityService().hasCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)user, new HasPermissions.Action[]{HasPermissions.DefaultActions.DELETE})) {
                return new SuccessInfo(false, "You are not permitted to delete user " + username, null, null);
            }
            try {
                return (SuccessInfo)this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval((WithQualifiedObjectIdentifier)user, () -> {
                    try {
                        this.getSecurityService().deleteUser(username);
                        return new SuccessInfo(true, "Deleted user: " + username + ".", null, null);
                    }
                    catch (UserManagementException e) {
                        return new SuccessInfo(false, "Could not delete user.", null, null);
                    }
                });
            }
            catch (AuthorizationException e) {
                return new SuccessInfo(false, "You are not permitted to delete user " + username, null, null);
            }
        }
        return new SuccessInfo(false, "Could not delete user.", null, null);
    }

    public Set<SuccessInfo> deleteUsers(Set<String> usernames) throws UnauthorizedException {
        HashSet<SuccessInfo> result = new HashSet<SuccessInfo>();
        for (String username : usernames) {
            result.add(this.deleteUser(username));
        }
        return result;
    }

    public void setSetting(String key, String clazz, String setting) {
        if (clazz.equals(Boolean.class.getName())) {
            this.getSecurityService().setSetting(key, (Object)Boolean.parseBoolean(setting));
        } else if (clazz.equals(Integer.class.getName())) {
            this.getSecurityService().setSetting(key, (Object)Integer.parseInt(setting));
        } else {
            this.getSecurityService().setSetting(key, (Object)setting);
        }
        this.getSecurityService().refreshSecurityConfig(this.getServletContext());
    }

    public String getAuthorizationUrl(CredentialDTO credential) throws OAuthException {
        logger.info("callback url: " + credential.getRedirectUrl());
        String authorizationUrl = null;
        try {
            authorizationUrl = this.getSecurityService().getAuthenticationUrl(this.createCredentialFromDTO(credential));
        }
        catch (UserManagementException e) {
            throw new OAuthException(e.getMessage());
        }
        return authorizationUrl;
    }

    public void addSetting(String key, String clazz, String setting) {
        try {
            this.getSecurityService().addSetting(key, Class.forName(clazz));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (UserManagementException e) {
            e.printStackTrace();
        }
        if (clazz.equals(Boolean.class.getName())) {
            this.getSecurityService().setSetting(key, (Object)Boolean.parseBoolean(setting));
        } else if (clazz.equals(Integer.class.getName())) {
            this.getSecurityService().setSetting(key, (Object)Integer.parseInt(setting));
        } else {
            this.getSecurityService().setSetting(key, (Object)setting);
        }
        this.getSecurityService().refreshSecurityConfig(this.getServletContext());
    }

    public void setPreference(String username, String key, String value) throws UserManagementException, UnauthorizedException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username));
        this.getSecurityService().setPreference(username, key, value);
    }

    public void setPreferences(String username, Map<String, String> keyValuePairs) throws UserManagementException, UnauthorizedException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username));
        for (Map.Entry<String, String> entry : keyValuePairs.entrySet()) {
            this.getSecurityService().setPreference(username, entry.getKey(), entry.getValue());
        }
    }

    public void unsetPreference(String username, String key) throws UserManagementException, UnauthorizedException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username));
        this.getSecurityService().unsetPreference(username, key);
    }

    public SuccessInfo addRoleToUser(String username, String userQualifierName, UUID roleDefinitionId, String tenantQualifierName, boolean transitive) throws UserManagementException, UnauthorizedException {
        SuccessInfo successInfo;
        try {
            User user = this.getOrThrowUser(username);
            this.getOrThrowQualifiedUser(userQualifierName);
            UserGroup tenant = this.getOrThrowTenant(tenantQualifierName);
            Role role = this.getSecurityService().getOrThrowRoleFromIDsAndCheckMetaPermissions(roleDefinitionId, tenant == null ? null : tenant.getId(), userQualifierName, transitive);
            TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((Role)role, (User)user);
            String message = "User " + SecurityUtils.getSubject().getPrincipal() + " added role " + role.getName() + " for user " + username;
            this.getSecurityService().setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(SecuredSecurityTypes.ROLE_ASSOCIATION, associationTypeIdentifier, associationTypeIdentifier.toString(), (Action)new /* Unavailable Anonymous Inner Class!! */);
            UserDTO userDTO = this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService());
            successInfo = new SuccessInfo(true, message, null, new Util.Triple((Object)userDTO, (Object)this.getAllUser(), (Object)this.getServerInfo()));
        }
        catch (UserManagementException e) {
            successInfo = new SuccessInfo(false, "You are not allowed to grant this role for user " + username + " or the username, group name or role name did not exist.", null, null);
        }
        return successInfo;
    }

    public SuccessInfo removeRoleFromUser(String username, String userQualifierName, UUID roleDefinitionId, String tenantQualifierName, Boolean isTransitive) throws UserManagementException, UnauthorizedException {
        SuccessInfo successInfo;
        try {
            User user = this.getOrThrowUser(username);
            this.getOrThrowQualifiedUser(userQualifierName);
            UserGroup tenant = this.getOrThrowTenant(tenantQualifierName);
            Role role = this.getSecurityService().getOrThrowRoleFromIDsAndCheckMetaPermissions(roleDefinitionId, tenant == null ? null : tenant.getId(), userQualifierName, isTransitive.booleanValue());
            String message = String.valueOf(SecurityUtils.getSubject().getPrincipal().toString()) + " removed role " + role.getName() + " for user " + username;
            TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((Role)role, (User)user);
            QualifiedObjectIdentifier qualifiedTypeIdentifier = SecuredSecurityTypes.ROLE_ASSOCIATION.getQualifiedObjectIdentifier(associationTypeIdentifier);
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval(qualifiedTypeIdentifier, (Callable)new /* Unavailable Anonymous Inner Class!! */);
            UserDTO userDTO = this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService());
            successInfo = new SuccessInfo(true, message, null, new Util.Triple((Object)userDTO, (Object)this.getAllUser(), (Object)this.getServerInfo()));
        }
        catch (UserManagementException e) {
            successInfo = new SuccessInfo(false, "You are not allowed to revoke this role from user " + username + " or the username, group name or role name did not exist.", null, null);
        }
        return successInfo;
    }

    public SuccessInfo addPermissionForUser(String username, WildcardPermission permission) throws UnauthorizedException {
        SuccessInfo successInfo;
        try {
            User user = this.getOrThrowUser(username);
            if (!this.getSecurityService().hasCurrentUserMetaPermissionWithOwnershipLookup(permission)) {
                throw new UnauthorizedException("Not permitted to grant/revoke permission " + permission + " for user " + user.getName());
            }
            TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((WildcardPermission)permission, (User)user);
            String message = "User " + SecurityUtils.getSubject().getPrincipal() + " added permission " + permission + " for user " + username;
            this.getSecurityService().setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(SecuredSecurityTypes.PERMISSION_ASSOCIATION, associationTypeIdentifier, associationTypeIdentifier.toString(), (Action)new /* Unavailable Anonymous Inner Class!! */);
            UserDTO userDTO = this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService());
            successInfo = new SuccessInfo(true, message, null, new Util.Triple((Object)userDTO, (Object)this.getAllUser(), (Object)this.getServerInfo()));
        }
        catch (UnauthorizedException | UserManagementException e) {
            successInfo = new SuccessInfo(false, "User " + SecurityUtils.getSubject().getPrincipal() + " is not permitted to grant permission " + permission + " to user " + username + " or the user or permission did not exist.", null, null);
        }
        return successInfo;
    }

    public SuccessInfo removePermissionFromUser(String username, WildcardPermissionWithSecurityDTO permission) throws UnauthorizedException {
        SuccessInfo successInfo;
        try {
            User user = this.getOrThrowUser(username);
            if (!this.getSecurityService().hasCurrentUserMetaPermissionWithOwnershipLookup((WildcardPermission)permission)) {
                throw new UnauthorizedException("Not permitted to grant/revoke permission " + permission + " for user " + user.getName());
            }
            String message = "User " + SecurityUtils.getSubject().getPrincipal() + " revoked permission " + permission + " for user " + username;
            TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((WildcardPermission)permission, (User)user);
            QualifiedObjectIdentifier qualifiedTypeIdentifier = SecuredSecurityTypes.PERMISSION_ASSOCIATION.getQualifiedObjectIdentifier(associationTypeIdentifier);
            this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval(qualifiedTypeIdentifier, (Callable)new /* Unavailable Anonymous Inner Class!! */);
            UserDTO userDTO = this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService());
            successInfo = new SuccessInfo(true, message, null, new Util.Triple((Object)userDTO, (Object)this.getAllUser(), (Object)this.getServerInfo()));
        }
        catch (UserManagementException e) {
            successInfo = new SuccessInfo(false, "Not permitted to revoke permission " + permission + " for user " + username + " or the user or permission did not exist", null, null);
        }
        return successInfo;
    }

    protected void sendPasswordChangedMailAsync(String username) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected Locale getLocaleFromLocaleName(String localeName) {
        try {
            return localeName == null || localeName.isEmpty() ? null : Locale.forLanguageTag(localeName);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e, () -> "Error while parsing locale with name '" + localeName + "'");
            return null;
        }
    }

    protected User getOrThrowQualifiedUser(String userQualifierName) throws UserManagementException {
        User user = this.getSecurityService().getUserByName(userQualifierName);
        if (userQualifierName != null && !userQualifierName.isEmpty() && user == null) {
            throw new UserManagementException("User " + userQualifierName + " not found.");
        }
        return user;
    }

    protected UserGroup getOrThrowTenant(String tenantQualifierName) throws UserManagementException {
        UserGroup tenant;
        if (tenantQualifierName == null || tenantQualifierName.trim().isEmpty()) {
            tenant = null;
        } else {
            tenant = this.getSecurityService().getUserGroupByName(tenantQualifierName);
            if (tenant == null) {
                throw new UserManagementException("Tenant not found: " + tenantQualifierName);
            }
        }
        return tenant;
    }

    protected User getOrThrowUser(String username) throws UserManagementException {
        User user = this.getSecurityService().getUserByName(username);
        if (user == null) {
            throw new UserManagementException("user " + username + " not found.");
        }
        return user;
    }

    public AccessControlListDTO overrideAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObject, AccessControlListDTO acl) throws UnauthorizedException {
        if (SecurityUtils.getSubject().isPermitted(idOfAccessControlledObject.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL))) {
            HashMap<UserGroup, Set> aclActionsByGroup = new HashMap<UserGroup, Set>();
            for (Map.Entry entry : acl.getActionsByUserGroup().entrySet()) {
                StrippedUserGroupDTO groupDTO = (StrippedUserGroupDTO)entry.getKey();
                UserGroup userGroup = groupDTO == null ? null : this.getSecurityService().getUserGroup(groupDTO.getId());
                aclActionsByGroup.put(userGroup, (Set)entry.getValue());
            }
            return this.securityDTOFactory.createAccessControlListDTO(this.getSecurityService().overrideAccessControlList(idOfAccessControlledObject, aclActionsByGroup));
        }
        throw new UnauthorizedException("Not permitted to update the ACL for a user");
    }

    public void setCORSFilterConfigurationToWildcard() {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_CORS_FILTER);
        this.getSecurityService().setCORSFilterConfigurationToWildcard(ServerInfo.getName());
    }

    public void setCORSFilterConfigurationAllowedOrigins(ArrayList<String> allowedOrigins) {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_CORS_FILTER);
        this.getSecurityService().setCORSFilterConfigurationAllowedOrigins(ServerInfo.getName(), allowedOrigins.toArray(new String[0]));
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }
}

