/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.sap.sse.ServerInfo;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ServerInfoDTO;
import com.sap.sse.landscape.aws.common.shared.SecuredAwsLandscapeType;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.interfaces.Credential;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.UnauthorizedException;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListAnnotationDTO;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.RoleDefinitionDTO;
import com.sap.sse.security.shared.dto.RolesAndPermissionsForUserDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.dto.UserGroupDTO;
import com.sap.sse.security.shared.dto.WildcardPermissionWithSecurityDTO;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.PermissionAndRoleAssociation;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.ui.client.SerializationDummy;
import com.sap.sse.security.ui.client.UserManagementService;
import com.sap.sse.security.ui.oauth.client.CredentialDTO;
import com.sap.sse.security.ui.server.Activator;
import com.sap.sse.security.ui.server.SecurityDTOFactory;
import com.sap.sse.security.ui.server.SecurityDTOUtil;
import com.sap.sse.security.ui.shared.SecurityServiceSharingDTO;
import com.sap.sse.security.ui.shared.SuccessInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class UserManagementServiceImpl
extends RemoteServiceServlet
implements UserManagementService {
    private static final long serialVersionUID = 4458564336368629101L;
    private static final Logger logger = Logger.getLogger(UserManagementServiceImpl.class.getName());
    private final BundleContext context = Activator.getContext();
    private final FutureTask<SecurityService> securityService;
    protected final SecurityDTOFactory securityDTOFactory = new SecurityDTOFactory();

    public UserManagementServiceImpl() {
        ServiceTracker tracker = new ServiceTracker(this.context, SecurityService.class, null);
        tracker.open();
        this.securityService = new FutureTask(new /* Unavailable Anonymous Inner Class!! */);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected UserDTO getAllUser() {
        User allUser = this.getSecurityService().getAllUser();
        return allUser == null ? null : this.securityDTOFactory.createUserDTOFromUser(allUser, this.getSecurityService());
    }

    protected ServerInfoDTO getServerInfo() {
        ServerInfoDTO result = new ServerInfoDTO(ServerInfo.getName(), ServerInfo.getBuildVersion(), ServerInfo.getManageEventsBaseUrl());
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)result);
        return result;
    }

    public ArrayList<HasPermissions> getAllHasPermissions() {
        ArrayList<HasPermissions> result = new ArrayList<HasPermissions>();
        Util.addAll((Iterable)this.getSecurityService().getAllHasPermissions(), result);
        return result;
    }

    public ArrayList<RoleDefinitionDTO> getRoleDefinitions() {
        ArrayList<RoleDefinitionDTO> result = new ArrayList<RoleDefinitionDTO>();
        Util.addAll((Iterable)this.securityDTOFactory.createRoleDefinitionDTOs(this.getSecurityService().getRoleDefinitions(), this.getSecurityService()), result);
        return result;
    }

    public Collection<AccessControlListAnnotationDTO> getAccessControlLists() throws UnauthorizedException {
        ArrayList<AccessControlListAnnotationDTO> acls = new ArrayList<AccessControlListAnnotationDTO>();
        for (AccessControlListAnnotation acl : this.getSecurityService().getAccessControlLists()) {
            if (!SecurityUtils.getSubject().isPermitted(acl.getIdOfAnnotatedObject().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL))) continue;
            acls.add(this.securityDTOFactory.createAccessControlListAnnotationDTO(acl));
        }
        return acls;
    }

    public Collection<UserGroupDTO> getUserGroups() {
        HashMap fromOriginalToStrippedDownUser = new HashMap();
        HashMap fromOriginalToStrippedDownUserGroup = new HashMap();
        return this.getSecurityService().mapAndFilterByReadPermissionForCurrentUser(this.getSecurityService().getUserGroupList(), ug -> this.securityDTOFactory.createUserGroupDTOFromUserGroup(ug, fromOriginalToStrippedDownUser, fromOriginalToStrippedDownUserGroup, this.getSecurityService()));
    }

    public UserGroupDTO getUserGroupByName(String userGroupName) throws UnauthorizedException {
        UserGroup userGroup = this.getSecurityService().getUserGroupByName(userGroupName);
        if (userGroup == null || SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.USER_GROUP.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.READ, (WithQualifiedObjectIdentifier)userGroup))) {
            HashMap fromOriginalToStrippedDownUser = new HashMap();
            HashMap fromOriginalToStrippedDownUserGroup = new HashMap();
            return this.securityDTOFactory.createUserGroupDTOFromUserGroup(userGroup, fromOriginalToStrippedDownUser, fromOriginalToStrippedDownUserGroup, this.getSecurityService());
        }
        throw new UnauthorizedException("Not permitted to read user group " + userGroupName);
    }

    public StrippedUserGroupDTO getStrippedUserGroupByName(String userGroupName) throws UnauthorizedException {
        UserGroup userGroup = this.getSecurityService().getUserGroupByName(userGroupName);
        if (userGroup == null || SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.USER_GROUP.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.READ, (WithQualifiedObjectIdentifier)userGroup))) {
            HashMap fromOriginalToStrippedDownUserGroup = new HashMap();
            return this.securityDTOFactory.createStrippedUserGroupDTOFromUserGroup(userGroup, fromOriginalToStrippedDownUserGroup);
        }
        throw new UnauthorizedException("Not permitted to read user group " + userGroupName);
    }

    private UserDTO getUserByName(String username) throws UnauthorizedException {
        User user = this.getSecurityService().getUserByName(username);
        if (user == null || SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.USER.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.READ, (WithQualifiedObjectIdentifier)user)) || SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.USER.getStringPermissionForObject((HasPermissions.Action)SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC, (WithQualifiedObjectIdentifier)user))) {
            return user == null ? null : this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService());
        }
        throw new UnauthorizedException("Not permitted to read user " + username);
    }

    public Collection<UserDTO> getUserList() throws UnauthorizedException {
        HasPermissions.Action[] requiredActionsForRead = SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS;
        return this.getSecurityService().mapAndFilterByAnyExplicitPermissionForCurrentUser(SecuredSecurityTypes.USER, requiredActionsForRead, this.getSecurityService().getUserList(), arg_0 -> this.getUserDTOWithFilteredRolesAndPermissions(arg_0));
    }

    public Util.Triple<UserDTO, UserDTO, ServerInfoDTO> getCurrentUser() throws UnauthorizedException {
        logger.fine("Request: " + this.getThreadLocalRequest().getRequestURL());
        User user = this.getSecurityService().getCurrentUser();
        if (user == null) {
            return new Util.Triple(null, (Object)this.getAllUser(), (Object)this.getServerInfo());
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)user);
        return new Util.Triple((Object)this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService()), (Object)this.getAllUser(), (Object)this.getServerInfo());
    }

    public Map<String, String> getSettings() {
        TreeMap<String, String> settings = new TreeMap<String, String>();
        for (Map.Entry e : this.getSecurityService().getAllSettings().entrySet()) {
            settings.put((String)e.getKey(), e.getValue().toString());
        }
        return settings;
    }

    public Map<String, String> getSettingTypes() {
        TreeMap<String, String> settingTypes = new TreeMap<String, String>();
        for (Map.Entry e : this.getSecurityService().getAllSettingTypes().entrySet()) {
            settingTypes.put((String)e.getKey(), ((Class)e.getValue()).getName());
        }
        return settingTypes;
    }

    protected SecurityService getSecurityService() {
        try {
            return (SecurityService)this.securityService.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPreference(String username, String key) throws UserManagementException, UnauthorizedException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username));
        return this.getSecurityService().getPreference(username, key);
    }

    public Map<String, String> getPreferences(String username, List<String> keys) throws UserManagementException, UnauthorizedException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username));
        HashMap<String, String> requestedPreferences = new HashMap<String, String>();
        for (String key : keys) {
            requestedPreferences.put(key, this.getSecurityService().getPreference(username, key));
        }
        return requestedPreferences;
    }

    public Map<String, String> getAllPreferences(String username) throws UserManagementException, UnauthorizedException {
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.getSecurityService().getUserByName(username));
        Map allPreferences = this.getSecurityService().getAllPreferences(username);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : allPreferences.entrySet()) {
            if (((String)entry.getKey()).startsWith("_")) continue;
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public String getOrCreateAccessToken(String username) throws UnauthorizedException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getUserByName(username));
        return this.getSecurityService().getOrCreateAccessToken(username);
    }

    public AccessControlListDTO getAccessControlListWithoutPruning(QualifiedObjectIdentifier idOfAccessControlledObject) throws UnauthorizedException {
        if (SecurityUtils.getSubject().isPermitted(idOfAccessControlledObject.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL))) {
            AccessControlListAnnotation accessControlList = this.getSecurityService().getAccessControlList(idOfAccessControlledObject);
            if (accessControlList == null) {
                return null;
            }
            return this.securityDTOFactory.createAccessControlListDTO((AccessControlList)accessControlList.getAnnotation());
        }
        throw new UnauthorizedException("Not permitted to get the unpruned ACL for a user");
    }

    public SecuredDTO addSecurityInformation(SecuredDTO securedDTO) {
        SecurityDTOUtil.addSecurityInformation((SecurityService)this.getSecurityService(), (SecuredDTO)securedDTO);
        return securedDTO;
    }

    public SerializationDummy serializationDummy(TypeRelativeObjectIdentifier typeRelativeObjectIdentifier, HasPermissions hasPermissions, SecuredAwsLandscapeType securedAwsLandscapeType) {
        return null;
    }

    public Boolean userExists(String username) {
        if (this.getSecurityService().getUserByName(username) != null) {
            return true;
        }
        return false;
    }

    public Boolean userGroupExists(String userGroupName) {
        if (this.getSecurityService().getUserGroupByName(userGroupName) != null) {
            return true;
        }
        return false;
    }

    public RolesAndPermissionsForUserDTO getRolesAndPermissionsForUser(String username) throws UserManagementException {
        User user = this.getSecurityService().getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User '" + username + "'not found.");
        }
        UserDTO userDTO = this.getUserDTOWithFilteredRolesAndPermissions(user);
        ArrayList<WildcardPermissionWithSecurityDTO> permissions = new ArrayList<WildcardPermissionWithSecurityDTO>();
        for (WildcardPermission p : userDTO.getPermissions()) {
            if (!(p instanceof WildcardPermissionWithSecurityDTO)) continue;
            permissions.add((WildcardPermissionWithSecurityDTO)p);
        }
        return new RolesAndPermissionsForUserDTO(userDTO.getRoles(), permissions);
    }

    private UserDTO getUserDTOWithFilteredRolesAndPermissions(User user) {
        UserDTO result = this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService(), permission -> {
            TypeRelativeObjectIdentifier typeRelativeObjectIdentifier = PermissionAndRoleAssociation.get((WildcardPermission)permission, (User)user);
            return SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.PERMISSION_ASSOCIATION.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, typeRelativeObjectIdentifier));
        }, role -> {
            TypeRelativeObjectIdentifier typeRelativeObjectIdentifier = PermissionAndRoleAssociation.get((Role)role, (User)user);
            return SecurityUtils.getSubject().isPermitted(SecuredSecurityTypes.ROLE_ASSOCIATION.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, typeRelativeObjectIdentifier));
        });
        if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)user)) {
            result.clearNonPublicFields();
        }
        return result;
    }

    public SecurityServiceSharingDTO getSharingConfiguration() {
        return new SecurityServiceSharingDTO(this.getSecurityService().getSharedAcrossSubdomainsOf(), this.getSecurityService().getBaseUrlForCrossDomainStorage());
    }

    protected Credential createCredentialFromDTO(CredentialDTO credentialDTO) {
        Credential credential = new Credential();
        credential.setAuthProvider(credentialDTO.getAuthProvider());
        credential.setAuthProviderName(credentialDTO.getAuthProviderName());
        credential.setEmail(credentialDTO.getEmail());
        credential.setLoginName(credentialDTO.getLoginName());
        credential.setPassword(credentialDTO.getPassword());
        credential.setRedirectUrl(credentialDTO.getRedirectUrl());
        credential.setState(credentialDTO.getState());
        credential.setVerifier(credentialDTO.getVerifier());
        credential.setOauthToken(credentialDTO.getOauthToken());
        return credential;
    }

    public Util.Triple<UserDTO, UserDTO, ServerInfoDTO> verifySocialUser(CredentialDTO credentialDTO) {
        User user = null;
        try {
            user = this.getSecurityService().verifySocialUser(this.createCredentialFromDTO(credentialDTO));
        }
        catch (UserManagementException e) {
            e.printStackTrace();
        }
        UserDTO userDTO = this.securityDTOFactory.createUserDTOFromUser(user, this.getSecurityService());
        return new Util.Triple((Object)userDTO, (Object)this.getAllUser(), (Object)this.getServerInfo());
    }

    public SuccessInfo logout() {
        logger.info("Logging out user: " + SecurityUtils.getSubject());
        this.getSecurityService().logout();
        this.getHttpSession().invalidate();
        Cookie cookie = new Cookie("GWT_LOCALE", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setSecure(true);
        this.getThreadLocalResponse().addCookie(cookie);
        logger.info("Invalidated HTTP session");
        return new SuccessInfo(true, "Logged out.", null, null);
    }

    public SuccessInfo login(String username, String password) {
        try {
            String redirectURL = this.getSecurityService().login(username, password);
            UserDTO user = this.securityDTOFactory.createUserDTOFromUser(this.getSecurityService().getUserByName(username), this.getSecurityService());
            return new SuccessInfo(true, "Success. Redirecting to " + redirectURL, redirectURL, new Util.Triple((Object)user, (Object)this.getAllUser(), (Object)this.getServerInfo()));
        }
        catch (UserManagementException | AuthenticationException e) {
            return new SuccessInfo(false, "Failed to login.", null, null);
        }
    }

    private HttpSession getHttpSession() {
        return this.getThreadLocalRequest().getSession();
    }

    public Util.Pair<Boolean, ArrayList<String>> getCORSFilterConfiguration() {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_CORS_FILTER);
        Util.Pair preResult = this.getSecurityService().getCORSFilterConfiguration(ServerInfo.getName());
        return preResult == null ? null : new Util.Pair((Object)((Boolean)preResult.getA()), new ArrayList((Collection)preResult.getB()));
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ FutureTask access$1(UserManagementServiceImpl userManagementServiceImpl) {
        return userManagementServiceImpl.securityService;
    }
}

