/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.sap.sse.common.Named;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecuredDTOOwnerColumn<T extends SecuredDTO>
extends TextColumn<T> {
    private final Function<T, Optional<Named>> ownerResolver;

    public SecuredDTOOwnerColumn(Function<OwnershipDTO, Named> ownerResolver) {
        Function<SecuredDTO, OwnershipDTO> ownershipResolver = SecuredDTO::getOwnership;
        this.ownerResolver = ownershipResolver.andThen(ownership -> Optional.ofNullable(ownership).map(ownerResolver));
    }

    public final String getValue(T object) {
        return ((Optional)this.ownerResolver.apply(object)).map(Named::getName).orElse("");
    }

    public Comparator<T> getComparator() {
        return Comparator.comparing(arg_0 -> this.getValue(arg_0));
    }

    public static <T extends SecuredDTO> SecuredDTOOwnerColumn<T> getGroupOwnerColumn() {
        return new SecuredDTOOwnerColumn(AbstractOwnership::getTenantOwner);
    }

    public static <T extends SecuredDTO> SecuredDTOOwnerColumn<T> getUserOwnerColumn() {
        return new SecuredDTOOwnerColumn(AbstractOwnership::getUserOwner);
    }

    public static <T extends SecuredDTO> void configureOwnerColumns(AbstractCellTable<T> table, ColumnSortEvent.ListHandler<T> columnSortHandler, StringMessages stringMessages) {
        SecuredDTOOwnerColumn groupColumn = SecuredDTOOwnerColumn.getGroupOwnerColumn();
        groupColumn.setSortable(true);
        table.addColumn((Column)groupColumn, stringMessages.group());
        columnSortHandler.setComparator((Column)groupColumn, groupColumn.getComparator());
        SecuredDTOOwnerColumn userColumn = SecuredDTOOwnerColumn.getUserOwnerColumn();
        table.addColumn((Column)userColumn, stringMessages.user());
        userColumn.setSortable(true);
        columnSortHandler.setComparator((Column)userColumn, userColumn.getComparator());
    }
}

