/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckCapacityResponse extends Wafv2Response implements
        ToCopyableBuilder<CheckCapacityResponse.Builder, CheckCapacityResponse> {
    private static final SdkField<Long> CAPACITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Capacity")
            .getter(getter(CheckCapacityResponse::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Long capacity;

    private CheckCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
    }

    /**
     * <p>
     * The capacity required by the rules and scope.
     * </p>
     * 
     * @return The capacity required by the rules and scope.
     */
    public final Long capacity() {
        return capacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckCapacityResponse)) {
            return false;
        }
        CheckCapacityResponse other = (CheckCapacityResponse) obj;
        return Objects.equals(capacity(), other.capacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckCapacityResponse").add("Capacity", capacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Capacity", CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckCapacityResponse, T> g) {
        return obj -> g.apply((CheckCapacityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, CheckCapacityResponse> {
        /**
         * <p>
         * The capacity required by the rules and scope.
         * </p>
         * 
         * @param capacity
         *        The capacity required by the rules and scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Long capacity);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private Long capacity;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckCapacityResponse model) {
            super(model);
            capacity(model.capacity);
        }

        public final Long getCapacity() {
            return capacity;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public CheckCapacityResponse build() {
            return new CheckCapacityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
