/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.ElasticLoadBalancingV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AllocationIdNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AlpnPolicyNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZoneNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CaCertificatesBundleNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CapacityDecreaseRequestsLimitExceededException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CapacityReservationPendingException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CapacityUnitsLimitExceededException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteAssociationSameAccountException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeCapacityReservationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeCapacityReservationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTargetGroupNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTrustStoreNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HealthUnavailableException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IncompatibleProtocolsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InsufficientCapacityException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidCaCertificatesBundleException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidLoadBalancerActionException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidRevocationContentException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidTargetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyCapacityReservationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyCapacityReservationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyIpPoolsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyIpPoolsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PriorRequestNotCompleteException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PriorityInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationContentNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationIdNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAssociationLimitException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyActionsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyCertificatesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyListenersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRegistrationsForTargetIdException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRulesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetGroupsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTrustStoreRevocationEntriesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTrustStoresException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyUniqueTargetGroupsPerLoadBalancerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociationNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreNotReadyException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddTrustStoreRevocationsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteSharedTrustStoreAssociationRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeregisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeRulesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeSslPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTrustStoreAssociationsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTrustStoreRevocationsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTrustStoresRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.GetTrustStoreCaCertificatesBundleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.GetTrustStoreRevocationContentRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyIpPoolsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyListenerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RegisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveTrustStoreRevocationsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetRulePrioritiesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.ElasticLoadBalancingV2AsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ElasticLoadBalancingV2AsyncClient}.
 *
 * @see ElasticLoadBalancingV2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultElasticLoadBalancingV2AsyncClient implements ElasticLoadBalancingV2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticLoadBalancingV2AsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.QUERY).build();

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultElasticLoadBalancingV2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Elastic_Load_Balancing_v2" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added
     * again.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/https-listener-certificates.html">SSL
     * certificates</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/tls-listener-certificates.html">Server
     * certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param addListenerCertificatesRequest
     * @return A Java Future containing the result of the AddListenerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddListenerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddListenerCertificatesResponse> addListenerCertificates(
            AddListenerCertificatesRequest addListenerCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addListenerCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addListenerCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddListenerCertificates");

            HttpResponseHandler<AddListenerCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddListenerCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddListenerCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddListenerCertificatesRequest, AddListenerCertificatesResponse>()
                            .withOperationName("AddListenerCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddListenerCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addListenerCertificatesRequest));
            CompletableFuture<AddListenerCertificatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load
     * Balancers, Network Load Balancers, Gateway Load Balancers, target groups, trust stores, listeners, and rules.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key,
     * <code>AddTags</code> updates its value.
     * </p>
     *
     * @param addTagsRequest
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");

            HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>().withOperationName("AddTags")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new AddTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsRequest));
            CompletableFuture<AddTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified revocation file to the specified trust store.
     * </p>
     *
     * @param addTrustStoreRevocationsRequest
     * @return A Java Future containing the result of the AddTrustStoreRevocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>InvalidRevocationContentException The provided revocation file is an invalid format, or uses an
     *         incorrect algorithm.</li>
     *         <li>TooManyTrustStoreRevocationEntriesException The specified trust store has too many revocation
     *         entries.</li>
     *         <li>RevocationContentNotFoundException The specified revocation file does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.AddTrustStoreRevocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddTrustStoreRevocationsResponse> addTrustStoreRevocations(
            AddTrustStoreRevocationsRequest addTrustStoreRevocationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTrustStoreRevocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTrustStoreRevocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTrustStoreRevocations");

            HttpResponseHandler<AddTrustStoreRevocationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddTrustStoreRevocationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddTrustStoreRevocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTrustStoreRevocationsRequest, AddTrustStoreRevocationsResponse>()
                            .withOperationName("AddTrustStoreRevocations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddTrustStoreRevocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTrustStoreRevocationsRequest));
            CompletableFuture<AddTrustStoreRevocationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">
     * Listeners for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners
     * for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * listeners with the same settings, each call succeeds.
     * </p>
     *
     * @param createListenerRequest
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateListenerException A listener with the specified port already exists.</li>
     *         <li>TooManyListenersException You've reached the limit on the number of listeners per load balancer.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>AlpnPolicyNotSupportedException The specified ALPN policy is not supported.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreNotReadyException The specified trust store is not active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateListenerResponse> createListener(CreateListenerRequest createListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateListener");

            HttpResponseHandler<CreateListenerResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateListenerRequest, CreateListenerResponse>()
                            .withOperationName("CreateListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createListenerRequest));
            CompletableFuture<CreateListenerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">
     * Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network
     * Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway
     * Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * load balancers with the same settings, each call succeeds.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateLoadBalancerNameException A load balancer with the specified name already exists.</li>
     *         <li>TooManyLoadBalancersException You've reached the limit on the number of load balancers for your
     *         Amazon Web Services account.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SubnetNotFoundException The specified subnet does not exist.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>InvalidSecurityGroupException The specified security group does not exist.</li>
     *         <li>InvalidSchemeException The requested scheme is not valid.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>AllocationIdNotFoundException The specified allocation ID does not exist.</li>
     *         <li>AvailabilityZoneNotSupportedException The specified Availability Zone is not supported.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLoadBalancerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLoadBalancerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLoadBalancer");

            HttpResponseHandler<CreateLoadBalancerResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoadBalancerRequest, CreateLoadBalancerResponse>()
                            .withOperationName("CreateLoadBalancer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLoadBalancerRequest));
            CompletableFuture<CreateLoadBalancerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     * </p>
     * <p>
     * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in
     * priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions
     * are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules"
     * >Listener rules</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PriorityInUseException The specified priority is in use.</li>
     *         <li>TooManyTargetGroupsException You've reached the limit on the number of target groups for your Amazon
     *         Web Services account.</li>
     *         <li>TooManyRulesException You've reached the limit on the number of rules per load balancer.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRule");

            HttpResponseHandler<CreateRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRuleRequest, CreateRuleResponse>().withOperationName("CreateRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRuleRequest));
            CompletableFuture<CreateRuleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">
     * Target groups for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target
     * groups for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * target groups with the same settings, each call succeeds.
     * </p>
     *
     * @param createTargetGroupRequest
     * @return A Java Future containing the result of the CreateTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTargetGroupNameException A target group with the specified name already exists.</li>
     *         <li>TooManyTargetGroupsException You've reached the limit on the number of target groups for your Amazon
     *         Web Services account.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTargetGroupResponse> createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTargetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTargetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTargetGroup");

            HttpResponseHandler<CreateTargetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTargetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTargetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTargetGroupRequest, CreateTargetGroupResponse>()
                            .withOperationName("CreateTargetGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTargetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTargetGroupRequest));
            CompletableFuture<CreateTargetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a trust store.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/mutual-authentication.html">Mutual TLS
     * for Application Load Balancers</a>.
     * </p>
     *
     * @param createTrustStoreRequest
     * @return A Java Future containing the result of the CreateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTrustStoreNameException A trust store with the specified name already exists.</li>
     *         <li>TooManyTrustStoresException You've reached the limit on the number of trust stores for your Amazon
     *         Web Services account.</li>
     *         <li>InvalidCaCertificatesBundleException The specified ca certificate bundle is in an invalid format, or
     *         corrupt.</li>
     *         <li>CaCertificatesBundleNotFoundException The specified ca certificate bundle does not exist.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrustStoreResponse> createTrustStore(CreateTrustStoreRequest createTrustStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrustStore");

            HttpResponseHandler<CreateTrustStoreResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrustStoreRequest, CreateTrustStoreResponse>()
                            .withOperationName("CreateTrustStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrustStoreRequest));
            CompletableFuture<CreateTrustStoreResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <p>
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     * </p>
     *
     * @param deleteListenerRequest
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteListenerResponse> deleteListener(DeleteListenerRequest deleteListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteListener");

            HttpResponseHandler<DeleteListenerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteListenerRequest, DeleteListenerResponse>()
                            .withOperationName("DeleteListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteListenerRequest));
            CompletableFuture<DeleteListenerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load
     * balancer also deletes its listeners.
     * </p>
     * <p>
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has
     * already been deleted, the call succeeds.
     * </p>
     * <p>
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run
     * and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or
     * terminate them.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLoadBalancerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLoadBalancerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLoadBalancer");

            HttpResponseHandler<DeleteLoadBalancerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>()
                            .withOperationName("DeleteLoadBalancer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLoadBalancerRequest));
            CompletableFuture<DeleteLoadBalancerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * You can't delete the default rule.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRule");

            HttpResponseHandler<DeleteRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRuleRequest, DeleteRuleResponse>().withOperationName("DeleteRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRuleRequest));
            CompletableFuture<DeleteRuleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a shared trust store association.
     * </p>
     *
     * @param deleteSharedTrustStoreAssociationRequest
     * @return A Java Future containing the result of the DeleteSharedTrustStoreAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>DeleteAssociationSameAccountException The specified association can't be within the same account.</li>
     *         <li>TrustStoreAssociationNotFoundException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteSharedTrustStoreAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteSharedTrustStoreAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSharedTrustStoreAssociationResponse> deleteSharedTrustStoreAssociation(
            DeleteSharedTrustStoreAssociationRequest deleteSharedTrustStoreAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSharedTrustStoreAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteSharedTrustStoreAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSharedTrustStoreAssociation");

            HttpResponseHandler<DeleteSharedTrustStoreAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSharedTrustStoreAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSharedTrustStoreAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSharedTrustStoreAssociationRequest, DeleteSharedTrustStoreAssociationResponse>()
                            .withOperationName("DeleteSharedTrustStoreAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSharedTrustStoreAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSharedTrustStoreAssociationRequest));
            CompletableFuture<DeleteSharedTrustStoreAssociationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified target group.
     * </p>
     * <p>
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any
     * associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2
     * instances continue to run until you stop or terminate them.
     * </p>
     *
     * @param deleteTargetGroupRequest
     * @return A Java Future containing the result of the DeleteTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException A specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTargetGroupResponse> deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTargetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTargetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTargetGroup");

            HttpResponseHandler<DeleteTargetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTargetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTargetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTargetGroupRequest, DeleteTargetGroupResponse>()
                            .withOperationName("DeleteTargetGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTargetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTargetGroupRequest));
            CompletableFuture<DeleteTargetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a trust store.
     * </p>
     *
     * @param deleteTrustStoreRequest
     * @return A Java Future containing the result of the DeleteTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreInUseException The specified trust store is currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrustStoreResponse> deleteTrustStore(DeleteTrustStoreRequest deleteTrustStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrustStore");

            HttpResponseHandler<DeleteTrustStoreResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrustStoreRequest, DeleteTrustStoreResponse>()
                            .withOperationName("DeleteTrustStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrustStoreRequest));
            CompletableFuture<DeleteTrustStoreResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no
     * longer receive traffic from the load balancer.
     * </p>
     * <p>
     * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to
     * ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by
     * default but can be updated for each target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Application Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Network Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/edit-target-group-attributes.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Gateway Load Balancers User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note: If the specified target does not exist, the action returns successfully.
     * </p>
     *
     * @param deregisterTargetsRequest
     * @return A Java Future containing the result of the DeregisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterTargetsResponse> deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterTargets");

            HttpResponseHandler<DeregisterTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeregisterTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeregisterTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterTargetsRequest, DeregisterTargetsResponse>()
                            .withOperationName("DeregisterTargets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterTargetsRequest));
            CompletableFuture<DeregisterTargetsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas
     * for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for
     * your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your
     * Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountLimitsRequest
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountLimits");

            HttpResponseHandler<DescribeAccountLimitsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAccountLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAccountLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse>()
                            .withOperationName("DescribeAccountLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountLimitsRequest));
            CompletableFuture<DescribeAccountLimitsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the capacity reservation status for the specified load balancer.
     * </p>
     *
     * @param describeCapacityReservationRequest
     * @return A Java Future containing the result of the DescribeCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeCapacityReservation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCapacityReservationResponse> describeCapacityReservation(
            DescribeCapacityReservationRequest describeCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCapacityReservation");

            HttpResponseHandler<DescribeCapacityReservationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCapacityReservationRequest, DescribeCapacityReservationResponse>()
                            .withOperationName("DescribeCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCapacityReservationRequest));
            CompletableFuture<DescribeCapacityReservationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the attributes for the specified listener.
     * </p>
     *
     * @param describeListenerAttributesRequest
     * @return A Java Future containing the result of the DescribeListenerAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeListenerAttributesResponse> describeListenerAttributes(
            DescribeListenerAttributesRequest describeListenerAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeListenerAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeListenerAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeListenerAttributes");

            HttpResponseHandler<DescribeListenerAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeListenerAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeListenerAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeListenerAttributesRequest, DescribeListenerAttributesResponse>()
                            .withOperationName("DescribeListenerAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeListenerAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeListenerAttributesRequest));
            CompletableFuture<DescribeListenerAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the default certificate is also in the certificate list, it appears twice in the results (once with
     * <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/https-listener-certificates.html">SSL
     * certificates</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/tls-listener-certificates.html">Server
     * certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeListenerCertificatesRequest
     * @return A Java Future containing the result of the DescribeListenerCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeListenerCertificatesResponse> describeListenerCertificates(
            DescribeListenerCertificatesRequest describeListenerCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeListenerCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeListenerCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeListenerCertificates");

            HttpResponseHandler<DescribeListenerCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeListenerCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeListenerCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeListenerCertificatesRequest, DescribeListenerCertificatesResponse>()
                            .withOperationName("DescribeListenerCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeListenerCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeListenerCertificatesRequest));
            CompletableFuture<DescribeListenerCertificatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load
     * Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     *
     * @param describeListenersRequest
     * @return A Java Future containing the result of the DescribeListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeListenersResponse> describeListeners(DescribeListenersRequest describeListenersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeListenersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeListenersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeListeners");

            HttpResponseHandler<DescribeListenersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeListenersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeListenersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeListenersRequest, DescribeListenersResponse>()
                            .withOperationName("DescribeListeners").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeListenersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeListenersRequest));
            CompletableFuture<DescribeListenersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load
     * Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeLoadBalancerAttributesRequest
     * @return A Java Future containing the result of the DescribeLoadBalancerAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoadBalancerAttributesResponse> describeLoadBalancerAttributes(
            DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoadBalancerAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeLoadBalancerAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoadBalancerAttributes");

            HttpResponseHandler<DescribeLoadBalancerAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLoadBalancerAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLoadBalancerAttributesRequest, DescribeLoadBalancerAttributesResponse>()
                            .withOperationName("DescribeLoadBalancerAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLoadBalancerAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLoadBalancerAttributesRequest));
            CompletableFuture<DescribeLoadBalancerAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A Java Future containing the result of the DescribeLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(
            DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoadBalancersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoadBalancersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoadBalancers");

            HttpResponseHandler<DescribeLoadBalancersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLoadBalancersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLoadBalancersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse>()
                            .withOperationName("DescribeLoadBalancers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLoadBalancersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLoadBalancersRequest));
            CompletableFuture<DescribeLoadBalancersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one
     * or more rules.
     * </p>
     *
     * @param describeRulesRequest
     * @return A Java Future containing the result of the DescribeRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRulesResponse> describeRules(DescribeRulesRequest describeRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRules");

            HttpResponseHandler<DescribeRulesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRulesRequest, DescribeRulesResponse>()
                            .withOperationName("DescribeRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRulesRequest));
            CompletableFuture<DescribeRulesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html">Security
     * policies</a> in the <i>Application Load Balancers Guide</i> and <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/describe-ssl-policies.html">Security
     * policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeSslPoliciesRequest
     * @return A Java Future containing the result of the DescribeSSLPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeSSLPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSslPoliciesResponse> describeSSLPolicies(
            DescribeSslPoliciesRequest describeSslPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSslPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSslPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSSLPolicies");

            HttpResponseHandler<DescribeSslPoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSslPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSslPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSslPoliciesRequest, DescribeSslPoliciesResponse>()
                            .withOperationName("DescribeSSLPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSslPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSslPoliciesRequest));
            CompletableFuture<DescribeSslPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more
     * Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTags");

            HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                            .withOperationName("DescribeTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTagsRequest));
            CompletableFuture<DescribeTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the attributes for the specified target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeTargetGroupAttributesRequest
     * @return A Java Future containing the result of the DescribeTargetGroupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTargetGroupAttributesResponse> describeTargetGroupAttributes(
            DescribeTargetGroupAttributesRequest describeTargetGroupAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTargetGroupAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTargetGroupAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTargetGroupAttributes");

            HttpResponseHandler<DescribeTargetGroupAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTargetGroupAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTargetGroupAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTargetGroupAttributesRequest, DescribeTargetGroupAttributesResponse>()
                            .withOperationName("DescribeTargetGroupAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTargetGroupAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTargetGroupAttributesRequest));
            CompletableFuture<DescribeTargetGroupAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     *
     * @param describeTargetGroupsRequest
     * @return A Java Future containing the result of the DescribeTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTargetGroupsResponse> describeTargetGroups(
            DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTargetGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTargetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTargetGroups");

            HttpResponseHandler<DescribeTargetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTargetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTargetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTargetGroupsRequest, DescribeTargetGroupsResponse>()
                            .withOperationName("DescribeTargetGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTargetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTargetGroupsRequest));
            CompletableFuture<DescribeTargetGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the health of the specified targets or all of your targets.
     * </p>
     *
     * @param describeTargetHealthRequest
     * @return A Java Future containing the result of the DescribeTargetHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>HealthUnavailableException The health of the specified targets could not be retrieved due to an
     *         internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTargetHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetHealth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTargetHealthResponse> describeTargetHealth(
            DescribeTargetHealthRequest describeTargetHealthRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTargetHealthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTargetHealthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTargetHealth");

            HttpResponseHandler<DescribeTargetHealthResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTargetHealthResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTargetHealthResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTargetHealthRequest, DescribeTargetHealthResponse>()
                            .withOperationName("DescribeTargetHealth").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTargetHealthRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTargetHealthRequest));
            CompletableFuture<DescribeTargetHealthResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes all resources associated with the specified trust store.
     * </p>
     *
     * @param describeTrustStoreAssociationsRequest
     * @return A Java Future containing the result of the DescribeTrustStoreAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrustStoreAssociationsResponse> describeTrustStoreAssociations(
            DescribeTrustStoreAssociationsRequest describeTrustStoreAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustStoreAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTrustStoreAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrustStoreAssociations");

            HttpResponseHandler<DescribeTrustStoreAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTrustStoreAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTrustStoreAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrustStoreAssociationsRequest, DescribeTrustStoreAssociationsResponse>()
                            .withOperationName("DescribeTrustStoreAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrustStoreAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrustStoreAssociationsRequest));
            CompletableFuture<DescribeTrustStoreAssociationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the revocation files in use by the specified trust store or revocation files.
     * </p>
     *
     * @param describeTrustStoreRevocationsRequest
     * @return A Java Future containing the result of the DescribeTrustStoreRevocations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrustStoreRevocationsResponse> describeTrustStoreRevocations(
            DescribeTrustStoreRevocationsRequest describeTrustStoreRevocationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustStoreRevocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTrustStoreRevocationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrustStoreRevocations");

            HttpResponseHandler<DescribeTrustStoreRevocationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTrustStoreRevocationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTrustStoreRevocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrustStoreRevocationsRequest, DescribeTrustStoreRevocationsResponse>()
                            .withOperationName("DescribeTrustStoreRevocations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrustStoreRevocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrustStoreRevocationsRequest));
            CompletableFuture<DescribeTrustStoreRevocationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes all trust stores for the specified account.
     * </p>
     *
     * @param describeTrustStoresRequest
     * @return A Java Future containing the result of the DescribeTrustStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.DescribeTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrustStoresResponse> describeTrustStores(
            DescribeTrustStoresRequest describeTrustStoresRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrustStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrustStores");

            HttpResponseHandler<DescribeTrustStoresResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTrustStoresResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTrustStoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrustStoresRequest, DescribeTrustStoresResponse>()
                            .withOperationName("DescribeTrustStores").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrustStoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrustStoresRequest));
            CompletableFuture<DescribeTrustStoresResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the resource policy for a specified resource.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");

            HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                            .withOperationName("GetResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourcePolicyRequest));
            CompletableFuture<GetResourcePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the ca certificate bundle.
     * </p>
     * <p>
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     * </p>
     *
     * @param getTrustStoreCaCertificatesBundleRequest
     * @return A Java Future containing the result of the GetTrustStoreCaCertificatesBundle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetTrustStoreCaCertificatesBundle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetTrustStoreCaCertificatesBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrustStoreCaCertificatesBundleResponse> getTrustStoreCaCertificatesBundle(
            GetTrustStoreCaCertificatesBundleRequest getTrustStoreCaCertificatesBundleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrustStoreCaCertificatesBundleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getTrustStoreCaCertificatesBundleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStoreCaCertificatesBundle");

            HttpResponseHandler<GetTrustStoreCaCertificatesBundleResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetTrustStoreCaCertificatesBundleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetTrustStoreCaCertificatesBundleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrustStoreCaCertificatesBundleRequest, GetTrustStoreCaCertificatesBundleResponse>()
                            .withOperationName("GetTrustStoreCaCertificatesBundle").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTrustStoreCaCertificatesBundleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTrustStoreCaCertificatesBundleRequest));
            CompletableFuture<GetTrustStoreCaCertificatesBundleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified revocation file.
     * </p>
     * <p>
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     * </p>
     *
     * @param getTrustStoreRevocationContentRequest
     * @return A Java Future containing the result of the GetTrustStoreRevocationContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.GetTrustStoreRevocationContent
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetTrustStoreRevocationContent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrustStoreRevocationContentResponse> getTrustStoreRevocationContent(
            GetTrustStoreRevocationContentRequest getTrustStoreRevocationContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrustStoreRevocationContentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getTrustStoreRevocationContentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStoreRevocationContent");

            HttpResponseHandler<GetTrustStoreRevocationContentResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetTrustStoreRevocationContentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetTrustStoreRevocationContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrustStoreRevocationContentRequest, GetTrustStoreRevocationContentResponse>()
                            .withOperationName("GetTrustStoreRevocationContent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTrustStoreRevocationContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTrustStoreRevocationContentRequest));
            CompletableFuture<GetTrustStoreRevocationContentResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the capacity reservation of the specified load balancer.
     * </p>
     * <p>
     * When modifying capacity reservation, you must include at least one <code>MinimumLoadBalancerCapacity</code> or
     * <code>ResetCapacityReservation</code>.
     * </p>
     *
     * @param modifyCapacityReservationRequest
     * @return A Java Future containing the result of the ModifyCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>CapacityUnitsLimitExceededException You've exceeded the capacity units limit.</li>
     *         <li>CapacityReservationPendingException There is a pending capacity reservation.</li>
     *         <li>InsufficientCapacityException There is insufficient capacity to reserve.</li>
     *         <li>CapacityDecreaseRequestsLimitExceededException You've exceeded the daily capacity decrease limit for
     *         this reservation.</li>
     *         <li>PriorRequestNotCompleteException This operation is not allowed while a prior request has not been
     *         completed.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyCapacityReservation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyCapacityReservationResponse> modifyCapacityReservation(
            ModifyCapacityReservationRequest modifyCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCapacityReservation");

            HttpResponseHandler<ModifyCapacityReservationResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyCapacityReservationRequest, ModifyCapacityReservationResponse>()
                            .withOperationName("ModifyCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyCapacityReservationRequest));
            CompletableFuture<ModifyCapacityReservationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * [Application Load Balancers] Modify the IP pool associated to a load balancer.
     * </p>
     *
     * @param modifyIpPoolsRequest
     * @return A Java Future containing the result of the ModifyIpPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyIpPools"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyIpPoolsResponse> modifyIpPools(ModifyIpPoolsRequest modifyIpPoolsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyIpPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyIpPoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyIpPools");

            HttpResponseHandler<ModifyIpPoolsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyIpPoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyIpPoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyIpPoolsRequest, ModifyIpPoolsResponse>()
                            .withOperationName("ModifyIpPools").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyIpPoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyIpPoolsRequest));
            CompletableFuture<ModifyIpPoolsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain
     * unchanged.
     * </p>
     * <p>
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate
     * properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy
     * and default certificate properties.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyListenerRequest
     * @return A Java Future containing the result of the ModifyListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateListenerException A listener with the specified port already exists.</li>
     *         <li>TooManyListenersException You've reached the limit on the number of listeners per load balancer.</li>
     *         <li>TooManyCertificatesException You've reached the limit on the number of certificates per load
     *         balancer.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>SslPolicyNotFoundException The specified SSL policy does not exist.</li>
     *         <li>CertificateNotFoundException The specified certificate does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>AlpnPolicyNotSupportedException The specified ALPN policy is not supported.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>TrustStoreNotReadyException The specified trust store is not active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyListenerResponse> modifyListener(ModifyListenerRequest modifyListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyListener");

            HttpResponseHandler<ModifyListenerResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyListenerRequest, ModifyListenerResponse>()
                            .withOperationName("ModifyListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyListenerRequest));
            CompletableFuture<ModifyListenerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified listener.
     * </p>
     *
     * @param modifyListenerAttributesRequest
     * @return A Java Future containing the result of the ModifyListenerAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyListenerAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListenerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyListenerAttributesResponse> modifyListenerAttributes(
            ModifyListenerAttributesRequest modifyListenerAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyListenerAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyListenerAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyListenerAttributes");

            HttpResponseHandler<ModifyListenerAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyListenerAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyListenerAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyListenerAttributesRequest, ModifyListenerAttributesResponse>()
                            .withOperationName("ModifyListenerAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyListenerAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyListenerAttributesRequest));
            CompletableFuture<ModifyListenerAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway
     * Load Balancer.
     * </p>
     * <p>
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that
     * you do not modify retain their current values.
     * </p>
     *
     * @param modifyLoadBalancerAttributesRequest
     * @return A Java Future containing the result of the ModifyLoadBalancerAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyLoadBalancerAttributesResponse> modifyLoadBalancerAttributes(
            ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyLoadBalancerAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyLoadBalancerAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyLoadBalancerAttributes");

            HttpResponseHandler<ModifyLoadBalancerAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyLoadBalancerAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyLoadBalancerAttributesRequest, ModifyLoadBalancerAttributesResponse>()
                            .withOperationName("ModifyLoadBalancerAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyLoadBalancerAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyLoadBalancerAttributesRequest));
            CompletableFuture<ModifyLoadBalancerAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyRuleRequest
     * @return A Java Future containing the result of the ModifyRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupAssociationLimitException You've reached the limit on the number of load balancers per
     *         target group.</li>
     *         <li>IncompatibleProtocolsException The specified configuration is not valid with this protocol.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>UnsupportedProtocolException The specified protocol is not supported.</li>
     *         <li>TooManyActionsException You've reached the limit on the number of actions per rule.</li>
     *         <li>InvalidLoadBalancerActionException The requested action is not valid.</li>
     *         <li>TooManyUniqueTargetGroupsPerLoadBalancerException You've reached the limit on the number of unique
     *         target groups per load balancer across all listeners. If a target group is used by multiple actions for a
     *         load balancer, it is counted as only one use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyRuleResponse> modifyRule(ModifyRuleRequest modifyRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyRule");

            HttpResponseHandler<ModifyRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyRuleRequest, ModifyRuleResponse>().withOperationName("ModifyRule")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyRuleRequest));
            CompletableFuture<ModifyRuleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     * </p>
     *
     * @param modifyTargetGroupRequest
     * @return A Java Future containing the result of the ModifyTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyTargetGroupResponse> modifyTargetGroup(ModifyTargetGroupRequest modifyTargetGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyTargetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyTargetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyTargetGroup");

            HttpResponseHandler<ModifyTargetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyTargetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyTargetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyTargetGroupRequest, ModifyTargetGroupResponse>()
                            .withOperationName("ModifyTargetGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyTargetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyTargetGroupRequest));
            CompletableFuture<ModifyTargetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified target group.
     * </p>
     *
     * @param modifyTargetGroupAttributesRequest
     * @return A Java Future containing the result of the ModifyTargetGroupAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyTargetGroupAttributesResponse> modifyTargetGroupAttributes(
            ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyTargetGroupAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyTargetGroupAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyTargetGroupAttributes");

            HttpResponseHandler<ModifyTargetGroupAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyTargetGroupAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyTargetGroupAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyTargetGroupAttributesRequest, ModifyTargetGroupAttributesResponse>()
                            .withOperationName("ModifyTargetGroupAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyTargetGroupAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyTargetGroupAttributesRequest));
            CompletableFuture<ModifyTargetGroupAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the ca certificate bundle for the specified trust store.
     * </p>
     *
     * @param modifyTrustStoreRequest
     * @return A Java Future containing the result of the ModifyTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>InvalidCaCertificatesBundleException The specified ca certificate bundle is in an invalid format, or
     *         corrupt.</li>
     *         <li>CaCertificatesBundleNotFoundException The specified ca certificate bundle does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.ModifyTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyTrustStoreResponse> modifyTrustStore(ModifyTrustStoreRequest modifyTrustStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyTrustStore");

            HttpResponseHandler<ModifyTrustStoreResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyTrustStoreRequest, ModifyTrustStoreResponse>()
                            .withOperationName("ModifyTrustStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyTrustStoreRequest));
            CompletableFuture<ModifyTrustStoreResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers the specified targets with the specified target group.
     * </p>
     * <p>
     * If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.
     * </p>
     * <p>
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target
     * group. Alternatively, you can override the port for a target when you register it. You can register each EC2
     * instance or IP address with the same target group multiple times using different ports.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-register-targets.html">
     * Register targets for your Application Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/target-group-register-targets.html">
     * Register targets for your Network Load Balancer</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-group-register-targets.html">
     * Register targets for your Gateway Load Balancer</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param registerTargetsRequest
     * @return A Java Future containing the result of the RegisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>TooManyTargetsException You've reached the limit on the number of targets.</li>
     *         <li>InvalidTargetException The specified target does not exist, is not in the same VPC as the target
     *         group, or has an unsupported instance type.</li>
     *         <li>TooManyRegistrationsForTargetIdException You've reached the limit on the number of times a target can
     *         be registered with a load balancer.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RegisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterTargetsResponse> registerTargets(RegisterTargetsRequest registerTargetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterTargets");

            HttpResponseHandler<RegisterTargetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(RegisterTargetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RegisterTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterTargetsRequest, RegisterTargetsResponse>()
                            .withOperationName("RegisterTargets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerTargetsRequest));
            CompletableFuture<RegisterTargetsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     * </p>
     *
     * @param removeListenerCertificatesRequest
     * @return A Java Future containing the result of the RemoveListenerCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveListenerCertificatesResponse> removeListenerCertificates(
            RemoveListenerCertificatesRequest removeListenerCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeListenerCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeListenerCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveListenerCertificates");

            HttpResponseHandler<RemoveListenerCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveListenerCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveListenerCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveListenerCertificatesRequest, RemoveListenerCertificatesResponse>()
                            .withOperationName("RemoveListenerCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveListenerCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeListenerCertificatesRequest));
            CompletableFuture<RemoveListenerCertificatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one
     * or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or
     * rules.
     * </p>
     *
     * @param removeTagsRequest
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>TargetGroupNotFoundException The specified target group does not exist.</li>
     *         <li>ListenerNotFoundException The specified listener does not exist.</li>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>TooManyTagsException You've reached the limit on the number of tags for this resource.</li>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTags");

            HttpResponseHandler<RemoveTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsRequest, RemoveTagsResponse>().withOperationName("RemoveTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeTagsRequest));
            CompletableFuture<RemoveTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified revocation file from the specified trust store.
     * </p>
     *
     * @param removeTrustStoreRevocationsRequest
     * @return A Java Future containing the result of the RemoveTrustStoreRevocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TrustStoreNotFoundException The specified trust store does not exist.</li>
     *         <li>RevocationIdNotFoundException The specified revocation ID does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.RemoveTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTrustStoreRevocationsResponse> removeTrustStoreRevocations(
            RemoveTrustStoreRevocationsRequest removeTrustStoreRevocationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTrustStoreRevocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTrustStoreRevocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTrustStoreRevocations");

            HttpResponseHandler<RemoveTrustStoreRevocationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveTrustStoreRevocationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveTrustStoreRevocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTrustStoreRevocationsRequest, RemoveTrustStoreRevocationsResponse>()
                            .withOperationName("RemoveTrustStoreRevocations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveTrustStoreRevocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeTrustStoreRevocationsRequest));
            CompletableFuture<RemoveTrustStoreRevocationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     * </p>
     *
     * @param setIpAddressTypeRequest
     * @return A Java Future containing the result of the SetIpAddressType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetIpAddressType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetIpAddressType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetIpAddressTypeResponse> setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setIpAddressTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setIpAddressTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetIpAddressType");

            HttpResponseHandler<SetIpAddressTypeResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetIpAddressTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetIpAddressTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetIpAddressTypeRequest, SetIpAddressTypeResponse>()
                            .withOperationName("SetIpAddressType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetIpAddressTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setIpAddressTypeRequest));
            CompletableFuture<SetIpAddressTypeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the priorities of the specified rules.
     * </p>
     * <p>
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that
     * you do not specify retain their current priority.
     * </p>
     *
     * @param setRulePrioritiesRequest
     * @return A Java Future containing the result of the SetRulePriorities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RuleNotFoundException The specified rule does not exist.</li>
     *         <li>PriorityInUseException The specified priority is in use.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetRulePrioritiesResponse> setRulePriorities(SetRulePrioritiesRequest setRulePrioritiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setRulePrioritiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setRulePrioritiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetRulePriorities");

            HttpResponseHandler<SetRulePrioritiesResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetRulePrioritiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetRulePrioritiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetRulePrioritiesRequest, SetRulePrioritiesResponse>()
                            .withOperationName("SetRulePriorities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetRulePrioritiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setRulePrioritiesRequest));
            CompletableFuture<SetRulePrioritiesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer.
     * The specified security groups override the previously associated security groups.
     * </p>
     * <p>
     * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load
     * balancer when you created it.
     * </p>
     * <p>
     * You can't associate a security group with a Gateway Load Balancer.
     * </p>
     *
     * @param setSecurityGroupsRequest
     * @return A Java Future containing the result of the SetSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>InvalidSecurityGroupException The specified security group does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetSecurityGroupsResponse> setSecurityGroups(SetSecurityGroupsRequest setSecurityGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setSecurityGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setSecurityGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetSecurityGroups");

            HttpResponseHandler<SetSecurityGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetSecurityGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetSecurityGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetSecurityGroupsRequest, SetSecurityGroupsResponse>()
                            .withOperationName("SetSecurityGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetSecurityGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setSecurityGroupsRequest));
            CompletableFuture<SetSecurityGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer,
     * Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.
     * </p>
     * <p>
     * When you specify subnets for a Network Load Balancer, or Gateway Load Balancer you must include all subnets that
     * were enabled previously, with their existing configurations, plus any additional subnets.
     * </p>
     *
     * @param setSubnetsRequest
     * @return A Java Future containing the result of the SetSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LoadBalancerNotFoundException The specified load balancer does not exist.</li>
     *         <li>InvalidConfigurationRequestException The requested configuration is not valid.</li>
     *         <li>SubnetNotFoundException The specified subnet does not exist.</li>
     *         <li>InvalidSubnetException The specified subnet is out of available addresses.</li>
     *         <li>AllocationIdNotFoundException The specified allocation ID does not exist.</li>
     *         <li>AvailabilityZoneNotSupportedException The specified Availability Zone is not supported.</li>
     *         <li>CapacityReservationPendingException There is a pending capacity reservation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticLoadBalancingV2Exception Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ElasticLoadBalancingV2AsyncClient.SetSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetSubnetsResponse> setSubnets(SetSubnetsRequest setSubnetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setSubnetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setSubnetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetSubnets");

            HttpResponseHandler<SetSubnetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetSubnetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetSubnetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetSubnetsRequest, SetSubnetsResponse>().withOperationName("SetSubnets")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetSubnetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setSubnetsRequest));
            CompletableFuture<SetSubnetsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public ElasticLoadBalancingV2AsyncWaiter waiter() {
        return ElasticLoadBalancingV2AsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final ElasticLoadBalancingV2ServiceClientConfiguration serviceClientConfiguration() {
        return new ElasticLoadBalancingV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CapacityDecreaseRequestLimitExceeded")
                                .exceptionBuilderSupplier(CapacityDecreaseRequestsLimitExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedProtocol")
                                .exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AllocationIdNotFound")
                                .exceptionBuilderSupplier(AllocationIdNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTargetGroupName")
                                .exceptionBuilderSupplier(DuplicateTargetGroupNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RevocationContentNotFound")
                                .exceptionBuilderSupplier(RevocationContentNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LoadBalancerNotFound")
                                .exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyLoadBalancers")
                                .exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest")
                                .exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyActions")
                                .exceptionBuilderSupplier(TooManyActionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName")
                                .exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCapacity")
                                .exceptionBuilderSupplier(InsufficientCapacityException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLoadBalancerAction")
                                .exceptionBuilderSupplier(InvalidLoadBalancerActionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustStoreInUse")
                                .exceptionBuilderSupplier(TrustStoreInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CaCertificatesBundleNotFound")
                                .exceptionBuilderSupplier(CaCertificatesBundleNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateNotFound")
                                .exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetGroupNotFound")
                                .exceptionBuilderSupplier(TargetGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ListenerNotFound")
                                .exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFound")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PriorityInUse")
                                .exceptionBuilderSupplier(PriorityInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRevocationContent")
                                .exceptionBuilderSupplier(InvalidRevocationContentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SSLPolicyNotFound")
                                .exceptionBuilderSupplier(SslPolicyNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateListener")
                                .exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidScheme")
                                .exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrustStores")
                                .exceptionBuilderSupplier(TooManyTrustStoresException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTargets")
                                .exceptionBuilderSupplier(TooManyTargetsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ALPNPolicyNotFound")
                                .exceptionBuilderSupplier(AlpnPolicyNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyUniqueTargetGroupsPerLoadBalancer")
                                .exceptionBuilderSupplier(TooManyUniqueTargetGroupsPerLoadBalancerException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationNotFound")
                                .exceptionBuilderSupplier(TrustStoreAssociationNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUse")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRules")
                                .exceptionBuilderSupplier(TooManyRulesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCertificates")
                                .exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTargetGroups")
                                .exceptionBuilderSupplier(TooManyTargetGroupsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CapacityUnitsLimitExceeded")
                                .exceptionBuilderSupplier(CapacityUnitsLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetGroupAssociationLimit")
                                .exceptionBuilderSupplier(TargetGroupAssociationLimitException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustStoreNotReady")
                                .exceptionBuilderSupplier(TrustStoreNotReadyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSecurityGroup")
                                .exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleProtocols")
                                .exceptionBuilderSupplier(IncompatibleProtocolsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RevocationIdNotFound")
                                .exceptionBuilderSupplier(RevocationIdNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyListeners")
                                .exceptionBuilderSupplier(TooManyListenersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotPermitted")
                                .exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTagKeys")
                                .exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTags")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRegistrationsForTargetId")
                                .exceptionBuilderSupplier(TooManyRegistrationsForTargetIdException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PriorRequestNotComplete")
                                .exceptionBuilderSupplier(PriorRequestNotCompleteException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTrustStoreName")
                                .exceptionBuilderSupplier(DuplicateTrustStoreNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCaCertificatesBundle")
                                .exceptionBuilderSupplier(InvalidCaCertificatesBundleException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CapacityReservationPending")
                                .exceptionBuilderSupplier(CapacityReservationPendingException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTarget")
                                .exceptionBuilderSupplier(InvalidTargetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustStoreNotFound")
                                .exceptionBuilderSupplier(TrustStoreNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrustStoreRevocationEntries")
                                .exceptionBuilderSupplier(TooManyTrustStoreRevocationEntriesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetNotFound")
                                .exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AvailabilityZoneNotSupported")
                                .exceptionBuilderSupplier(AvailabilityZoneNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RuleNotFound")
                                .exceptionBuilderSupplier(RuleNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteAssociationSameAccount")
                                .exceptionBuilderSupplier(DeleteAssociationSameAccountException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HealthUnavailable")
                                .exceptionBuilderSupplier(HealthUnavailableException::builder).httpStatusCode(500).build())
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ElasticLoadBalancingV2Exception::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ElasticLoadBalancingV2ServiceClientConfigurationBuilder serviceConfigBuilder = new ElasticLoadBalancingV2ServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
