/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about items that were not successfully processed in a batch call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnsuccessfulItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UnsuccessfulItem.Builder, UnsuccessfulItem> {
    private static final SdkField<UnsuccessfulItemError> ERROR_FIELD = SdkField
            .<UnsuccessfulItemError> builder(MarshallingType.SDK_POJO)
            .memberName("Error")
            .getter(getter(UnsuccessfulItem::error))
            .setter(setter(Builder::error))
            .constructor(UnsuccessfulItemError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(UnsuccessfulItem::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ERROR_FIELD, RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UnsuccessfulItemError error;

    private final String resourceId;

    private UnsuccessfulItem(BuilderImpl builder) {
        this.error = builder.error;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * Information about the error.
     * </p>
     * 
     * @return Information about the error.
     */
    public final UnsuccessfulItemError error() {
        return error;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsuccessfulItem)) {
            return false;
        }
        UnsuccessfulItem other = (UnsuccessfulItem) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnsuccessfulItem").add("Error", error()).add("ResourceId", resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Error", ERROR_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnsuccessfulItem, T> g) {
        return obj -> g.apply((UnsuccessfulItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnsuccessfulItem> {
        /**
         * <p>
         * Information about the error.
         * </p>
         * 
         * @param error
         *        Information about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(UnsuccessfulItemError error);

        /**
         * <p>
         * Information about the error.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnsuccessfulItemError.Builder} avoiding
         * the need to create one manually via {@link UnsuccessfulItemError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnsuccessfulItemError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(UnsuccessfulItemError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link UnsuccessfulItemError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(UnsuccessfulItemError)
         */
        default Builder error(Consumer<UnsuccessfulItemError.Builder> error) {
            return error(UnsuccessfulItemError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    static final class BuilderImpl implements Builder {
        private UnsuccessfulItemError error;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsuccessfulItem model) {
            error(model.error);
            resourceId(model.resourceId);
        }

        public final UnsuccessfulItemError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(UnsuccessfulItemError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(UnsuccessfulItemError error) {
            this.error = error;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public UnsuccessfulItem build() {
            return new UnsuccessfulItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
