/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeCertificateRequest extends AcmRequest implements
        ToCopyableBuilder<RevokeCertificateRequest.Builder, RevokeCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(RevokeCertificateRequest::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> REVOCATION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevocationReason").getter(getter(RevokeCertificateRequest::revocationReasonAsString))
            .setter(setter(Builder::revocationReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            REVOCATION_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificateArn;

    private final String revocationReason;

    private RevokeCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.revocationReason = builder.revocationReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the public or private certificate that will be revoked. The ARN must have the
     * following form:
     * </p>
     * <p>
     * <code>arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the public or private certificate that will be revoked. The ARN must
     *         have the following form: </p>
     *         <p>
     *         <code>arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012</code>
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * Specifies why you revoked the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationReason}
     * will return {@link RevocationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revocationReasonAsString}.
     * </p>
     * 
     * @return Specifies why you revoked the certificate.
     * @see RevocationReason
     */
    public final RevocationReason revocationReason() {
        return RevocationReason.fromValue(revocationReason);
    }

    /**
     * <p>
     * Specifies why you revoked the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationReason}
     * will return {@link RevocationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revocationReasonAsString}.
     * </p>
     * 
     * @return Specifies why you revoked the certificate.
     * @see RevocationReason
     */
    public final String revocationReasonAsString() {
        return revocationReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(revocationReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeCertificateRequest)) {
            return false;
        }
        RevokeCertificateRequest other = (RevokeCertificateRequest) obj;
        return Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(revocationReasonAsString(), other.revocationReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeCertificateRequest").add("CertificateArn", certificateArn())
                .add("RevocationReason", revocationReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "RevocationReason":
            return Optional.ofNullable(clazz.cast(revocationReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("RevocationReason", REVOCATION_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeCertificateRequest, T> g) {
        return obj -> g.apply((RevokeCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AcmRequest.Builder, SdkPojo, CopyableBuilder<Builder, RevokeCertificateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the public or private certificate that will be revoked. The ARN must have
         * the following form:
         * </p>
         * <p>
         * <code>arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012</code>
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the public or private certificate that will be revoked. The ARN must
         *        have the following form: </p>
         *        <p>
         *        <code>arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * Specifies why you revoked the certificate.
         * </p>
         * 
         * @param revocationReason
         *        Specifies why you revoked the certificate.
         * @see RevocationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationReason
         */
        Builder revocationReason(String revocationReason);

        /**
         * <p>
         * Specifies why you revoked the certificate.
         * </p>
         * 
         * @param revocationReason
         *        Specifies why you revoked the certificate.
         * @see RevocationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationReason
         */
        Builder revocationReason(RevocationReason revocationReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmRequest.BuilderImpl implements Builder {
        private String certificateArn;

        private String revocationReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeCertificateRequest model) {
            super(model);
            certificateArn(model.certificateArn);
            revocationReason(model.revocationReason);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getRevocationReason() {
            return revocationReason;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        @Override
        public final Builder revocationReason(RevocationReason revocationReason) {
            this.revocationReason(revocationReason == null ? null : revocationReason.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeCertificateRequest build() {
            return new RevokeCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
