/*
 * Decompiled with CFR 0.152.
 */
package org.moxieapps.gwt.highcharts.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import org.moxieapps.gwt.highcharts.client.Animation;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.Configurable;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.plotOptions.Marker;

public class Point
extends Configurable<Point> {
    private String name;
    private Number[] values;
    private JavaScriptObject nativePoint;
    private boolean selected = false;
    private boolean sliced = false;
    private String text;
    private String title;
    public String id;

    Number[] getValues() {
        return this.values;
    }

    public Point(Number y) {
        this(new Number[]{y});
    }

    public Point(Number x, Number y) {
        this(new Number[]{x, y});
    }

    public Point(Number x, Number a, Number b) {
        this(new Number[]{x, a, b});
    }

    public Point(Number x, Number open, Number high, Number low, Number close) {
        this(new Number[]{x, open, high, low, close});
    }

    public Point(Number ... values) {
        this.values = values;
    }

    public Point(String name, Number y) {
        this.values = new Number[]{y};
        this.setName(name);
    }

    public Point(String name) {
        this.setName(name);
    }

    public Point(Number x, String title, String text) {
        this.values = new Number[]{x};
        this.setTitle(title);
        this.setText(text);
    }

    public Point(JavaScriptObject nativePoint) {
        this.nativePoint = nativePoint;
    }

    public Number getValue() {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "value")) {
            return Point.nativeGetNumber(this.nativePoint, "value");
        }
        if (this.values.length == 3) {
            return this.values[2];
        }
        return null;
    }

    public Number getZ() {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "z")) {
            return Point.nativeGetNumber(this.nativePoint, "z");
        }
        if (this.values.length == 3) {
            return this.values[2];
        }
        return null;
    }

    public Number getY() {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "y")) {
            return Point.nativeGetNumber(this.nativePoint, "y");
        }
        if (this.values.length <= 3 && this.values.length > 1) {
            return this.values[1];
        }
        return this.values[0];
    }

    public Number getX() {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "x")) {
            return Point.nativeGetNumber(this.nativePoint, "x");
        }
        if (this.values.length > 1) {
            return this.values[0];
        }
        return null;
    }

    public Number getOpen() {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "open")) {
            return Point.nativeGetNumber(this.nativePoint, "open");
        }
        if (this.values.length >= 4) {
            if (this.values.length == 4) {
                return this.values[0];
            }
            return this.values[1];
        }
        return null;
    }

    public Number getHigh() {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "high")) {
            return Point.nativeGetNumber(this.nativePoint, "high");
        }
        if (this.values.length >= 4) {
            if (this.values.length == 4) {
                return this.values[1];
            }
            return this.values[2];
        }
        return null;
    }

    public Number getLow() {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "low")) {
            return Point.nativeGetNumber(this.nativePoint, "low");
        }
        if (this.values.length >= 4) {
            if (this.values.length == 4) {
                return this.values[2];
            }
            return this.values[3];
        }
        return null;
    }

    public Number getClose() {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "close")) {
            return Point.nativeGetNumber(this.nativePoint, "close");
        }
        if (this.values.length >= 4) {
            if (this.values.length == 4) {
                return this.values[3];
            }
            return this.values[4];
        }
        return null;
    }

    public Point setColor(String color) {
        return (Point)this.setOption("color", color);
    }

    public Point setDrilldownSeries(Series drilldownSeries) {
        return (Point)this.setOption("drilldown", drilldownSeries.getId());
    }

    public Point setIsIntermediateSum(boolean isIntermediateSum) {
        return (Point)this.setOption("isIntermediateSum", isIntermediateSum);
    }

    public Point setIsSum(boolean isSum) {
        return (Point)this.setOption("isSum", isSum);
    }

    public Point setMarker(Marker marker) {
        return (Point)this.setOption("marker", marker != null ? marker.getOptions() : null);
    }

    public Point setName(String name) {
        this.name = name;
        return (Point)this.setOption("name", name);
    }

    public String getName() {
        if (this.nativePoint != null) {
            return Point.nativeGetString(this.nativePoint, "name");
        }
        return this.name;
    }

    public Point setParent(Point parent) {
        return (Point)this.setOption("parent", parent != null ? parent.getId(true) : null);
    }

    public Point setParent(String parent) {
        return (Point)this.setOption("parent", parent);
    }

    public Point setSelected(boolean selected) {
        this.selected = selected;
        return (Point)this.setOption("selected", selected);
    }

    public Point setSliced(boolean sliced) {
        this.sliced = sliced;
        return (Point)this.setOption("sliced", sliced);
    }

    public Point setUserData(JSONObject userData) {
        return (Point)this.setOption("userData", userData);
    }

    public JSONObject getUserData() {
        if (this.nativePoint != null) {
            JavaScriptObject nativeUserData = Point.nativeGetUserData(this.nativePoint);
            return nativeUserData != null ? new JSONObject(nativeUserData) : null;
        }
        return this.getOptions() != null ? (JSONObject)this.getOptions().get("userData") : null;
    }

    public Point remove() {
        return this.remove(true, true);
    }

    public Point remove(boolean redraw, boolean animation) {
        return this.remove(redraw, animation ? new Animation() : null);
    }

    public Point remove(boolean redraw, Animation animation) {
        if (this.nativePoint != null) {
            if (animation == null || animation.getOptions() == null) {
                Point.nativeRemove(this.nativePoint, redraw, animation != null);
            } else {
                Point.nativeRemove(this.nativePoint, redraw, animation.getOptions().getJavaScriptObject());
            }
        }
        return this;
    }

    public Point select(boolean select, boolean accumulate) {
        if (this.nativePoint != null) {
            Point.nativeSelect(this.nativePoint, select, accumulate);
        } else {
            this.setSelected(select);
        }
        return this;
    }

    public Point selectToggle(boolean accumulate) {
        if (this.nativePoint != null) {
            Point.nativeSelectToggle(this.nativePoint, accumulate);
        } else {
            this.setSelected(!this.selected);
        }
        return this;
    }

    public Point slice(boolean sliced) {
        return this.slice(sliced, true, true);
    }

    public Point slice(boolean sliced, boolean redraw, boolean animation) {
        return this.slice(sliced, redraw, animation ? new Animation() : null);
    }

    public Point slice(boolean sliced, boolean redraw, Animation animation) {
        if (this.nativePoint != null) {
            if (animation == null || animation.getOptions() == null) {
                Point.nativeSlice(this.nativePoint, sliced, redraw, animation != null);
            } else {
                Point.nativeSlice(this.nativePoint, sliced, redraw, animation.getOptions().getJavaScriptObject());
            }
        } else {
            this.setSliced(sliced);
        }
        return this;
    }

    public Point sliceToggle() {
        return this.sliceToggle(true, true);
    }

    public Point sliceToggle(boolean redraw, boolean animation) {
        return this.sliceToggle(redraw, animation ? new Animation() : null);
    }

    public Point sliceToggle(boolean redraw, Animation animation) {
        if (this.nativePoint != null) {
            if (animation == null || animation.getOptions() == null) {
                Point.nativeSlice(this.nativePoint, redraw, animation != null);
            } else {
                Point.nativeSlice(this.nativePoint, redraw, animation.getOptions().getJavaScriptObject());
            }
        } else {
            this.setSliced(!this.sliced);
        }
        return this;
    }

    public Point setText(String text) {
        this.text = text;
        return (Point)this.setOption("text", text);
    }

    public String getText() {
        if (this.nativePoint != null) {
            return Point.nativeGetString(this.nativePoint, "text");
        }
        return this.text;
    }

    public Point setTitle(String title) {
        this.title = title;
        return (Point)this.setOption("title", title);
    }

    public String getTitle() {
        if (this.nativePoint != null) {
            return Point.nativeGetString(this.nativePoint, "title");
        }
        return this.title;
    }

    public Point update(Number y) {
        return this.update(new Point(y));
    }

    public Point update(Number x, Number y) {
        return this.update(new Point(x, y));
    }

    public Point update(Number x, Number low, Number high) {
        return this.update(new Point(x, low, high));
    }

    public Point update(Number y, boolean redraw) {
        return this.update(new Point(y), redraw, true);
    }

    public Point update(Number x, Number y, boolean redraw) {
        return this.update(new Point(x, y), redraw, true);
    }

    public Point update(Number x, Number low, Number high, boolean redraw) {
        return this.update(new Point(x, low, high), redraw, true);
    }

    public Point update(Point pointOptions) {
        return this.update(pointOptions, true, true);
    }

    public Point update(Point pointOptions, boolean redraw, boolean animation) {
        return this.update(pointOptions, redraw, animation ? new Animation() : null);
    }

    public Point update(Point pointOptions, boolean redraw, Animation animation) {
        if (this.nativePoint != null) {
            if (animation == null || animation.getOptions() == null) {
                if (pointOptions.isSingleValue()) {
                    if (pointOptions.getY() == null) {
                        Point.nativeUpdateToNull(this.nativePoint, redraw, animation != null);
                    } else {
                        Point.nativeUpdate(this.nativePoint, pointOptions.getY().doubleValue(), redraw, animation != null);
                    }
                } else {
                    Point.nativeUpdate(this.nativePoint, Point.convertPointToJavaScriptObject(pointOptions), redraw, animation != null);
                }
            } else if (pointOptions.isSingleValue()) {
                if (pointOptions.getY() == null) {
                    Point.nativeUpdateToNull(this.nativePoint, redraw, animation.getOptions().getJavaScriptObject());
                } else {
                    Point.nativeUpdate(this.nativePoint, pointOptions.getY().doubleValue(), redraw, animation.getOptions().getJavaScriptObject());
                }
            } else {
                Point.nativeUpdate(this.nativePoint, Point.convertPointToJavaScriptObject(pointOptions), redraw, animation.getOptions().getJavaScriptObject());
            }
        } else {
            this.values = pointOptions.values;
            this.name = pointOptions.name;
            this.selected = pointOptions.selected;
            this.sliced = pointOptions.sliced;
            if (this.getOptions() != null) {
                for (String key : pointOptions.getOptions().keySet()) {
                    this.setOption(key, pointOptions.getOptions().get(key));
                }
            }
        }
        return this;
    }

    boolean isSingleValue() {
        return this.getOptions() == null && (this.getValues() == null || this.getValues().length == 1);
    }

    boolean hasNativeProperties() {
        return this.nativePoint != null && (Point.nativeContainsKey(this.nativePoint, "name") || Point.nativeContainsKey(this.nativePoint, "userData"));
    }

    static JSONValue addPointNativeProperties(Point point, JSONObject options) {
        if (options.get("name") == null && Point.nativeContainsKey(point.nativePoint, "name")) {
            options.put("name", (JSONValue)new JSONString(point.getName()));
        }
        if (options.get("userData") == null && Point.nativeContainsKey(point.nativePoint, "userData")) {
            options.put("userData", (JSONValue)point.getUserData());
        }
        return options;
    }

    String getId(boolean generateIdIsMissing) {
        if (this.nativePoint != null && Point.nativeContainsKey(this.nativePoint, "id")) {
            return Point.nativeGetString(this.nativePoint, "id");
        }
        if (this.id == null && generateIdIsMissing) {
            this.id = Document.get().createUniqueId();
            this.setOption("id", this.id);
        }
        return this.id;
    }

    private static JavaScriptObject convertPointToJavaScriptObject(Point point) {
        JSONObject options = point.getOptions() != null ? point.getOptions() : new JSONObject();
        Chart.addPointScalarValues(point, options, Series.Type.LINE);
        if (point.hasNativeProperties()) {
            Point.addPointNativeProperties(point, options);
        }
        return options.getJavaScriptObject();
    }

    public JavaScriptObject getNativePoint() {
        return this.nativePoint;
    }

    private static native boolean nativeContainsKey(JavaScriptObject var0, String var1);

    private static native int nativeGetDataLength(JavaScriptObject var0);

    private static native double nativeGetNumber(JavaScriptObject var0, String var1);

    private static native String nativeGetString(JavaScriptObject var0, String var1);

    private static native void nativeRemove(JavaScriptObject var0, boolean var1, boolean var2);

    private static native void nativeRemove(JavaScriptObject var0, boolean var1, JavaScriptObject var2);

    private static native void nativeSelect(JavaScriptObject var0, boolean var1, boolean var2);

    private static native void nativeSelectToggle(JavaScriptObject var0, boolean var1);

    private static native void nativeSlice(JavaScriptObject var0, boolean var1, boolean var2, JavaScriptObject var3);

    private static native void nativeSlice(JavaScriptObject var0, boolean var1, boolean var2, boolean var3);

    private static native void nativeSlice(JavaScriptObject var0, boolean var1, JavaScriptObject var2);

    private static native void nativeSlice(JavaScriptObject var0, boolean var1, boolean var2);

    private static native void nativeUpdate(JavaScriptObject var0, JavaScriptObject var1, boolean var2, JavaScriptObject var3);

    private static native void nativeUpdate(JavaScriptObject var0, double var1, boolean var3, JavaScriptObject var4);

    private static native void nativeUpdate(JavaScriptObject var0, JavaScriptObject var1, boolean var2, boolean var3);

    private static native void nativeUpdate(JavaScriptObject var0, double var1, boolean var3, boolean var4);

    private static native void nativeUpdateToNull(JavaScriptObject var0, boolean var1, JavaScriptObject var2);

    private static native void nativeUpdateToNull(JavaScriptObject var0, boolean var1, boolean var2);

    private static native JavaScriptObject nativeGetUserData(JavaScriptObject var0);
}

