/*
 * Decompiled with CFR 0.152.
 */
package org.moxieapps.gwt.highcharts.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.moxieapps.gwt.highcharts.client.Animation;
import org.moxieapps.gwt.highcharts.client.Axis;
import org.moxieapps.gwt.highcharts.client.ChartSubtitle;
import org.moxieapps.gwt.highcharts.client.ChartTitle;
import org.moxieapps.gwt.highcharts.client.Color;
import org.moxieapps.gwt.highcharts.client.ColorAxis;
import org.moxieapps.gwt.highcharts.client.Configurable;
import org.moxieapps.gwt.highcharts.client.Credits;
import org.moxieapps.gwt.highcharts.client.Exporting;
import org.moxieapps.gwt.highcharts.client.LabelItem;
import org.moxieapps.gwt.highcharts.client.Legend;
import org.moxieapps.gwt.highcharts.client.Loading;
import org.moxieapps.gwt.highcharts.client.Navigation;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.ResetZoomButton;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.Style;
import org.moxieapps.gwt.highcharts.client.ToolTip;
import org.moxieapps.gwt.highcharts.client.ToolTipData;
import org.moxieapps.gwt.highcharts.client.XAxis;
import org.moxieapps.gwt.highcharts.client.YAxis;
import org.moxieapps.gwt.highcharts.client.ZAxis;
import org.moxieapps.gwt.highcharts.client.events.AxisSetExtremesEvent;
import org.moxieapps.gwt.highcharts.client.events.ChartClickEvent;
import org.moxieapps.gwt.highcharts.client.events.ChartClickEventHandler;
import org.moxieapps.gwt.highcharts.client.events.ChartLoadEvent;
import org.moxieapps.gwt.highcharts.client.events.ChartLoadEventHandler;
import org.moxieapps.gwt.highcharts.client.events.ChartRedrawEvent;
import org.moxieapps.gwt.highcharts.client.events.ChartRedrawEventHandler;
import org.moxieapps.gwt.highcharts.client.events.ChartSelectionEvent;
import org.moxieapps.gwt.highcharts.client.events.ChartSelectionEventHandler;
import org.moxieapps.gwt.highcharts.client.events.PointClickEvent;
import org.moxieapps.gwt.highcharts.client.events.PointLegendItemClickEvent;
import org.moxieapps.gwt.highcharts.client.events.PointMouseOutEvent;
import org.moxieapps.gwt.highcharts.client.events.PointMouseOverEvent;
import org.moxieapps.gwt.highcharts.client.events.PointRemoveEvent;
import org.moxieapps.gwt.highcharts.client.events.PointSelectEvent;
import org.moxieapps.gwt.highcharts.client.events.PointUnselectEvent;
import org.moxieapps.gwt.highcharts.client.events.PointUpdateEvent;
import org.moxieapps.gwt.highcharts.client.events.SeriesCheckboxClickEvent;
import org.moxieapps.gwt.highcharts.client.events.SeriesClickEvent;
import org.moxieapps.gwt.highcharts.client.events.SeriesHideEvent;
import org.moxieapps.gwt.highcharts.client.events.SeriesLegendItemClickEvent;
import org.moxieapps.gwt.highcharts.client.events.SeriesMouseOutEvent;
import org.moxieapps.gwt.highcharts.client.events.SeriesMouseOverEvent;
import org.moxieapps.gwt.highcharts.client.events.SeriesShowEvent;
import org.moxieapps.gwt.highcharts.client.labels.AxisLabelsData;
import org.moxieapps.gwt.highcharts.client.labels.DataLabelsData;
import org.moxieapps.gwt.highcharts.client.labels.LegendLabelsData;
import org.moxieapps.gwt.highcharts.client.labels.StackLabelsData;
import org.moxieapps.gwt.highcharts.client.plotOptions.AreaPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.AreaRangePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.AreaSplinePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.AreaSplineRangePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.BarPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.BoxPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.BubblePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.CandlestickPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.ColumnPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.ColumnRangePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.ErrorBarPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.FunnelPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.GaugePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.HeatmapPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.LinePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.Marker;
import org.moxieapps.gwt.highcharts.client.plotOptions.OHLCPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.PiePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.PlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.PyramidPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.ScatterPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.SeriesPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.SolidGaugePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.SplinePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.TreemapPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.WaterfallPlotOptions;

public abstract class BaseChart<T>
extends Widget {
    private Legend legend;
    private ToolTip toolTip;
    Series.Type defaultSeriesType = Series.Type.LINE;
    private Configurable configurable = new Configurable(){};
    private AreaPlotOptions areaPlotOptions;
    private AreaRangePlotOptions areaRangePlotOptions;
    private AreaSplinePlotOptions areaSplinePlotOptions;
    private AreaSplineRangePlotOptions areaSplineRangePlotOptions;
    private BarPlotOptions barPlotOptions;
    private BoxPlotOptions boxPlotOptions;
    private BubblePlotOptions bubblePlotOptions;
    private ColumnPlotOptions columnPlotOptions;
    private ColumnRangePlotOptions columnRangePlotOptions;
    private ErrorBarPlotOptions errorBarPlotOptions;
    private FunnelPlotOptions funnelPlotOptions;
    private GaugePlotOptions gaugePlotOptions;
    private HeatmapPlotOptions heatmapPlotOptions;
    private LinePlotOptions linePlotOptions;
    private PiePlotOptions piePlotOptions;
    private PyramidPlotOptions pyramidPlotOptions;
    private SeriesPlotOptions seriesPlotOptions;
    private ScatterPlotOptions scatterPlotOptions;
    private SolidGaugePlotOptions solidGaugePlotOptions;
    private SplinePlotOptions splinePlotOptions;
    private TreemapPlotOptions treemapPlotOptions;
    private WaterfallPlotOptions waterfallPlotOptions;
    protected CandlestickPlotOptions candlestickPlotOptions;
    protected OHLCPlotOptions ohlcPlotOptions;
    private ChartClickEventHandler chartClickEventHandler;
    private ChartLoadEventHandler chartLoadEventHandler;
    private ChartRedrawEventHandler chartRedrawEventHandler;
    private ChartSelectionEventHandler chartSelectionEventHandler;
    private boolean persistent = false;
    private ArrayList<Series> seriesList = new ArrayList();
    private ArrayList<XAxis> xAxes = new ArrayList();
    private ArrayList<YAxis> yAxes = new ArrayList();
    private ArrayList<ZAxis> zAxes = new ArrayList();
    private JavaScriptObject chart;

    protected BaseChart() {
        DivElement divElement = Document.get().createDivElement();
        divElement.getStyle().setOverflow(Style.Overflow.HIDDEN);
        divElement.setId(Document.get().createUniqueId());
        this.setElement((Element)divElement);
    }

    public T setAlignTicks(boolean alignTicks) {
        return this.setOption("/chart/alignTicks", alignTicks);
    }

    public T setAnimation(boolean animation) {
        return this.setOption("/chart/animation", animation);
    }

    public T setAnimation(Animation animation) {
        return this.setOption("/chart/animation", animation.getOptions());
    }

    public T setBackgroundColor(String backgroundColor) {
        return this.setOption("/chart/backgroundColor", backgroundColor);
    }

    public T setBackgroundColor(Color backgroundColor) {
        return this.setOption("/chart/backgroundColor", backgroundColor != null ? backgroundColor.getOptionValue() : null);
    }

    public T setBorderColor(String borderColor) {
        return this.setOption("/chart/borderColor", borderColor);
    }

    public T setBorderColor(Color borderColor) {
        return this.setOption("/chart/borderColor", borderColor != null ? borderColor.getOptionValue() : null);
    }

    public T setBorderRadius(Number borderRadius) {
        return this.setOption("/chart/borderRadius", borderRadius);
    }

    public T setBorderWidth(Number borderWidth) {
        return this.setOption("/chart/borderWidth", borderWidth);
    }

    public T setChartSubtitleText(String subtitle) {
        return this.setOption("/subtitle/text", subtitle);
    }

    public T setChartSubtitle(ChartSubtitle subtitle) {
        return this.setOption("/subtitle", subtitle != null ? subtitle.getOptions() : null);
    }

    public T setChartTitleText(String title) {
        return this.setOption("/title/text", title);
    }

    public T setChartTitle(ChartTitle title) {
        return this.setOption("/title", title != null ? title.getOptions() : null);
    }

    public T setClassName(String className) {
        return this.setOption("/chart/className", className);
    }

    public T setColors(String ... colors) {
        return this.setOption("/colors", colors);
    }

    public T setColorAxis(ColorAxis colorAxis) {
        return this.setOption("/colorAxis", colorAxis != null ? colorAxis.getOptions() : null);
    }

    public T setCredits(Credits credits) {
        return this.setOption("/credits", credits != null ? credits.getOptions() : null);
    }

    public T setExporting(Exporting exporting) {
        return this.setOption("/exporting", exporting != null ? exporting.getOptions() : null);
    }

    public T setHeight(Number height) {
        return this.setOption("/chart/height", height);
    }

    public T setIgnoreHiddenSeries(boolean ignoreHiddenSeries) {
        return this.setOption("/chart/ignoreHiddenSeries", ignoreHiddenSeries);
    }

    public T setInverted(boolean inverted) {
        return this.setOption("/chart/inverted", inverted);
    }

    public T setLabelItems(LabelItem ... labelItems) {
        return this.setOption("/labels/items", labelItems);
    }

    public T setLabelsStyle(Style style) {
        return this.setOption("/labels/style", style != null ? style.getOptions() : null);
    }

    public T setLegend(Legend legend) {
        this.legend = legend;
        return this.setOption("/legend", legend != null ? legend.getOptions() : null);
    }

    public T setLoading(Loading loading) {
        return this.setOption("/loading", loading != null ? loading.getOptions() : null);
    }

    public T setMargin(Number marginTop, Number marginRight, Number marginBottom, Number marginLeft) {
        JSONArray margins = new JSONArray();
        margins.set(0, (JSONValue)new JSONNumber(marginTop.doubleValue()));
        margins.set(1, (JSONValue)new JSONNumber(marginRight.doubleValue()));
        margins.set(2, (JSONValue)new JSONNumber(marginBottom.doubleValue()));
        margins.set(3, (JSONValue)new JSONNumber(marginLeft.doubleValue()));
        return this.setOption("/chart/margin", margins);
    }

    public T setMarginTop(Number marginTop) {
        return this.setOption("/chart/marginTop", marginTop);
    }

    public T setMarginRight(Number marginRight) {
        return this.setOption("/chart/marginRight", marginRight);
    }

    public T setMarginBottom(Number marginBottom) {
        return this.setOption("/chart/marginBottom", marginBottom);
    }

    public T setMarginLeft(Number marginLeft) {
        return this.setOption("/chart/marginLeft", marginLeft);
    }

    public T setNavigation(Navigation navigation) {
        return this.setOption("/navigation", navigation != null ? navigation.getOptions() : null);
    }

    public T setPinchType(PinchType pinchType) {
        return this.setOption("/chart/pinchType", pinchType != null ? pinchType.toString() : null);
    }

    public T setPlotBackgroundColor(String plotBackgroundColor) {
        return this.setOption("/chart/plotBackgroundColor", plotBackgroundColor);
    }

    public T setPlotBackgroundColor(Color plotBackgroundColor) {
        return this.setOption("/chart/plotBackgroundColor", plotBackgroundColor != null ? plotBackgroundColor.getOptionValue() : null);
    }

    public T setPlotBackgroundImage(String plotBackgroundImage) {
        return this.setOption("/chart/plotBackgroundImage", plotBackgroundImage);
    }

    public T setPlotBorderColor(String plotBorderColor) {
        return this.setOption("/chart/plotBorderColor", plotBorderColor);
    }

    public T setPlotBorderColor(Color plotBorderColor) {
        return this.setOption("/chart/plotBorderColor", plotBorderColor != null ? plotBorderColor.getOptionValue() : null);
    }

    public T setPlotBorderWidth(Number plotBorderWidth) {
        return this.setOption("/chart/plotBorderWidth", plotBorderWidth);
    }

    public T setPolar(boolean polar) {
        return this.setOption("/chart/polar", polar);
    }

    public T setPlotShadow(boolean plotShadow) {
        return this.setOption("/chart/plotShadow", plotShadow);
    }

    public T setReflow(boolean reflow) {
        return this.setOption("/chart/reflow", reflow);
    }

    public T setResetZoomButton(ResetZoomButton resetZoomButton) {
        return this.setOption("/chart/resetZoomButton", resetZoomButton);
    }

    public T setSelectionMarkerFill(String selectionMarkerFill) {
        return this.setOption("/chart/selectionMarkerFill", selectionMarkerFill);
    }

    public T setSelectionMarkerFill(Color selectionMarkerFill) {
        return this.setOption("/chart/selectionMarkerFill", selectionMarkerFill != null ? selectionMarkerFill.getOptionValue() : null);
    }

    public T setShadow(boolean shadow) {
        return this.setOption("/chart/shadow", shadow);
    }

    public T setShowAxes(boolean showAxes) {
        return this.setOption("/chart/showAxes", showAxes);
    }

    public T setSpacingTop(Number spacingTop) {
        return this.setOption("/chart/spacingTop", spacingTop);
    }

    public T setSpacingRight(Number spacingRight) {
        return this.setOption("/chart/spacingRight", spacingRight);
    }

    public T setSpacingBottom(Number spacingBottom) {
        return this.setOption("/chart/spacingBottom", spacingBottom);
    }

    public T setSpacingLeft(Number spacingLeft) {
        return this.setOption("/chart/spacingLeft", spacingLeft);
    }

    public T setStyle(Style style) {
        return this.setOption("/chart/style", style != null ? style.getOptions() : null);
    }

    public T setSymbols(Marker.Symbol ... symbols) {
        JSONArray symbolsArray = null;
        if (symbols != null) {
            symbolsArray = new JSONArray();
            int i = 0;
            while (i < symbols.length) {
                Marker.Symbol symbol = symbols[i];
                symbolsArray.set(i, (JSONValue)new JSONString(symbol.toString()));
                ++i;
            }
        }
        return this.setOption("/symbols", symbolsArray);
    }

    public T setTitle(ChartTitle chartTitle, ChartSubtitle chartSubtitle) {
        if (this.isRendered()) {
            BaseChart.nativeSetTitle(this.chart, chartTitle != null ? chartTitle.getOptions().getJavaScriptObject() : null, chartSubtitle != null ? chartSubtitle.getOptions().getJavaScriptObject() : null);
        }
        if (!this.isRendered() || this.isPersistent()) {
            this.setChartTitle(chartTitle);
            this.setChartSubtitle(chartSubtitle);
        }
        return this.returnThis();
    }

    public T setToolTip(ToolTip toolTip) {
        this.toolTip = toolTip;
        return this.setOption("/tooltip", toolTip != null ? toolTip.getOptions() : null);
    }

    public T setType(Series.Type type) {
        this.defaultSeriesType = type;
        return this.setOption("/chart/type", type != null ? type.toString() : null);
    }

    public T setWidth(Number width) {
        return this.setOption("/chart/width", width);
    }

    public T setSizeToMatchContainer() {
        return this.setSize(this.getOffsetWidth(), this.getOffsetHeight());
    }

    public T setWidth100() {
        this.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        return this.returnThis();
    }

    public T setHeight100() {
        this.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
        return this.returnThis();
    }

    public T setSize(int width, int height) {
        return this.setSize(width, height, true);
    }

    public T setSize(int width, int height, boolean animated) {
        return this.setSize(width, height, animated ? new Animation() : null);
    }

    public T setSize(int width, int height, Animation animation) {
        if (width <= 0 || height <= 0) {
            return this.returnThis();
        }
        if (this.isRendered()) {
            if (animation == null || animation.getOptions() == null) {
                BaseChart.nativeSetSize(this.chart, width, height, animation != null);
            } else {
                BaseChart.nativeSetSize(this.chart, width, height, animation.getOptions().getJavaScriptObject());
            }
        } else {
            this.setOption("/chart/width", width);
            this.setOption("/chart/height", height);
        }
        return this.returnThis();
    }

    public T setOption(String path, Object value) {
        this.configurable.setOption(path, value);
        return this.returnThis();
    }

    public JSONObject getOptions() {
        return this.configurable.getOptions();
    }

    private T returnThis() {
        BaseChart instance = this;
        return (T)((Object)instance);
    }

    public T setAreaPlotOptions(AreaPlotOptions areaPlotOptions) {
        this.areaPlotOptions = areaPlotOptions;
        return areaPlotOptions != null && areaPlotOptions.getOptions() != null ? this.setOption("/plotOptions/area", areaPlotOptions.getOptions()) : this.returnThis();
    }

    public T setAreaRangePlotOptions(AreaRangePlotOptions areaRangePlotOptions) {
        this.areaRangePlotOptions = areaRangePlotOptions;
        return areaRangePlotOptions != null && areaRangePlotOptions.getOptions() != null ? this.setOption("/plotOptions/arearange", areaRangePlotOptions.getOptions()) : this.returnThis();
    }

    public T setAreaSplinePlotOptions(AreaSplinePlotOptions areaSplinePlotOptions) {
        this.areaSplinePlotOptions = areaSplinePlotOptions;
        return areaSplinePlotOptions != null && areaSplinePlotOptions.getOptions() != null ? this.setOption("/plotOptions/areaspline", areaSplinePlotOptions.getOptions()) : this.returnThis();
    }

    public T setAreaSplineRangePlotOptions(AreaSplineRangePlotOptions areaSplineRangePlotOptions) {
        this.areaSplineRangePlotOptions = areaSplineRangePlotOptions;
        return areaSplineRangePlotOptions != null && areaSplineRangePlotOptions.getOptions() != null ? this.setOption("/plotOptions/areasplinerange", areaSplineRangePlotOptions.getOptions()) : this.returnThis();
    }

    public T setBarPlotOptions(BarPlotOptions barPlotOptions) {
        this.barPlotOptions = barPlotOptions;
        return barPlotOptions != null && barPlotOptions.getOptions() != null ? this.setOption("/plotOptions/bar", barPlotOptions.getOptions()) : this.returnThis();
    }

    public T setBoxPlotOptions(BoxPlotOptions boxPlotOptions) {
        this.boxPlotOptions = boxPlotOptions;
        return boxPlotOptions != null && boxPlotOptions.getOptions() != null ? this.setOption("/plotOptions/box", boxPlotOptions.getOptions()) : this.returnThis();
    }

    public T setBubblePlotOptions(BubblePlotOptions bubblePlotOptions) {
        this.bubblePlotOptions = bubblePlotOptions;
        return bubblePlotOptions != null && bubblePlotOptions.getOptions() != null ? this.setOption("/plotOptions/bubble", bubblePlotOptions.getOptions()) : this.returnThis();
    }

    public T setColumnPlotOptions(ColumnPlotOptions columnPlotOptions) {
        this.columnPlotOptions = columnPlotOptions;
        return columnPlotOptions != null && columnPlotOptions.getOptions() != null ? this.setOption("/plotOptions/column", columnPlotOptions.getOptions()) : this.returnThis();
    }

    public T setColumnRangePlotOptions(ColumnRangePlotOptions columnRangePlotOptions) {
        this.columnRangePlotOptions = columnRangePlotOptions;
        return columnRangePlotOptions != null && columnRangePlotOptions.getOptions() != null ? this.setOption("/plotOptions/columnrange", columnRangePlotOptions.getOptions()) : this.returnThis();
    }

    public T setErrorBarPlotOptions(ErrorBarPlotOptions errorBarPlotOptions) {
        this.errorBarPlotOptions = errorBarPlotOptions;
        return errorBarPlotOptions != null && errorBarPlotOptions.getOptions() != null ? this.setOption("/plotOptions/errorbar", errorBarPlotOptions.getOptions()) : this.returnThis();
    }

    public T setFunnelPlotOptions(FunnelPlotOptions funnelPlotOptions) {
        this.funnelPlotOptions = funnelPlotOptions;
        return funnelPlotOptions != null && funnelPlotOptions.getOptions() != null ? this.setOption("/plotOptions/funnel", funnelPlotOptions.getOptions()) : this.returnThis();
    }

    public T setGaugePlotOptions(GaugePlotOptions gaugePlotOptions) {
        this.gaugePlotOptions = gaugePlotOptions;
        return gaugePlotOptions != null && gaugePlotOptions.getOptions() != null ? this.setOption("/plotOptions/gauge", gaugePlotOptions.getOptions()) : this.returnThis();
    }

    public T setHeatmapPlotOptions(HeatmapPlotOptions heatmapPlotOptions) {
        this.heatmapPlotOptions = heatmapPlotOptions;
        return heatmapPlotOptions != null && heatmapPlotOptions.getOptions() != null ? this.setOption("/plotOptions/heatmap", heatmapPlotOptions.getOptions()) : this.returnThis();
    }

    public T setLinePlotOptions(LinePlotOptions linePlotOptions) {
        this.linePlotOptions = linePlotOptions;
        return linePlotOptions != null && linePlotOptions.getOptions() != null ? this.setOption("/plotOptions/line", linePlotOptions.getOptions()) : this.returnThis();
    }

    public T setPiePlotOptions(PiePlotOptions piePlotOptions) {
        this.piePlotOptions = piePlotOptions;
        return piePlotOptions != null && piePlotOptions.getOptions() != null ? this.setOption("/plotOptions/pie", piePlotOptions.getOptions()) : this.returnThis();
    }

    public T setPyramidPlotOptions(PyramidPlotOptions pyramidPlotOptions) {
        this.pyramidPlotOptions = pyramidPlotOptions;
        return pyramidPlotOptions != null && pyramidPlotOptions.getOptions() != null ? this.setOption("/plotOptions/pyramid", pyramidPlotOptions.getOptions()) : this.returnThis();
    }

    public T setSeriesPlotOptions(SeriesPlotOptions seriesPlotOptions) {
        this.seriesPlotOptions = seriesPlotOptions;
        return seriesPlotOptions != null && seriesPlotOptions.getOptions() != null ? this.setOption("/plotOptions/series", seriesPlotOptions.getOptions()) : this.returnThis();
    }

    public T setScatterPlotOptions(ScatterPlotOptions scatterPlotOptions) {
        this.scatterPlotOptions = scatterPlotOptions;
        return scatterPlotOptions != null && scatterPlotOptions.getOptions() != null ? this.setOption("/plotOptions/scatter", scatterPlotOptions.getOptions()) : this.returnThis();
    }

    public T setTreemapPlotOptions(TreemapPlotOptions treemapPlotOptions) {
        this.treemapPlotOptions = treemapPlotOptions;
        return treemapPlotOptions != null && treemapPlotOptions.getOptions() != null ? this.setOption("/plotOptions/treemap", treemapPlotOptions.getOptions()) : this.returnThis();
    }

    public T setWaterfallPlotOptions(WaterfallPlotOptions waterfallPlotOptions) {
        this.waterfallPlotOptions = waterfallPlotOptions;
        return waterfallPlotOptions != null && waterfallPlotOptions.getOptions() != null ? this.setOption("/plotOptions/waterfall", waterfallPlotOptions.getOptions()) : this.returnThis();
    }

    public T setClickEventHandler(ChartClickEventHandler chartClickEventHandler) {
        this.chartClickEventHandler = chartClickEventHandler;
        return this.returnThis();
    }

    public T setLoadEventHandler(ChartLoadEventHandler chartLoadEventHandler) {
        this.chartLoadEventHandler = chartLoadEventHandler;
        return this.returnThis();
    }

    public T setRedrawEventHandler(ChartRedrawEventHandler chartRedrawEventHandler) {
        this.chartRedrawEventHandler = chartRedrawEventHandler;
        return this.returnThis();
    }

    public T setSelectionEventHandler(ChartSelectionEventHandler chartSelectionEventHandler) {
        this.chartSelectionEventHandler = chartSelectionEventHandler;
        return this.returnThis();
    }

    public T setSolidGaugePlotOptions(SolidGaugePlotOptions solidGaugePlotOptions) {
        this.solidGaugePlotOptions = solidGaugePlotOptions;
        return this.solidGaugePlotOptions != null && solidGaugePlotOptions.getOptions() != null ? this.setOption("/plotOptions/solidgauge", solidGaugePlotOptions.getOptions()) : this.returnThis();
    }

    public T setSplinePlotOptions(SplinePlotOptions splinePlotOptions) {
        this.splinePlotOptions = splinePlotOptions;
        return this.setOption("/plotOptions/spline", splinePlotOptions.getOptions());
    }

    public T setZoomType(ZoomType zoomType) {
        return this.setOption("/chart/zoomType", zoomType != null ? zoomType.toString() : null);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public T setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this.returnThis();
    }

    public Series createSeries() {
        return new Series(this);
    }

    public T addSeries(Series series) {
        return this.addSeries(series, true, true);
    }

    public T addSeries(Series series, boolean redraw, boolean animation) {
        return this.addSeries(series, redraw, animation ? new Animation() : null);
    }

    public T addSeries(Series series, boolean redraw, Animation animation) {
        this.seriesList.add(series);
        if (this.isRendered()) {
            JavaScriptObject seriesOptions = this.convertSeriesToJSON(series).getJavaScriptObject();
            if (animation == null || animation.getOptions() == null) {
                boolean animationFlag = animation != null;
                BaseChart.nativeAddSeries(this.chart, seriesOptions, redraw, animationFlag);
            } else {
                JavaScriptObject animationOptions = animation.getOptions().getJavaScriptObject();
                BaseChart.nativeAddSeries(this.chart, seriesOptions, redraw, animationOptions);
            }
            series.setRendered(true);
            series.show();
            series.clearInternalPointsList();
        }
        return this.returnThis();
    }

    public Series getSeries(String seriesId) {
        for (Series series : this.seriesList) {
            if (!series.getId().equals(seriesId)) continue;
            return series;
        }
        return null;
    }

    public Series[] getSeries() {
        return this.seriesList.toArray(new Series[this.seriesList.size()]);
    }

    public boolean removeSeries(Series series) {
        return this.removeSeries(series, true);
    }

    public boolean removeSeries(Series series, boolean redraw) {
        JavaScriptObject nativeSeries;
        if (!this.seriesList.remove(series)) {
            return false;
        }
        if (this.isRendered() && (nativeSeries = BaseChart.nativeGet(this.chart, series.getId())) != null) {
            BaseChart.nativeRemoveSeries(this.chart, nativeSeries, redraw);
        }
        return true;
    }

    public T removeAllSeries() {
        this.removeAllSeries(true);
        return this.returnThis();
    }

    public T removeAllSeries(boolean redraw) {
        ArrayList<Series> clonedList = new ArrayList<Series>(this.seriesList);
        Iterator<Series> iterator = clonedList.iterator();
        while (iterator.hasNext()) {
            Series series = iterator.next();
            if (iterator.hasNext()) {
                this.removeSeries(series, false);
                continue;
            }
            this.removeSeries(series, redraw);
        }
        return this.returnThis();
    }

    public Series[] getSelectedSeries() {
        ArrayList<Series> selectedSeries = new ArrayList<Series>();
        if (this.isRendered()) {
            JsArrayString selectedSeriesIds = BaseChart.nativeGetSelectedSeriesIds(this.chart);
            int i = 0;
            while (i < selectedSeriesIds.length()) {
                String selectedSeriesId = selectedSeriesIds.get(i);
                for (Series series : this.seriesList) {
                    if (!series.getId().equals(selectedSeriesId)) continue;
                    selectedSeries.add(series);
                }
                ++i;
            }
        }
        return selectedSeries.toArray(new Series[selectedSeries.size()]);
    }

    public Point[] getSelectedPoints() {
        ArrayList<Point> selectedPoints = new ArrayList<Point>();
        if (this.isRendered()) {
            JsArray<JavaScriptObject> nativeSelectedPoints = BaseChart.nativeGetSelectedPoints(this.chart);
            int i = 0;
            while (i < nativeSelectedPoints.length()) {
                selectedPoints.add(new Point(nativeSelectedPoints.get(i)));
                ++i;
            }
        }
        return selectedPoints.toArray(new Point[selectedPoints.size()]);
    }

    public String getSVG() {
        if (this.isRendered()) {
            return BaseChart.nativeGetSVG(this.chart);
        }
        return null;
    }

    public T hideLoading() {
        if (this.isRendered()) {
            BaseChart.nativeHideLoading(this.chart);
        }
        return this.returnThis();
    }

    public T showLoading(String message) {
        if (this.isRendered()) {
            BaseChart.nativeShowLoading(this.chart, message);
        }
        return this.returnThis();
    }

    public T print() {
        if (this.isRendered()) {
            BaseChart.nativePrint(this.chart);
        }
        return this.returnThis();
    }

    public XAxis getXAxis() {
        return this.getXAxis(0);
    }

    public XAxis getXAxis(int axisIndex) {
        if (axisIndex < this.xAxes.size()) {
            return this.xAxes.get(axisIndex);
        }
        int i = this.xAxes.size();
        while (i <= axisIndex) {
            this.xAxes.add(new XAxis(this));
            ++i;
        }
        return this.xAxes.get(axisIndex);
    }

    public YAxis getYAxis() {
        return this.getYAxis(0);
    }

    public YAxis getYAxis(int axisIndex) {
        if (axisIndex < this.yAxes.size()) {
            return this.yAxes.get(axisIndex);
        }
        int i = this.yAxes.size();
        while (i <= axisIndex) {
            this.yAxes.add(new YAxis(this));
            ++i;
        }
        return this.yAxes.get(axisIndex);
    }

    public ZAxis getZAxis() {
        return this.getZAxis(0);
    }

    public ZAxis getZAxis(int axisIndex) {
        if (axisIndex < this.zAxes.size()) {
            return this.zAxes.get(axisIndex);
        }
        int i = this.zAxes.size();
        while (i <= axisIndex) {
            this.zAxes.add(new ZAxis(this));
            ++i;
        }
        return this.zAxes.get(axisIndex);
    }

    private Axis<?> getAxis(String axisId) {
        if (axisId == null) {
            return null;
        }
        for (XAxis xAxis : this.xAxes) {
            if (!axisId.equals(xAxis.getId())) continue;
            return xAxis;
        }
        for (YAxis yAxis : this.yAxes) {
            if (!axisId.equals(yAxis.getId())) continue;
            return yAxis;
        }
        for (ZAxis zAxis : this.zAxes) {
            if (!axisId.equals(zAxis.getId())) continue;
            return zAxis;
        }
        return null;
    }

    public JavaScriptObject getNativeChart() {
        return this.chart;
    }

    public T redraw() {
        if (this.isRendered()) {
            BaseChart.nativeRedraw(this.chart);
            BaseChart.nativeAdjustCheckboxPosition(this.chart);
        }
        return this.returnThis();
    }

    public T reflow() {
        if (this.isRendered()) {
            BaseChart.nativeChartReflow(this.chart);
        }
        return this.returnThis();
    }

    public boolean isRendered() {
        return this.chart != null;
    }

    protected void onLoad() {
        JSONArray xAxisLabelFormatters = new JSONArray();
        JSONArray xAxisEventHandlers = new JSONArray();
        int i = 0;
        int xAxesSize = this.xAxes.size();
        while (i < xAxesSize) {
            XAxis xAxis = this.xAxes.get(i);
            xAxisLabelFormatters.set(i, (JSONValue)JSONBoolean.getInstance((xAxis.getLabels() != null && xAxis.getLabels().getFormatter() != null ? 1 : 0) != 0));
            JSONObject axisEventHandlers = new JSONObject();
            axisEventHandlers.put("setExtremes", (JSONValue)JSONBoolean.getInstance((xAxis.getAxisSetExtremesEventHandler() != null ? 1 : 0) != 0));
            xAxisEventHandlers.set(i, (JSONValue)axisEventHandlers);
            ++i;
        }
        JSONArray yAxisLabelFormatters = new JSONArray();
        JSONArray yAxisStackLabelFormatters = new JSONArray();
        JSONArray yAxisEventHandlers = new JSONArray();
        int i2 = 0;
        int yAxesSize = this.yAxes.size();
        while (i2 < yAxesSize) {
            YAxis yAxis = this.yAxes.get(i2);
            yAxisLabelFormatters.set(i2, (JSONValue)JSONBoolean.getInstance((yAxis.getLabels() != null && yAxis.getLabels().getFormatter() != null ? 1 : 0) != 0));
            yAxisStackLabelFormatters.set(i2, (JSONValue)JSONBoolean.getInstance((yAxis.getStackLabels() != null && yAxis.getStackLabels().getFormatter() != null ? 1 : 0) != 0));
            JSONObject axisEventHandlers = new JSONObject();
            axisEventHandlers.put("setExtremes", (JSONValue)JSONBoolean.getInstance((yAxis.getAxisSetExtremesEventHandler() != null ? 1 : 0) != 0));
            yAxisEventHandlers.set(i2, (JSONValue)axisEventHandlers);
            ++i2;
        }
        JSONObject plotOptionsLabelFormatters = new JSONObject();
        plotOptionsLabelFormatters.put("area", (JSONValue)this.hasDataLabelsFormatter(this.areaPlotOptions));
        plotOptionsLabelFormatters.put("arearange", (JSONValue)this.hasDataLabelsFormatter(this.areaRangePlotOptions));
        plotOptionsLabelFormatters.put("areaspline", (JSONValue)this.hasDataLabelsFormatter(this.areaSplinePlotOptions));
        plotOptionsLabelFormatters.put("areasplinerange", (JSONValue)this.hasDataLabelsFormatter(this.areaSplineRangePlotOptions));
        plotOptionsLabelFormatters.put("bar", (JSONValue)this.hasDataLabelsFormatter(this.barPlotOptions));
        plotOptionsLabelFormatters.put("box", (JSONValue)this.hasDataLabelsFormatter(this.boxPlotOptions));
        plotOptionsLabelFormatters.put("bubble", (JSONValue)this.hasDataLabelsFormatter(this.bubblePlotOptions));
        plotOptionsLabelFormatters.put("candlestick", (JSONValue)this.hasDataLabelsFormatter(this.candlestickPlotOptions));
        plotOptionsLabelFormatters.put("column", (JSONValue)this.hasDataLabelsFormatter(this.columnPlotOptions));
        plotOptionsLabelFormatters.put("columnrange", (JSONValue)this.hasDataLabelsFormatter(this.columnRangePlotOptions));
        plotOptionsLabelFormatters.put("errorbar", (JSONValue)this.hasDataLabelsFormatter(this.errorBarPlotOptions));
        plotOptionsLabelFormatters.put("funnel", (JSONValue)this.hasDataLabelsFormatter(this.funnelPlotOptions));
        plotOptionsLabelFormatters.put("gauge", (JSONValue)this.hasDataLabelsFormatter(this.gaugePlotOptions));
        plotOptionsLabelFormatters.put("heatmap", (JSONValue)this.hasDataLabelsFormatter(this.heatmapPlotOptions));
        plotOptionsLabelFormatters.put("line", (JSONValue)this.hasDataLabelsFormatter(this.linePlotOptions));
        plotOptionsLabelFormatters.put("pie", (JSONValue)this.hasDataLabelsFormatter(this.piePlotOptions));
        plotOptionsLabelFormatters.put("pyramid", (JSONValue)this.hasDataLabelsFormatter(this.pyramidPlotOptions));
        plotOptionsLabelFormatters.put("ohlc", (JSONValue)this.hasDataLabelsFormatter(this.ohlcPlotOptions));
        plotOptionsLabelFormatters.put("series", (JSONValue)this.hasDataLabelsFormatter(this.seriesPlotOptions));
        plotOptionsLabelFormatters.put("scatter", (JSONValue)this.hasDataLabelsFormatter(this.scatterPlotOptions));
        plotOptionsLabelFormatters.put("solidgauge", (JSONValue)this.hasDataLabelsFormatter(this.solidGaugePlotOptions));
        plotOptionsLabelFormatters.put("spline", (JSONValue)this.hasDataLabelsFormatter(this.splinePlotOptions));
        plotOptionsLabelFormatters.put("treemap", (JSONValue)this.hasDataLabelsFormatter(this.treemapPlotOptions));
        plotOptionsLabelFormatters.put("waterfall", (JSONValue)this.hasDataLabelsFormatter(this.waterfallPlotOptions));
        JSONArray seriesLabelFormatters = new JSONArray();
        int i3 = 0;
        int seriesListSize = this.seriesList.size();
        while (i3 < seriesListSize) {
            Series series = this.seriesList.get(i3);
            seriesLabelFormatters.set(i3, (JSONValue)this.hasDataLabelsFormatter(series));
            ++i3;
        }
        JSONObject chartEventHandlers = new JSONObject();
        chartEventHandlers.put("click", (JSONValue)JSONBoolean.getInstance((this.chartClickEventHandler != null ? 1 : 0) != 0));
        chartEventHandlers.put("load", (JSONValue)JSONBoolean.getInstance((this.chartLoadEventHandler != null ? 1 : 0) != 0));
        chartEventHandlers.put("redraw", (JSONValue)JSONBoolean.getInstance((this.chartRedrawEventHandler != null ? 1 : 0) != 0));
        chartEventHandlers.put("selection", (JSONValue)JSONBoolean.getInstance((this.chartSelectionEventHandler != null ? 1 : 0) != 0));
        JSONObject seriesEventHandlers = new JSONObject();
        JSONObject pointEventHandlers = new JSONObject();
        if (this.seriesPlotOptions != null) {
            seriesEventHandlers.put("click", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getSeriesClickEventHandler() != null ? 1 : 0) != 0));
            seriesEventHandlers.put("checkboxClick", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getSeriesCheckboxClickEventHandler() != null ? 1 : 0) != 0));
            seriesEventHandlers.put("hide", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getSeriesHideEventHandler() != null ? 1 : 0) != 0));
            seriesEventHandlers.put("legendItemClick", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getSeriesLegendItemClickEventHandler() != null ? 1 : 0) != 0));
            seriesEventHandlers.put("mouseOver", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getSeriesMouseOverEventHandler() != null ? 1 : 0) != 0));
            seriesEventHandlers.put("mouseOut", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getSeriesMouseOutEventHandler() != null ? 1 : 0) != 0));
            seriesEventHandlers.put("show", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getSeriesShowEventHandler() != null ? 1 : 0) != 0));
            pointEventHandlers.put("click", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getPointClickEventHandler() != null ? 1 : 0) != 0));
            pointEventHandlers.put("mouseOver", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getPointMouseOverEventHandler() != null ? 1 : 0) != 0));
            pointEventHandlers.put("mouseOut", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getPointMouseOutEventHandler() != null ? 1 : 0) != 0));
            pointEventHandlers.put("remove", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getPointRemoveEventHandler() != null ? 1 : 0) != 0));
            pointEventHandlers.put("select", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getPointSelectEventHandler() != null ? 1 : 0) != 0));
            pointEventHandlers.put("unselect", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getPointUnselectEventHandler() != null ? 1 : 0) != 0));
            pointEventHandlers.put("update", (JSONValue)JSONBoolean.getInstance((this.seriesPlotOptions.getPointUpdateEventHandler() != null ? 1 : 0) != 0));
        }
        if (this.piePlotOptions != null) {
            pointEventHandlers.put("legendItemClick", (JSONValue)JSONBoolean.getInstance((this.piePlotOptions.getPointLegendItemClickEventHandler() != null ? 1 : 0) != 0));
        }
        this.chart = this.nativeRenderChart(this.getChartTypeName(), this.createNativeOptions(), this.toolTip != null && this.toolTip.getToolTipFormatter() != null, this.legend != null && this.legend.getLabelsFormatter() != null, chartEventHandlers.getJavaScriptObject(), seriesEventHandlers.getJavaScriptObject(), pointEventHandlers.getJavaScriptObject(), xAxisEventHandlers.getJavaScriptObject(), yAxisEventHandlers.getJavaScriptObject(), xAxisLabelFormatters.getJavaScriptObject(), yAxisLabelFormatters.getJavaScriptObject(), yAxisStackLabelFormatters.getJavaScriptObject(), plotOptionsLabelFormatters.getJavaScriptObject(), seriesLabelFormatters.getJavaScriptObject());
        for (Series series : this.seriesList) {
            series.clearInternalPointsList();
            series.setRendered(true);
        }
    }

    protected abstract String getChartTypeName();

    private JSONBoolean hasDataLabelsFormatter(PlotOptions plotOptions) {
        return JSONBoolean.getInstance((plotOptions != null && plotOptions.getDataLabels() != null && plotOptions.getDataLabels().getFormatter() != null ? 1 : 0) != 0);
    }

    private JSONBoolean hasDataLabelsFormatter(Series series) {
        return JSONBoolean.getInstance((series != null && series.getPlotOptions() != null && series.getPlotOptions().getDataLabels() != null && series.getPlotOptions().getDataLabels().getFormatter() != null ? 1 : 0) != 0);
    }

    protected void onUnload() {
        if (this.isRendered()) {
            BaseChart.nativeDestroy(this.chart);
            this.chart = null;
            for (Series series : this.seriesList) {
                series.setRendered(false);
            }
        }
    }

    private JavaScriptObject createNativeOptions() {
        JSONValue zAxisJSONValue;
        JSONValue yAxisJSONValue;
        JSONValue chartValue;
        JSONObject options = this.getOptions();
        if (options == null) {
            options = new JSONObject();
        }
        if ((chartValue = options.get("chart")) == null || chartValue.isObject() == null) {
            chartValue = new JSONObject();
            options.put("chart", chartValue);
        }
        JSONObject chartObject = (JSONObject)options.get("chart");
        chartObject.put("renderTo", (JSONValue)new JSONString(this.getElement().getId()));
        if (this.seriesList.size() > 0) {
            JSONValue seriesValue = options.get("series");
            if (seriesValue == null || seriesValue.isArray() == null) {
                options.put("series", (JSONValue)new JSONArray());
            }
            JSONArray seriesArray = (JSONArray)options.get("series");
            int i = 0;
            int seriesListSize = this.seriesList.size();
            while (i < seriesListSize) {
                Series series = this.seriesList.get(i);
                JSONObject seriesOptions = this.convertSeriesToJSON(series);
                seriesArray.set(i, (JSONValue)seriesOptions);
                ++i;
            }
        }
        this.getXAxis();
        this.getYAxis();
        JSONValue xAxisJSONValue = BaseChart.convertToJSONValue(this.xAxes.toArray(new Configurable[this.xAxes.size()]));
        if (xAxisJSONValue != null && xAxisJSONValue.isNull() == null) {
            options.put("xAxis", xAxisJSONValue);
        }
        if ((yAxisJSONValue = BaseChart.convertToJSONValue(this.yAxes.toArray(new Configurable[this.yAxes.size()]))) != null && yAxisJSONValue.isNull() == null) {
            options.put("yAxis", yAxisJSONValue);
        }
        if ((zAxisJSONValue = BaseChart.convertToJSONValue(this.zAxes.toArray(new Configurable[this.zAxes.size()]))) != null && zAxisJSONValue.isNull() == null) {
            options.put("zAxis", zAxisJSONValue);
        }
        return options.getJavaScriptObject();
    }

    protected JSONObject convertSeriesToJSON(Series series) {
        JSONValue dataValue;
        JSONObject seriesOptions = series.getOptions();
        if (seriesOptions == null) {
            seriesOptions = new JSONObject();
        }
        if ((dataValue = seriesOptions.get("data")) == null || dataValue.isArray() == null) {
            seriesOptions.put("data", (JSONValue)new JSONArray());
        }
        this.copyPointsToJSONArray(series.getPoints(), (JSONArray)seriesOptions.get("data"), series.getType());
        return seriesOptions;
    }

    private static JSONValue convertToJSONValue(Configurable ... configurables) {
        if (configurables.length > 1) {
            JSONArray jsonArray = new JSONArray();
            int i = 0;
            while (i < configurables.length) {
                jsonArray.set(i, (JSONValue)configurables[i].getOptions());
                ++i;
            }
            return jsonArray;
        }
        if (configurables.length == 1) {
            return configurables[0].getOptions();
        }
        return JSONNull.getInstance();
    }

    private void copyPointsToJSONArray(Point[] points, JSONArray jsonArray, Series.Type seriesType) {
        int i = 0;
        int pointsLength = points.length;
        while (i < pointsLength) {
            Point point = points[i];
            jsonArray.set(i, this.convertPointToJSON(point, seriesType));
            ++i;
        }
    }

    JSONValue convertPointToJSON(Point point, Series.Type seriesType) {
        if (seriesType == null) {
            seriesType = this.defaultSeriesType;
        }
        if (point == null) {
            return JSONNull.getInstance();
        }
        JSONObject options = point.getOptions();
        if (options != null) {
            BaseChart.addPointScalarValues(point, options, seriesType);
            return this.addPointId(point, options);
        }
        if (point.hasNativeProperties()) {
            options = new JSONObject();
            BaseChart.addPointScalarValues(point, options, seriesType);
            this.addPointId(point, options);
            return Point.addPointNativeProperties(point, options);
        }
        if (this.isPersistent()) {
            options = new JSONObject();
            BaseChart.addPointScalarValues(point, options, seriesType);
            return this.addPointId(point, options);
        }
        if (point.getValues().length == 1) {
            return BaseChart.convertNumberToJSONValue(point.getValues()[0]);
        }
        if (point.getValues().length > 1) {
            Number[] numbers = point.getValues();
            JSONArray jsonArray = new JSONArray();
            int i = 0;
            while (i < numbers.length) {
                jsonArray.set(i, BaseChart.convertNumberToJSONValue(numbers[i]));
                ++i;
            }
            return jsonArray;
        }
        throw new IllegalArgumentException("Unable to convert point to JSON due to an invalid type");
    }

    JSONValue addPointId(Point point, JSONObject options) {
        if (this.isPersistent()) {
            String id = point.getId(true);
            options.put("id", (JSONValue)new JSONString(id));
        }
        return options;
    }

    static JSONValue addPointScalarValues(Point point, JSONObject options, Series.Type seriesType) {
        switch (seriesType) {
            case BOXPLOT: {
                options.put("low", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                options.put("q1", BaseChart.convertNumberToJSONValue(point.getValues()[1]));
                options.put("median", BaseChart.convertNumberToJSONValue(point.getValues()[2]));
                options.put("q3", BaseChart.convertNumberToJSONValue(point.getValues()[3]));
                options.put("high", BaseChart.convertNumberToJSONValue(point.getValues()[4]));
                break;
            }
            case BUBBLE: {
                options.put("x", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                options.put("y", BaseChart.convertNumberToJSONValue(point.getValues()[1]));
                options.put("z", BaseChart.convertNumberToJSONValue(point.getValues()[2]));
                break;
            }
            case COLUMN_RANGE: 
            case ERRORBAR: {
                if (point.getValues().length > 2) {
                    options.put("x", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                    options.put("low", BaseChart.convertNumberToJSONValue(point.getValues()[1]));
                    options.put("high", BaseChart.convertNumberToJSONValue(point.getValues()[2]));
                    break;
                }
                options.put("low", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                options.put("high", BaseChart.convertNumberToJSONValue(point.getValues()[1]));
                break;
            }
            case HEATMAP: {
                options.put("x", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                options.put("y", BaseChart.convertNumberToJSONValue(point.getValues()[1]));
                options.put("value", BaseChart.convertNumberToJSONValue(point.getValues()[2]));
                break;
            }
            case OHLC: 
            case CANDLESTICK: {
                if (point.getValues().length == 4) {
                    options.put("open", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                    options.put("high", BaseChart.convertNumberToJSONValue(point.getValues()[1]));
                    options.put("low", BaseChart.convertNumberToJSONValue(point.getValues()[2]));
                    options.put("close", BaseChart.convertNumberToJSONValue(point.getValues()[3]));
                    break;
                }
                options.put("x", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                options.put("open", BaseChart.convertNumberToJSONValue(point.getValues()[1]));
                options.put("high", BaseChart.convertNumberToJSONValue(point.getValues()[2]));
                options.put("low", BaseChart.convertNumberToJSONValue(point.getValues()[3]));
                options.put("close", BaseChart.convertNumberToJSONValue(point.getValues()[4]));
                break;
            }
            case FLAGS: {
                options.put("x", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                break;
            }
            case TREEMAP: {
                if (point.getValues() == null || point.getValues().length <= 0) break;
                options.put("value", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                break;
            }
            default: {
                if (point.getValues().length == 1) {
                    options.put("y", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                } else {
                    options.put("x", BaseChart.convertNumberToJSONValue(point.getValues()[0]));
                    options.put("y", BaseChart.convertNumberToJSONValue(point.getValues()[1]));
                }
                if (point.getValues().length != 3) break;
                options.put("z", BaseChart.convertNumberToJSONValue(point.getValues()[2]));
            }
        }
        return options;
    }

    static JSONValue convertNumberToJSONValue(Number number) {
        if (number != null) {
            return new JSONNumber(number.doubleValue());
        }
        return JSONNull.getInstance();
    }

    JavaScriptObject get(String id) {
        if (this.isRendered()) {
            return BaseChart.nativeGet(this.chart, id);
        }
        return null;
    }

    private native JavaScriptObject nativeRenderChart(String var1, JavaScriptObject var2, boolean var3, boolean var4, JavaScriptObject var5, JavaScriptObject var6, JavaScriptObject var7, JavaScriptObject var8, JavaScriptObject var9, JavaScriptObject var10, JavaScriptObject var11, JavaScriptObject var12, JavaScriptObject var13, JavaScriptObject var14);

    private boolean chartEventCallback(JavaScriptObject nativeEvent, String eventType) {
        if ("click".equals(eventType) && this.chartClickEventHandler != null) {
            return this.chartClickEventHandler.onClick(new ChartClickEvent(nativeEvent));
        }
        if ("load".equals(eventType) && this.chartLoadEventHandler != null) {
            return this.chartLoadEventHandler.onLoad(new ChartLoadEvent(nativeEvent));
        }
        if ("redraw".equals(eventType) && this.chartRedrawEventHandler != null) {
            return this.chartRedrawEventHandler.onRedraw(new ChartRedrawEvent(nativeEvent));
        }
        if ("selection".equals(eventType) && this.chartSelectionEventHandler != null) {
            return this.chartSelectionEventHandler.onSelection(new ChartSelectionEvent(nativeEvent));
        }
        return true;
    }

    private boolean seriesEventCallback(JavaScriptObject nativeSeries, JavaScriptObject nativeEvent, String eventType) {
        if ("click".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getSeriesClickEventHandler() != null) {
            return this.seriesPlotOptions.getSeriesClickEventHandler().onClick(new SeriesClickEvent(nativeEvent, nativeSeries));
        }
        if ("checkboxClick".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getSeriesCheckboxClickEventHandler() != null) {
            return this.seriesPlotOptions.getSeriesCheckboxClickEventHandler().onClick(new SeriesCheckboxClickEvent(nativeEvent, nativeSeries));
        }
        if ("hide".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getSeriesHideEventHandler() != null) {
            return this.seriesPlotOptions.getSeriesHideEventHandler().onHide(new SeriesHideEvent(nativeEvent, nativeSeries));
        }
        if ("legendItemClick".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getSeriesLegendItemClickEventHandler() != null) {
            return this.seriesPlotOptions.getSeriesLegendItemClickEventHandler().onClick(new SeriesLegendItemClickEvent(nativeEvent, nativeSeries));
        }
        if ("mouseOver".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getSeriesMouseOverEventHandler() != null) {
            return this.seriesPlotOptions.getSeriesMouseOverEventHandler().onMouseOver(new SeriesMouseOverEvent(nativeEvent, nativeSeries));
        }
        if ("mouseOut".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getSeriesMouseOutEventHandler() != null) {
            return this.seriesPlotOptions.getSeriesMouseOutEventHandler().onMouseOut(new SeriesMouseOutEvent(nativeEvent, nativeSeries));
        }
        if ("show".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getSeriesShowEventHandler() != null) {
            return this.seriesPlotOptions.getSeriesShowEventHandler().onShow(new SeriesShowEvent(nativeEvent, nativeSeries));
        }
        return true;
    }

    private boolean pointEventCallback(JavaScriptObject nativePoint, JavaScriptObject nativeEvent, String eventType) {
        if ("click".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getPointClickEventHandler() != null) {
            return this.seriesPlotOptions.getPointClickEventHandler().onClick(new PointClickEvent(nativeEvent, nativePoint));
        }
        if ("mouseOver".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getPointMouseOverEventHandler() != null) {
            return this.seriesPlotOptions.getPointMouseOverEventHandler().onMouseOver(new PointMouseOverEvent(nativeEvent, nativePoint));
        }
        if ("mouseOut".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getPointMouseOutEventHandler() != null) {
            return this.seriesPlotOptions.getPointMouseOutEventHandler().onMouseOut(new PointMouseOutEvent(nativeEvent, nativePoint));
        }
        if ("remove".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getPointRemoveEventHandler() != null) {
            return this.seriesPlotOptions.getPointRemoveEventHandler().onRemove(new PointRemoveEvent(nativeEvent, nativePoint));
        }
        if ("select".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getPointSelectEventHandler() != null) {
            return this.seriesPlotOptions.getPointSelectEventHandler().onSelect(new PointSelectEvent(nativeEvent, nativePoint));
        }
        if ("unselect".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getPointUnselectEventHandler() != null) {
            return this.seriesPlotOptions.getPointUnselectEventHandler().onUnselect(new PointUnselectEvent(nativeEvent, nativePoint));
        }
        if ("update".equals(eventType) && this.seriesPlotOptions != null && this.seriesPlotOptions.getPointUpdateEventHandler() != null) {
            return this.seriesPlotOptions.getPointUpdateEventHandler().onUpdate(new PointUpdateEvent(nativeEvent, nativePoint));
        }
        if ("legendItemClick".equals(eventType) && this.piePlotOptions != null && this.piePlotOptions.getPointLegendItemClickEventHandler() != null) {
            return this.piePlotOptions.getPointLegendItemClickEventHandler().onClick(new PointLegendItemClickEvent(nativeEvent, nativePoint));
        }
        return true;
    }

    private boolean axisEventCallback(String axisId, JavaScriptObject nativeEvent, String eventType) {
        Axis<?> axis = this.getAxis(axisId);
        if ("setExtremes".equals(eventType) && axis != null && axis.getAxisSetExtremesEventHandler() != null) {
            return axis.getAxisSetExtremesEventHandler().onSetExtremes(new AxisSetExtremesEvent(nativeEvent, axis));
        }
        return true;
    }

    private String toolTipFormatterCallback(JavaScriptObject nativeData) {
        if (this.toolTip == null || this.toolTip.getToolTipFormatter() == null) {
            return null;
        }
        return this.toolTip.getToolTipFormatter().format(new ToolTipData(nativeData));
    }

    private String legendLabelsFormatterCallback(JavaScriptObject nativeData) {
        if (this.legend == null || this.legend.getLabelsFormatter() == null) {
            return null;
        }
        return this.legend.getLabelsFormatter().format(new LegendLabelsData(nativeData));
    }

    private String xAxisLabelFormatterCallback(JavaScriptObject nativeData, int axisIndex) {
        if (this.xAxes == null || this.xAxes.size() <= axisIndex || this.xAxes.get(axisIndex).getLabels() == null || this.xAxes.get(axisIndex).getLabels().getFormatter() == null) {
            return null;
        }
        return this.xAxes.get(axisIndex).getLabels().getFormatter().format(new AxisLabelsData(nativeData));
    }

    private String yAxisLabelFormatterCallback(JavaScriptObject nativeData, int axisIndex) {
        if (this.yAxes == null || this.yAxes.size() <= axisIndex || this.yAxes.get(axisIndex).getLabels() == null || this.yAxes.get(axisIndex).getLabels().getFormatter() == null) {
            return null;
        }
        return this.yAxes.get(axisIndex).getLabels().getFormatter().format(new AxisLabelsData(nativeData));
    }

    private String yAxisStackLabelFormatterCallback(JavaScriptObject nativeData, int axisIndex) {
        if (this.yAxes == null || this.yAxes.size() <= axisIndex || this.yAxes.get(axisIndex).getStackLabels() == null || this.yAxes.get(axisIndex).getStackLabels().getFormatter() == null) {
            return null;
        }
        return this.yAxes.get(axisIndex).getStackLabels().getFormatter().format(new StackLabelsData(nativeData));
    }

    private String plotOptionsLabelsFormatterCallback(JavaScriptObject nativeData, String type) {
        PlotOptions plotOptions = null;
        if ("area".equals(type)) {
            plotOptions = this.areaPlotOptions;
        }
        if ("arearange".equals(type)) {
            plotOptions = this.areaRangePlotOptions;
        }
        if ("areaspline".equals(type)) {
            plotOptions = this.areaSplinePlotOptions;
        }
        if ("areasplinerange".equals(type)) {
            plotOptions = this.areaSplineRangePlotOptions;
        }
        if ("bar".equals(type)) {
            plotOptions = this.barPlotOptions;
        }
        if ("box".equals(type)) {
            plotOptions = this.boxPlotOptions;
        }
        if ("bubble".equals(type)) {
            plotOptions = this.bubblePlotOptions;
        }
        if ("candlestick".equals(type)) {
            plotOptions = this.candlestickPlotOptions;
        }
        if ("column".equals(type)) {
            plotOptions = this.columnPlotOptions;
        }
        if ("columnrange".equals(type)) {
            plotOptions = this.columnRangePlotOptions;
        }
        if ("errorbar".equals(type)) {
            plotOptions = this.errorBarPlotOptions;
        }
        if ("funnel".equals(type)) {
            plotOptions = this.funnelPlotOptions;
        }
        if ("gauge".equals(type)) {
            plotOptions = this.gaugePlotOptions;
        }
        if ("heatmap".equals(type)) {
            plotOptions = this.heatmapPlotOptions;
        }
        if ("line".equals(type)) {
            plotOptions = this.linePlotOptions;
        }
        if ("ohlc".equals(type)) {
            plotOptions = this.ohlcPlotOptions;
        }
        if ("pie".equals(type)) {
            plotOptions = this.piePlotOptions;
        }
        if ("pyramid".equals(type)) {
            plotOptions = this.pyramidPlotOptions;
        }
        if ("scatter".equals(type)) {
            plotOptions = this.scatterPlotOptions;
        }
        if ("series".equals(type)) {
            plotOptions = this.seriesPlotOptions;
        }
        if ("solidgauge".equals(type)) {
            plotOptions = this.solidGaugePlotOptions;
        }
        if ("spline".equals(type)) {
            plotOptions = this.splinePlotOptions;
        }
        if ("treemap".equals(type)) {
            plotOptions = this.treemapPlotOptions;
        }
        if ("waterfall".equals(type)) {
            plotOptions = this.waterfallPlotOptions;
        }
        if (plotOptions == null || plotOptions.getDataLabels() == null || plotOptions.getDataLabels().getFormatter() == null) {
            return null;
        }
        return plotOptions.getDataLabels().getFormatter().format(new DataLabelsData(nativeData));
    }

    private String seriesLabelsFormatterCallback(JavaScriptObject nativeData, int seriesIndex) {
        if (this.seriesList == null || this.seriesList.size() <= seriesIndex || this.seriesList.get(seriesIndex).getPlotOptions() == null || this.seriesList.get(seriesIndex).getPlotOptions().getDataLabels() == null || this.seriesList.get(seriesIndex).getPlotOptions().getDataLabels().getFormatter() == null) {
            return null;
        }
        return this.seriesList.get(seriesIndex).getPlotOptions().getDataLabels().getFormatter().format(new DataLabelsData(nativeData));
    }

    private static native JavaScriptObject nativeAdjustCheckboxPosition(JavaScriptObject var0);

    private static native void nativeChartReflow(JavaScriptObject var0);

    private static native void nativeRedraw(JavaScriptObject var0);

    private static native void nativeDestroy(JavaScriptObject var0);

    private static native void nativeSetSize(JavaScriptObject var0, int var1, int var2, boolean var3);

    private static native void nativeSetSize(JavaScriptObject var0, int var1, int var2, JavaScriptObject var3);

    private static native JavaScriptObject nativeGet(JavaScriptObject var0, String var1);

    private static native void nativeAddSeries(JavaScriptObject var0, JavaScriptObject var1, boolean var2, boolean var3);

    private static native void nativeAddSeries(JavaScriptObject var0, JavaScriptObject var1, boolean var2, JavaScriptObject var3);

    private static native void nativeRemoveSeries(JavaScriptObject var0, JavaScriptObject var1, boolean var2);

    private static native void nativeHideLoading(JavaScriptObject var0);

    private static native void nativeShowLoading(JavaScriptObject var0, String var1);

    private static native void nativePrint(JavaScriptObject var0);

    private static native JsArrayString nativeGetSelectedSeriesIds(JavaScriptObject var0);

    private static native JsArray<JavaScriptObject> nativeGetSelectedPoints(JavaScriptObject var0);

    private static native String nativeGetSVG(JavaScriptObject var0);

    private static native void nativeSetTitle(JavaScriptObject var0, JavaScriptObject var1, JavaScriptObject var2);

    public native void showResetZoom();

    public native void hideResetZoom();

    public static enum PinchType {
        X("x"),
        Y("y"),
        X_AND_Y("xy");

        private final String optionValue;

        private PinchType(String optionValue) {
            this.optionValue = optionValue;
        }

        public String toString() {
            return this.optionValue;
        }
    }

    public static enum ZoomType {
        X("x"),
        Y("y"),
        X_AND_Y("xy");

        private final String optionValue;

        private ZoomType(String optionValue) {
            this.optionValue = optionValue;
        }

        public String toString() {
            return this.optionValue;
        }
    }
}

