/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.media.mp4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mp4parser.Container;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.UserBox;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.tools.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MP4MediaParser {
    public static final int REQUIRED_SIZE_IN_BYTES = 10000000;

    public static boolean determine360(IsoFile isof) throws ParserConfigurationException, SAXException, IOException {
        boolean spherical = false;
        UserBox uuidBox = (UserBox)Path.getPath((Container)isof, (String)"moov[0]/trak[0]/uuid");
        if (uuidBox != null) {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(uuidBox.getData()));
            NodeList childs = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node child = childs.item(i);
                if (child.getNodeName().toLowerCase().contains(":spherical")) {
                    spherical = true;
                }
                ++i;
            }
        }
        return spherical;
    }

    public static long determineDurationInMillis(IsoFile isof) {
        MovieHeaderBox mhb;
        long duration = -1L;
        MovieBox mbox = isof.getMovieBox();
        if (mbox != null && (mhb = mbox.getMovieHeaderBox()) != null) {
            duration = mhb.getDuration() * 1000L / mhb.getTimescale();
        }
        return duration;
    }

    public static Date determineRecordingStart(IsoFile isof) {
        MovieHeaderBox mhb;
        Date creationTime = null;
        MovieBox mbox = isof.getMovieBox();
        if (mbox != null && (mhb = mbox.getMovieHeaderBox()) != null) {
            creationTime = mhb.getCreationTime();
        }
        return creationTime;
    }
}

