/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasLeaderboardContext;
import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.shared.tracking.LineDetails;
import com.sap.sailing.domain.shared.tracking.Track;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.geocoding.ReverseGeocoder;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.json.simple.parser.ParseException;

public class TrackedRaceWithContext
implements HasTrackedRaceContext {
    private static final Logger logger = Logger.getLogger(TrackedRaceWithContext.class.getName());
    private final HasLeaderboardContext leaderboardContext;
    private final Regatta regatta;
    private final RaceColumn raceColumn;
    private final Fleet fleet;
    private final TrackedRace trackedRace;
    private Integer year;
    private boolean yearHasBeenInitialized;
    private volatile String cachedDayAsISO;

    public TrackedRaceWithContext(HasLeaderboardContext leaderboardContext, Regatta regatta, RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.leaderboardContext = leaderboardContext;
        this.regatta = regatta;
        this.raceColumn = raceColumn;
        this.fleet = fleet;
        this.trackedRace = trackedRace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fleet == null ? 0 : this.fleet.hashCode());
        result = 31 * result + (this.raceColumn == null ? 0 : this.raceColumn.hashCode());
        result = 31 * result + (this.regatta == null ? 0 : this.regatta.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrackedRaceWithContext other = (TrackedRaceWithContext)obj;
        if (this.fleet == null ? other.fleet != null : !this.fleet.equals(other.fleet)) {
            return false;
        }
        if (this.raceColumn == null ? other.raceColumn != null : !this.raceColumn.equals(other.raceColumn)) {
            return false;
        }
        return !(this.regatta == null ? other.regatta != null : !this.regatta.equals(other.regatta));
    }

    @Override
    public HasLeaderboardContext getLeaderboardContext() {
        return this.leaderboardContext;
    }

    @Override
    public Regatta getRegatta() {
        return this.regatta;
    }

    @Override
    public CourseArea getCourseArea() {
        CourseArea result;
        if (this.getRegatta() != null) {
            Fleet fleetOfTrackedRace = this.raceColumn.getFleetOfTrackedRace(this.trackedRace);
            if (fleetOfTrackedRace != null) {
                RaceLog raceLog = this.getRegatta().getRacelog(this.raceColumn.getName(), fleetOfTrackedRace.getName());
                if (raceLog != null) {
                    ReadonlyRaceState raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.getTrackedRace().getRaceLogResolver(), (RaceLog)raceLog);
                    DomainFactory baseDomainFactory = this.getLeaderboardContext().getLeaderboardGroupContext().getBaseDomainFactory();
                    result = baseDomainFactory.getExistingCourseAreaById((Serializable)raceState.getCourseAreaId());
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public TrackedRace getTrackedRace() {
        return this.trackedRace;
    }

    @Override
    public RaceColumn getRaceColumn() {
        return this.raceColumn;
    }

    @Override
    public Fleet getFleet() {
        return this.fleet;
    }

    @Override
    public RaceDefinition getRace() {
        RaceDefinition result = this.getTrackedRace() != null ? this.getTrackedRace().getRace() : null;
        return result;
    }

    @Override
    public Integer getYear() {
        if (!this.yearHasBeenInitialized) {
            this.year = this.calculateYear();
            this.yearHasBeenInitialized = true;
        }
        return this.year;
    }

    private Integer calculateYear() {
        Integer result;
        if (this.getTrackedRace() != null) {
            TimePoint time;
            TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
            TimePoint timePoint = time = startOfRace != null ? startOfRace : this.getTrackedRace().getStartOfTracking();
            if (time == null) {
                result = 0;
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time.asDate());
                result = calendar.get(1);
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public NauticalSide getAdvantageousEndOfLine() {
        NauticalSide result;
        if (this.getTrackedRace() != null) {
            LineDetails startLine = this.getTrackedRace().getStartLine(this.getTrackedRace().getStartOfRace());
            result = startLine.getAdvantageousSideWhileApproachingLine();
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Boolean isMedalRace() {
        Boolean result = this.getTrackedRace() != null ? Boolean.valueOf(((RaceColumn)this.getLeaderboardContext().getLeaderboard().getRaceColumnAndFleet(this.getTrackedRace()).getA()).isMedalRace()) : null;
        return result;
    }

    @Override
    public Boolean isTracked() {
        Boolean result = this.getTrackedRace() != null ? Boolean.valueOf(this.getTrackedRace().hasStarted(MillisecondsTimePoint.now())) : null;
        return result;
    }

    @Override
    public Duration getDuration() {
        MillisecondsDurationImpl duration;
        if (this.getTrackedRace() != null) {
            TrackedRace race = this.getTrackedRace();
            TimePoint start = race.getStartOfRace();
            if (start == null) {
                start = race.getStartOfTracking();
            }
            if (start != null) {
                TimePoint end = race.getEndOfRace();
                if (end == null) {
                    end = race.getEndOfTracking();
                }
                duration = end != null ? new MillisecondsDurationImpl(end.asMillis() - start.asMillis()) : null;
            } else {
                duration = null;
            }
        } else {
            duration = null;
        }
        return duration;
    }

    private <T> int getNumberOfRawFixes(Iterable<T> tracksFor, BiFunction<T, TrackedRace, Track<?>> trackProvider) {
        int result;
        if (this.getTrackedRace() != null) {
            int number = 0;
            for (T trackedObject : tracksFor) {
                Track<?> track = trackProvider.apply(trackedObject, this.getTrackedRace());
                track.lockForRead();
                try {
                    number += Util.size((Iterable)track.getRawFixes());
                }
                finally {
                    track.unlockAfterRead();
                }
            }
            result = number;
        } else {
            result = 0;
        }
        return result;
    }

    @Override
    public int getNumberOfCompetitorFixes() {
        int result = this.getTrackedRace() != null ? this.getNumberOfRawFixes(this.getRace().getCompetitors(), (competitor, trackedRace) -> trackedRace.getTrack(competitor)) : 0;
        return result;
    }

    @Override
    public int getNumberOfMarkFixes() {
        int result = this.getTrackedRace() == null ? 0 : this.getNumberOfRawFixes(this.getTrackedRace().getMarks(), (mark, trackedRace) -> trackedRace.getTrack(mark));
        return result;
    }

    @Override
    public int getNumberOfWindFixes() {
        int result;
        if (this.getTrackedRace() != null) {
            Set windSources = this.getTrackedRace().getWindSources();
            Set windSourcesToExclude = this.getTrackedRace().getWindSourcesToExclude();
            Iterable windSourcesToUse = StreamSupport.stream(windSources.spliterator(), false).filter(ws -> !Util.contains((Iterable)windSourcesToExclude, (Object)ws)).filter(ws -> ws.getType() != WindSourceType.TRACK_BASED_ESTIMATION && ws.getType() != WindSourceType.MANEUVER_BASED_ESTIMATION).collect(Collectors.toList());
            result = this.getNumberOfRawFixes(windSourcesToUse, (windSource, trackedRace) -> trackedRace.getOrCreateWindTrack(windSource));
        } else {
            result = 0;
        }
        return result;
    }

    @Override
    public Double getRelativeScoreForCompetitor(Competitor competitor) {
        TimePoint now = MillisecondsTimePoint.now();
        Double maxTotalPoints = 1.0;
        Double totalPointsOfCompetitor = null;
        for (Competitor c : this.getLeaderboardContext().getLeaderboard().getCompetitors()) {
            Double totalPoints = this.getLeaderboardContext().getLeaderboard().getTotalPoints(c, this.getRaceColumn(), now);
            if (totalPoints == null) continue;
            maxTotalPoints = Math.max(maxTotalPoints, totalPoints);
            if (c != competitor) continue;
            totalPointsOfCompetitor = totalPoints;
        }
        return totalPointsOfCompetitor == null ? null : Double.valueOf(totalPointsOfCompetitor / maxTotalPoints);
    }

    @Override
    public Integer getRankAtFinishForCompetitor(Competitor competitor) {
        int rank;
        Integer result = this.getTrackedRace() != null ? ((rank = this.getTrackedRace().getRank(competitor, this.getTrackedRace().getEndOfTracking())) == 0 ? null : Integer.valueOf(rank)) : null;
        return result;
    }

    @Override
    public Distance getAdvantageOfStarboardSideOfStartline() {
        Distance result;
        if (this.getTrackedRace() != null) {
            if (this.getTrackedRace().getStartOfRace() != null) {
                LineDetails startLine = this.getTrackedRace().getStartLine(this.getTrackedRace().getStartOfRace());
                if (startLine == null) {
                    result = null;
                } else {
                    Distance absoluteAdvantage = startLine.getAdvantage();
                    result = startLine.getAdvantageousSideWhileApproachingLine() == NauticalSide.STARBOARD ? absoluteAdvantage : absoluteAdvantage.scale(-1.0);
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Bearing getTrueWindAngleOfStartLineFromStarboardSide() {
        Bearing angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind;
        LineDetails startLine;
        Bearing result = this.getTrackedRace() != null ? (this.getTrackedRace().getStartOfRace() != null ? ((startLine = this.getTrackedRace().getStartLine(this.getTrackedRace().getStartOfRace())) == null ? null : ((angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind = startLine.getAngleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind()) == null ? null : new DegreeBearingImpl(-180.0).add(angleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind))) : null) : null;
        return result;
    }

    @Override
    public Distance getStartLineLength() {
        LineDetails startLine;
        Distance result = this.getTrackedRace() != null ? (this.getTrackedRace().getStartOfRace() != null ? ((startLine = this.getTrackedRace().getStartLine(this.getTrackedRace().getStartOfRace())) == null ? null : startLine.getLength()) : null) : null;
        return result;
    }

    @Override
    public Distance getFinishLineLength() {
        LineDetails finishLine;
        Distance result = this.getTrackedRace() == null ? null : (this.getTrackedRace().getFinishedTime() != null ? ((finishLine = this.getTrackedRace().getFinishLine(this.getTrackedRace().getFinishedTime())) == null ? null : finishLine.getLength()) : null);
        return result;
    }

    @Override
    public Double getStartLineBiasInMetersAtStartOfRace() {
        return this.getStartLineBiasInMetersAtTimePoint(this.getTrackedRace().getStartOfRace());
    }

    @Override
    public Double getStartLineBiasInMeters30SecondsAfterRaceStart() {
        return this.getStartLineBiasInMetersAtTimePoint(this.getTrackedRace().getStartOfRace().plus(TimeUnit.SECONDS.toMillis(30L)));
    }

    private Double getStartLineBiasInMetersAtTimePoint(TimePoint timePoint) {
        LineDetails startLine = this.getTrackedRace().getStartLine(timePoint);
        switch (startLine.getAdvantageousSideWhileApproachingLine()) {
            case PORT: {
                return startLine.getAdvantage().getMeters() * -1.0;
            }
            case STARBOARD: {
                return startLine.getAdvantage().getMeters();
            }
        }
        return null;
    }

    @Override
    public String getDayAsISO() {
        if (this.cachedDayAsISO == null) {
            Position courseCenter;
            TimePoint timePoint;
            TimePoint timePoint2 = timePoint = this.getTrackedRace().getStartOfRace() != null ? this.getTrackedRace().getStartOfRace() : this.getTrackedRace().getStartOfTracking();
            if (timePoint != null && (courseCenter = this.getTrackedRace().getCenterOfCourse(timePoint)) != null) {
                try {
                    TimeZone timeZone = ReverseGeocoder.INSTANCE.getTimeZone(courseCenter, timePoint);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    df.setTimeZone(timeZone);
                    this.cachedDayAsISO = df.format(timePoint.asDate());
                }
                catch (IOException | ParseException e) {
                    logger.warning("Error trying to obtain time zone for race " + this.getTrackedRace() + ": " + e.getMessage());
                }
            }
        }
        return this.cachedDayAsISO;
    }

    @Override
    public LegType getTypeOfFirstLeg() throws NoWindException {
        TrackedLeg firstTrackedLeg;
        Course course;
        List legs;
        TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
        LegType result = startOfRace == null ? null : ((legs = (course = this.getTrackedRace().getRace().getCourse()).getLegs()).isEmpty() ? null : ((firstTrackedLeg = this.getTrackedRace().getTrackedLeg((Leg)legs.get(0))) == null ? null : firstTrackedLeg.getLegType(startOfRace)));
        return result;
    }
}

