/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasManeuverContext;
import com.sap.sailing.datamining.data.HasManeuverSpeedDetailsContext;
import com.sap.sailing.datamining.data.ManeuverSpeedDetailsStatistic;
import com.sap.sailing.datamining.impl.components.ManeuverSpeedDetailsUtils;
import com.sap.sailing.datamining.impl.data.ManeuverSpeedDetailsStatisticImpl;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsSettings;
import com.sap.sailing.domain.common.NauticalSide;
import java.util.function.Function;

public class ManeuverSpeedDetailsWithContext
implements HasManeuverSpeedDetailsContext {
    private final HasManeuverContext maneuverContext;
    private final double[] maneuverSpeedPerTWA;
    private int maneuverEnteringTWA;
    private final ManeuverSpeedDetailsSettings settings;

    public ManeuverSpeedDetailsWithContext(HasManeuverContext maneuverContext, double[] maneuverSpeedPerTWA, int enteringTWA, ManeuverSpeedDetailsSettings settings) {
        this.maneuverContext = maneuverContext;
        this.maneuverSpeedPerTWA = maneuverSpeedPerTWA;
        this.maneuverEnteringTWA = enteringTWA;
        this.settings = settings;
    }

    @Override
    public HasManeuverContext getManeuverContext() {
        return this.maneuverContext;
    }

    @Override
    public NauticalSide getToSide() {
        return this.maneuverContext.getManeuver().getToSide();
    }

    @Override
    public ManeuverSpeedDetailsStatistic getSpeedSlopeStatistic() {
        double[] speedSlopePerTWA = new double[360];
        double lastSpeedValue = 0.0;
        Function<Integer, Integer> twaIterationFunction = ManeuverSpeedDetailsUtils.getTWAIterationFunctionForManeuverDirection(this.getToSide());
        int twa = this.maneuverEnteringTWA;
        int i = 0;
        while (i < 360) {
            speedSlopePerTWA[twa] = this.maneuverSpeedPerTWA[twa] == 0.0 || lastSpeedValue == 0.0 ? 0.0 : this.maneuverSpeedPerTWA[twa] - lastSpeedValue;
            lastSpeedValue = this.maneuverSpeedPerTWA[twa];
            ++i;
            twa = twaIterationFunction.apply(twa);
        }
        return new ManeuverSpeedDetailsStatisticImpl(speedSlopePerTWA, this.getToSide(), this.settings);
    }

    @Override
    public ManeuverSpeedDetailsStatistic getRatioToEnteringSpeedStatistic() {
        double[] speedRatioToBeginningSpeedPerTWA = new double[360];
        double firstSpeedValue = this.maneuverContext.getManeuverEnteringSpeed();
        Function<Integer, Integer> twaIterationFunction = ManeuverSpeedDetailsUtils.getTWAIterationFunctionForManeuverDirection(this.getToSide());
        int twa = this.maneuverEnteringTWA;
        int i = 0;
        while (i < 360) {
            if (firstSpeedValue == 0.0) {
                firstSpeedValue = this.maneuverSpeedPerTWA[twa];
            }
            speedRatioToBeginningSpeedPerTWA[twa] = this.maneuverSpeedPerTWA[twa] == 0.0 || firstSpeedValue == 0.0 ? 0.0 : this.maneuverSpeedPerTWA[twa] / firstSpeedValue;
            ++i;
            twa = twaIterationFunction.apply(twa);
        }
        return new ManeuverSpeedDetailsStatisticImpl(speedRatioToBeginningSpeedPerTWA, this.getToSide(), this.settings);
    }

    @Override
    public ManeuverSpeedDetailsStatistic getRatioToPreviousTWASpeedStatistic() {
        double[] speedRatioToPreviousSpeedPerTWA = new double[360];
        double lastSpeedValue = 0.0;
        Function<Integer, Integer> twaIterationFunction = ManeuverSpeedDetailsUtils.getTWAIterationFunctionForManeuverDirection(this.getToSide());
        int twa = this.maneuverEnteringTWA;
        int i = 0;
        while (i < 360) {
            speedRatioToPreviousSpeedPerTWA[twa] = this.maneuverSpeedPerTWA[twa] == 0.0 || lastSpeedValue == 0.0 ? 0.0 : this.maneuverSpeedPerTWA[twa] / lastSpeedValue;
            lastSpeedValue = this.maneuverSpeedPerTWA[twa];
            ++i;
            twa = twaIterationFunction.apply(twa);
        }
        return new ManeuverSpeedDetailsStatisticImpl(speedRatioToPreviousSpeedPerTWA, this.getToSide(), this.settings);
    }

    @Override
    public Double getLowestRatioToEnteringSpeedStatistic() {
        double[] speedRatioPerTWA = this.getRatioToEnteringSpeedStatistic().getManeuverValuePerTWA();
        double lowestSpeedRatio = 1.0;
        double[] dArray = speedRatioPerTWA;
        int n = speedRatioPerTWA.length;
        int n2 = 0;
        while (n2 < n) {
            double speedRatio = dArray[n2];
            if (speedRatio != 0.0 && speedRatio < lowestSpeedRatio) {
                lowestSpeedRatio = speedRatio;
            }
            ++n2;
        }
        return lowestSpeedRatio;
    }

    @Override
    public Double getHighestRatioToEnteringSpeedStatistic() {
        double[] speedRatioPerTWA = this.getRatioToEnteringSpeedStatistic().getManeuverValuePerTWA();
        double highestSpeedRatio = 1.0;
        double[] dArray = speedRatioPerTWA;
        int n = speedRatioPerTWA.length;
        int n2 = 0;
        while (n2 < n) {
            double speedRatio = dArray[n2];
            if (speedRatio != 0.0 && speedRatio > highestSpeedRatio) {
                highestSpeedRatio = speedRatio;
            }
            ++n2;
        }
        return highestSpeedRatio;
    }

    @Override
    public Double getHighestRatioToEnteringSpeedMinusLowestStatistic() {
        double[] speedRatioPerTWA = this.getRatioToEnteringSpeedStatistic().getManeuverValuePerTWA();
        double highestSpeedRatio = 1.0;
        double lowestSpeedRatio = 1.0;
        double[] dArray = speedRatioPerTWA;
        int n = speedRatioPerTWA.length;
        int n2 = 0;
        while (n2 < n) {
            double speedRatio = dArray[n2];
            if (speedRatio != 0.0) {
                if (speedRatio > highestSpeedRatio) {
                    highestSpeedRatio = speedRatio;
                }
                if (speedRatio < lowestSpeedRatio) {
                    lowestSpeedRatio = speedRatio;
                }
            }
            ++n2;
        }
        return highestSpeedRatio - lowestSpeedRatio;
    }

    @Override
    public Double getAbsTwaAtLowestRatioToEnteringSpeedStatistic() {
        double[] speedRatioPerTWA = this.getRatioToEnteringSpeedStatistic().getManeuverValuePerTWA();
        double lowestSpeedRatio = 1.0;
        double twaAtLowestSpeedRatio = -1.0;
        int encodedTwa = 0;
        while (encodedTwa < 360) {
            double speedRatio = speedRatioPerTWA[encodedTwa];
            if (speedRatio != 0.0 && speedRatio < lowestSpeedRatio) {
                lowestSpeedRatio = speedRatio;
                twaAtLowestSpeedRatio = encodedTwa;
            }
            ++encodedTwa;
        }
        if (twaAtLowestSpeedRatio == -1.0) {
            return null;
        }
        if (twaAtLowestSpeedRatio > 180.0) {
            twaAtLowestSpeedRatio = 360.0 - twaAtLowestSpeedRatio;
        }
        return twaAtLowestSpeedRatio;
    }

    @Override
    public Double getAbsTwaAtHighestRatioToEnteringSpeedStatistic() {
        double[] speedRatioPerTWA = this.getRatioToEnteringSpeedStatistic().getManeuverValuePerTWA();
        double highestSpeedRatio = 1.0;
        double twaAtHighestSpeedRatio = -1.0;
        int encodedTwa = 0;
        while (encodedTwa < 360) {
            double speedRatio = speedRatioPerTWA[encodedTwa];
            if (speedRatio != 0.0 && speedRatio > highestSpeedRatio) {
                highestSpeedRatio = speedRatio;
                twaAtHighestSpeedRatio = encodedTwa;
            }
            ++encodedTwa;
        }
        if (twaAtHighestSpeedRatio == -1.0) {
            return null;
        }
        if (twaAtHighestSpeedRatio > 180.0) {
            twaAtHighestSpeedRatio = 360.0 - twaAtHighestSpeedRatio;
        }
        return twaAtHighestSpeedRatio;
    }
}

