/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasCompleteManeuverCurveWithEstimationDataContext;
import com.sap.sailing.datamining.data.HasRaceOfCompetitorContext;
import com.sap.sailing.datamining.shared.ManeuverSettings;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.maneuverdetection.CompleteManeuverCurveWithEstimationData;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.datamining.shared.impl.dto.ClusterDTO;

public class CompleteManeuverCurveWithEstimationDataWithContext
implements HasCompleteManeuverCurveWithEstimationDataContext {
    private final CompleteManeuverCurveWithEstimationData maneuverWithEstimationData;
    private final HasRaceOfCompetitorContext raceOfCompetitorContext;
    private final ManeuverSettings maneuverSettings;
    private final CompleteManeuverCurveWithEstimationData previousManeuverCurve;
    private final CompleteManeuverCurveWithEstimationData nextManeuverCurve;

    public CompleteManeuverCurveWithEstimationDataWithContext(HasRaceOfCompetitorContext raceOfCompetitorContext, CompleteManeuverCurveWithEstimationData maneuverWithEstimationData, ManeuverSettings maneuverSettings, CompleteManeuverCurveWithEstimationData previousManeuverCurve, CompleteManeuverCurveWithEstimationData nextManeuverCurve) {
        this.raceOfCompetitorContext = raceOfCompetitorContext;
        this.maneuverWithEstimationData = maneuverWithEstimationData;
        this.maneuverSettings = maneuverSettings;
        this.previousManeuverCurve = previousManeuverCurve;
        this.nextManeuverCurve = nextManeuverCurve;
    }

    @Override
    public HasRaceOfCompetitorContext getRaceOfCompetitorContext() {
        return this.raceOfCompetitorContext;
    }

    @Override
    public Double getManeuverStartSpeedDeviationRatioFromAvgStatistic() {
        SpeedWithBearing speedWithBearingBeforeManeuver = this.getManeuverCurveBoundariesForAnalysis().getSpeedWithBearingBefore();
        SpeedWithBearing averageSpeedWithBearingBeforeManeuver = this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getAverageSpeedWithBearingBefore();
        if (speedWithBearingBeforeManeuver != null && averageSpeedWithBearingBeforeManeuver != null) {
            if (speedWithBearingBeforeManeuver.getKnots() < averageSpeedWithBearingBeforeManeuver.getKnots()) {
                return averageSpeedWithBearingBeforeManeuver.getKnots() / speedWithBearingBeforeManeuver.getKnots();
            }
            return speedWithBearingBeforeManeuver.getKnots() / averageSpeedWithBearingBeforeManeuver.getKnots();
        }
        return null;
    }

    @Override
    public Double getManeuverStartCogDeviationFromAvgInDegreesStatistic() {
        SpeedWithBearing speedWithBearingBeforeManeuver = this.getManeuverCurveBoundariesForAnalysis().getSpeedWithBearingBefore();
        SpeedWithBearing averageSpeedWithBearingBeforeManeuver = this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getAverageSpeedWithBearingBefore();
        if (speedWithBearingBeforeManeuver != null && averageSpeedWithBearingBeforeManeuver != null) {
            return Math.abs(averageSpeedWithBearingBeforeManeuver.getBearing().getDifferenceTo(speedWithBearingBeforeManeuver.getBearing()).getDegrees());
        }
        return null;
    }

    @Override
    public Double getManeuverEndSpeedDeviationRatioFromAvgStatistic() {
        SpeedWithBearing speedWithBearingAfterManeuver = this.getManeuverCurveBoundariesForAnalysis().getSpeedWithBearingAfter();
        SpeedWithBearing averageSpeedWithBearingAfterManeuver = this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getAverageSpeedWithBearingAfter();
        if (speedWithBearingAfterManeuver != null && averageSpeedWithBearingAfterManeuver != null) {
            if (speedWithBearingAfterManeuver.getKnots() < averageSpeedWithBearingAfterManeuver.getKnots()) {
                return averageSpeedWithBearingAfterManeuver.getKnots() / speedWithBearingAfterManeuver.getKnots();
            }
            return speedWithBearingAfterManeuver.getKnots() / averageSpeedWithBearingAfterManeuver.getKnots();
        }
        return null;
    }

    @Override
    public Double getManeuverEndCogDeviationFromAvgInDegreesStatistic() {
        SpeedWithBearing speedWithBearingAfterManeuver = this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getSpeedWithBearingAfter();
        SpeedWithBearing averageSpeedWithBearingAfterManeuver = this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getAverageSpeedWithBearingAfter();
        if (speedWithBearingAfterManeuver != null && averageSpeedWithBearingAfterManeuver != null) {
            return Math.abs(averageSpeedWithBearingAfterManeuver.getBearing().getDifferenceTo(speedWithBearingAfterManeuver.getBearing()).getDegrees());
        }
        return null;
    }

    @Override
    public Double getDurationToNextManeuverInSecondsStatistic() {
        Duration duration = this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getDurationFromManeuverEndToNextManeuverStart();
        if (duration != null) {
            return duration.asSeconds();
        }
        return null;
    }

    @Override
    public Double getDurationFromPreviousManeuverInSecondsStatistic() {
        Duration duration = this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getDurationFromPreviousManeuverEndToManeuverStart();
        if (duration != null) {
            return duration.asSeconds();
        }
        return null;
    }

    @Override
    public boolean isNextManeuverAtLeastOneSecondInFront() {
        return this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getDurationFromManeuverEndToNextManeuverStart() != null && this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getDurationFromManeuverEndToNextManeuverStart().asSeconds() >= 1.0;
    }

    @Override
    public boolean isPreviousManeuverAtLeastOneSecondBehind() {
        return this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getDurationFromPreviousManeuverEndToManeuverStart() != null && this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getDurationFromPreviousManeuverEndToManeuverStart().asSeconds() >= 1.0;
    }

    @Override
    public CompleteManeuverCurveWithEstimationData getCompleteManeuverCurveWithEstimationData() {
        return this.maneuverWithEstimationData;
    }

    @Override
    public ClusterDTO getJibingCount() {
        return new ClusterDTO(String.valueOf(this.maneuverWithEstimationData.getJibingCount()));
    }

    @Override
    public ClusterDTO getTackingCount() {
        return new ClusterDTO(String.valueOf(this.maneuverWithEstimationData.getTackingCount()));
    }

    @Override
    public double getAbsTwaAtMaxTurningRate() {
        return this.getAbsTwaFromCourse(this.maneuverWithEstimationData.getMainCurve().getCourseAtMaxTurningRate());
    }

    @Override
    public double getAbsTwaAtLowestSpeed() {
        return this.getAbsTwaFromCourse(this.maneuverWithEstimationData.getMainCurve().getLowestSpeed().getBearing());
    }

    @Override
    public double getAbsTwaAtHighestSpeed() {
        return this.getAbsTwaFromCourse(this.maneuverWithEstimationData.getMainCurve().getHighestSpeed().getBearing());
    }

    private double getAbsTwaFromCourse(Bearing course) {
        double twa = this.maneuverWithEstimationData.getWind().getFrom().getDifferenceTo(course).getDegrees();
        return Math.abs(twa);
    }

    @Override
    public NauticalSide getToSide() {
        return this.maneuverWithEstimationData.getMainCurve().getDirectionChangeInDegrees() < 0.0 ? NauticalSide.PORT : NauticalSide.STARBOARD;
    }

    private ManeuverCurveBoundaries getManeuverCurveBoundariesForAnalysis() {
        return this.maneuverSettings.isMainCurveAnalysis() ? this.maneuverWithEstimationData.getMainCurve() : this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed();
    }

    @Override
    public Double getEnteringAbsTWA() {
        return this.getAbsTwaFromCourse(this.getManeuverCurveBoundariesForAnalysis().getSpeedWithBearingBefore().getBearing());
    }

    @Override
    public Double getExitingAbsTWA() {
        return this.getAbsTwaFromCourse(this.getManeuverCurveBoundariesForAnalysis().getSpeedWithBearingAfter().getBearing());
    }

    @Override
    public ManeuverType getTypeOfPreviousManeuver() {
        return this.previousManeuverCurve == null ? ManeuverType.UNKNOWN : this.previousManeuverCurve.getManeuverTypeForCompleteManeuverCurve();
    }

    @Override
    public ManeuverType getTypeOfNextManeuver() {
        return this.nextManeuverCurve == null ? ManeuverType.UNKNOWN : this.nextManeuverCurve.getManeuverTypeForCompleteManeuverCurve();
    }

    @Override
    public Double getAbsoluteDirectionChangeInDegrees() {
        return Math.abs(this.getManeuverCurveBoundariesForAnalysis().getDirectionChangeInDegrees());
    }

    @Override
    public Double getRelativeBearingToNextMarkBeforeManeuver() {
        return this.maneuverWithEstimationData.getRelativeBearingToNextMarkBeforeManeuver() == null ? null : Double.valueOf(this.maneuverWithEstimationData.getRelativeBearingToNextMarkBeforeManeuver().getDegrees());
    }

    @Override
    public Double getRelativeBearingToNextMarkAfterManeuver() {
        return this.maneuverWithEstimationData.getRelativeBearingToNextMarkAfterManeuver() == null ? null : Double.valueOf(this.maneuverWithEstimationData.getRelativeBearingToNextMarkAfterManeuver().getDegrees());
    }

    public TimePoint getTimePointBeforeForAnalysis() {
        return this.getManeuverCurveBoundariesForAnalysis().getTimePointBefore();
    }

    public TimePoint getTimePointAfterForAnalysis() {
        return this.getManeuverCurveBoundariesForAnalysis().getTimePointAfter();
    }

    @Override
    public Double getManeuverEnteringSpeed() {
        return this.getManeuverCurveBoundariesForAnalysis().getSpeedWithBearingBefore().getKnots();
    }

    @Override
    public Double getManeuverExitingSpeed() {
        return this.getManeuverCurveBoundariesForAnalysis().getSpeedWithBearingAfter().getKnots();
    }

    @Override
    public double getAbsTwaAtManeuverMiddle() {
        ManeuverCurveBoundaries boundariesForAnalysis = this.getManeuverCurveBoundariesForAnalysis();
        Bearing middleCourse = boundariesForAnalysis.getSpeedWithBearingBefore().getBearing().add((Bearing)new DegreeBearingImpl(boundariesForAnalysis.getDirectionChangeInDegrees() / 2.0));
        return this.getAbsTwaFromCourse(middleCourse);
    }

    @Override
    public double getGpsSamplingRate() {
        return this.maneuverSettings.isMainCurveAnalysis() ? (double)this.maneuverWithEstimationData.getMainCurve().getGpsFixesCount() / this.maneuverWithEstimationData.getMainCurve().getDuration().asSeconds() : (double)this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getGpsFixesCount() / this.maneuverWithEstimationData.getCurveWithUnstableCourseAndSpeed().getDuration().asSeconds();
    }

    @Override
    public Double getAbsRelativeBearingToNextMarkBeforeManeuver() {
        Double bearing = this.getRelativeBearingToNextMarkBeforeManeuver();
        return bearing == null ? null : Double.valueOf(Math.abs(bearing));
    }

    @Override
    public Double getAbsRelativeBearingToNextMarkAfterManeuver() {
        Double bearing = this.getRelativeBearingToNextMarkAfterManeuver();
        return bearing == null ? null : Double.valueOf(Math.abs(bearing));
    }
}

