/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components.aggregators;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sse.common.Speed;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ParallelSpeedMedianAggregationProcessor
extends AbstractParallelGroupedDataStoringAggregationProcessor<Speed, Speed> {
    private static final AggregationProcessorDefinition<Speed, Speed> DEFINITION = new SimpleAggregationProcessorDefinition(Speed.class, Speed.class, "Median", ParallelSpeedMedianAggregationProcessor.class);
    private Map<GroupKey, List<Speed>> groupedValues = new HashMap<GroupKey, List<Speed>>();

    public static AggregationProcessorDefinition<Speed, Speed> getDefinition() {
        return DEFINITION;
    }

    public ParallelSpeedMedianAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, Speed>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Median");
    }

    protected void storeElement(GroupedDataEntry<Speed> element) {
        GroupKey key = element.getKey();
        if (!this.groupedValues.containsKey(key)) {
            this.groupedValues.put(key, new ArrayList());
        }
        this.groupedValues.get(key).add((Speed)element.getDataEntry());
    }

    protected Map<GroupKey, Speed> aggregateResult() {
        HashMap<GroupKey, Speed> result = new HashMap<GroupKey, Speed>();
        for (Map.Entry<GroupKey, List<Speed>> groupedValuesEntry : this.groupedValues.entrySet()) {
            if (this.isAborted()) break;
            result.put(groupedValuesEntry.getKey(), this.getMedianOf(groupedValuesEntry.getValue()));
        }
        return result;
    }

    private Speed getMedianOf(List<Speed> values) {
        Collections.sort(values);
        if (this.listSizeIsEven(values)) {
            int index1 = values.size() / 2 - 1;
            int index2 = index1 + 1;
            return new KnotSpeedImpl((values.get(index1).getKnots() + values.get(index2).getKnots()) / 2.0);
        }
        int index = (values.size() + 1) / 2 - 1;
        return values.get(index);
    }

    private boolean listSizeIsEven(List<?> values) {
        return values.size() % 2 == 0;
    }
}

