/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasManeuverContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.datamining.impl.data.ManeuverWithContext;
import com.sap.sailing.datamining.shared.ManeuverSettings;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public class ManeuverRetrievalProcessor
extends AbstractRetrievalProcessor<HasTrackedLegOfCompetitorContext, HasManeuverContext> {
    private final ManeuverSettings settings;

    public ManeuverRetrievalProcessor(ExecutorService executor, Collection<Processor<HasManeuverContext, ?>> resultReceivers, ManeuverSettings settings, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasTrackedLegOfCompetitorContext.class, HasManeuverContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
        this.settings = settings;
    }

    protected Iterable<HasManeuverContext> retrieveData(HasTrackedLegOfCompetitorContext element) {
        ArrayList<HasManeuverContext> maneuversWithContext = new ArrayList<HasManeuverContext>();
        TimePoint finishTime = element.getTrackedLegOfCompetitor().getFinishTime();
        if (finishTime != null) {
            ManeuverWithContext maneuverWithContext;
            Iterable maneuvers = null;
            if (!this.isLastLeg(element)) {
                finishTime = finishTime.minus(1L);
            }
            try {
                maneuvers = element.getTrackedLegOfCompetitor().getManeuvers(finishTime, false);
            }
            catch (NoWindException e) {
                throw new IllegalStateException("No wind retrieving the maneuvers", e);
            }
            Maneuver previousManeuver = null;
            Maneuver currentManeuver = null;
            for (Maneuver nextManeuver : maneuvers) {
                ManeuverWithContext maneuverWithContext2;
                if (this.isAborted()) break;
                if (currentManeuver != null && this.isManeuverCompliantWithSettings(previousManeuver, maneuverWithContext2 = new ManeuverWithContext(element, currentManeuver, this.settings.isMainCurveAnalysis(), previousManeuver, nextManeuver), nextManeuver)) {
                    maneuversWithContext.add(maneuverWithContext2);
                }
                previousManeuver = currentManeuver;
                currentManeuver = nextManeuver;
            }
            if (currentManeuver != null && this.isManeuverCompliantWithSettings(previousManeuver, maneuverWithContext = new ManeuverWithContext(element, currentManeuver, this.settings.isMainCurveAnalysis(), previousManeuver, null), null)) {
                maneuversWithContext.add(maneuverWithContext);
            }
        }
        return maneuversWithContext;
    }

    private boolean isLastLeg(HasTrackedLegOfCompetitorContext element) {
        if (element.getTrackedLegContext().getTrackedRaceContext().getRace() != null) {
            Waypoint finishWaypoint = element.getTrackedLegContext().getTrackedRaceContext().getRace().getCourse().getLastWaypoint();
            Waypoint toWaypoint = element.getTrackedLegOfCompetitor().getLeg().getTo();
            return finishWaypoint.equals(toWaypoint);
        }
        return false;
    }

    private boolean isManeuverCompliantWithSettings(Maneuver previousManeuver, ManeuverWithContext currentManeuverWithContext, Maneuver nextManeuver) {
        Duration durationToNextManeuver;
        boolean mainCurveAnalysis = this.settings.isMainCurveAnalysis();
        Duration maneuverDuration = this.settings.getMinManeuverDuration() != null || this.settings.getMaxManeuverDuration() != null ? currentManeuverWithContext.getTimePointBeforeForAnalysis().until(currentManeuverWithContext.getTimePointAfterForAnalysis()) : null;
        double maneuverEnteringSpeed = this.settings.getMinManeuverEnteringSpeedInKnots() != null || this.settings.getMaxManeuverEnteringSpeedInKnots() != null ? currentManeuverWithContext.getManeuverEnteringSpeed() : 0.0;
        double maneuverExitingSpeed = this.settings.getMinManeuverExitingSpeedInKnots() != null || this.settings.getMaxManeuverExitingSpeedInKnots() != null ? currentManeuverWithContext.getManeuverExitingSpeed() : 0.0;
        double maneuverEnteringAbsTWA = this.settings.getMinManeuverEnteringAbsTWA() != null ? currentManeuverWithContext.getEnteringAbsTWA() : 0.0;
        double maneuverExitingAbsTWA = this.settings.getMinManeuverExitingAbsTWA() != null ? currentManeuverWithContext.getExitingAbsTWA() : 0.0;
        Duration durationToPreviousManeuver = previousManeuver != null ? this.getManeuverBoundariesForAnalysis(previousManeuver, mainCurveAnalysis).getTimePointAfter().until(currentManeuverWithContext.getTimePointBeforeForAnalysis()) : null;
        Duration duration = durationToNextManeuver = nextManeuver != null ? currentManeuverWithContext.getTimePointAfterForAnalysis().until(this.getManeuverBoundariesForAnalysis(nextManeuver, mainCurveAnalysis).getTimePointBefore()) : null;
        return !(this.settings.getMinManeuverDuration() != null && maneuverDuration.compareTo((Object)this.settings.getMinManeuverDuration()) < 0 || this.settings.getMaxManeuverDuration() != null && maneuverDuration.compareTo((Object)this.settings.getMaxManeuverDuration()) > 0 || this.settings.getMinManeuverEnteringSpeedInKnots() != null && maneuverEnteringSpeed < this.settings.getMinManeuverEnteringSpeedInKnots() || this.settings.getMaxManeuverEnteringSpeedInKnots() != null && maneuverEnteringSpeed > this.settings.getMaxManeuverEnteringSpeedInKnots() || this.settings.getMinManeuverExitingSpeedInKnots() != null && maneuverExitingSpeed < this.settings.getMinManeuverExitingSpeedInKnots() || this.settings.getMaxManeuverExitingSpeedInKnots() != null && maneuverExitingSpeed > this.settings.getMaxManeuverExitingSpeedInKnots() || this.settings.getMinManeuverEnteringAbsTWA() != null && maneuverEnteringAbsTWA < this.settings.getMinManeuverEnteringAbsTWA() || this.settings.getMaxManeuverEnteringAbsTWA() != null && maneuverEnteringAbsTWA > this.settings.getMaxManeuverEnteringAbsTWA() || this.settings.getMinManeuverExitingAbsTWA() != null && maneuverExitingAbsTWA < this.settings.getMinManeuverExitingAbsTWA() || this.settings.getMaxManeuverExitingAbsTWA() != null && maneuverExitingAbsTWA > this.settings.getMaxManeuverExitingAbsTWA() || this.settings.getMinAbsCourseChangeInDegrees() != null && currentManeuverWithContext.getAbsoluteDirectionChangeInDegrees() < this.settings.getMinAbsCourseChangeInDegrees() || this.settings.getMaxAbsCourseChangeInDegrees() != null && currentManeuverWithContext.getAbsoluteDirectionChangeInDegrees() > this.settings.getMaxAbsCourseChangeInDegrees() || this.settings.getMinDurationFromPrecedingManeuver() != null && (previousManeuver == null || durationToPreviousManeuver.compareTo((Object)this.settings.getMinDurationFromPrecedingManeuver()) < 0) || this.settings.getMaxDurationFromPrecedingManeuver() != null && (previousManeuver == null || durationToPreviousManeuver.compareTo((Object)this.settings.getMaxDurationFromPrecedingManeuver()) > 0) || this.settings.getMinDurationToFollowingManeuver() != null && (nextManeuver == null || durationToNextManeuver.compareTo((Object)this.settings.getMinDurationToFollowingManeuver()) < 0) || this.settings.getMaxDurationToFollowingManeuver() != null && (nextManeuver == null || durationToNextManeuver.compareTo((Object)this.settings.getMaxDurationToFollowingManeuver()) > 0));
    }

    private ManeuverCurveBoundaries getManeuverBoundariesForAnalysis(Maneuver maneuver, boolean mainCurveAnalysis) {
        return mainCurveAnalysis ? maneuver.getMainCurveBoundaries() : maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries();
    }
}

