/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.data;

import com.sap.sailing.datamining.data.HasBravoFixTrackContext;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Wind;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.annotations.Connector;
import com.sap.sse.datamining.annotations.Dimension;
import com.sap.sse.datamining.annotations.Statistic;
import com.sap.sse.datamining.shared.impl.dto.ClusterDTO;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.util.Locale;

public interface HasFoilingSegmentContext {
    @Connector(scanForStatistics=false)
    public HasBravoFixTrackContext getBravoFixTrackContext();

    public TimePoint getStartOfFoilingSegment();

    public TimePoint getEndOfFoilingSegment();

    @Dimension(messageKey="FoilingSegmentName")
    public String getName();

    @Statistic(messageKey="FoilingDuration")
    public Duration getDuration();

    @Statistic(messageKey="FoilingDistance")
    public Distance getDistance();

    @Statistic(messageKey="TakeoffSpeedInKnotsInKnots", resultDecimals=1)
    public Double getTakeoffSpeedInKnots();

    @Statistic(messageKey="LandingSpeedInKnots", resultDecimals=1)
    public Double getLandingSpeedInKnots();

    @Statistic(messageKey="AbsoluteTrueWindAngleAtTakeoff", resultDecimals=1)
    public Bearing getAbsoluteTrueWindAngleAtTakeoffInDegrees() throws NoWindException;

    @Statistic(messageKey="AbsoluteTrueWindAngleAtLanding", resultDecimals=1)
    public Bearing getAbsoluteTrueWindAngleAtLandingInDegrees() throws NoWindException;

    @Statistic(messageKey="AverageAbsoluteTrueWindAngle", resultDecimals=1)
    public Bearing getAverageAbsoluteTrueWindAngle() throws NoWindException;

    @Dimension(messageKey="WindStrengthInBeaufortAtTakeoff")
    public ClusterDTO getWindStrengthAsBeaufortClusterAtTakeoff(Locale var1, ResourceBundleStringMessages var2);

    @Dimension(messageKey="WindStrengthInBeaufortAtLanding")
    public ClusterDTO getWindStrengthAsBeaufortClusterAtLanding(Locale var1, ResourceBundleStringMessages var2);

    @Connector(messageKey="WindAtTakeoff")
    public Wind getWindAtTakeoff();

    @Connector(messageKey="WindAtLanding")
    public Wind getWindAtLanding();

    @Dimension(messageKey="StartsOnLegType")
    public LegType getStartsOnLegType() throws NoWindException;

    @Dimension(messageKey="EndsOnLegType")
    public LegType getEndsOnLegType() throws NoWindException;
}

