/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sse.common.Speed;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterBoundary;
import com.sap.sse.datamining.data.ClusterFormatter;
import com.sap.sse.datamining.data.ClusterGroup;
import com.sap.sse.datamining.impl.data.ClusterWithLowerAndUpperBoundaries;
import com.sap.sse.datamining.impl.data.ClusterWithSingleBoundary;
import com.sap.sse.datamining.impl.data.ComparableClusterBoundary;
import com.sap.sse.datamining.impl.data.ComparisonStrategy;
import com.sap.sse.datamining.impl.data.FixClusterGroup;
import com.sap.sse.datamining.impl.data.LinearDoubleClusterGroup;
import com.sap.sse.datamining.impl.data.LocalizedCluster;
import com.sap.sse.datamining.impl.data.PercentageClusterFormatter;
import java.util.ArrayList;

public class SailingClusterGroups {
    private final ClusterGroup<Speed> windStrengthInBeaufortClusterGroup;
    private final ClusterGroup<Double> percentageClusterGroup;
    private final ClusterFormatter<Double> percentageClusterFormatter;

    public SailingClusterGroups() {
        ArrayList<LocalizedCluster> clusters = new ArrayList<LocalizedCluster>();
        KnotSpeedImpl lowerBoundWindSpeed = new KnotSpeedImpl(0.0);
        ComparableClusterBoundary lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        KnotSpeedImpl upperBoundWindSpeed = new KnotSpeedImpl(1.0);
        ComparableClusterBoundary upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft0", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(1.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(4.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft1", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(4.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(7.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft2", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(7.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(11.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft3", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(11.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(16.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft4", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(16.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(22.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft5", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(22.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(28.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft6", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(28.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(34.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft7", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(34.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(41.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft8", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(41.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(48.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft9", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(48.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(56.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft10", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(56.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        upperBoundWindSpeed = new KnotSpeedImpl(64.0);
        upperBound = new ComparableClusterBoundary((Comparable)upperBoundWindSpeed, ComparisonStrategy.LOWER_THAN);
        clusters.add(new LocalizedCluster("Bft11", (Cluster)new ClusterWithLowerAndUpperBoundaries((ClusterBoundary)lowerBound, (ClusterBoundary)upperBound)));
        lowerBoundWindSpeed = new KnotSpeedImpl(64.0);
        lowerBound = new ComparableClusterBoundary((Comparable)lowerBoundWindSpeed, ComparisonStrategy.GREATER_EQUALS_THAN);
        clusters.add(new LocalizedCluster("Bft12", (Cluster)new ClusterWithSingleBoundary((ClusterBoundary)lowerBound)));
        this.windStrengthInBeaufortClusterGroup = new FixClusterGroup(clusters);
        this.percentageClusterGroup = new LinearDoubleClusterGroup(0.0, 1.0, 0.1, true);
        this.percentageClusterFormatter = new PercentageClusterFormatter();
    }

    public ClusterGroup<Speed> getWindStrengthInBeaufortClusterGroup() {
        return this.windStrengthInBeaufortClusterGroup;
    }

    public ClusterGroup<Double> getPercentageClusterGroup() {
        return this.percentageClusterGroup;
    }

    public ClusterFormatter<Double> getPercentageClusterFormatter() {
        return this.percentageClusterFormatter;
    }
}

