/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.aicore.impl;

import com.sap.sse.aicore.Credentials;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CredentialsImpl
implements Credentials {
    private static final String CLIENT_CREDENTIALS_PATH = "/oauth/token?grant_type=client_credentials";
    private static final String GRANT_TYPE_NAME = "grant_type";
    private static final String GRANT_TYPE_VALUE = "client_credentials";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String AI_RESOURCE_GROUP_HEADER_NAME = "AI-Resource-Group";
    private static final String AI_DEFAULT_RESOURCE_GROUP = "default";
    private final String clientId;
    private final String clientSecret;
    private final URL xsuaaUrl;
    private final String identityZone;
    private final String identityZoneId;
    private final String appName;
    private final URL aiApiUrl;
    private String token;

    public CredentialsImpl(String clientId, String clientSecret, String xsuaaUrl, String identityZone, String identityZoneId, String appName, String aiApiUrl) throws MalformedURLException {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.xsuaaUrl = new URL(xsuaaUrl);
        this.identityZone = identityZone;
        this.identityZoneId = identityZoneId;
        this.appName = appName;
        this.aiApiUrl = new URL(aiApiUrl);
    }

    @Override
    public void authorize(HttpRequest httpGet) throws URISyntaxException, UnsupportedOperationException, ClientProtocolException, IOException, ParseException {
        httpGet.addHeader(AI_RESOURCE_GROUP_HEADER_NAME, AI_DEFAULT_RESOURCE_GROUP);
        httpGet.addHeader("Authorization", "Bearer " + this.getToken());
    }

    @Override
    public String getIdentityZone() {
        return this.identityZone;
    }

    @Override
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public URL getAiApiUrl() {
        return this.aiApiUrl;
    }

    String getToken() throws URISyntaxException, UnsupportedOperationException, ClientProtocolException, IOException, ParseException {
        if (this.token == null) {
            this.token = this.fetchToken();
        }
        return this.token;
    }

    String getClientId() {
        return this.clientId;
    }

    String getClientSecret() {
        return this.clientSecret;
    }

    URL getXsuaaUrl() {
        return this.xsuaaUrl;
    }

    String fetchToken() throws URISyntaxException, UnsupportedOperationException, ClientProtocolException, IOException, ParseException {
        HttpPost postRequest = new HttpPost(new URI(String.valueOf(this.xsuaaUrl.toString()) + CLIENT_CREDENTIALS_PATH));
        postRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(GRANT_TYPE_NAME, GRANT_TYPE_VALUE));
        params.add(new BasicNameValuePair(CLIENT_ID, this.clientId));
        params.add(new BasicNameValuePair(CLIENT_SECRET, this.clientSecret));
        postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
        JSONParser jsonParser = new JSONParser();
        HttpResponse response = client.execute((HttpUriRequest)postRequest);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 401) {
            throw new SecurityException("Authentication failed: " + response.getStatusLine().getReasonPhrase());
        }
        if (statusCode == 403) {
            throw new AccessControlException("Authorization failed: " + response.getStatusLine().getReasonPhrase());
        }
        if (statusCode >= 400) {
            throw new IOException("Error obtaining client token: " + response.getStatusLine().getReasonPhrase() + " (" + statusCode + ")");
        }
        JSONObject tokenJson = (JSONObject)jsonParser.parse((Reader)new InputStreamReader(response.getEntity().getContent()));
        return (String)tokenJson.get((Object)ACCESS_TOKEN);
    }
}

