/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.aicore;

import com.sap.sse.aicore.ChatSession;
import com.sap.sse.aicore.Credentials;
import com.sap.sse.aicore.CredentialsParser;
import com.sap.sse.aicore.Deployment;
import com.sap.sse.aicore.impl.AICoreImpl;
import com.sap.sse.aicore.impl.ChatSessionImpl;
import com.sap.sse.common.Util;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public interface AICore {
    public static final Logger logger = Logger.getLogger(AICore.class.getName());
    public static final String CREDENTIALS_SYSTEM_PROPERTY_NAME = "sap.aicore.credentials";

    public static AICore getDefault() throws MalformedURLException, ParseException {
        Credentials credentials;
        String systemProperty = System.getProperty(CREDENTIALS_SYSTEM_PROPERTY_NAME);
        if (Util.hasLength((String)systemProperty)) {
            Credentials parsedCredentials;
            try {
                parsedCredentials = CredentialsParser.create().parse(systemProperty);
            }
            catch (Exception e) {
                logger.warning("Failed to parse credentials from system property sap.aicore.credentials: " + systemProperty);
                parsedCredentials = null;
            }
            credentials = parsedCredentials != null ? parsedCredentials : null;
        } else {
            logger.warning("No credentials provided for AICore service through system property sap.aicore.credentials; cannot produce an authenticated default service instance");
            credentials = null;
        }
        return AICore.create(credentials);
    }

    public static AICore create(Credentials credentials) {
        return new AICoreImpl(credentials, ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor());
    }

    public Iterable<Deployment> getDeployments() throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException;

    default public Iterable<String> getModelNames() throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        return Util.map(this.getDeployments(), d -> d.getModelName());
    }

    default public Optional<Deployment> getDeploymentByModelName(String modelName) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        return Util.stream(this.getDeployments()).filter(d -> d.getModelName().equals(modelName)).findAny();
    }

    default public Optional<ChatSession> createChatSession(String modelName) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        return this.getDeploymentByModelName(modelName).map(d -> new ChatSessionImpl(this, (Deployment)d));
    }

    default public ChatSession createChatSession(Deployment deployment) {
        return new ChatSessionImpl(this, deployment);
    }

    public HttpGet getHttpGetRequest(String var1) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException;

    public HttpPost getHttpPostRequest(String var1) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException;

    public JSONObject getJSONResponse(HttpUriRequest var1) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException;

    public void getJSONResponse(HttpUriRequest var1, Consumer<JSONObject> var2, Optional<Consumer<Exception>> var3);

    public boolean hasCredentials();

    public void setCredentials(Credentials var1);
}

