/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.resultimport.CompetitorEntry;
import com.sap.sailing.resultimport.CompetitorRow;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.impl.ScoreCorrectionForCompetitorInRaceImpl;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScoreCorrectionForRaceImpl
implements RegattaScoreCorrections.ScoreCorrectionsForRace {
    private final int raceNumberStartingWithOne;
    private final Map<String, RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace> scoreCorrectionsBySailID;

    public ScoreCorrectionForRaceImpl(RegattaResults regattaResult, int raceNumberStartingWithZero) {
        this.raceNumberStartingWithOne = raceNumberStartingWithZero + 1;
        this.scoreCorrectionsBySailID = new HashMap<String, RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace>();
        for (CompetitorRow competitorRow : regattaResult.getCompetitorResults()) {
            String competitorName = competitorRow.getCompetitorName();
            CompetitorEntry competitorEntry = raceNumberStartingWithZero < Util.size(competitorRow.getRankAndMaxPointsReasonAndPointsAndDiscarded()) ? (CompetitorEntry)Util.get(competitorRow.getRankAndMaxPointsReasonAndPointsAndDiscarded(), (int)raceNumberStartingWithZero) : null;
            this.scoreCorrectionsBySailID.put(competitorRow.getSailID(), new ScoreCorrectionForCompetitorInRaceImpl(competitorRow.getSailID(), competitorName, competitorEntry));
        }
    }

    public String getRaceNameOrNumber() {
        return "" + this.raceNumberStartingWithOne;
    }

    public Set<String> getSailIDs() {
        return this.scoreCorrectionsBySailID.keySet();
    }

    public RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace getScoreCorrectionForCompetitor(String sailID) {
        return this.scoreCorrectionsBySailID.get(sailID);
    }
}

