/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.xrr.resultimport.Parser;
import com.sap.sailing.xrr.resultimport.impl.RaceResultAsScoreCorrectionForCompetitorInRace;
import com.sap.sailing.xrr.schema.Boat;
import com.sap.sailing.xrr.schema.Division;
import com.sap.sailing.xrr.schema.RaceResult;
import com.sap.sailing.xrr.schema.Team;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class ScoreCorrectionForRaceResult
implements RegattaScoreCorrections.ScoreCorrectionsForRace {
    private final Parser parser;
    private final Division division;
    private final Set<String> raceIDs;
    private final BigInteger raceNumber;
    private static final Logger logger = Logger.getLogger(ScoreCorrectionForRaceResult.class.getName());

    public ScoreCorrectionForRaceResult(Parser parser, Division division, BigInteger raceNumber, Set<String> raceIDs) {
        this.parser = parser;
        this.division = division;
        this.raceNumber = raceNumber;
        this.raceIDs = raceIDs;
    }

    public String getRaceNameOrNumber() {
        return this.raceNumber.toString();
    }

    public Set<String> getSailIDs() {
        HashSet<String> result = new HashSet<String>();
        for (Object o : this.division.getSeriesResultOrRaceResultOrTRResult()) {
            RaceResult raceResult;
            if (!(o instanceof RaceResult) || !this.raceIDs.contains((raceResult = (RaceResult)o).getRaceID())) continue;
            Team team = this.parser.getTeam(raceResult.getTeamID());
            if (team != null) {
                Boat boat = this.parser.getBoat(team.getBoatID());
                if (boat != null) {
                    result.add(boat.getSailNumber());
                    continue;
                }
                logger.severe("Could not find a boat for ID " + team.getBoatID() + " for team with ID " + raceResult.getTeamID() + " for raceresult of race with ID " + raceResult.getRaceID());
                continue;
            }
            logger.severe("Could not find a team for ID " + raceResult.getTeamID() + " for raceresult of race with ID " + raceResult.getRaceID());
        }
        return result;
    }

    public RegattaScoreCorrections.ScoreCorrectionForCompetitorInRace getScoreCorrectionForCompetitor(String sailID) {
        return new RaceResultAsScoreCorrectionForCompetitorInRace(this.parser, this.division, this.raceIDs, sailID);
    }
}

