/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.resultimport.impl;

import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.impl.NationalityImpl;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.dto.PersonDTO;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.xrr.resultimport.Parser;
import com.sap.sailing.xrr.resultimport.ParserFactory;
import com.sap.sailing.xrr.schema.Boat;
import com.sap.sailing.xrr.schema.Division;
import com.sap.sailing.xrr.schema.Event;
import com.sap.sailing.xrr.schema.IFNationCode;
import com.sap.sailing.xrr.schema.Person;
import com.sap.sailing.xrr.schema.Race;
import com.sap.sailing.xrr.schema.RaceResult;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sailing.xrr.schema.SeriesResult;
import com.sap.sailing.xrr.schema.Team;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CompetitorResolver {
    private static final Logger logger = Logger.getLogger(CompetitorResolver.class.getName());
    private static final String ID_CONNECTOR_SYMBOL = "-";
    private final ResultDocumentProvider documentProvider;
    private final ParserFactory parserFactory;
    private final String idPrefix;

    public CompetitorResolver(ResultDocumentProvider documentProvider, ParserFactory parserFactory, String idPrefix) {
        this.documentProvider = documentProvider;
        this.parserFactory = parserFactory;
        this.idPrefix = idPrefix;
    }

    public Map<String, Set<String>> getHasCompetitorsForRegattasInEvent() throws IOException, URISyntaxException, SAXException, ParserConfigurationException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (ResultDocumentDescriptor resultDocDescr : this.documentProvider.getResultDocumentDescriptors()) {
            String eventName = resultDocDescr.getEventName();
            String regattaName = resultDocDescr.getRegattaName();
            HashSet<String> set = (HashSet<String>)result.get(eventName);
            if (set == null) {
                set = new HashSet<String>();
                result.put(eventName, set);
            }
            set.add(regattaName);
        }
        return result;
    }

    public Iterable<CompetitorDescriptor> getCompetitorDescriptors(String eventName, String regattaName) throws JAXBException, IOException, URISyntaxException, SAXException, ParserConfigurationException {
        ArrayList<CompetitorDescriptor> result = new ArrayList<CompetitorDescriptor>();
        HashMap<String, CompetitorDescriptor> resultsByTeamID = new HashMap<String, CompetitorDescriptor>();
        HashMap<String, CompetitorDescriptor> teamsWithoutRaceAssignments = new HashMap<String, CompetitorDescriptor>();
        for (ResultDocumentDescriptor resultDocumentDescriptor : this.documentProvider.getResultDocumentDescriptors()) {
            if (!resultDocumentDescriptor.getEventName().equals(eventName) || regattaName != null && !regattaName.equals(resultDocumentDescriptor.getRegattaName())) continue;
            Parser parser = this.parserFactory.createParser(resultDocumentDescriptor.getInputStream(), resultDocumentDescriptor.getEventName());
            try {
                RegattaResults regattaResults = parser.parse();
                HashSet<Team> teamsOutsideOfDivision = new HashSet<Team>();
                HashMap<Division, Event> divisions = new HashMap<Division, Event>();
                for (Object o : regattaResults.getPersonOrBoatOrTeam()) {
                    if (o instanceof Team) {
                        Team team = (Team)o;
                        teamsOutsideOfDivision.add(team);
                        continue;
                    }
                    if (!(o instanceof Event)) continue;
                    Event event = (Event)o;
                    for (Object eventO : event.getRaceOrDivisionOrRegattaSeriesResult()) {
                        if (!(eventO instanceof Division)) continue;
                        Division division = (Division)eventO;
                        divisions.put(division, event);
                        if (regattaName != null && !regattaName.equals(division.getTitle())) continue;
                        for (Object divisionO : division.getSeriesResultOrRaceResultOrTRResult()) {
                            String raceID = null;
                            Team team = null;
                            if (divisionO instanceof RaceResult) {
                                RaceResult raceResult = (RaceResult)divisionO;
                                raceID = raceResult.getRaceID();
                                team = parser.getTeam(raceResult.getTeamID());
                            } else if (divisionO instanceof SeriesResult) {
                                SeriesResult seriesResult = (SeriesResult)divisionO;
                                team = parser.getTeam(seriesResult.getTeamID());
                            }
                            if (team == null) continue;
                            CompetitorDescriptor competitorDescriptor = this.createCompetitorDescriptor(team, parser, event, division, raceID);
                            resultsByTeamID.put(team.getTeamID(), competitorDescriptor);
                            result.add(competitorDescriptor);
                        }
                    }
                }
                for (Team teamOutsideOfDivision : teamsOutsideOfDivision) {
                    if (divisions.size() == 1) {
                        if (resultsByTeamID.containsKey(teamOutsideOfDivision.getTeamID())) continue;
                        CompetitorDescriptor competitorDescriptor = this.createCompetitorDescriptor(teamOutsideOfDivision, parser, (Event)divisions.values().iterator().next(), (Division)divisions.keySet().iterator().next(), null);
                        resultsByTeamID.put(teamOutsideOfDivision.getTeamID(), competitorDescriptor);
                        result.add(competitorDescriptor);
                        continue;
                    }
                    teamsWithoutRaceAssignments.put(teamOutsideOfDivision.getTeamID(), this.createCompetitorDescriptor(teamOutsideOfDivision, parser, null, null, null));
                }
            }
            catch (JAXBException e) {
                logger.log(Level.WARNING, "Exception trying to read competitors for event " + resultDocumentDescriptor.getEventName() + ", regatta " + resultDocumentDescriptor.getRegattaName() + " from document " + resultDocumentDescriptor.getDocumentName(), e);
            }
        }
        for (Map.Entry entry : teamsWithoutRaceAssignments.entrySet()) {
            if (resultsByTeamID.containsKey(entry.getKey())) continue;
            result.add((CompetitorDescriptor)entry.getValue());
        }
        return result;
    }

    private CompetitorDescriptor createCompetitorDescriptor(Team team, Parser parser, Event event, Division division, String raceID) {
        Object boatId;
        Object competitorId;
        Boat boat = parser.getBoat(team.getBoatID());
        String sailNumber = boat.getSailNumber();
        Race race = parser.getRace(raceID);
        Nationality[] teamNationality = new Nationality[]{team.getNOC() == null ? null : new NationalityImpl(team.getNOC().name())};
        String boatClassName = division != null ? parser.getBoatClassName(division) : null;
        HashSet<String> crewFamilyNames = new HashSet<String>();
        List persons = team.getCrew().stream().sorted((c1, c2) -> -c1.getPosition().name().compareTo(c2.getPosition().name())).map(crew -> {
            NationalityImpl nationality;
            Person xrrPerson = parser.getPerson(crew.getPersonID());
            String familyName = xrrPerson.getFamilyName();
            crewFamilyNames.add(familyName);
            String name = String.valueOf(xrrPerson.getGivenName()) + " " + familyName;
            if (xrrPerson.getNOC() == null) {
                nationality = null;
            } else {
                nationality = new NationalityImpl(xrrPerson.getNOC().name());
                if (teamNationality[0] == null) {
                    nationalityArray[0] = nationality;
                }
            }
            PersonDTO person = new PersonDTO(name, null, xrrPerson.getGender() == null ? null : xrrPerson.getGender().name(), nationality == null ? null : nationality.getCountryCode().getThreeLetterIOCCode());
            return person;
        }).collect(Collectors.toList());
        if (teamNationality[0] == null && sailNumber != null && sailNumber.length() > 3) {
            try {
                String substring = sailNumber.substring(0, 3);
                IFNationCode nationalityCode = IFNationCode.fromValue((String)substring);
                teamNationality[0] = new NationalityImpl(nationalityCode.name());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not infer team nationality from sail number: " + sailNumber + ". Nationality will be nulled");
            }
        }
        try {
            competitorId = UUID.fromString(team.getTeamID());
        }
        catch (IllegalArgumentException e) {
            competitorId = String.valueOf(this.idPrefix) + ID_CONNECTOR_SYMBOL + team.getTeamID();
        }
        try {
            boatId = UUID.fromString(boat.getBoatID());
        }
        catch (IllegalArgumentException e) {
            boatId = String.valueOf(this.idPrefix) + ID_CONNECTOR_SYMBOL + boat.getBoatID();
        }
        CompetitorDescriptor competitorDescriptor = new CompetitorDescriptor(event == null ? null : event.getTitle(), division == null ? null : String.valueOf(division.getTitle()) + (division.getGender() == null ? "" : division.getGender().name()), race != null ? race.getRaceName() : null, null, (Serializable)competitorId, this.getCompetitorNameFromTeamAndBoat(team, boat, crewFamilyNames), null, this.getCompetitorNameFromTeamAndBoat(team, boat, crewFamilyNames), persons, teamNationality[0] == null ? null : teamNationality[0].getCountryCode(), null, null, (Serializable)boatId, boat.getBoatName(), boatClassName, sailNumber);
        return competitorDescriptor;
    }

    private String getCompetitorNameFromTeamAndBoat(Team team, Boat boat, Set<String> crewFamilyNames) {
        String result;
        if (Util.hasLength((String)team.getTeamName())) {
            result = team.getTeamName();
        } else if (boat.getBoatName() != null) {
            result = boat.getBoatName();
        } else if (crewFamilyNames.size() > 0) {
            String concatenatedTeamName = null;
            for (String familyName : crewFamilyNames) {
                concatenatedTeamName = concatenatedTeamName != null ? String.valueOf(concatenatedTeamName) + "+" + familyName : familyName;
            }
            result = concatenatedTeamName;
        } else {
            result = null;
        }
        return result;
    }
}

