/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.interfaces;

import org.apache.shiro.authc.SaltedAuthenticationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.SimpleByteSource;

public class SimpleSaltedAuthenticationInfo
implements SaltedAuthenticationInfo {
    private static final long serialVersionUID = -8423637970683173260L;
    private String username;
    private String saltedPassword;
    private byte[] salt;

    public SimpleSaltedAuthenticationInfo(String username, String saltedPassword, byte[] salt) {
        this.username = username;
        this.saltedPassword = saltedPassword;
        this.salt = salt;
    }

    public PrincipalCollection getPrincipals() {
        SimplePrincipalCollection coll = new SimplePrincipalCollection((Object)this.username, this.username);
        return coll;
    }

    public Object getCredentials() {
        return this.saltedPassword;
    }

    public ByteSource getCredentialsSalt() {
        return new SimpleByteSource(this.salt);
    }
}

