/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.shared;

import com.sap.sailing.domain.common.impl.WindSpeedSteppingWithMaxDistance;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettings;

public class PolarDataMiningSettingsImpl
extends PolarDataMiningSettings {
    private static final long serialVersionUID = 2731616509404813790L;
    private Integer minimumDataCountPerGraph;
    private double minimumWindConfidence;
    private Integer minimumDataCountPerAngle;
    private Integer numberOfHistogramColumns;
    private boolean useOnlyWindGaugesForWindSpeed;
    private boolean useOnlyEstimationForWindDirection;
    private WindSpeedSteppingWithMaxDistance windStepping;
    private boolean applyMinimumWindConfidence;

    public static PolarDataMiningSettingsImpl createStandardPolarSettings() {
        double[] levels = new double[]{4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 20.0, 25.0, 30.0};
        WindSpeedSteppingWithMaxDistance windStepping = new WindSpeedSteppingWithMaxDistance(levels, 2.5);
        return new PolarDataMiningSettingsImpl(1000, 0.01, true, 100, 20, true, true, windStepping);
    }

    PolarDataMiningSettingsImpl() {
    }

    public PolarDataMiningSettingsImpl(Integer minimumDataCountPerGraph, double minimumWindConfidence, boolean applyMinimumWindConfidence, Integer minimumDataCountPerAngle, Integer numberOfHistogramColumns, boolean useOnlyWindGaugesForWindSpeed, boolean useOnlyEstimationForWindDirection, WindSpeedSteppingWithMaxDistance windStepping) {
        this.minimumDataCountPerGraph = minimumDataCountPerGraph;
        this.minimumWindConfidence = minimumWindConfidence;
        this.applyMinimumWindConfidence = applyMinimumWindConfidence;
        this.minimumDataCountPerAngle = minimumDataCountPerAngle;
        this.numberOfHistogramColumns = numberOfHistogramColumns;
        this.useOnlyWindGaugesForWindSpeed = useOnlyWindGaugesForWindSpeed;
        this.useOnlyEstimationForWindDirection = useOnlyEstimationForWindDirection;
        this.windStepping = windStepping;
    }

    @Override
    public Integer getMinimumDataCountPerGraph() {
        return this.minimumDataCountPerGraph;
    }

    @Override
    public double getMinimumWindConfidence() {
        return this.minimumWindConfidence;
    }

    @Override
    public Integer getMinimumDataCountPerAngle() {
        return this.minimumDataCountPerAngle;
    }

    @Override
    public int getNumberOfHistogramColumns() {
        return this.numberOfHistogramColumns;
    }

    @Override
    public boolean useOnlyWindGaugesForWindSpeed() {
        return this.useOnlyWindGaugesForWindSpeed;
    }

    @Override
    public boolean useOnlyEstimatedForWindDirection() {
        return this.useOnlyEstimationForWindDirection;
    }

    @Override
    public WindSpeedSteppingWithMaxDistance getWindSpeedStepping() {
        return this.windStepping;
    }

    @Override
    public boolean applyMinimumWindConfidence() {
        return this.applyMinimumWindConfidence;
    }

    @Override
    public boolean areDefault() {
        return PolarDataMiningSettingsImpl.createStandardPolarSettings().equals((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applyMinimumWindConfidence ? 1231 : 1237);
        result = 31 * result + (this.minimumDataCountPerAngle == null ? 0 : this.minimumDataCountPerAngle.hashCode());
        result = 31 * result + (this.minimumDataCountPerGraph == null ? 0 : this.minimumDataCountPerGraph.hashCode());
        long temp = Double.doubleToLongBits(this.minimumWindConfidence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.numberOfHistogramColumns == null ? 0 : this.numberOfHistogramColumns.hashCode());
        result = 31 * result + (this.useOnlyEstimationForWindDirection ? 1231 : 1237);
        result = 31 * result + (this.useOnlyWindGaugesForWindSpeed ? 1231 : 1237);
        result = 31 * result + (this.windStepping == null ? 0 : this.windStepping.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PolarDataMiningSettingsImpl other = (PolarDataMiningSettingsImpl)((Object)obj);
        if (this.applyMinimumWindConfidence != other.applyMinimumWindConfidence) {
            return false;
        }
        if (this.minimumDataCountPerAngle == null ? other.minimumDataCountPerAngle != null : !this.minimumDataCountPerAngle.equals(other.minimumDataCountPerAngle)) {
            return false;
        }
        if (this.minimumDataCountPerGraph == null ? other.minimumDataCountPerGraph != null : !this.minimumDataCountPerGraph.equals(other.minimumDataCountPerGraph)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minimumWindConfidence) != Double.doubleToLongBits(other.minimumWindConfidence)) {
            return false;
        }
        if (this.numberOfHistogramColumns == null ? other.numberOfHistogramColumns != null : !this.numberOfHistogramColumns.equals(other.numberOfHistogramColumns)) {
            return false;
        }
        if (this.useOnlyEstimationForWindDirection != other.useOnlyEstimationForWindDirection) {
            return false;
        }
        if (this.useOnlyWindGaugesForWindSpeed != other.useOnlyWindGaugesForWindSpeed) {
            return false;
        }
        return !(this.windStepping == null ? other.windStepping != null : !this.windStepping.equals((Object)other.windStepping));
    }
}

