/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.sailwave.html.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.domain.resultimport.ResultUrlProvider;
import com.sap.sailing.resultimport.AbstractResultUrlProvider;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.ResultUrlRegistry;
import com.sap.sailing.resultimport.impl.RegattaScoreCorrectionsImpl;
import com.sap.sailing.sailwave.html.resultimport.impl.SailwaveHtmlParser;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScoreCorrectionProviderImpl
extends AbstractResultUrlProvider
implements ScoreCorrectionProvider,
ResultUrlProvider {
    private static final long serialVersionUID = 5853404150107387702L;
    public static final String PROVIDER_NAME = "Sailwave HTML Score Importer";

    public ScoreCorrectionProviderImpl(ResultUrlRegistry resultUrlRegistry) {
        super(resultUrlRegistry);
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public Map<String, Set<Util.Pair<String, TimePoint>>> getHasResultsForBoatClassFromDateByEventName() {
        HashMap<String, Set<Util.Pair<String, TimePoint>>> result = new HashMap<String, Set<Util.Pair<String, TimePoint>>>();
        SailwaveHtmlParser parser = new SailwaveHtmlParser();
        for (URL url : this.getReadableUrls()) {
            try {
                URLConnection conn = url.openConnection();
                MillisecondsTimePoint lastModified = new MillisecondsTimePoint(conn.getLastModified());
                RegattaResults regattaResult = parser.getRegattaResults((InputStream)conn.getContent());
                String boatClassName = this.getBoatClassName(regattaResult);
                result.put(boatClassName, Collections.singleton(new Util.Pair((Object)boatClassName, (Object)lastModified)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private String getBoatClassName(RegattaResults regattaResult) {
        Map metadata = regattaResult.getMetadata();
        if (metadata.containsKey("class")) {
            return (String)metadata.get("class");
        }
        for (String metadatum : metadata.values()) {
            if (metadatum == null || metadatum.length() <= 0) continue;
            return metadatum;
        }
        return null;
    }

    public URL resolveUrl(String url) throws MalformedURLException {
        return new URL(url);
    }

    public RegattaScoreCorrections getScoreCorrections(String eventName, String boatClassName, TimePoint timePoint) throws Exception {
        SailwaveHtmlParser parser = new SailwaveHtmlParser();
        for (URL url : this.getReadableUrls()) {
            URLConnection conn = url.openConnection();
            RegattaResults regattaResult = parser.getRegattaResults((InputStream)conn.getContent());
            if ((boatClassName != null || this.getBoatClassName(regattaResult) != null) && !boatClassName.equals(this.getBoatClassName(regattaResult))) continue;
            return new RegattaScoreCorrectionsImpl((ScoreCorrectionProvider)this, regattaResult);
        }
        return null;
    }

    public RegattaScoreCorrections getScoreCorrections(InputStream inputStream) throws Exception {
        return new RegattaScoreCorrectionsImpl((ScoreCorrectionProvider)this, new SailwaveHtmlParser().getRegattaResults(inputStream));
    }

    public String getOptionalSampleURL() {
        return null;
    }
}

