/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.util.impl;

import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.util.SecuredServer;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.shiro.authz.AuthorizationException;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SecuredServerImpl
implements SecuredServer {
    private static final String BEARER_TOKEN_PREFIX_IN_AUTHORIZATION_HEADER = "Bearer ";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final Logger logger = Logger.getLogger(SecuredServerImpl.class.getName());
    private final String bearerToken;
    private final URL baseUrl;

    public SecuredServerImpl(URL baseUrl, String bearerToken) {
        this.baseUrl = baseUrl;
        this.bearerToken = bearerToken;
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getBearerToken() {
        return this.bearerToken;
    }

    protected Util.Pair<Object, Integer> getJsonParsedResponse(HttpUriRequest request) throws IOException, ClientProtocolException, ParseException {
        Object jsonParseResult;
        this.authenticate((HttpRequest)request);
        CloseableHttpClient client = this.createHttpClient();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HttpResponse response = client.execute(request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == Response.Status.NO_CONTENT.getStatusCode() || Response.Status.fromStatusCode((int)statusCode) == null || Response.Status.fromStatusCode((int)statusCode).getFamily() != Response.Status.Family.SUCCESSFUL) {
            jsonParseResult = null;
        } else {
            response.getEntity().writeTo((OutputStream)bos);
            try {
                jsonParseResult = new JSONParser().parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), HttpUrlConnectionHelper.getCharsetFromHttpEntity((HttpEntity)response.getEntity(), (String)"UTF-8")));
            }
            catch (ParseException e) {
                jsonParseResult = new String(bos.toByteArray());
            }
        }
        return new Util.Pair(jsonParseResult, (Object)statusCode);
    }

    private CloseableHttpClient createHttpClient() {
        return HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
    }

    private void authenticate(HttpRequest request) {
        if (this.bearerToken != null) {
            request.setHeader(AUTHORIZATION_HEADER, BEARER_TOKEN_PREFIX_IN_AUTHORIZATION_HEADER + this.bearerToken);
        }
    }

    protected void authenticate(ClientUpgradeRequest websocketUpgradeRequest) {
        if (this.bearerToken != null) {
            websocketUpgradeRequest.setHeader(AUTHORIZATION_HEADER, BEARER_TOKEN_PREFIX_IN_AUTHORIZATION_HEADER + this.bearerToken);
        }
    }

    @Override
    public UUID getUserGroupIdByName(String userGroupName) throws ClientProtocolException, IOException, ParseException, IllegalAccessException {
        UUID groupId;
        URL getUserGroupIdByNameUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/usergroup?groupName=" + userGroupName);
        HttpGet getRequest = new HttpGet(getUserGroupIdByNameUrl.toString());
        Util.Pair<Object, Integer> result = this.getJsonParsedResponse((HttpUriRequest)getRequest);
        if ((Integer)result.getB() >= 200 && (Integer)result.getB() < 300) {
            JSONObject groupJson = (JSONObject)result.getA();
            groupId = groupJson == null ? null : UUID.fromString(groupJson.get((Object)"groupId").toString());
        } else {
            if (((Integer)result.getB()).intValue() == Response.Status.FORBIDDEN.getStatusCode() || ((Integer)result.getB()).intValue() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new AuthorizationException("Not allowed to access group " + userGroupName + ": " + result.getA());
            }
            groupId = null;
        }
        return groupId;
    }

    @Override
    public Util.Pair<UUID, String> getGroupAndUserOwner(HasPermissions type, TypeRelativeObjectIdentifier typeRelativeObjectId) throws ClientProtocolException, IOException, ParseException {
        URL getGroupAndUserOwnerUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/ownership/" + type.getName() + "/" + typeRelativeObjectId.toString());
        HttpGet getRequest = new HttpGet(getGroupAndUserOwnerUrl.toString());
        JSONObject ownershipJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getRequest).getA();
        Object groupIdValue = ownershipJson.get((Object)"groupId");
        UUID groupId = groupIdValue == null ? null : UUID.fromString(groupIdValue.toString());
        Object usernameValue = ownershipJson.get((Object)"username");
        String username = usernameValue == null ? null : usernameValue.toString();
        return new Util.Pair((Object)groupId, (Object)username);
    }

    @Override
    public void setGroupAndUserOwner(HasPermissions type, TypeRelativeObjectIdentifier typeRelativeObjectId, Optional<String> displayName, Optional<UUID> groupId, Optional<String> username) throws ClientProtocolException, IOException, ParseException {
        URL setGroupAndUserOwnerUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/ownership/" + type.getName() + "/" + typeRelativeObjectId.toString());
        HttpPut putRequest = new HttpPut(setGroupAndUserOwnerUrl.toString());
        JSONObject ownershipJson = new JSONObject();
        username.map(un -> ownershipJson.put((Object)"username", un));
        groupId.map(gid -> ownershipJson.put((Object)"groupId", (Object)gid.toString()));
        displayName.map(dn -> ownershipJson.put((Object)"displayName", dn));
        StringEntity entity = new StringEntity(ownershipJson.toJSONString(), "UTF-8");
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)entity);
        this.authenticate((HttpRequest)putRequest);
        CloseableHttpResponse response = this.createHttpClient().execute((HttpUriRequest)putRequest);
        if (response.getStatusLine().getStatusCode() >= 300) {
            throw new IllegalArgumentException(response.getStatusLine().getReasonPhrase());
        }
    }

    @Override
    public Map<UUID, Set<String>> getAccessControlLists(HasPermissions type, TypeRelativeObjectIdentifier typeRelativeObjectId) throws ClientProtocolException, IOException, ParseException {
        URL getGroupAndUserOwnerUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/ownership/" + type.getName() + "/" + typeRelativeObjectId.toString() + "/" + "acl");
        HttpGet getRequest = new HttpGet(getGroupAndUserOwnerUrl.toString());
        JSONObject aclJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getRequest).getA();
        HashMap<UUID, Set<String>> result = new HashMap<UUID, Set<String>>();
        JSONArray actionsByUserGroups = (JSONArray)aclJson.get((Object)"acl");
        for (Object actionsByUserGroup : actionsByUserGroups) {
            JSONObject actionsByUserGroupJson = (JSONObject)actionsByUserGroup;
            Object groupIdAsString = actionsByUserGroupJson.get((Object)"groupId");
            UUID groupId = groupIdAsString == null ? null : UUID.fromString(groupIdAsString.toString());
            JSONArray actions = (JSONArray)actionsByUserGroupJson.get((Object)"actions");
            HashSet<String> actionStringSet = new HashSet<String>();
            for (Object action : actions) {
                actionStringSet.add(action.toString());
            }
            result.put(groupId, actionStringSet);
        }
        return result;
    }

    @Override
    public void setAccessControlLists(HasPermissions type, TypeRelativeObjectIdentifier typeRelativeObjectId, Map<UUID, Set<String>> actionsPerGroup) throws ClientProtocolException, IOException, ParseException {
        URL setGroupAndUserOwnerUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/ownership/" + type.getName() + "/" + typeRelativeObjectId.toString() + "/" + "acl");
        HttpPut putRequest = new HttpPut(setGroupAndUserOwnerUrl.toString());
        JSONObject aclJson = new JSONObject();
        JSONArray actionsByUserGroupJson = new JSONArray();
        aclJson.put((Object)"acl", (Object)actionsByUserGroupJson);
        for (Map.Entry<UUID, Set<String>> e : actionsPerGroup.entrySet()) {
            JSONObject groupIdAndPermissions = new JSONObject();
            groupIdAndPermissions.put((Object)"groupId", e.getKey() == null ? null : e.getKey().toString());
            JSONArray actionsJson = new JSONArray();
            actionsJson.addAll((Collection)e.getValue());
            groupIdAndPermissions.put((Object)"actions", (Object)actionsJson);
            actionsByUserGroupJson.add((Object)groupIdAndPermissions);
        }
        StringEntity entity = new StringEntity(aclJson.toJSONString(), "UTF-8");
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)entity);
        this.authenticate((HttpRequest)putRequest);
        CloseableHttpResponse response = this.createHttpClient().execute((HttpUriRequest)putRequest);
        if (response.getStatusLine().getStatusCode() >= 300) {
            throw new IllegalArgumentException(response.getStatusLine().getReasonPhrase());
        }
    }

    @Override
    public Iterable<Util.Pair<WildcardPermission, Boolean>> hasPermissions(Iterable<WildcardPermission> permissions) throws ClientProtocolException, IOException, ParseException {
        StringBuilder sb = new StringBuilder("security/api/restsecurity/has_permission?");
        for (WildcardPermission permission : permissions) {
            sb.append("permission");
            sb.append('=');
            sb.append(URLEncoder.encode(permission.toString(), "UTF-8"));
            sb.append('&');
        }
        sb.delete(sb.length() - 1, sb.length());
        URL getPermissionsUrl = new URL(this.getBaseUrl(), sb.toString());
        HttpGet getRequest = new HttpGet(getPermissionsUrl.toString());
        JSONArray permissionsJson = (JSONArray)this.getJsonParsedResponse((HttpUriRequest)getRequest).getA();
        ArrayList<Util.Pair<WildcardPermission, Boolean>> result = new ArrayList<Util.Pair<WildcardPermission, Boolean>>();
        for (Object o : permissionsJson) {
            JSONObject permissionAndGranted = (JSONObject)o;
            String permissionAsString = permissionAndGranted.get((Object)"permission").toString();
            Boolean permissionGranted = (Boolean)permissionAndGranted.get((Object)"granted");
            result.add((Util.Pair<WildcardPermission, Boolean>)new Util.Pair((Object)new WildcardPermission(permissionAsString), (Object)permissionGranted));
        }
        return result;
    }

    @Override
    public String getUsername() throws ClientProtocolException, IOException, ParseException {
        URL getUsernameUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/access_token");
        HttpGet getRequest = new HttpGet(getUsernameUrl.toString());
        JSONObject accessTokenJson = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getRequest).getA();
        Object usernameValue = accessTokenJson.get((Object)"username");
        String username = usernameValue == null ? null : usernameValue.toString();
        return username;
    }

    @Override
    public Iterable<String> getNamesOfUsersInGroup(UUID userGroupId) throws ClientProtocolException, IOException, ParseException {
        URL addUserToGroupUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/usergroup/" + userGroupId.toString());
        HttpGet getRequest = new HttpGet(addUserToGroupUrl.toString());
        Util.Pair<Object, Integer> result = this.getJsonParsedResponse((HttpUriRequest)getRequest);
        if (((Integer)result.getB()).intValue() == Response.Status.FORBIDDEN.getStatusCode() || ((Integer)result.getB()).intValue() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            throw new AuthorizationException("Not allowed to access group with ID " + userGroupId + ": " + result.getA());
        }
        JSONObject userGroupJson = (JSONObject)result.getA();
        JSONArray usersInGroup = (JSONArray)userGroupJson.get((Object)"users");
        return Util.map((Iterable)usersInGroup, u -> u.toString());
    }

    @Override
    public void addUserToGroup(UUID userGroupId, String username) throws ClientProtocolException, IOException, ParseException {
        if (!Util.contains(this.getNamesOfUsersInGroup(userGroupId), (Object)username)) {
            URL addUserToGroupUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/usergroup/" + userGroupId.toString() + "/user" + "/" + username);
            HttpPut putRequest = new HttpPut(addUserToGroupUrl.toString());
            Util.Pair<Object, Integer> result = this.getJsonParsedResponse((HttpUriRequest)putRequest);
            Integer status = (Integer)result.getB();
            if (status.intValue() == Response.Status.FORBIDDEN.getStatusCode() || status.intValue() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new AuthorizationException("Not allowed to access group with ID " + userGroupId + ": " + result.getA());
            }
            if (status < 200 || status >= 300) {
                throw new IllegalArgumentException("Couldn't add user " + username + " to user group with ID " + userGroupId + ": " + result.getA());
            }
        }
    }

    @Override
    public void removeUserFromGroup(UUID userGroupId, String username) throws ClientProtocolException, IOException, ParseException {
        if (Util.contains(this.getNamesOfUsersInGroup(userGroupId), (Object)username)) {
            URL removeUserFromGroupUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/usergroup/" + userGroupId.toString() + "/user" + "/" + username);
            HttpDelete putRequest = new HttpDelete(removeUserFromGroupUrl.toString());
            Util.Pair<Object, Integer> result = this.getJsonParsedResponse((HttpUriRequest)putRequest);
            Integer status = (Integer)result.getB();
            if (status.intValue() == Response.Status.FORBIDDEN.getStatusCode() || status.intValue() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new AuthorizationException("Not allowed to access group with ID " + userGroupId + ": " + result.getA());
            }
            if (status < 200 || status >= 300) {
                throw new IllegalArgumentException("Couldn't remove user " + username + " from user group with ID " + userGroupId + ": " + result.getA());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public UUID createUserGroupAndAddCurrentUser(String userGroupName) throws ClientProtocolException, IOException, ParseException, IllegalAccessException {
        if (this.getUserGroupIdByName(userGroupName) == null) {
            JSONObject paramPayload = new JSONObject();
            paramPayload.put((Object)"groupName", (Object)userGroupName);
            URL createUserGroupUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/usergroup");
            HttpPut putRequest = new HttpPut(createUserGroupUrl.toString());
            putRequest.setEntity((HttpEntity)new StringEntity(paramPayload.toJSONString(), "UTF-8"));
            putRequest.setHeader("Content-Type", "application/json");
            Util.Pair<Object, Integer> response = this.getJsonParsedResponse((HttpUriRequest)putRequest);
            if (response.getA() instanceof JSONObject) {
                JSONObject userGroupJson = (JSONObject)response.getA();
                UUID newGroupId = UUID.fromString(userGroupJson.get((Object)"groupId").toString());
                return newGroupId;
            }
            if (((Integer)response.getB()).intValue() == Response.Status.FORBIDDEN.getStatusCode()) throw new AuthorizationException("Not allowed to create group " + userGroupName + ": " + response.getA());
            if (((Integer)response.getB()).intValue() != Response.Status.UNAUTHORIZED.getStatusCode()) throw new IllegalArgumentException("Error trying to create user group " + userGroupName + ": " + response.getA());
            throw new AuthorizationException("Not allowed to create group " + userGroupName + ": " + response.getA());
        }
        logger.warning("User group name " + userGroupName + " already exists on server " + this.getBaseUrl() + ". Not creating again.");
        return null;
    }

    @Override
    public void addRoleToUser(UUID roleId, String username, UUID qualifiedForGroupWithId, String qualifiedForUserWithName, boolean transitive) throws ClientProtocolException, IOException, ParseException {
        URL addRoleToUserUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/add_role_to_user?username=" + username + "&" + "role_definition_id" + "=" + roleId.toString() + (qualifiedForGroupWithId == null ? "" : "&qualifying_group_id=" + qualifiedForGroupWithId.toString()) + (qualifiedForUserWithName == null ? "" : "&qualifying_username=" + qualifiedForUserWithName) + "&" + "transitive" + "=" + transitive);
        HttpPut putRequest = new HttpPut(addRoleToUserUrl.toString());
        Util.Pair<Object, Integer> result = this.getJsonParsedResponse((HttpUriRequest)putRequest);
        Integer status = (Integer)result.getB();
        if (status.intValue() == Response.Status.FORBIDDEN.getStatusCode() || status.intValue() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            throw new AuthorizationException("Not allowed to add role with ID " + roleId + " to user " + username + ": " + result.getA());
        }
        if (status < 200 || status >= 300) {
            throw new IllegalArgumentException("Couldn't add role with ID " + roleId + " to user " + username + ": " + result.getA());
        }
    }

    @Override
    public Iterable<SecuredServer.RoleDescriptor> getRoles(String username) throws ClientProtocolException, IOException, ParseException {
        URL getRolesForUserUrl = new URL(this.getBaseUrl(), "security/api/restsecurity/get_roles_for_user" + (username == null ? "" : "?username=" + username));
        HttpGet getRequest = new HttpGet(getRolesForUserUrl.toString());
        Util.Pair<Object, Integer> result = this.getJsonParsedResponse((HttpUriRequest)getRequest);
        Integer status = (Integer)result.getB();
        if (status.intValue() == Response.Status.FORBIDDEN.getStatusCode() || status.intValue() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            throw new AuthorizationException("Not allowed to get roles for user " + username + " to user " + username + ": " + result.getA());
        }
        if (status < 200 || status >= 300) {
            throw new IllegalArgumentException("Couldn't get roles from user " + username + ": " + result.getA());
        }
        return Util.map((Iterable)((JSONArray)result.getA()), jsonRole -> new SecuredServer.RoleDescriptor(jsonRole){
            final JSONObject jsonRoleObject;
            {
                this.jsonRoleObject = (JSONObject)object;
            }

            @Override
            public UUID getRoleDefinitionId() {
                return UUID.fromString(this.jsonRoleObject.get((Object)"role_definition_id").toString());
            }

            @Override
            public UUID getQualifiedForGroupWithId() {
                return this.jsonRoleObject.get((Object)"qualifying_group_id") == null ? null : UUID.fromString(this.jsonRoleObject.get((Object)"qualifying_group_id").toString());
            }

            @Override
            public String getQualifiedForUserWithName() {
                return this.jsonRoleObject.get((Object)"qualifying_username") == null ? null : this.jsonRoleObject.get((Object)"qualifying_username").toString();
            }

            @Override
            public Boolean isTransitive() {
                return this.jsonRoleObject.get((Object)"transitive") == null ? null : (Boolean)this.jsonRoleObject.get((Object)"transitive");
            }
        });
    }

    public String toString() {
        return this.getBaseUrl().toString();
    }
}

