/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.util;

import com.sap.sse.common.Duration;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class RemoteServerUtil {
    private static final Logger logger = Logger.getLogger(RemoteServerUtil.class.getName());

    private RemoteServerUtil() {
    }

    public static String resolveBearerTokenForRemoteServer(String remoteServerUrl, String username, String password) {
        try {
            return RemoteServerUtil.resolveBearerTokenForRemoteServer(RemoteServerUtil.createBaseUrl(remoteServerUrl), username, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String resolveBearerTokenForRemoteServer(String hostname, int port, String username, String password) {
        try {
            return RemoteServerUtil.resolveBearerTokenForRemoteServer(RemoteServerUtil.getBaseServerUrl(hostname, port), username, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getBaseServerUrl(String hostname, int port) throws MalformedURLException {
        return new URL(port == 443 ? "https" : "http", hostname, port, "");
    }

    private static String resolveBearerTokenForRemoteServer(URL base, String username, String password) throws Exception {
        String token = "";
        if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
            int length;
            String path = "/security/api/restsecurity/access_token";
            URL serverAddress = RemoteServerUtil.createRemoteServerUrl(base, path, null);
            URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)serverAddress, (Duration)Duration.ONE_MINUTE, t -> {
                String auth = String.valueOf(username) + ":" + password;
                String base64 = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
                t.setRequestProperty("Authorization", "Basic " + base64);
            });
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = connection.getInputStream().read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String jsonToken = result.toString("UTF-8");
            Object requestBody = JSONValue.parseWithException((String)jsonToken);
            if (requestBody instanceof JSONObject) {
                JSONObject json = (JSONObject)requestBody;
                Object tokenObj = json.get((Object)"access_token");
                if (tokenObj instanceof String) {
                    token = (String)tokenObj;
                    logger.info("Obtained access token for user " + username);
                } else {
                    logger.warning("Did not find access token for user " + username);
                }
            } else {
                throw new RuntimeException("Could not obtain token for server");
            }
        }
        return token;
    }

    public static URL createBaseUrl(String urlAsString) throws MalformedURLException {
        URL url;
        String urlAsStringWithTrailingSlashRemoved = urlAsString == null ? null : (urlAsString.length() > 0 && urlAsString.charAt(urlAsString.length() - 1) == '/' ? urlAsString.substring(0, urlAsString.length() - 1) : urlAsString);
        try {
            url = new URL(urlAsStringWithTrailingSlashRemoved);
        }
        catch (MalformedURLException e1) {
            String urlAsStringAfterFormatting = urlAsStringWithTrailingSlashRemoved;
            if (urlAsStringAfterFormatting.contains("://")) {
                urlAsStringAfterFormatting = urlAsStringWithTrailingSlashRemoved.split("://")[1];
            }
            url = new URL("http://" + urlAsStringAfterFormatting);
        }
        return url;
    }

    public static URL createRemoteServerUrl(URL base, String pathWithLeadingSlash, String query) throws Exception {
        URL url = query != null ? new URL(String.valueOf(base.toExternalForm()) + pathWithLeadingSlash + "?" + query) : new URL(String.valueOf(base.toExternalForm()) + pathWithLeadingSlash);
        return url;
    }
}

