/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.ListResult;
import com.chargebee.internal.ListRequest;
import com.chargebee.models.Subscription;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiRequest;
import com.sap.sse.security.subscription.chargebee.ChargebeeInternalApiRequestWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChargebeeSubscriptionRequest
extends ChargebeeApiRequest {
    private static final Logger logger = Logger.getLogger(ChargebeeSubscriptionRequest.class.getName());
    private final String subscriptionId;
    private final OnResultListener listener;

    public ChargebeeSubscriptionRequest(String subscriptionId, OnResultListener listener, SubscriptionApiRequestProcessor requestProcessor, SubscriptionApiBaseService chargebeeApiServiceParams) {
        super(requestProcessor, chargebeeApiServiceParams);
        this.subscriptionId = subscriptionId;
        this.listener = listener;
    }

    @Override
    protected ChargebeeInternalApiRequestWrapper createRequest() {
        logger.info(() -> "Fetch Chargebee subscription, subscription id: " + this.subscriptionId);
        Subscription.SubscriptionListRequest request = ((Subscription.SubscriptionListRequest)((Subscription.SubscriptionListRequest)Subscription.list().limit(1)).id().is(this.subscriptionId)).includeDeleted(Boolean.valueOf(false));
        return new ChargebeeInternalApiRequestWrapper((ListRequest<?>)request);
    }

    @Override
    protected void processResult(ChargebeeInternalApiRequestWrapper request) {
        ListResult result = request.getListResult();
        Subscription subscription = result != null && !result.isEmpty() ? ((ListResult.Entry)result.get(0)).subscription() : null;
        this.onDone(subscription);
    }

    @Override
    protected void handleError(Exception e) {
        logger.log(Level.SEVERE, "Fetch Chargebee subscription failed, subscription id: " + this.subscriptionId, e);
        this.onDone(null);
    }

    private void onDone(Subscription subscription) {
        if (this.listener != null) {
            this.listener.onSubscriptionResult(subscription);
        }
    }

    public static interface OnResultListener {
        public void onSubscriptionResult(Subscription var1);
    }
}

