/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.Result;
import com.chargebee.internal.Request;
import com.chargebee.models.Subscription;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiRequest;
import com.sap.sse.security.subscription.chargebee.ChargebeeInternalApiRequestWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChargebeeNonRenewingSubscriptionRequest
extends ChargebeeApiRequest {
    private static final Logger logger = Logger.getLogger(ChargebeeNonRenewingSubscriptionRequest.class.getName());
    private final String subscriptionId;
    private final OnResultListener listener;

    public ChargebeeNonRenewingSubscriptionRequest(String subscriptionId, OnResultListener listener, SubscriptionApiRequestProcessor requestProcessor, SubscriptionApiBaseService chargebeeApiServiceParams) {
        super(requestProcessor, chargebeeApiServiceParams);
        this.subscriptionId = subscriptionId;
        this.listener = listener;
    }

    @Override
    protected ChargebeeInternalApiRequestWrapper createRequest() {
        logger.info(() -> "Set Chargebee subscription to non renewing, subscription id: " + this.subscriptionId);
        Subscription.CancelForItemsRequest request = Subscription.cancelForItems((String)this.subscriptionId).endOfTerm(Boolean.valueOf(true));
        return new ChargebeeInternalApiRequestWrapper((Request<?>)request);
    }

    @Override
    protected void processResult(ChargebeeInternalApiRequestWrapper request) {
        Result result = request.getResult();
        if (result != null) {
            this.onDone(result.subscription());
        } else {
            this.onDone(null);
        }
    }

    @Override
    protected void handleError(Exception e) {
        logger.log(Level.SEVERE, "Setting Chargebee subscription to non renewing failed, subscription id: " + this.subscriptionId, e);
        this.onDone(null);
    }

    private void onDone(Subscription subscription) {
        if (this.listener != null) {
            this.listener.onSubscriptionNonRenewingResult(subscription);
        }
    }

    public static interface OnResultListener {
        public void onSubscriptionNonRenewingResult(Subscription var1);
    }
}

