/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.shared.subscription.chargebee.ChargebeeSubscription;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiSubscriptionData;
import com.sap.sse.security.subscription.chargebee.ChargebeeSubscriptionListRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ChargebeeFetchUserSubscriptionsTask
implements ChargebeeSubscriptionListRequest.OnResultListener {
    private static final Logger logger = Logger.getLogger(ChargebeeFetchUserSubscriptionsTask.class.getName());
    private final SubscriptionApiRequestProcessor requestProcessor;
    private final OnResultListener listener;
    private Map<String, List<Subscription>> userSubscriptions;
    private final SubscriptionApiBaseService chargebeeApiServiceParams;

    public ChargebeeFetchUserSubscriptionsTask(SubscriptionApiRequestProcessor requestProcessor, OnResultListener listener, SubscriptionApiBaseService chargebeeApiServiceParams) {
        this.requestProcessor = requestProcessor;
        this.listener = listener;
        this.chargebeeApiServiceParams = chargebeeApiServiceParams;
    }

    public void run() {
        this.fetchSubscriptionList(null);
    }

    @Override
    public void onSubscriptionListResult(Iterable<ChargebeeApiSubscriptionData> subscriptions, String nextOffset) {
        if (subscriptions != null) {
            if (this.userSubscriptions == null) {
                this.userSubscriptions = new HashMap<String, List<Subscription>>();
            }
            for (ChargebeeApiSubscriptionData sub : subscriptions) {
                List<Object> list;
                ChargebeeSubscription subscription = sub.toSubscription(this.chargebeeApiServiceParams.getSubscriptionPlanProvider());
                String customerId = subscription.getCustomerId();
                if (this.userSubscriptions.containsKey(customerId)) {
                    list = this.userSubscriptions.get(customerId);
                } else {
                    list = new ArrayList();
                    this.userSubscriptions.put(customerId, list);
                }
                list.add(subscription);
            }
        } else {
            this.userSubscriptions = null;
            this.onDone();
        }
        if (nextOffset == null || nextOffset.isEmpty()) {
            this.onDone();
        } else {
            this.fetchSubscriptionList(nextOffset);
        }
    }

    private void fetchSubscriptionList(String offset) {
        logger.info(() -> "Schedule fetch Chargebee subscriptions, offset: " + (offset == null ? "" : offset));
        this.requestProcessor.addRequest(new ChargebeeSubscriptionListRequest(offset, this, this.requestProcessor, this.chargebeeApiServiceParams));
    }

    private void onDone() {
        if (this.listener != null) {
            this.listener.onSubscriptionsResult(this.userSubscriptions);
        }
    }

    @FunctionalInterface
    public static interface OnResultListener {
        public void onSubscriptionsResult(Map<String, List<Subscription>> var1);
    }
}

