/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.Environment;
import com.sap.sse.common.Duration;
import com.sap.sse.security.shared.SubscriptionPlanProvider;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.SubscriptionApiService;
import com.sap.sse.security.subscription.SubscriptionDataHandler;
import com.sap.sse.security.subscription.chargebee.ChargeBeeGetSelfServicePortalSessionTask;
import com.sap.sse.security.subscription.chargebee.ChargebeeCancelSubscriptionTask;
import com.sap.sse.security.subscription.chargebee.ChargebeeConfiguration;
import com.sap.sse.security.subscription.chargebee.ChargebeeFetchItemPricesTask;
import com.sap.sse.security.subscription.chargebee.ChargebeeFetchUserSubscriptionsTask;
import com.sap.sse.security.subscription.chargebee.ChargebeeNonRenewingSubscriptionTask;
import com.sap.sse.security.subscription.chargebee.ChargebeeSubscriptionDataHandler;

public class ChargebeeApiService
implements SubscriptionApiService {
    private final boolean active;
    private final SubscriptionApiRequestProcessor requestProcessor;
    private static final Duration TIME_BETWEEN_API_REQUEST_START = Duration.ONE_MILLISECOND.times(400L);
    private static final Duration LIMIT_REACHED_RESUME_DELAY = Duration.ONE_MILLISECOND.times(65000L);
    protected final SubscriptionPlanProvider subscriptionPlanProvider;

    public ChargebeeApiService(ChargebeeConfiguration configuration, SubscriptionApiRequestProcessor requestProcessor, SubscriptionPlanProvider subscriptionPlanProvider) {
        this.subscriptionPlanProvider = subscriptionPlanProvider;
        if (configuration != null) {
            Environment.configure((String)configuration.getSite(), (String)configuration.getApiKey());
            this.active = true;
        } else {
            this.active = false;
        }
        this.requestProcessor = requestProcessor;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getProviderName() {
        return "chargebee";
    }

    @Override
    public Duration getTimeBetweenApiRequestStart() {
        return TIME_BETWEEN_API_REQUEST_START;
    }

    @Override
    public Duration getLimitReachedResumeDelay() {
        return LIMIT_REACHED_RESUME_DELAY;
    }

    @Override
    public void getUserSubscriptions(SubscriptionApiService.OnSubscriptionsResultListener listener) {
        new ChargebeeFetchUserSubscriptionsTask(this.requestProcessor, subscriptions -> listener.onSubscriptionsResult(subscriptions), this).run();
    }

    @Override
    public void cancelSubscription(String subscriptionId, SubscriptionApiService.OnCancelSubscriptionResultListener listener) {
        new ChargebeeCancelSubscriptionTask(subscriptionId, this.requestProcessor, result -> listener.onCancelResult(result), this).run();
    }

    @Override
    public void nonRenewingSubscription(String subscriptionId, SubscriptionApiService.OnNonRenewingSubscriptionResultListener listener) {
        new ChargebeeNonRenewingSubscriptionTask(subscriptionId, this.requestProcessor, result -> listener.onNonRenewingResult(result), this).run();
    }

    @Override
    public void getUserSelfServicePortalSession(String userId, SubscriptionApiService.OnSelfServicePortalSessionResultListener listener) {
        new ChargeBeeGetSelfServicePortalSessionTask(userId, this.requestProcessor, result -> listener.onSessionResult(result), this).run();
    }

    @Override
    public SubscriptionDataHandler getDataHandler() {
        return new ChargebeeSubscriptionDataHandler();
    }

    @Override
    public SubscriptionPlanProvider getSubscriptionPlanProvider() {
        return this.subscriptionPlanProvider;
    }

    @Override
    public void getItemPrices(SubscriptionApiService.OnItemPriceResultListener listener) {
        new ChargebeeFetchItemPricesTask(this.requestProcessor, result -> listener.onItemPriceResult(result), this).run();
    }
}

