/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.models.PortalSession;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeSelfServicePortalSessionRequest;
import java.util.logging.Logger;

public class ChargeBeeGetSelfServicePortalSessionTask
implements ChargebeeSelfServicePortalSessionRequest.OnResultListener {
    private static final Logger logger = Logger.getLogger(ChargeBeeGetSelfServicePortalSessionTask.class.getName());
    private final String userId;
    private final SubscriptionApiRequestProcessor requestProcessor;
    private final OnResultListener listener;
    private final SubscriptionApiBaseService chargebeeApiServiceParams;

    public ChargeBeeGetSelfServicePortalSessionTask(String userId, SubscriptionApiRequestProcessor requestProcessor, OnResultListener listener, SubscriptionApiBaseService chargebeeApiServiceParams) {
        this.userId = userId;
        this.requestProcessor = requestProcessor;
        this.listener = listener;
        this.chargebeeApiServiceParams = chargebeeApiServiceParams;
    }

    public void run() {
        logger.info(() -> "Schedule fetch of self service portal session, user id: " + this.userId);
        this.requestProcessor.addRequest(new ChargebeeSelfServicePortalSessionRequest(this.userId, this, this.requestProcessor, this.chargebeeApiServiceParams));
    }

    @Override
    public void onSessionResult(PortalSession session) {
        this.listener.onSessionResult(session);
    }

    @FunctionalInterface
    public static interface OnResultListener {
        public void onSessionResult(PortalSession var1);
    }
}

