/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.impl;

import com.nulabinc.zxcvbn.StandardDictionaries;
import com.nulabinc.zxcvbn.StandardKeyboards;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.Zxcvbn;
import com.nulabinc.zxcvbn.ZxcvbnBuilder;
import com.nulabinc.zxcvbn.io.ClasspathResource;
import com.nulabinc.zxcvbn.io.Resource;
import com.nulabinc.zxcvbn.matchers.SlantedKeyboardLoader;
import com.sap.sse.ServerInfo;
import com.sap.sse.branding.BrandingConfigurationService;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimedLock;
import com.sap.sse.common.Util;
import com.sap.sse.common.http.HttpHeaderUtil;
import com.sap.sse.common.impl.TimedLockImpl;
import com.sap.sse.common.mail.MailException;
import com.sap.sse.common.media.TakedownNoticeRequestContext;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.mail.MailService;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import com.sap.sse.rest.CORSFilterConfiguration;
import com.sap.sse.security.Action;
import com.sap.sse.security.ClientUtils;
import com.sap.sse.security.GithubApi;
import com.sap.sse.security.InstagramApi;
import com.sap.sse.security.OAuthRealm;
import com.sap.sse.security.PermissionChangeListener;
import com.sap.sse.security.SecurityInitializationCustomizer;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.security.ShiroWildcardPermissionFromParts;
import com.sap.sse.security.impl.ObjectInputStreamResolvingAgainstSecurityCache;
import com.sap.sse.security.impl.PermissionChangeListeners;
import com.sap.sse.security.impl.ReplicableSecurityService;
import com.sap.sse.security.impl.ReplicatingCache;
import com.sap.sse.security.impl.ReplicatingCacheManager;
import com.sap.sse.security.impl.SecurityServiceAclResolver;
import com.sap.sse.security.impl.SecurityServiceInitialLoadExtensionsDTO;
import com.sap.sse.security.interfaces.AccessControlStore;
import com.sap.sse.security.interfaces.Credential;
import com.sap.sse.security.interfaces.OAuthToken;
import com.sap.sse.security.interfaces.SocialSettingsKeys;
import com.sap.sse.security.interfaces.UserImpl;
import com.sap.sse.security.interfaces.UserStore;
import com.sap.sse.security.operations.AclAddPermissionOperation;
import com.sap.sse.security.operations.AclPutPermissionsOperation;
import com.sap.sse.security.operations.AclRemovePermissionOperation;
import com.sap.sse.security.operations.AddPermissionForUserOperation;
import com.sap.sse.security.operations.AddRoleForUserOperation;
import com.sap.sse.security.operations.AddSettingOperation;
import com.sap.sse.security.operations.AddUserToUserGroupOperation;
import com.sap.sse.security.operations.CreateRoleDefinitionOperation;
import com.sap.sse.security.operations.CreateUserGroupOperation;
import com.sap.sse.security.operations.CreateUserOperation;
import com.sap.sse.security.operations.DeleteAclOperation;
import com.sap.sse.security.operations.DeleteOwnershipOperation;
import com.sap.sse.security.operations.DeleteRoleDefinitionOperation;
import com.sap.sse.security.operations.DeleteUserGroupOperation;
import com.sap.sse.security.operations.DeleteUserOperation;
import com.sap.sse.security.operations.PutRoleDefinitionToUserGroupOperation;
import com.sap.sse.security.operations.ReleaseBearerTokenLockOnIpOperation;
import com.sap.sse.security.operations.ReleaseUserCreationLockOnIpOperation;
import com.sap.sse.security.operations.RemoveAccessTokenOperation;
import com.sap.sse.security.operations.RemovePermissionForUserOperation;
import com.sap.sse.security.operations.RemoveRoleDefinitionFromUserGroupOperation;
import com.sap.sse.security.operations.RemoveRoleFromUserOperation;
import com.sap.sse.security.operations.RemoveUserFromUserGroupOperation;
import com.sap.sse.security.operations.ResetPasswordOperation;
import com.sap.sse.security.operations.ResetUserLockOperation;
import com.sap.sse.security.operations.SecurityOperation;
import com.sap.sse.security.operations.SetAccessTokenOperation;
import com.sap.sse.security.operations.SetDefaultTenantForServerForUserOperation;
import com.sap.sse.security.operations.SetEmptyAccessControlListOperation;
import com.sap.sse.security.operations.SetOwnershipOperation;
import com.sap.sse.security.operations.SetPreferenceOperation;
import com.sap.sse.security.operations.SetSettingOperation;
import com.sap.sse.security.operations.UnsetPreferenceOperation;
import com.sap.sse.security.operations.UpdateItemPriceOperation;
import com.sap.sse.security.operations.UpdateRoleDefinitionOperation;
import com.sap.sse.security.operations.UpdateSimpleUserEmailOperation;
import com.sap.sse.security.operations.UpdateSimpleUserPasswordOperation;
import com.sap.sse.security.operations.UpdateUserPropertiesOperation;
import com.sap.sse.security.operations.UpdateUserSubscriptionOperation;
import com.sap.sse.security.operations.ValidateEmailOperation;
import com.sap.sse.security.persistence.PersistenceFactory;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.Account;
import com.sap.sse.security.shared.AdminRole;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.HasPermissionsProvider;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.PredefinedRoles;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.RolePrototype;
import com.sap.sse.security.shared.SecurityAccessControlList;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.SubscriptionPlanProvider;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.UserGroupManagementException;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.UserRole;
import com.sap.sse.security.shared.UsernamePasswordAccount;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.PermissionAndRoleAssociation;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.security.shared.subscription.SubscriptionPlanRole;
import com.sap.sse.security.shared.subscription.SubscriptionPrice;
import com.sap.sse.security.util.RemoteServerUtil;
import com.sap.sse.shared.classloading.ClassLoaderRegistry;
import com.sap.sse.shared.util.impl.ApproximateTime;
import com.sap.sse.util.ClearStateTestSupport;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.env.BasicIniEnvironment;
import org.apache.shiro.env.Environment;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.util.SavedRequest;
import org.apache.shiro.web.util.WebUtils;
import org.osgi.util.tracker.ServiceTracker;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.FacebookApi;
import org.scribe.builder.api.FlickrApi;
import org.scribe.builder.api.Foursquare2Api;
import org.scribe.builder.api.GoogleApi;
import org.scribe.builder.api.ImgUrApi;
import org.scribe.builder.api.LinkedInApi;
import org.scribe.builder.api.LiveApi;
import org.scribe.builder.api.TumblrApi;
import org.scribe.builder.api.TwitterApi;
import org.scribe.builder.api.VimeoApi;
import org.scribe.builder.api.YahooApi;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;

public class SecurityServiceImpl
extends AbstractReplicableWithObjectInputStream<ReplicableSecurityService, SecurityOperation<?>>
implements ReplicableSecurityService,
ClearStateTestSupport {
    private static final Logger logger = Logger.getLogger(SecurityServiceImpl.class.getName());
    private static final String ADMIN_DEFAULT_PASSWORD = "admin";
    private final Set<String> migratedHasPermissionTypes = new ConcurrentSkipListSet<String>();
    private SecurityManager securityManager;
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/StringMessages";
    private static final ResourceBundleStringMessages messages = ResourceBundleStringMessages.create((String)"stringmessages/StringMessages", (ClassLoader)SecurityServiceImpl.class.getClassLoader(), (String)StandardCharsets.UTF_8.name());
    private final ReplicatingCacheManager cacheManager;
    private final ConcurrentMap<String, Util.Pair<Boolean, Set<String>>> corsFilterConfigurationsByReplicaSetName;
    private final UserStore store;
    private final AccessControlStore accessControlStore;
    private boolean isInitialOrMigration;
    private boolean isNewServer;
    private final ServiceTracker<MailService, MailService> mailServiceTracker;
    private final ServiceTracker<CORSFilterConfiguration, CORSFilterConfiguration> corsFilterConfigurationTracker;
    private final ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker;
    private ThreadLocal<UserGroup> temporaryDefaultTenant = new InheritableThreadLocal<UserGroup>();
    private static final Ini shiroConfiguration;
    private static final Environment shiroEnvironment;
    private final HasPermissionsProvider hasPermissionsProvider;
    private final SubscriptionPlanProvider subscriptionPlanProvider;
    private String sharedAcrossSubdomainsOf;
    private String baseUrlForCrossDomainStorage;
    private final transient Set<SecurityInitializationCustomizer> customizers = ConcurrentHashMap.newKeySet();
    private final PermissionChecker.AclResolver<AccessControlList, Ownership> aclResolver;
    private final PermissionChangeListeners permissionChangeListeners;
    private final ClassLoaderRegistry initialLoadClassLoaderRegistry = ClassLoaderRegistry.createInstance();
    private final ConcurrentMap<String, TimedLock> clientIPBasedTimedLocksForBearerTokenAuthentication;
    private static final String CLIENT_IP_NULL_ESCAPE;
    private final ConcurrentMap<String, TimedLock> clientIPBasedTimedLocksForUserCreation;
    private final Zxcvbn passwordValidator;
    private static final ConcurrentMap<User, NamedReentrantReadWriteLock> subscriptionLocksForUsers;
    private static final Object userGroupLock;

    static {
        CLIENT_IP_NULL_ESCAPE = UUID.randomUUID().toString();
        shiroConfiguration = new Ini();
        shiroConfiguration.loadFromPath("classpath:shiro.ini");
        shiroEnvironment = new BasicIniEnvironment("classpath:shiro.ini");
        subscriptionLocksForUsers = new ConcurrentHashMap<User, NamedReentrantReadWriteLock>();
        userGroupLock = new Object();
    }

    public SecurityServiceImpl(ServiceTracker<MailService, MailService> mailServiceTracker, ServiceTracker<CORSFilterConfiguration, CORSFilterConfiguration> corsFilterConfigurationTracker, ServiceTracker<BrandingConfigurationService, BrandingConfigurationService> brandingConfigurationServiceTracker, UserStore userStore, AccessControlStore accessControlStore, HasPermissionsProvider hasPermissionsProvider, SubscriptionPlanProvider subscriptionPlanProvider) {
        this(mailServiceTracker, corsFilterConfigurationTracker, null, userStore, accessControlStore, hasPermissionsProvider, subscriptionPlanProvider, null, null);
    }

    public SecurityServiceImpl(ServiceTracker<MailService, MailService> mailServiceTracker, ServiceTracker<CORSFilterConfiguration, CORSFilterConfiguration> corsFilterConfigurationTracker, ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker, UserStore userStore, AccessControlStore accessControlStore, HasPermissionsProvider hasPermissionsProvider, SubscriptionPlanProvider subscriptionPlanProvider, String sharedAcrossSubdomainsOf, String baseUrlForCrossDomainStorage) {
        this.initialLoadClassLoaderRegistry.addClassLoader(this.getClass().getClassLoader());
        if (hasPermissionsProvider == null) {
            throw new IllegalArgumentException("No HasPermissionsProvider defined");
        }
        logger.info("Initializing Security Service with user store " + userStore);
        this.clientIPBasedTimedLocksForBearerTokenAuthentication = new ConcurrentHashMap<String, TimedLock>();
        this.clientIPBasedTimedLocksForUserCreation = new ConcurrentHashMap<String, TimedLock>();
        this.permissionChangeListeners = new PermissionChangeListeners(this);
        this.sharedAcrossSubdomainsOf = sharedAcrossSubdomainsOf;
        this.subscriptionPlanProvider = subscriptionPlanProvider;
        this.baseUrlForCrossDomainStorage = baseUrlForCrossDomainStorage;
        this.store = userStore;
        this.accessControlStore = accessControlStore;
        this.mailServiceTracker = mailServiceTracker;
        this.corsFilterConfigurationTracker = corsFilterConfigurationTracker;
        this.replicationServiceTracker = replicationServiceTracker;
        this.hasPermissionsProvider = hasPermissionsProvider;
        this.cacheManager = this.loadReplicationCacheManagerContents();
        this.corsFilterConfigurationsByReplicaSetName = this.loadCORSFilterConfigurations();
        logger.info("Loaded shiro.ini file from: classpath:shiro.ini");
        StringBuilder logMessage = new StringBuilder("[urls] section from Shiro configuration:");
        Ini.Section urlsSection = shiroConfiguration.getSection("urls");
        if (urlsSection != null) {
            for (Map.Entry e : urlsSection.entrySet()) {
                logMessage.append("\n");
                logMessage.append((String)e.getKey());
                logMessage.append(": ");
                logMessage.append((String)e.getValue());
            }
        }
        logger.info(logMessage.toString());
        System.setProperty("java.net.useSystemProxies", "true");
        SecurityManager securityManager = shiroEnvironment.getSecurityManager();
        logger.info("Created: " + securityManager);
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        this.securityManager = securityManager;
        this.aclResolver = new SecurityServiceAclResolver(accessControlStore);
        try {
            this.passwordValidator = this.createPasswordValidator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Zxcvbn createPasswordValidator() throws IOException {
        ZxcvbnBuilder builder = new ZxcvbnBuilder();
        builder.dictionaries(StandardDictionaries.loadAllDictionaries());
        builder.keyboards(StandardKeyboards.loadAllKeyboards());
        return builder.keyboard(new SlantedKeyboardLoader("qwertz", (Resource)new ClasspathResource("qwertz-keyboard.txt")).load()).build();
    }

    public ClassLoader getDeserializationClassLoader() {
        return this.initialLoadClassLoaderRegistry.getCombinedMasterDataClassLoader();
    }

    @Override
    public ClassLoaderRegistry getInitialLoadClassLoaderRegistry() {
        return this.initialLoadClassLoaderRegistry;
    }

    private ReplicatingCacheManager loadReplicationCacheManagerContents() {
        logger.info("Loading session cache manager contents");
        int count = 0;
        ReplicatingCacheManager result = new ReplicatingCacheManager();
        for (Map.Entry cacheNameAndSessions : PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory().loadSessionsByCacheName().entrySet()) {
            String cacheName = (String)cacheNameAndSessions.getKey();
            ReplicatingCache cache = (ReplicatingCache)result.getCache(cacheName, this);
            for (Session session : (Set)cacheNameAndSessions.getValue()) {
                cache.put(session.getId(), session, false);
                ++count;
            }
        }
        logger.info("Loaded " + count + " sessions");
        return result;
    }

    private ConcurrentMap<String, Util.Pair<Boolean, Set<String>>> loadCORSFilterConfigurations() {
        logger.info("Loading CORS filter configurations");
        ConcurrentHashMap<String, Util.Pair<Boolean, Set<String>>> result = new ConcurrentHashMap<String, Util.Pair<Boolean, Set<String>>>();
        result.putAll(PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory().loadCORSFilterConfigurationsForReplicaSetNames());
        if (result.containsKey(ServerInfo.getName())) {
            Util.Pair thisServersCORSFilterConfig = (Util.Pair)result.get(ServerInfo.getName());
            if (((Boolean)thisServersCORSFilterConfig.getA()).booleanValue()) {
                this.getCORSFilterConfiguration().setWildcard();
            } else {
                this.getCORSFilterConfiguration().setOrigins((Iterable)thisServersCORSFilterConfig.getB());
            }
        }
        return result;
    }

    @Override
    public Iterable<? extends HasPermissions> getAllHasPermissions() {
        return this.hasPermissionsProvider.getAllHasPermissions();
    }

    @Override
    public Map<Serializable, SubscriptionPlan> getAllSubscriptionPlans() {
        return this.subscriptionPlanProvider.getAllSubscriptionPlans();
    }

    @Override
    public SubscriptionPlan getSubscriptionPlanById(String planId) {
        return (SubscriptionPlan)this.subscriptionPlanProvider.getAllSubscriptionPlans().get(planId);
    }

    @Override
    public SubscriptionPlan getSubscriptionPlanByItemPriceId(String itemPriceId) {
        SubscriptionPlan result = null;
        Map<Serializable, SubscriptionPlan> allSubscriptionPlans = this.getAllSubscriptionPlans();
        for (SubscriptionPlan plan : allSubscriptionPlans.values()) {
            for (SubscriptionPrice price : plan.getPrices()) {
                if (!itemPriceId.equals(price.getPriceId())) continue;
                result = plan;
            }
        }
        return result;
    }

    @Override
    public void initialize() {
        this.initEmptyStore();
        this.initEmptyAccessControlStore();
    }

    private void initEmptyStore() {
        AdminRole adminRolePrototype = AdminRole.getInstance();
        RoleDefinition adminRoleDefinition = this.getRoleDefinition(adminRolePrototype.getId());
        assert (adminRoleDefinition != null);
        try {
            this.isInitialOrMigration = false;
            if (!this.store.hasUsers()) {
                this.isInitialOrMigration = true;
                logger.info("No users found, creating default user \"admin\" with password \"admin\"");
                User adminUser = this.createSimpleUser(ADMIN_DEFAULT_PASSWORD, "nobody@sapsailing.com", ADMIN_DEFAULT_PASSWORD, null, null, Locale.ENGLISH, null, null, null, false);
                this.setOwnership(adminUser.getIdentifier(), adminUser, null);
                Role adminRole = new Role(adminRoleDefinition, Boolean.valueOf(true));
                this.addRoleForUserAndSetUserAsOwner(adminUser, adminRole);
                UserGroup defaultTenant = this.getServerGroup();
                this.addUserToUserGroup(defaultTenant, adminUser);
                this.setDefaultTenantForCurrentServerForUser(adminUser.getName(), defaultTenant.getId());
            }
            if (this.store.getUserByName("<all>") == null) {
                this.isInitialOrMigration = true;
                this.isNewServer = true;
                logger.info("<all> not found -> creating it now");
                User allUser = (User)this.apply(new CreateUserOperation("<all>", null, new Account[0]));
                this.setOwnership(allUser.getIdentifier(), null, this.getServerGroup());
                WildcardPermission createUserPermission = SecuredSecurityTypes.USER.getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.CREATE});
                this.addPermissionForUser("<all>", createUserPermission);
                QualifiedObjectIdentifier qualifiedTypeIdentifierForPermission = SecuredSecurityTypes.PERMISSION_ASSOCIATION.getQualifiedObjectIdentifier(PermissionAndRoleAssociation.get((WildcardPermission)createUserPermission, (User)allUser));
                this.setOwnership(qualifiedTypeIdentifierForPermission, null, this.getServerGroup());
            }
            if (this.isInitialOrMigration) {
                for (UUID predefinedRoleId : this.getPredefinedRoleIds()) {
                    RoleDefinition predefinedRole = this.getRoleDefinition(predefinedRoleId);
                    if (predefinedRole == null) continue;
                    this.addToAccessControlList(predefinedRole.getIdentifier(), null, HasPermissions.DefaultActions.READ.name());
                }
            }
        }
        catch (MailException | UserGroupManagementException | UserManagementException e) {
            logger.log(Level.SEVERE, "Exception while creating default admin and <all> user", e);
        }
    }

    private Iterable<UUID> getPredefinedRoleIds() {
        HashSet<UUID> predefinedRoleIds = new HashSet<UUID>();
        predefinedRoleIds.add(AdminRole.getInstance().getId());
        predefinedRoleIds.add(UserRole.getInstance().getId());
        PredefinedRoles[] predefinedRolesArray = PredefinedRoles.values();
        int n = predefinedRolesArray.length;
        int n2 = 0;
        while (n2 < n) {
            PredefinedRoles otherPredefinedRole = predefinedRolesArray[n2];
            predefinedRoleIds.add(otherPredefinedRole.getId());
            ++n2;
        }
        return predefinedRoleIds;
    }

    private void initEmptyAccessControlStore() {
    }

    private MailService getMailService() {
        return this.mailServiceTracker == null ? null : (MailService)this.mailServiceTracker.getService();
    }

    private CORSFilterConfiguration getCORSFilterConfiguration() {
        return this.corsFilterConfigurationTracker == null ? null : (CORSFilterConfiguration)this.corsFilterConfigurationTracker.getService();
    }

    private ReplicationService getReplicationService() {
        return this.replicationServiceTracker == null ? null : (ReplicationService)this.replicationServiceTracker.getService();
    }

    @Override
    public void sendMail(String username, String subject, String body) throws MailException {
        String toAddress;
        User user = this.getUserByName(username);
        if (user != null && (toAddress = user.getEmail()) != null) {
            MailService mailService = this.getMailService();
            if (mailService == null) {
                logger.warning(String.format("Could not send mail to user %s: no MailService found", username));
            } else {
                this.getMailService().sendMail(toAddress, subject, body);
            }
        }
    }

    @Override
    public void resetPassword(String username, String passwordResetBaseURL) throws UserManagementException, MailException {
        final User user = this.store.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        if (!user.isEmailValidated()) {
            throw new UserManagementException("Cannot reset password without validated e-mail address");
        }
        String passwordResetSecret = user.createRandomSecret();
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is starting password reset for user " + username);
        this.apply(new ResetPasswordOperation(username, passwordResetSecret));
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        try {
            urlParameters.put("u", URLEncoder.encode(user.getName(), "UTF-8"));
            urlParameters.put("e", URLEncoder.encode(user.getEmail(), "UTF-8"));
            urlParameters.put("s", URLEncoder.encode(passwordResetSecret, "UTF-8"));
            final StringBuilder url = this.buildURL(passwordResetBaseURL, urlParameters);
            new Thread("sending password reset e-mail to user " + username){

                @Override
                public void run() {
                    try {
                        SecurityServiceImpl.this.sendMail(user.getName(), "Password Reset", "Please click on the link below to reset your password for user " + user.getName() + ".\n   " + url.toString());
                    }
                    catch (MailException e) {
                        logger.log(Level.SEVERE, "Error sending mail for password reset of user " + user.getName() + " to address " + user.getEmail(), e);
                    }
                }
            }.start();
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "Internal error: encoding UTF-8 not found. Couldn't send e-mail to user " + user.getName() + " at e-mail address " + user.getEmail(), e);
        }
    }

    @Override
    public Void internalResetPassword(String username, String passwordResetSecret) {
        logger.info("Password reset for user " + username + " requested");
        this.getUserByName(username).startPasswordReset(passwordResetSecret);
        return null;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public OwnershipAnnotation getOwnership(QualifiedObjectIdentifier idOfOwnedObjectAsString) {
        return this.accessControlStore.getOwnership(idOfOwnedObjectAsString);
    }

    private UserGroup getDefaultTenantForUser(User user) {
        UserGroup specificTenant = this.temporaryDefaultTenant.get();
        if (specificTenant == null && (specificTenant = user.getDefaultTenant(ServerInfo.getName())) == null) {
            String defaultTenantName = this.getDefaultTenantNameForUsername(user.getName());
            specificTenant = this.getUserGroupByName(defaultTenantName);
        }
        return specificTenant;
    }

    @Override
    public UserGroup getDefaultTenantForCurrentUser() {
        if (SecurityUtils.getSecurityManager() != null && this.getCurrentUser() == null) {
            return null;
        }
        return this.getDefaultTenantForUser(this.getCurrentUser());
    }

    @Override
    public void setTemporaryDefaultTenant(UUID tenantGroupId) {
        if (tenantGroupId != null || this.getCurrentUser() == null) {
            UserGroup tenantGroup = this.getUserGroup(tenantGroupId);
            if (tenantGroup == null) {
                this.temporaryDefaultTenant.remove();
            } else if (Util.contains(this.getUserGroupsOfUser(this.getCurrentUser()), (Object)tenantGroup)) {
                this.temporaryDefaultTenant.set(tenantGroup);
            } else {
                logger.warning("User " + this.getCurrentUser().getName() + " tried to set foreign temporary default tenant group " + tenantGroupId.toString());
            }
        } else {
            this.temporaryDefaultTenant.remove();
        }
    }

    @Override
    public RoleDefinition getRoleDefinition(UUID idOfRoleDefinition) {
        return this.store.getRoleDefinition(idOfRoleDefinition);
    }

    @Override
    public Iterable<AccessControlListAnnotation> getAccessControlLists() {
        return this.accessControlStore.getAccessControlLists();
    }

    @Override
    public AccessControlListAnnotation getAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObjectAsString) {
        return this.accessControlStore.getAccessControlList(idOfAccessControlledObjectAsString);
    }

    public AccessControlListAnnotation getOrCreateAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObjectAsString) {
        return this.accessControlStore.getOrCreateAcl(idOfAccessControlledObjectAsString);
    }

    private SecurityService setEmptyAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObjectAsString) {
        return this.setEmptyAccessControlList(idOfAccessControlledObjectAsString, null);
    }

    private SecurityService setEmptyAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObjectAsString, String displayNameOfAccessControlledObject) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is clearing ACL of object with ID " + idOfAccessControlledObjectAsString);
        this.apply(new SetEmptyAccessControlListOperation(idOfAccessControlledObjectAsString, displayNameOfAccessControlledObject));
        return this;
    }

    @Override
    public Void internalSetEmptyAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObject, String displayNameOfAccessControlledObject) {
        this.permissionChangeListeners.aclChanged(idOfAccessControlledObject);
        this.accessControlStore.setEmptyAccessControlList(idOfAccessControlledObject, displayNameOfAccessControlledObject);
        return null;
    }

    @Override
    public AccessControlList overrideAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObject, Map<UserGroup, Set<String>> permissionMap) {
        return this.overrideAccessControlList(idOfAccessControlledObject, permissionMap, null);
    }

    @Override
    public AccessControlList overrideAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObject, Map<UserGroup, Set<String>> permissionMap, String displayNameOfAccessControlledObject) {
        this.setEmptyAccessControlList(idOfAccessControlledObject, displayNameOfAccessControlledObject);
        for (Map.Entry<UserGroup, Set<String>> entry : permissionMap.entrySet()) {
            UserGroup userGroup = entry.getKey();
            Set<String> actionsToSet = userGroup == null ? entry.getValue().stream().filter(action -> !SecurityAccessControlList.isDeniedAction((String)action)).collect(Collectors.toSet()) : entry.getValue();
            UUID userGroupId = userGroup == null ? null : userGroup.getId();
            logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is setting the ACL for " + idOfAccessControlledObject + " with actions " + actionsToSet);
            this.apply(new AclPutPermissionsOperation(idOfAccessControlledObject, userGroupId, actionsToSet));
        }
        return (AccessControlList)this.accessControlStore.getAccessControlList(idOfAccessControlledObject).getAnnotation();
    }

    @Override
    public Void internalAclPutPermissions(QualifiedObjectIdentifier idOfAccessControlledObject, UUID groupId, Set<String> actions) {
        this.permissionChangeListeners.aclChanged(idOfAccessControlledObject);
        this.accessControlStore.setAclPermissions(idOfAccessControlledObject, this.getUserGroup(groupId), actions);
        return null;
    }

    @Override
    public AccessControlList addToAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObject, UserGroup group, String action) {
        if (this.getAccessControlList(idOfAccessControlledObject) == null) {
            this.setEmptyAccessControlList(idOfAccessControlledObject);
        }
        UUID groupId = group == null ? null : group.getId();
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is adding permission " + action + " for group with ID " + groupId + " to the ACL for " + idOfAccessControlledObject);
        this.apply(new AclAddPermissionOperation(idOfAccessControlledObject, groupId, action));
        return (AccessControlList)this.accessControlStore.getAccessControlList(idOfAccessControlledObject).getAnnotation();
    }

    @Override
    public Void internalAclAddPermission(QualifiedObjectIdentifier idOfAccessControlledObject, UUID groupId, String action) {
        this.permissionChangeListeners.aclChanged(idOfAccessControlledObject);
        this.accessControlStore.addAclPermission(idOfAccessControlledObject, this.getUserGroup(groupId), action);
        return null;
    }

    @Override
    public AccessControlList removeFromAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObject, UserGroup group, String permission) {
        AccessControlList result;
        if (this.getAccessControlList(idOfAccessControlledObject) != null) {
            UUID groupId = group == null ? null : group.getId();
            logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is removing permission " + permission + " for group with ID " + groupId + " from the ACL for " + idOfAccessControlledObject);
            this.apply(new AclRemovePermissionOperation(idOfAccessControlledObject, groupId, permission));
            result = (AccessControlList)this.accessControlStore.getAccessControlList(idOfAccessControlledObject).getAnnotation();
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Void internalAclRemovePermission(QualifiedObjectIdentifier idOfAccessControlledObject, UUID groupId, String permission) {
        this.permissionChangeListeners.aclChanged(idOfAccessControlledObject);
        this.accessControlStore.removeAclPermission(idOfAccessControlledObject, this.getUserGroup(groupId), permission);
        return null;
    }

    @Override
    public void deleteAccessControlList(QualifiedObjectIdentifier idOfAccessControlledObject) {
        if (this.getAccessControlList(idOfAccessControlledObject) != null) {
            logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is deleting the ACL of object " + idOfAccessControlledObject);
            this.apply(new DeleteAclOperation(idOfAccessControlledObject));
        }
    }

    @Override
    public Void internalDeleteAcl(QualifiedObjectIdentifier idOfAccessControlledObject) {
        this.permissionChangeListeners.aclChanged(idOfAccessControlledObject);
        this.accessControlStore.removeAccessControlList(idOfAccessControlledObject);
        return null;
    }

    @Override
    public Ownership setOwnership(QualifiedObjectIdentifier objectId, User userOwner, UserGroup tenantOwner) {
        return this.setOwnership(objectId, userOwner, tenantOwner, null);
    }

    @Override
    public Ownership setOwnership(QualifiedObjectIdentifier objectId, User userOwner, UserGroup tenantOwner, String displayNameOfOwnedObject) {
        Ownership result;
        UserGroup existingTenantOwner;
        User existingUserOwner;
        if (userOwner == null && tenantOwner == null) {
            throw new IllegalArgumentException("No owner is not valid, would create non changeable object");
        }
        UUID tenantId = tenantOwner == null ? null : tenantOwner.getId();
        String userOwnerName = userOwner == null ? null : userOwner.getName();
        OwnershipAnnotation existingOwnership = this.getOwnership(objectId);
        if (existingOwnership == null || existingOwnership.getAnnotation() == null) {
            existingUserOwner = null;
            existingTenantOwner = null;
        } else {
            existingUserOwner = (User)((Ownership)existingOwnership.getAnnotation()).getUserOwner();
            existingTenantOwner = (UserGroup)((Ownership)existingOwnership.getAnnotation()).getTenantOwner();
        }
        String existingDisplayNameOfOwnedObject = existingOwnership == null ? null : existingOwnership.getDisplayNameOfAnnotatedObject();
        if (Util.equalsWithNull((Object)existingDisplayNameOfOwnedObject, (Object)displayNameOfOwnedObject) && existingUserOwner == userOwner && existingTenantOwner == tenantOwner) {
            result = (Ownership)existingOwnership.getAnnotation();
        } else {
            logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is setting ownership of object " + objectId + " to group with ID " + tenantId + " and user " + userOwnerName);
            result = (Ownership)this.apply(new SetOwnershipOperation(objectId, userOwnerName, tenantId, displayNameOfOwnedObject));
        }
        return result;
    }

    @Override
    public Ownership internalSetOwnership(QualifiedObjectIdentifier objectId, String userOwnerName, UUID tenantOwnerId, String displayName) {
        Ownership result = (Ownership)this.accessControlStore.setOwnership(objectId, this.getUserByName(userOwnerName), this.getUserGroup(tenantOwnerId), displayName).getAnnotation();
        this.permissionChangeListeners.ownershipChanged(objectId);
        return result;
    }

    @Override
    public void deleteOwnership(QualifiedObjectIdentifier objectId) {
        if (this.getOwnership(objectId) != null) {
            logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is deleting ownership information from object with ID " + objectId);
            this.apply(new DeleteOwnershipOperation(objectId));
        }
    }

    @Override
    public Void internalDeleteOwnership(QualifiedObjectIdentifier objectId) {
        this.accessControlStore.removeOwnership(objectId);
        this.permissionChangeListeners.ownershipChanged(objectId);
        return null;
    }

    @Override
    public Iterable<UserGroup> getUserGroupList() {
        return this.store.getUserGroups();
    }

    @Override
    public Iterable<UserGroup> getUserGroupsWithRoleDefinition(RoleDefinition roleDefinition) {
        return this.store.getUserGroupsWithRoleDefinition(roleDefinition);
    }

    @Override
    public UserGroup getUserGroup(UUID id) {
        return this.store.getUserGroup(id);
    }

    @Override
    public UserGroup getUserGroupByName(String name) {
        return this.store.getUserGroupByName(name);
    }

    @Override
    public Iterable<UserGroup> getUserGroupsOfUser(User user) {
        return this.store.getUserGroupsOfUser(user);
    }

    @Override
    public UserGroup createUserGroup(UUID id, String name) throws UserGroupManagementException {
        return this.createUserGroupWithInitialUser(id, name, this.getCurrentUser());
    }

    private UserGroup createUserGroupWithInitialUser(UUID id, String name, User initialUser) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is creating user group " + name + " with ID " + id);
        this.apply(new CreateUserGroupOperation(id, name));
        UserGroup userGroup = this.store.getUserGroup(id);
        if (initialUser != null) {
            logger.info("Adding initial user " + initialUser + " to group " + userGroup);
            this.addUserToUserGroup(userGroup, initialUser);
            this.addUserRoleForGroupToUser(userGroup, initialUser);
        }
        return userGroup;
    }

    @Override
    public Void internalCreateUserGroup(UUID id, String name) throws UserGroupManagementException {
        this.store.createUserGroup(id, name);
        return null;
    }

    @Override
    public void addUserToUserGroup(UserGroup userGroup, User user) {
        logger.info("Adding user " + user.getName() + " to group " + userGroup.getName());
        userGroup.add(user);
        UUID groupId = userGroup.getId();
        String username = user.getName();
        this.apply(new AddUserToUserGroupOperation(groupId, username));
    }

    @Override
    public Void internalAddUserToUserGroup(UUID groupId, String username) {
        UserGroup userGroup = this.getUserGroup(groupId);
        User user = this.getUserByName(username);
        userGroup.add(user);
        this.permissionChangeListeners.userAddedToOrRemovedFromGroup(user, userGroup);
        this.store.updateUserGroup(userGroup);
        return null;
    }

    @Override
    public Void internalRemoveUserFromUserGroup(UUID groupId, String username) {
        UserGroup userGroup = this.getUserGroup(groupId);
        User user = this.getUserByName(username);
        this.permissionChangeListeners.userAddedToOrRemovedFromGroup(user, userGroup);
        userGroup.remove(user);
        this.store.updateUserGroup(userGroup);
        return null;
    }

    @Override
    public void removeUserFromUserGroup(UserGroup userGroup, User user) {
        logger.info("Removing user " + user.getName() + " from group " + userGroup.getName());
        userGroup.remove(user);
        UUID userGroupId = userGroup.getId();
        String username = user.getName();
        this.apply(new RemoveUserFromUserGroupOperation(userGroupId, username));
    }

    @Override
    public void putRoleDefinitionToUserGroup(UserGroup userGroup, RoleDefinition roleDefinition, boolean forAll) {
        logger.info("Adding role definition " + roleDefinition.getName() + "(forAll = " + forAll + ") to group " + userGroup.getName());
        this.apply(new PutRoleDefinitionToUserGroupOperation(userGroup.getId(), roleDefinition.getId(), forAll));
    }

    @Override
    public Void internalPutRoleDefinitionToUserGroup(UUID groupId, UUID roleDefinitionId, boolean forAll) throws UserGroupManagementException {
        UserGroup userGroup = this.getUserGroup(groupId);
        RoleDefinition roleDefinition = this.getRoleDefinition(roleDefinitionId);
        this.permissionChangeListeners.roleAddedToOrRemovedFromGroup(userGroup, roleDefinition);
        userGroup.put(roleDefinition, forAll);
        this.store.updateUserGroup(userGroup);
        return null;
    }

    @Override
    public void removeRoleDefintionFromUserGroup(UserGroup userGroup, RoleDefinition roleDefinition) {
        logger.info("Removing role definition " + roleDefinition.getName() + " from group " + userGroup.getName());
        this.apply(new RemoveRoleDefinitionFromUserGroupOperation(userGroup.getId(), roleDefinition.getId()));
    }

    @Override
    public Void internalRemoveRoleDefinitionFromUserGroup(UUID groupId, UUID roleDefinitionId) throws UserGroupManagementException {
        UserGroup userGroup = this.getUserGroup(groupId);
        RoleDefinition roleDefinition = this.getRoleDefinition(roleDefinitionId);
        this.permissionChangeListeners.roleAddedToOrRemovedFromGroup(userGroup, roleDefinition);
        userGroup.remove(roleDefinition);
        this.store.updateUserGroup(userGroup);
        return null;
    }

    @Override
    public void deleteUserGroup(UserGroup userGroup) throws UserGroupManagementException {
        logger.info("Removing user group " + userGroup.getName());
        this.apply(new DeleteUserGroupOperation(userGroup.getId()));
    }

    @Override
    public void releaseUserCreationLockOnIp(String ip) {
        logger.info("Releasing timed lock for user creation at IP " + ip);
        this.apply(new ReleaseUserCreationLockOnIpOperation(ip));
    }

    @Override
    public void releaseBearerTokenLockOnIp(String ip) {
        logger.info("Releasing timed lock for bearer token abuse at IP " + ip);
        this.apply(new ReleaseBearerTokenLockOnIpOperation(ip));
    }

    @Override
    public Void internalDeleteUserGroup(UUID groupId) throws UserGroupManagementException {
        UserGroup userGroup = this.getUserGroup(groupId);
        if (userGroup == null) {
            logger.warning("Strange: the user group with ID " + groupId + " which is about to be deleted couldn't be found");
        } else {
            Iterable ownerhipsWithGroupOwner = this.accessControlStore.getOwnerhipsWithGroupOwner(userGroup);
            this.accessControlStore.removeAllOwnershipsFor(userGroup);
            this.store.deleteUserGroup(userGroup);
            for (OwnershipAnnotation ownershipWithGroupAsOwner : ownerhipsWithGroupOwner) {
                this.permissionChangeListeners.ownershipChanged(ownershipWithGroupAsOwner.getIdOfAnnotatedObject());
            }
        }
        return null;
    }

    @Override
    public Iterable<User> getUserList() {
        return this.store.getUsers();
    }

    @Override
    public String login(String username, String password) throws AuthenticationException {
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        logger.info("Trying to login: " + username);
        Subject subject = SecurityUtils.getSubject();
        subject.login((AuthenticationToken)token);
        HttpServletRequest httpRequest = WebUtils.getHttpRequest((Object)subject);
        SavedRequest savedRequest = WebUtils.getSavedRequest((ServletRequest)httpRequest);
        String redirectUrl = savedRequest != null ? savedRequest.getRequestUrl() : "";
        logger.info("Redirecturl: " + redirectUrl);
        return redirectUrl;
    }

    @Override
    public void logout() {
        Subject subject = SecurityUtils.getSubject();
        logger.info("Logging out");
        subject.logout();
    }

    @Override
    public User getUserByName(String name) {
        return this.store.getUserByName(name);
    }

    @Override
    public User getUserByAccessToken(String accessToken) {
        return this.store.getUserByAccessToken(accessToken);
    }

    @Override
    public User getUserByEmail(String email) {
        return this.store.getUserByEmail(email);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<User> getUsersWithPermissions(WildcardPermission permission) {
        void var11_12;
        if (Util.size((Iterable)permission.getQualifiedObjectIdentifiers()) != 1) {
            throw new IllegalArgumentException("Permission needs to specify exactly one object identifier");
        }
        ScheduledExecutorService foregroundExecutor = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor();
        int numberOfJobs = ThreadPoolUtil.INSTANCE.getReasonableThreadPoolSize();
        ConcurrentHashMap result = new ConcurrentHashMap();
        User allUser = this.getAllUser();
        ConcurrentLinkedDeque userList = new ConcurrentLinkedDeque();
        Util.addAll(this.getUserList(), userList);
        HashSet futures = new HashSet();
        QualifiedObjectIdentifier objectIdentifier = (QualifiedObjectIdentifier)permission.getQualifiedObjectIdentifiers().iterator().next();
        OwnershipAnnotation ownership = this.accessControlStore.getOwnership(objectIdentifier);
        AccessControlListAnnotation acl = this.accessControlStore.getAccessControlList(objectIdentifier);
        boolean bl = false;
        while (var11_12 < numberOfJobs) {
            futures.add(foregroundExecutor.submit(() -> {
                User user2;
                int usersHandled = 0;
                while ((user2 = (User)userList.poll()) != null) {
                    ++usersHandled;
                    if (!PermissionChecker.isPermitted((WildcardPermission)permission, (SecurityUser)user2, (SecurityUser)allUser, (AbstractOwnership)(ownership == null ? null : (Ownership)ownership.getAnnotation()), acl == null ? null : (AccessControlList)acl.getAnnotation())) continue;
                    result.put(user2, true);
                }
                int finalUsersHandled = usersHandled;
                logger.fine(() -> "Handled " + finalUsersHandled + " users in job " + this);
            }));
            ++var11_12;
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.log(Level.WARNING, "Exception while trying to wait for user permission check", e);
            }
        }
        return result.keySet();
    }

    @Override
    public HashMap<String, TimedLock> getClientIPBasedTimedLocksForUserCreation() {
        return new HashMap<String, TimedLock>(this.clientIPBasedTimedLocksForUserCreation);
    }

    @Override
    public HashMap<String, TimedLock> getClientIPBasedTimedLocksForBearerTokenAbuse() {
        return new HashMap<String, TimedLock>(this.clientIPBasedTimedLocksForBearerTokenAuthentication);
    }

    @Override
    public User createSimpleUser(String username, String email, String password, String fullName, String company, Locale locale, String validationBaseURL, UserGroup groupOwningUser, String requestClientIP, boolean enforceStrongPassword) throws UserManagementException, MailException, UserGroupManagementException {
        if (requestClientIP != null) {
            this.checkAndRecordUserCreationFromClientIP(requestClientIP);
        }
        logger.info("Creating user " + username);
        if (this.store.getUserByName(username) != null) {
            logger.warning("User " + username + " already exists");
            throw new UserManagementException("User already exists");
        }
        if (username == null || username.length() < 3) {
            throw new UserManagementException("Username does not meet requirements");
        }
        if (enforceStrongPassword && !this.isPasswordGoodEnough(password)) {
            throw new UserManagementException("Password does not meet requirements");
        }
        SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
        byte[] salt = rng.nextBytes().getBytes();
        String hashedPasswordBase64 = this.hashPassword(password, salt);
        UsernamePasswordAccount upa = new UsernamePasswordAccount(username, hashedPasswordBase64, salt);
        User result = (User)this.apply(new CreateUserOperation(username, email, new Account[]{upa}));
        this.addUserRoleToUser(result);
        UserGroup tenant = this.getOrCreateTenantForUser(result);
        this.setDefaultTenantForCurrentServerForUser(username, tenant.getId());
        this.apply(new SetOwnershipOperation(result.getIdentifier(), username, groupOwningUser == null ? null : groupOwningUser.getId(), username));
        this.updateUserProperties(username, fullName, company, locale);
        this.updateSimpleUserEmail(username, email, validationBaseURL);
        return result;
    }

    private boolean isPasswordGoodEnough(String password) {
        Strength strength;
        boolean result = password == null ? false : (strength = this.passwordValidator.measure((CharSequence)password)).getGuessesLog10() > 8.0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRecordUserCreationFromClientIP(String clientIP) throws UserManagementException {
        assert (clientIP != null);
        ConcurrentMap<String, TimedLock> concurrentMap = this.clientIPBasedTimedLocksForUserCreation;
        synchronized (concurrentMap) {
            TimedLock timedLock = (TimedLock)this.clientIPBasedTimedLocksForUserCreation.get(clientIP);
            if (timedLock != null && timedLock.isLocked()) {
                timedLock.extendLockDuration();
                throw new UserManagementException("Client IP " + clientIP + " locked for user creation: " + timedLock);
            }
            this.apply((SecurityOperation & Serializable)s -> s.internalRecordUserCreationFromClientIP(clientIP));
        }
    }

    @Override
    public boolean isUserCreationLockedForClientIP(String clientIP) {
        TimedLock timedLock = (TimedLock)this.clientIPBasedTimedLocksForUserCreation.get(this.escapeNullClientIP(clientIP));
        return timedLock != null && timedLock.isLocked();
    }

    @Override
    public TimedLock internalRecordUserCreationFromClientIP(String clientIP) {
        TimedLockImpl result = new TimedLockImpl(TimePoint.now().plus(DEFAULT_CLIENT_IP_BASED_USER_CREATION_LOCKING_DURATION), DEFAULT_CLIENT_IP_BASED_USER_CREATION_LOCKING_DURATION);
        this.clientIPBasedTimedLocksForUserCreation.put(clientIP, (TimedLock)result);
        this.scheduleCleanUpTask(clientIP, (TimedLock)result, this.clientIPBasedTimedLocksForUserCreation, "client IPs locked for user creation");
        return result;
    }

    private void addUserRoleToUser(User user) {
        this.addRoleForUserAndSetUserAsOwner(user, new Role(this.store.getRoleDefinitionByPrototype((RolePrototype)UserRole.getInstance()), null, user, Boolean.valueOf(true)));
    }

    private void addUserRoleForGroupToUser(UserGroup group, User user) {
        this.addRoleForUserAndSetUserAsOwner(user, new Role(this.store.getRoleDefinitionByPrototype((RolePrototype)UserRole.getInstance()), group, null, Boolean.valueOf(true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserGroup getOrCreateTenantForUser(User user) throws UserGroupManagementException {
        String username = user.getName();
        String defaultTenantNameForUsername = this.getDefaultTenantNameForUsername(username);
        Object object = userGroupLock;
        synchronized (object) {
            UserGroup tenant = this.store.getUserGroupByName(defaultTenantNameForUsername);
            if (tenant != null) {
                logger.info("Found existing tenant " + defaultTenantNameForUsername + " to be used as default tenant for new user " + username);
            } else {
                logger.info("Creating user group " + defaultTenantNameForUsername + " as default tenant for new user " + username);
                tenant = this.createUserGroupWithInitialUser(UUID.randomUUID(), defaultTenantNameForUsername, user);
                this.setOwnership(tenant.getIdentifier(), user, tenant);
            }
            return tenant;
        }
    }

    @Override
    public User internalCreateUser(String username, String email, Account ... accounts) throws UserManagementException {
        User result = this.store.createUser(username, email, (TimedLock)new TimedLockImpl(), accounts);
        return result;
    }

    private String getDefaultTenantNameForUsername(String username) {
        return String.valueOf(username) + "-tenant";
    }

    @Override
    public void updateSimpleUserPassword(String username, String newPassword) throws UserManagementException {
        User user = this.store.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        this.updateSimpleUserPassword(user, newPassword);
    }

    private void updateSimpleUserPassword(User user, String newPassword) throws UserManagementException {
        if (!this.isPasswordGoodEnough(newPassword)) {
            throw new UserManagementException("Password does not meet requirements");
        }
        SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
        byte[] salt = rng.nextBytes().getBytes();
        String hashedPasswordBase64 = this.hashPassword(newPassword, salt);
        this.apply(new UpdateSimpleUserPasswordOperation(user.getName(), salt, hashedPasswordBase64));
    }

    @Override
    public Void internalUpdateSimpleUserPassword(String username, byte[] salt, String hashedPasswordBase64) {
        User user = this.getUserByName(username);
        UsernamePasswordAccount account = (UsernamePasswordAccount)user.getAccount(Account.AccountType.USERNAME_PASSWORD);
        account.setSalt(salt);
        account.setSaltedPassword(hashedPasswordBase64);
        logger.info("Password for user " + username + " was updated by " + SessionUtils.getPrincipal());
        user.passwordWasReset();
        this.store.updateUser(user);
        return null;
    }

    @Override
    public void updateUserProperties(String username, String fullName, String company, Locale locale) throws UserManagementException {
        User user = this.store.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        this.apply(new UpdateUserPropertiesOperation(username, fullName, company, locale));
    }

    @Override
    public Void internalUpdateUserProperties(String username, String fullName, String company, Locale locale) {
        User user = this.store.getUserByName(username);
        user.setFullName(fullName);
        user.setCompany(company);
        user.setLocale(locale);
        this.store.updateUser(user);
        return null;
    }

    @Override
    public void resetUserTimedLock(String username) throws UserManagementException {
        User user = this.store.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        this.apply(new ResetUserLockOperation(username, user.getTimedLock()));
    }

    @Override
    public Void internalResetUserTimedLock(String username) {
        User user = this.store.getUserByName(username);
        user.getTimedLock().resetLock();
        this.store.updateUser(user);
        return null;
    }

    @Override
    public boolean checkPassword(String username, String password) throws UserManagementException {
        User user = this.store.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        if (user.getTimedLock().isLocked()) {
            throw new UserManagementException("Password authentication currently locked for user");
        }
        UsernamePasswordAccount account = (UsernamePasswordAccount)user.getAccount(Account.AccountType.USERNAME_PASSWORD);
        String hashedOldPassword = this.hashPassword(password, account.getSalt());
        boolean result = Util.equalsWithNull((Object)hashedOldPassword, (Object)account.getSaltedPassword());
        if (!result) {
            logger.info("Failed password check for user " + username);
            this.apply((SecurityOperation & Serializable)s -> s.internalFailedPasswordAuthentication(username));
        } else {
            this.apply((SecurityOperation & Serializable)s -> s.internalSuccessfulPasswordAuthentication(username));
        }
        return result;
    }

    @Override
    public TimedLock failedPasswordAuthentication(User user) {
        return (TimedLock)this.apply((SecurityOperation & Serializable)s -> s.internalFailedPasswordAuthentication(user.getName()));
    }

    @Override
    public TimedLock internalFailedPasswordAuthentication(String username) {
        TimedLock timedLock;
        User user = this.getUserByName(username);
        if (user != null) {
            timedLock = user.getTimedLock();
            timedLock.extendLockDuration();
            this.store.updateUser(user);
            logger.info("failed password authentication for user " + username + "; locking: " + timedLock);
        } else {
            timedLock = null;
        }
        return timedLock;
    }

    @Override
    public void successfulPasswordAuthentication(User user) {
        if (this.internalSuccessfulPasswordAuthentication(user.getName()).booleanValue()) {
            this.replicate((SecurityOperation & Serializable)s -> s.internalSuccessfulPasswordAuthentication(user.getName()));
        }
    }

    @Override
    public Boolean internalSuccessfulPasswordAuthentication(String username) {
        boolean changed;
        User user = this.getUserByName(username);
        if (user != null) {
            changed = user.getTimedLock().resetLock();
            if (changed) {
                this.store.updateUser(user);
            }
        } else {
            changed = false;
        }
        return changed;
    }

    @Override
    public TimedLock failedBearerTokenAuthentication(String clientIP) {
        TimedLock result;
        ReplicationService replicationService = this.getReplicationService();
        if (replicationService == null || !replicationService.isReplicationStarting()) {
            result = (TimedLock)this.apply((SecurityOperation & Serializable)s -> s.internalFailedBearerTokenAuthentication(clientIP));
        } else {
            logger.warning("Replication is starting, so not recording failed bearer token authentication for client IP " + clientIP);
            result = null;
        }
        return result;
    }

    @Override
    public TimedLock internalFailedBearerTokenAuthentication(String clientIP) {
        TimedLock timedLock = this.clientIPBasedTimedLocksForBearerTokenAuthentication.computeIfAbsent(this.escapeNullClientIP(clientIP), key -> new TimedLockImpl());
        timedLock.extendLockDuration();
        logger.info("failed bearer token authentication from client IP " + clientIP + "; locking: " + timedLock);
        this.scheduleCleanUpTask(clientIP, timedLock, this.clientIPBasedTimedLocksForBearerTokenAuthentication, "client IPs locked for bearer token authentication");
        return timedLock;
    }

    private void scheduleCleanUpTask(String clientIPOrNull, TimedLock timedLock, ConcurrentMap<String, TimedLock> mapToRemoveFrom, String nameOfMapForLog) {
        long millisUntilLockingExpiry = Math.max(2L * ApproximateTime.approximateNow().until(timedLock.getLockedUntil()).asMillis(), Duration.ONE_HOUR.asMillis());
        ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().schedule(() -> {
            TimedLock lab = (TimedLock)mapToRemoveFrom.get(this.escapeNullClientIP(clientIPOrNull));
            if (lab != null && !lab.isLocked()) {
                mapToRemoveFrom.remove(this.escapeNullClientIP(clientIPOrNull));
                logger.info("Removed " + clientIPOrNull + " from " + nameOfMapForLog + "; " + mapToRemoveFrom.size() + " locked client IP(s) remaining");
            }
        }, millisUntilLockingExpiry, TimeUnit.MILLISECONDS);
    }

    private String escapeNullClientIP(String clientIP) {
        return clientIP == null ? CLIENT_IP_NULL_ESCAPE : clientIP;
    }

    @Override
    public void successfulBearerTokenAuthentication(String clientIP) {
        if (this.internalSuccessfulBearerTokenAuthentication(clientIP).booleanValue()) {
            this.replicate((SecurityOperation & Serializable)s -> s.internalSuccessfulBearerTokenAuthentication(clientIP));
        }
    }

    @Override
    public Boolean internalSuccessfulBearerTokenAuthentication(String clientIP) {
        boolean changed;
        TimedLock timedLock = (TimedLock)this.clientIPBasedTimedLocksForBearerTokenAuthentication.remove(this.escapeNullClientIP(clientIP));
        if (timedLock != null) {
            logger.info("Unlocked bearer token authentication from " + clientIP + "; last locking state was " + timedLock);
            changed = true;
        } else {
            changed = false;
        }
        return changed;
    }

    @Override
    public boolean isClientIPLockedForBearerTokenAuthentication(String clientIP) {
        TimedLock timedLock = (TimedLock)this.clientIPBasedTimedLocksForBearerTokenAuthentication.get(this.escapeNullClientIP(clientIP));
        return timedLock != null && timedLock.isLocked();
    }

    @Override
    public boolean checkPasswordResetSecret(String username, String passwordResetSecret) throws UserManagementException {
        User user = this.store.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        return Util.equalsWithNull((Object)user.getPasswordResetSecret(), (Object)passwordResetSecret);
    }

    @Override
    public void updateSimpleUserEmail(final String username, final String newEmail, final String validationBaseURL) throws UserManagementException {
        final User user = this.store.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is changing e-mail address of user " + username + " to " + newEmail);
        final String validationSecret = user.createRandomSecret();
        this.apply(new UpdateSimpleUserEmailOperation(username, newEmail, validationSecret));
        if (validationBaseURL != null && newEmail != null && !newEmail.trim().isEmpty()) {
            new Thread("e-mail validation after changing e-mail of user " + username + " to " + newEmail){

                @Override
                public void run() {
                    try {
                        SecurityServiceImpl.this.startEmailValidation(user, validationSecret, validationBaseURL);
                    }
                    catch (MailException e) {
                        logger.log(Level.SEVERE, "Error sending mail to validate e-mail address change for user " + username + " to address " + newEmail, e);
                    }
                }
            }.start();
        }
    }

    @Override
    public Void internalUpdateSimpleUserEmail(String username, String newEmail, String validationSecret) {
        User user = this.getUserByName(username);
        user.setEmail(newEmail);
        user.startEmailValidation(validationSecret);
        this.store.updateUser(user);
        return null;
    }

    @Override
    public boolean validateEmail(String username, String validationSecret) throws UserManagementException {
        User user = this.store.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        return (Boolean)this.apply(new ValidateEmailOperation(username, validationSecret));
    }

    @Override
    public Boolean internalValidateEmail(String username, String validationSecret) {
        User user = this.store.getUserByName(username);
        boolean result = user.validate(validationSecret);
        if (result) {
            this.store.updateUser(user);
        }
        return result;
    }

    private void startEmailValidation(User user, String validationSecret, String baseURL) throws MailException {
        try {
            HashMap<String, String> urlParameters = new HashMap<String, String>();
            urlParameters.put("u", URLEncoder.encode(user.getName(), "UTF-8"));
            urlParameters.put("v", URLEncoder.encode(validationSecret, "UTF-8"));
            StringBuilder url = this.buildURL(baseURL, urlParameters);
            this.sendMail(user.getName(), messages.get(user.getLocaleOrDefault(), "emailValidationSubject"), messages.get(user.getLocaleOrDefault(), "emailValidationMessage", new String[]{user.getName()}) + "\n" + "   " + url.toString());
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "Internal error: encoding UTF-8 not found. Couldn't send e-mail to user " + user.getName() + " at e-mail address " + user.getEmail(), e);
        }
    }

    public StringBuilder buildURL(String baseURL, Map<String, String> urlParameters) {
        StringBuilder url = new StringBuilder(baseURL == null ? "" : baseURL);
        boolean first = baseURL == null || !baseURL.contains("?") || baseURL.contains("#");
        for (Map.Entry<String, String> e : urlParameters.entrySet()) {
            if (first) {
                url.append('?');
                first = false;
            } else {
                url.append('&');
            }
            url.append(e.getKey());
            url.append('=');
            url.append(e.getValue());
        }
        return url;
    }

    protected String hashPassword(String password, Object salt) {
        return new Sha256Hash((Object)password, salt, 1024).toBase64();
    }

    @Override
    public RoleDefinition createRoleDefinition(UUID roleId, String name) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " created role " + name + " with ID " + roleId);
        return (RoleDefinition)this.apply(new CreateRoleDefinitionOperation(roleId, name));
    }

    @Override
    public RoleDefinition internalCreateRoleDefinition(UUID roleId, String name) {
        return this.store.createRoleDefinition(roleId, name, Collections.emptySet());
    }

    @Override
    public void deleteRoleDefinition(RoleDefinition roleDefinition) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " deleted role " + roleDefinition);
        UUID roleId = roleDefinition.getId();
        this.apply(new DeleteRoleDefinitionOperation(roleId));
    }

    @Override
    public Void internalDeleteRoleDefinition(UUID roleId) {
        RoleDefinition roleDefinition = this.store.getRoleDefinition(roleId);
        this.permissionChangeListeners.roleDefinitionRemoved(roleDefinition);
        this.store.removeRoleDefinition(roleDefinition);
        return null;
    }

    @Override
    public void updateRoleDefinition(RoleDefinition roleDefinitionWithNewProperties) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " updated role " + roleDefinitionWithNewProperties);
        this.apply(new UpdateRoleDefinitionOperation(roleDefinitionWithNewProperties));
    }

    @Override
    public Void internalUpdateRoleDefinition(RoleDefinition roleWithNewProperties) {
        RoleDefinition role = this.store.getRoleDefinition(roleWithNewProperties.getId());
        role.setName(roleWithNewProperties.getName());
        this.store.setRoleDefinitionDisplayName(roleWithNewProperties.getId(), role.getName());
        this.permissionChangeListeners.permissionAddedToOrRemovedFromRoleDefinition(role, role.getPermissions(), roleWithNewProperties.getPermissions());
        role.setPermissions((Iterable)roleWithNewProperties.getPermissions());
        this.store.setRoleDefinitionPermissions(role.getId(), role.getPermissions());
        return null;
    }

    @Override
    public Iterable<RoleDefinition> getRoleDefinitions() {
        ArrayList<RoleDefinition> result = new ArrayList<RoleDefinition>();
        this.filterObjectsWithPermissionForCurrentUser((HasPermissions.Action)HasPermissions.DefaultActions.READ, this.store.getRoleDefinitions(), t -> {
            boolean bl = result.add((RoleDefinition)t);
        });
        return result;
    }

    private void addRoleForUserAndSetUserAsOwner(User user, Role role) {
        this.addRoleForUser(user.getName(), role);
        TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((Role)role, (User)user);
        QualifiedObjectIdentifier qualifiedTypeIdentifier = SecuredSecurityTypes.ROLE_ASSOCIATION.getQualifiedObjectIdentifier(associationTypeIdentifier);
        this.setOwnership(qualifiedTypeIdentifier, user, null);
    }

    @Override
    public void addRoleForUser(User user, Role role) {
        this.addRoleForUser(user.getName(), role);
    }

    @Override
    public void addRoleForUser(String username, Role role) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " added role " + role + " to user " + username);
        UUID roleDefinitionId = role.getRoleDefinition().getId();
        UUID idOfTenantQualifyingRole = role.getQualifiedForTenant() == null ? null : ((UserGroup)role.getQualifiedForTenant()).getId();
        String nameOfUserQualifyingRole = role.getQualifiedForUser() == null ? null : ((User)role.getQualifiedForUser()).getName();
        Boolean transitive = role.isTransitive();
        this.apply(new AddRoleForUserOperation(username, roleDefinitionId, idOfTenantQualifyingRole, nameOfUserQualifyingRole, transitive));
    }

    @Override
    public Void internalAddRoleForUser(String username, UUID roleDefinitionId, UUID idOfTenantQualifyingRole, String nameOfUserQualifyingRole, Boolean transitive) throws UserManagementException {
        Role role = new Role(this.getRoleDefinition(roleDefinitionId), this.getUserGroup(idOfTenantQualifyingRole), this.getUserByName(nameOfUserQualifyingRole), transitive);
        this.permissionChangeListeners.roleAddedToOrRemovedFromUser(this.getUserByName(username), role);
        this.store.addRoleForUser(username, role);
        return null;
    }

    @Override
    public void removeRoleFromUser(User user, Role role) {
        this.removeRoleFromUser(user.getName(), role);
    }

    @Override
    public void removeRoleFromUser(String username, Role role) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " removed role " + role + " to user " + username);
        UUID roleDefinitionId = role.getRoleDefinition().getId();
        UUID idOfTenantQualifyingRole = role.getQualifiedForTenant() == null ? null : ((UserGroup)role.getQualifiedForTenant()).getId();
        String nameOfUserQualifyingRole = role.getQualifiedForUser() == null ? null : ((User)role.getQualifiedForUser()).getName();
        Boolean transitive = role.isTransitive();
        this.apply(new RemoveRoleFromUserOperation(username, roleDefinitionId, idOfTenantQualifyingRole, nameOfUserQualifyingRole, transitive));
    }

    @Override
    public Void internalRemoveRoleFromUser(String username, UUID roleDefinitionId, UUID idOfTenantQualifyingRole, String nameOfUserQualifyingRole, Boolean transitive) throws UserManagementException {
        Role role = new Role(this.getRoleDefinition(roleDefinitionId), this.getUserGroup(idOfTenantQualifyingRole), this.getUserByName(nameOfUserQualifyingRole), transitive);
        this.permissionChangeListeners.roleAddedToOrRemovedFromUser(this.getUserByName(username), role);
        this.store.removeRoleFromUser(username, role);
        return null;
    }

    @Override
    public void removePermissionFromUser(String username, WildcardPermission permissionToRemove) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is removing permission " + permissionToRemove + " from user " + username);
        this.apply(new RemovePermissionForUserOperation(username, permissionToRemove));
    }

    @Override
    public Void internalRemovePermissionForUser(String username, WildcardPermission permissionToRemove) throws UserManagementException {
        this.permissionChangeListeners.permissionAddedToOrRemovedFromUser(this.getUserByName(username), permissionToRemove);
        this.store.removePermissionFromUser(username, permissionToRemove);
        return null;
    }

    @Override
    public void addPermissionForUser(String username, WildcardPermission permissionToAdd) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is adding permission " + permissionToAdd + " to user " + username);
        this.apply(new AddPermissionForUserOperation(username, permissionToAdd));
    }

    @Override
    public Void internalAddPermissionForUser(String username, WildcardPermission permissionToAdd) throws UserManagementException {
        this.permissionChangeListeners.permissionAddedToOrRemovedFromUser(this.getUserByName(username), permissionToAdd);
        this.store.addPermissionForUser(username, permissionToAdd);
        return null;
    }

    @Override
    public void deleteUser(String username) throws UserManagementException {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is deleting user " + username);
        User userToDelete = this.store.getUserByName(username);
        if (userToDelete == null) {
            throw new UserManagementException("User does not exist");
        }
        this.apply(new DeleteUserOperation(username));
    }

    @Override
    public Void internalDeleteUser(String username) throws UserManagementException {
        User userToDelete = this.store.getUserByName(username);
        if (userToDelete != null) {
            List usersInGroupList;
            this.permissionChangeListeners.userDeleted(userToDelete);
            this.accessControlStore.removeAllOwnershipsFor(userToDelete);
            this.store.deleteUser(username);
            String defaultTenantNameForUsername = this.getDefaultTenantNameForUsername(username);
            UserGroup defaultTenantUserGroup = this.getUserGroupByName(defaultTenantNameForUsername);
            if (defaultTenantUserGroup != null && (usersInGroupList = Util.asList((Iterable)defaultTenantUserGroup.getUsers())).isEmpty()) {
                try {
                    this.internalDeleteUserGroup(defaultTenantUserGroup.getId());
                }
                catch (UserGroupManagementException e) {
                    logger.log(Level.SEVERE, "Could not delete default tenant for user", e);
                }
            }
        }
        return null;
    }

    @Override
    public boolean setSetting(String key, Object setting) {
        return (Boolean)this.apply(new SetSettingOperation(key, setting));
    }

    @Override
    public Boolean internalSetSetting(String key, Object setting) {
        return this.store.setSetting(key, setting);
    }

    @Override
    public Map<String, Object> getAllSettings() {
        return this.store.getAllSettings();
    }

    @Override
    public Map<String, Class<?>> getAllSettingTypes() {
        return this.store.getAllSettingTypes();
    }

    @Override
    public User verifySocialUser(Credential credential) throws UserManagementException {
        String username;
        OAuthToken otoken = new OAuthToken(credential, credential.getVerifier());
        Subject subject = SecurityUtils.getSubject();
        if (!subject.isAuthenticated()) {
            try {
                subject.login((AuthenticationToken)otoken);
                logger.info("User [" + subject.getPrincipal().toString() + "] logged in successfully.");
            }
            catch (UnknownAccountException uae) {
                logger.info("There is no user with username of " + subject.getPrincipal());
                throw new UserManagementException("Invalid credentials!");
            }
            catch (IncorrectCredentialsException ice) {
                logger.info("Password for account " + subject.getPrincipal() + " was incorrect!");
                throw new UserManagementException("Invalid credentials!");
            }
            catch (LockedAccountException lae) {
                logger.info("The account for username " + subject.getPrincipal() + " is locked.  " + "Please contact your administrator to unlock it.");
                throw new UserManagementException("Invalid credentials!");
            }
            catch (AuthenticationException ae) {
                logger.log(Level.SEVERE, ae.getLocalizedMessage());
                throw new UserManagementException("An error occured while authenticating the user!");
            }
        }
        if ((username = subject.getPrincipal().toString()) == null) {
            logger.info("Something went wrong while authneticating, check doGetAuthenticationInfo() in " + OAuthRealm.class.getName() + ".");
            throw new UserManagementException("An error occured while authenticating the user!");
        }
        User user = this.store.getUserByName(username);
        if (user == null) {
            logger.info("Could not find user " + username);
            throw new UserManagementException("An error occured while authenticating the user!");
        }
        return user;
    }

    @Override
    public User getCurrentUser() {
        String username;
        Object principal;
        Subject subject = SecurityUtils.getSubject();
        User result = subject == null || !subject.isAuthenticated() ? null : ((principal = subject.getPrincipal()) == null ? null : ((username = principal.toString()) == null || username.length() <= 0 ? null : this.store.getUserByName(username)));
        return result;
    }

    @Override
    public String getAuthenticationUrl(Credential credential) throws UserManagementException {
        Token requestToken = null;
        String authorizationUrl = null;
        int authProvider = credential.getAuthProvider();
        OAuthService service = this.getOAuthService(authProvider);
        if (service == null) {
            throw new UserManagementException("Could not build OAuthService");
        }
        if (authProvider == 3 || authProvider == 4 || authProvider == 7 || authProvider == 5 || authProvider == 6 || authProvider == 13 || authProvider == 11 || authProvider == 2) {
            String authProviderName = ClientUtils.getAuthProviderName(authProvider);
            logger.info(String.valueOf(authProviderName) + " requires Request token first.. obtaining..");
            try {
                requestToken = service.getRequestToken();
                logger.info("Got request token: " + requestToken);
                SessionUtils.saveRequestTokenToSession(requestToken);
            }
            catch (Exception e) {
                throw new UserManagementException("Could not get request token for " + authProvider + " " + e.getMessage());
            }
        }
        logger.info("Getting Authorization url...");
        try {
            authorizationUrl = service.getAuthorizationUrl(requestToken);
            if (authProvider == 1 || authProvider == 10 || authProvider == 9) {
                String state = UUID.randomUUID().toString();
                authorizationUrl = String.valueOf(authorizationUrl) + "&state=" + state;
                SessionUtils.saveStateToSession(state);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UserManagementException("Could not get Authorization url: ");
        }
        if (authProvider == 5) {
            authorizationUrl = String.valueOf(authorizationUrl) + "&perms=read";
        }
        if (authProvider == 1) {
            authorizationUrl = String.valueOf(authorizationUrl) + "&scope=email";
        }
        logger.info("Authorization url: " + authorizationUrl);
        return authorizationUrl;
    }

    private OAuthService getOAuthService(int authProvider) {
        OAuthService service = null;
        switch (authProvider) {
            case 1: {
                service = new ServiceBuilder().provider(FacebookApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_FACEBOOK_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_FACEBOOK_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 2: {
                service = new ServiceBuilder().provider(GoogleApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_GOOGLE_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_GOOGLE_APP_SECRET.name(), String.class)).scope((String)this.store.getSetting(SocialSettingsKeys.OAUTH_GOOGLE_SCOPE.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 3: {
                service = new ServiceBuilder().provider(TwitterApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_TWITTER_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_TWITTER_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 4: {
                service = new ServiceBuilder().provider(YahooApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_YAHOO_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_YAHOO_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 7: {
                service = new ServiceBuilder().provider(LinkedInApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_LINKEDIN_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_LINKEDIN_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 9: {
                service = new ServiceBuilder().provider(InstagramApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_INSTAGRAM_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_INSTAGRAM_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 10: {
                service = new ServiceBuilder().provider(GithubApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_GITHUB_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_GITHUB_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 6: {
                service = new ServiceBuilder().provider(ImgUrApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_IMGUR_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_IMGUR_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 5: {
                service = new ServiceBuilder().provider(FlickrApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_FLICKR_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_FLICKR_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 11: {
                service = new ServiceBuilder().provider(VimeoApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_VIMEO_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_VIMEO_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 8: {
                service = new ServiceBuilder().provider(LiveApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_WINDOWS_LIVE_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_WINDOWS_LIVE_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).scope("wl.basic").build();
                break;
            }
            case 13: {
                service = new ServiceBuilder().provider(TumblrApi.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_TUMBLR_LIVE_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_TUMBLR_LIVE_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 14: {
                service = new ServiceBuilder().provider(Foursquare2Api.class).apiKey((String)this.store.getSetting(SocialSettingsKeys.OAUTH_FOURSQUARE_APP_ID.name(), String.class)).apiSecret((String)this.store.getSetting(SocialSettingsKeys.OAUTH_FOURSQUARE_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            default: {
                return null;
            }
        }
        return service;
    }

    @Override
    public void addSetting(String key, Class<?> clazz) throws UserManagementException {
        if (!SecurityServiceImpl.isValidSettingsKey(key)) {
            throw new UserManagementException("Invalid key!");
        }
        this.apply(new AddSettingOperation(key, clazz));
    }

    @Override
    public Void internalAddSetting(String key, Class<?> clazz) {
        this.store.addSetting(key, clazz);
        return null;
    }

    public static boolean isValidSettingsKey(String key) {
        char[] characters;
        char[] cArray = characters = key.toCharArray();
        int n = characters.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetter(c) && c != '_') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void refreshSecurityConfig(ServletContext context) {
        logger.info("Refreshing security configuration!");
        IniWebEnvironment env = (IniWebEnvironment)WebUtils.getRequiredWebEnvironment((ServletContext)context);
        System.out.println("Env: " + env);
        FilterChainResolver resolver = env.getFilterChainResolver();
        System.out.println("Resolver: " + resolver);
        if (resolver instanceof PathMatchingFilterChainResolver) {
            PathMatchingFilterChainResolver pmfcr = (PathMatchingFilterChainResolver)resolver;
            FilterChainManager filterChainManager = pmfcr.getFilterChainManager();
            System.out.println(filterChainManager);
            Set chainNames = filterChainManager.getChainNames();
            System.out.println("Chains:");
            for (String s : chainNames) {
                System.out.println(String.valueOf(s) + ": " + Arrays.toString(filterChainManager.getChain(s).toArray((Object[])new Filter[0])));
            }
        }
    }

    @Override
    public ReplicatingCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void setPreference(String username, String key, String value) {
        this.apply(new SetPreferenceOperation(username, key, value));
    }

    @Override
    public void setPreferenceObject(String username, String key, Object value) {
        String preferenceObjectAsString = this.internalSetPreferenceObject(username, key, value);
        this.apply(new SetPreferenceOperation(username, key, preferenceObjectAsString));
    }

    @Override
    public Void internalSetPreference(String username, String key, String value) {
        this.store.setPreference(username, key, value);
        return null;
    }

    @Override
    public String internalSetPreferenceObject(String username, String key, Object value) {
        return this.store.setPreferenceObject(username, key, value);
    }

    @Override
    public void unsetPreference(String username, String key) {
        this.apply(new UnsetPreferenceOperation(username, key));
    }

    @Override
    public Void internalUnsetPreference(String username, String key) {
        this.store.unsetPreference(username, key);
        return null;
    }

    @Override
    public Void internalSetAccessToken(String username, String accessToken) {
        this.store.setAccessToken(username, accessToken);
        return null;
    }

    @Override
    public String getAccessToken(String username) {
        return this.store.getAccessToken(username);
    }

    @Override
    public String getOrCreateAccessToken(String username) {
        String result = this.store.getAccessToken(username);
        if (result == null) {
            result = this.createAccessToken(username);
        }
        return result;
    }

    @Override
    public String getOrCreateTargetServerBearerToken(String targetServerUrlAsString, String targetServerUsername, String targetServerPassword, String targetServerBearerToken) {
        if ((Util.hasLength((String)targetServerUsername) || Util.hasLength((String)targetServerPassword)) && Util.hasLength((String)targetServerBearerToken)) {
            IllegalArgumentException e = new IllegalArgumentException("Please use either username/password or bearer token, not both.");
            logger.log(Level.WARNING, e.getMessage(), e);
            throw e;
        }
        User user = this.getCurrentUser();
        String effectiveTargetServerBearerToken = !Util.hasLength((String)targetServerUsername) && !Util.hasLength((String)targetServerPassword) && !Util.hasLength((String)targetServerBearerToken) ? (user == null ? null : this.getOrCreateAccessToken(user.getName())) : targetServerBearerToken;
        String token = !Util.hasLength((String)effectiveTargetServerBearerToken) ? (targetServerUsername != null ? RemoteServerUtil.resolveBearerTokenForRemoteServer(targetServerUrlAsString, targetServerUsername, targetServerPassword) : null) : effectiveTargetServerBearerToken;
        return token;
    }

    @Override
    public Void internalRemoveAccessToken(String username) {
        this.store.removeAccessToken(username);
        return null;
    }

    @Override
    public String getPreference(String username, String key) {
        return this.store.getPreference(username, key);
    }

    @Override
    public Map<String, String> getAllPreferences(String username) {
        return this.store.getAllPreferences(username);
    }

    @Override
    public String createAccessToken(String username) {
        String token;
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " is requesting a new access token for user " + username);
        User user = this.getUserByName(username);
        if (user != null) {
            SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
            byte[] salt = rng.nextBytes().getBytes();
            token = this.hashPassword(new String(rng.nextBytes().getBytes()), salt);
            this.apply(new SetAccessTokenOperation(user.getName(), token));
        } else {
            token = null;
        }
        return token;
    }

    @Override
    public void removeAccessToken(String username) {
        Subject subject = SecurityUtils.getSubject();
        if (!this.hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getUserByName(username))) {
            throw new AuthorizationException("User " + subject.getPrincipal().toString() + " does not have permission to remove access token of user " + username);
        }
        logger.info("Subject " + subject.getPrincipal() + " is removing the access token for user " + username);
        this.apply(new RemoveAccessTokenOperation(username));
    }

    @Override
    public UserGroup getServerGroup() {
        return this.store.getServerGroup();
    }

    @Override
    public <T> T setOwnershipCheckPermissionForObjectCreationAndRevertOnError(HasPermissions type, TypeRelativeObjectIdentifier typeIdentifier, String securityDisplayName, Callable<T> actionWithResult) {
        return this.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(type, typeIdentifier, securityDisplayName, actionWithResult, true);
    }

    private <T> T setOwnershipCheckPermissionForObjectCreationAndRevertOnError(HasPermissions type, TypeRelativeObjectIdentifier typeRelativeIdentifier, String securityDisplayName, Callable<T> actionWithResult, boolean doServerCreateObjectCheck) {
        QualifiedObjectIdentifier identifier = type.getQualifiedObjectIdentifier(typeRelativeIdentifier);
        T result = null;
        boolean didSetOwnership = false;
        try {
            OwnershipAnnotation preexistingOwnership = this.getOwnership(identifier);
            if (preexistingOwnership == null) {
                didSetOwnership = true;
                this.setDefaultOwnership(identifier, securityDisplayName);
            } else {
                logger.fine("Preexisting ownership found for " + identifier + ": " + preexistingOwnership);
            }
            if (doServerCreateObjectCheck) {
                this.checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CREATE_OBJECT);
            }
            try {
                SecurityUtils.getSubject().checkPermission(identifier.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CREATE));
            }
            catch (AuthorizationException e) {
                if (didSetOwnership) {
                    throw e;
                }
                throw new UnauthorizedException(MessageFormat.format("You are not permitted to create a \"{0}\" with name or identifier \"{1}\". This is most probably caused by an already existing entry with the same name/identifier. Please try to use a different name.", identifier.getTypeIdentifier(), identifier.getTypeRelativeObjectIdentifier().toString()), (Throwable)e);
            }
            result = actionWithResult.call();
        }
        catch (AuthorizationException e) {
            if (didSetOwnership) {
                this.deleteOwnership(identifier);
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public boolean hasCurrentUserServerPermission(SecuredSecurityTypes.ServerActions action) {
        return SecurityUtils.getSubject().isPermitted(this.constructServerPermissionString(action));
    }

    @Override
    public void checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions action) {
        SecurityUtils.getSubject().checkPermission(this.constructServerPermissionString(action));
    }

    private String constructServerPermissionString(SecuredSecurityTypes.ServerActions action) {
        return SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)action, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()}));
    }

    @Override
    public <T> T setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(HasPermissions type, TypeRelativeObjectIdentifier typeIdentifier, String securityDisplayName, Callable<T> actionWithResult) {
        return this.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(type, typeIdentifier, securityDisplayName, actionWithResult, false);
    }

    @Override
    public void setDefaultOwnership(QualifiedObjectIdentifier identifier, String description) {
        this.setOwnership(identifier, this.getCurrentUser(), this.getDefaultTenantForCurrentUser(), description);
    }

    @Override
    public void setDefaultOwnershipIfNotSet(QualifiedObjectIdentifier identifier) {
        OwnershipAnnotation preexistingOwnership = this.getOwnership(identifier);
        if (preexistingOwnership == null || preexistingOwnership.getAnnotation() == null || ((Ownership)preexistingOwnership.getAnnotation()).getTenantOwner() == null && ((Ownership)preexistingOwnership.getAnnotation()).getUserOwner() == null) {
            this.setDefaultOwnership(identifier, identifier.toString());
        }
    }

    @Override
    public void setOwnershipCheckPermissionForObjectCreationAndRevertOnError(HasPermissions type, TypeRelativeObjectIdentifier typeRelativeObjectIdentifier, String securityDisplayName, Action actionToCreateObject) {
        this.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(type, typeRelativeObjectIdentifier, securityDisplayName, () -> {
            actionToCreateObject.run();
            return null;
        });
    }

    @Override
    public void setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(HasPermissions type, TypeRelativeObjectIdentifier typeRelativeObjectIdentifier, String securityDisplayName, Action actionToCreateObject) {
        this.setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(type, typeRelativeObjectIdentifier, securityDisplayName, () -> {
            actionToCreateObject.run();
            return null;
        });
    }

    @Override
    public void setOwnershipIfNotSet(QualifiedObjectIdentifier identifier, User user, UserGroup tenantOwner) {
        OwnershipAnnotation preexistingOwnership = this.getOwnership(identifier);
        if (preexistingOwnership == null || preexistingOwnership.getAnnotation() == null || ((Ownership)preexistingOwnership.getAnnotation()).getTenantOwner() == null && ((Ownership)preexistingOwnership.getAnnotation()).getUserOwner() == null) {
            this.setOwnership(identifier, user, tenantOwner, identifier.toString());
        }
    }

    @Override
    public User checkPermissionForUserCreationAndRevertOnErrorForUserCreation(String username, Callable<User> createActionReturningCreatedObject) throws UserManagementException {
        QualifiedObjectIdentifier identifier = SecuredSecurityTypes.USER.getQualifiedObjectIdentifier(UserImpl.getTypeRelativeObjectIdentifier((String)username));
        User result = null;
        try {
            SecurityUtils.getSubject().checkPermission(identifier.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.CREATE));
            result = createActionReturningCreatedObject.call();
        }
        catch (AuthorizationException e) {
            logger.warning("Unauthorized request to create user with name \"" + username + "\": " + e.getMessage());
            throw e;
        }
        catch (UserManagementException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public void checkPermissionAndDeleteOwnershipForObjectRemoval(WithQualifiedObjectIdentifier object, Action actionToDeleteObject) {
        this.checkPermissionAndDeleteOwnershipForObjectRemoval(object, () -> {
            actionToDeleteObject.run();
            return null;
        });
    }

    @Override
    public <T> T checkPermissionAndDeleteOwnershipForObjectRemoval(WithQualifiedObjectIdentifier object, Callable<T> actionToDeleteObject) {
        QualifiedObjectIdentifier identifier = object.getIdentifier();
        return this.checkPermissionAndDeleteOwnershipForObjectRemoval(identifier, actionToDeleteObject);
    }

    @Override
    public <T> T checkPermissionAndDeleteOwnershipForObjectRemoval(QualifiedObjectIdentifier identifier, Callable<T> actionToDeleteObject) {
        try {
            SecurityUtils.getSubject().checkPermission(identifier.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.DELETE));
            T result = actionToDeleteObject.call();
            this.deleteAllDataForRemovedObject(identifier);
            return result;
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkPermissionAndDeleteOwnershipForObjectRemoval(QualifiedObjectIdentifier identifier, Action actionToDeleteObject) {
        this.checkPermissionAndDeleteOwnershipForObjectRemoval(identifier, () -> {
            actionToDeleteObject.run();
            return null;
        });
    }

    @Override
    public void deleteAllDataForRemovedObject(QualifiedObjectIdentifier identifier) {
        this.deleteOwnership(identifier);
        this.deleteAccessControlList(identifier);
    }

    @Override
    public <T extends WithQualifiedObjectIdentifier> void filterObjectsWithPermissionForCurrentUser(HasPermissions.Action action, Iterable<T> objectsToFilter, Consumer<T> filteredObjectsConsumer) {
        objectsToFilter.forEach(objectToCheck -> {
            if (SecurityUtils.getSubject().isPermitted((Permission)new ShiroWildcardPermissionFromParts(objectToCheck.getIdentifier().getPermission(action)))) {
                filteredObjectsConsumer.accept(objectToCheck);
            }
        });
    }

    @Override
    public <T extends WithQualifiedObjectIdentifier> void filterObjectsWithAnyPermissionForCurrentUser(HasPermissions.Action[] actions, Iterable<T> objectsToFilter, Consumer<T> filteredObjectsConsumer) {
        objectsToFilter.forEach(objectToCheck -> {
            boolean isPermitted = false;
            int i = 0;
            while (i < actions.length) {
                if (SecurityUtils.getSubject().isPermitted((Permission)new ShiroWildcardPermissionFromParts(objectToCheck.getIdentifier().getPermission(actions[i])))) {
                    isPermitted = true;
                    break;
                }
                ++i;
            }
            if (isPermitted) {
                filteredObjectsConsumer.accept(objectToCheck);
            }
        });
    }

    @Override
    public <T extends WithQualifiedObjectIdentifier, R> List<R> mapAndFilterByReadPermissionForCurrentUser(Iterable<T> objectsToFilter, Function<T, R> filteredObjectsMapper) {
        ArrayList result = new ArrayList();
        this.filterObjectsWithPermissionForCurrentUser((HasPermissions.Action)HasPermissions.DefaultActions.READ, objectsToFilter, filteredObject -> {
            boolean bl = result.add(filteredObjectsMapper.apply(filteredObject));
        });
        return result;
    }

    @Override
    public <T extends WithQualifiedObjectIdentifier, R> List<R> mapAndFilterByAnyExplicitPermissionForCurrentUser(HasPermissions permittedObject, HasPermissions.Action[] actions, Iterable<T> objectsToFilter, Function<T, R> filteredObjectsMapper) {
        ArrayList result = new ArrayList();
        this.filterObjectsWithAnyPermissionForCurrentUser(actions, objectsToFilter, filteredObject -> {
            boolean bl = result.add(filteredObjectsMapper.apply(filteredObject));
        });
        return result;
    }

    @Override
    public User getAllUser() {
        return this.store.getUserByName("<all>");
    }

    @Override
    public boolean hasCurrentUserMetaPermission(WildcardPermission permissionToCheck, Ownership ownership) {
        return PermissionChecker.checkMetaPermission((WildcardPermission)permissionToCheck, (Iterable)this.hasPermissionsProvider.getAllHasPermissions(), (SecurityUser)this.getCurrentUser(), (SecurityUser)this.getAllUser(), (AbstractOwnership)ownership, this.aclResolver);
    }

    @Override
    public boolean hasCurrentUserMetaPermissionWithOwnershipLookup(WildcardPermission permissionToCheck) {
        return PermissionChecker.checkMetaPermissionWithOwnershipResolution((WildcardPermission)permissionToCheck, (Iterable)this.hasPermissionsProvider.getAllHasPermissions(), (SecurityUser)this.getCurrentUser(), (SecurityUser)this.getAllUser(), qualifiedObjectId -> {
            OwnershipAnnotation ownershipAnnotation = this.accessControlStore.getOwnership(qualifiedObjectId);
            return ownershipAnnotation == null ? null : (Ownership)ownershipAnnotation.getAnnotation();
        }, this.aclResolver);
    }

    @Override
    public boolean hasCurrentUserAnyPermission(WildcardPermission permissionToCheck) {
        User currentUser = this.getCurrentUser();
        return PermissionChecker.hasUserAnyPermission((WildcardPermission)permissionToCheck, (Iterable)this.hasPermissionsProvider.getAllHasPermissions(), (SecurityUser)currentUser, (SecurityUser)this.getAllUser(), null);
    }

    @Override
    public boolean hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(RoleDefinition roleDefinition, Ownership qualificationForGrantedPermissions) {
        boolean result = true;
        for (WildcardPermission permissionToCheck : roleDefinition.getPermissions()) {
            if (this.hasCurrentUserMetaPermission(permissionToCheck, qualificationForGrantedPermissions)) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public boolean hasCurrentUserMetaPermissionsOfRoleDefinitionsWithQualification(Set<RoleDefinition> roleDefinitions, Ownership qualificationForGrantedPermissions) {
        boolean result = true;
        for (RoleDefinition roleDefinition : roleDefinitions) {
            if (!(result &= this.hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(roleDefinition, qualificationForGrantedPermissions))) break;
        }
        return result;
    }

    @Override
    public RoleDefinition getOrCreateRoleDefinitionFromPrototype(RolePrototype rolePrototype, boolean makeReadableForAll) {
        AccessControlListAnnotation acl;
        Set allowedActions;
        RoleDefinition result;
        RoleDefinition potentiallyExistingRoleDefinition = this.store.getRoleDefinition(rolePrototype.getId());
        if (potentiallyExistingRoleDefinition == null) {
            result = this.store.createRoleDefinition(rolePrototype.getId(), rolePrototype.getName(), (Iterable)rolePrototype.getPermissions());
            this.setOwnership(result.getIdentifier(), null, this.getServerGroup());
        } else if (rolePrototype.getPermissions() != null && !rolePrototype.getPermissions().equals(potentiallyExistingRoleDefinition.getPermissions())) {
            RoleDefinition roleDefinition;
            this.store.setRoleDefinitionPermissions(potentiallyExistingRoleDefinition.getId(), rolePrototype.getPermissions());
            result = roleDefinition = this.store.getRoleDefinition(rolePrototype.getId());
        } else {
            result = potentiallyExistingRoleDefinition;
        }
        if (makeReadableForAll && !(allowedActions = ((AccessControlList)(acl = this.getOrCreateAccessControlList(result.getIdentifier())).getAnnotation()).getAllowedActions(null)).contains(HasPermissions.DefaultActions.READ.name())) {
            this.addToAccessControlList(result.getIdentifier(), null, HasPermissions.DefaultActions.READ.name());
        }
        return result;
    }

    @Override
    public void setCORSFilterConfigurationToWildcard(String serverName) {
        this.apply((SecurityOperation & Serializable)s -> s.internalSetCORSFilterConfigurationToWildcard(serverName));
    }

    @Override
    public Void internalSetCORSFilterConfigurationToWildcard(String serverName) {
        if (Util.equalsWithNull((Object)serverName, (Object)ServerInfo.getName())) {
            this.getCORSFilterConfiguration().setWildcard();
        }
        this.corsFilterConfigurationsByReplicaSetName.put(serverName, (Util.Pair<Boolean, Set<String>>)new Util.Pair((Object)true, Collections.emptySet()));
        PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory().storeCORSFilterConfigurationIsWildcard(serverName);
        return null;
    }

    @Override
    public void setCORSFilterConfigurationAllowedOrigins(String serverName, String ... allowedOrigins) throws IllegalArgumentException {
        String[] stringArray = allowedOrigins;
        int n = allowedOrigins.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedOrigin = stringArray[n2];
            if (!HttpHeaderUtil.isValidOriginHeaderValue((String)allowedOrigin)) {
                throw new IllegalArgumentException("\"" + allowedOrigin + "\" is not a valid format for a CORS origin");
            }
            ++n2;
        }
        this.apply((SecurityOperation & Serializable)s -> s.internalSetCORSFilterConfigurationAllowedOrigins(serverName, allowedOrigins));
    }

    @Override
    public Void internalSetCORSFilterConfigurationAllowedOrigins(String serverName, String ... allowedOrigins) {
        List<Object> allowedOriginsAsList;
        List<Object> list = allowedOriginsAsList = allowedOrigins == null ? Collections.emptyList() : Arrays.asList(allowedOrigins);
        if (Util.equalsWithNull((Object)serverName, (Object)ServerInfo.getName())) {
            this.getCORSFilterConfiguration().setOrigins(allowedOriginsAsList);
        }
        this.corsFilterConfigurationsByReplicaSetName.put(serverName, (Util.Pair<Boolean, Set<String>>)new Util.Pair((Object)false, (Object)Util.asNewSet(allowedOriginsAsList)));
        PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory().storeCORSFilterConfigurationAllowedOrigins(serverName, allowedOrigins);
        return null;
    }

    @Override
    public Util.Pair<Boolean, Set<String>> getCORSFilterConfiguration(String serverName) {
        return (Util.Pair)this.corsFilterConfigurationsByReplicaSetName.get(serverName);
    }

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
        this.store.clear();
        this.accessControlStore.clear();
        this.corsFilterConfigurationsByReplicaSetName.clear();
        this.clientIPBasedTimedLocksForBearerTokenAuthentication.clear();
        this.clientIPBasedTimedLocksForUserCreation.clear();
    }

    public Serializable getId() {
        return this.getClass().getName();
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return new ObjectInputStreamResolvingAgainstSecurityCache(is, this.store, null, classLoaderCache);
    }

    public void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        logger.info("Reading cache manager...");
        ReplicatingCacheManager newCacheManager = (ReplicatingCacheManager)is.readObject();
        this.cacheManager.replaceContentsFrom(newCacheManager);
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        if (this.store != null) {
            Thread.currentThread().setContextClassLoader(this.store.getClass().getClassLoader());
        }
        logger.info("Reading user store...");
        boolean createdServerGroup = false;
        try {
            UserStore newUserStore = (UserStore)is.readObject();
            UserGroup newServerGroup = newUserStore.getUserGroupByName(this.store.getServerGroupName());
            UserGroup oldServerGroup = this.store.getServerGroup();
            this.store.replaceContentsFrom(newUserStore);
            if (newServerGroup == null) {
                String serverGroupName = this.store.getServerGroupName();
                UUID serverGroupUuid = UUID.randomUUID();
                this.createUserGroupWithInitialUser(serverGroupUuid, serverGroupName, null);
                this.store.setServerGroup(this.store.getUserGroupByName(this.store.getServerGroupName()));
                createdServerGroup = true;
            } else if (newServerGroup != oldServerGroup) {
                this.store.setServerGroup(newServerGroup);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        if (this.accessControlStore != null) {
            Thread.currentThread().setContextClassLoader(this.accessControlStore.getClass().getClassLoader());
        }
        logger.info("Reading access control store...");
        try {
            AccessControlStore newAccessControlStore = (AccessControlStore)is.readObject();
            this.accessControlStore.replaceContentsFrom(newAccessControlStore);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        this.migrateServerObject();
        if (createdServerGroup) {
            UserGroup serverGroup = this.store.getServerGroup();
            this.setOwnership(serverGroup.getIdentifier(), null, serverGroup, serverGroup.getName());
            User adminUserOrNull = this.store.getUserByName(ADMIN_DEFAULT_PASSWORD);
            if (adminUserOrNull == null) {
                logger.info("User 'admin' does not exist on replicated central SecurityService. 'admin' will not be properly set up for this server.");
            } else {
                this.addUserToUserGroup(serverGroup, adminUserOrNull);
                this.setDefaultTenantForCurrentServerForUser(ADMIN_DEFAULT_PASSWORD, serverGroup.getId());
            }
            this.isNewServer = true;
        }
        this.isInitialOrMigration = false;
        logger.info("Reading isSharedAcrossSubdomains...");
        this.sharedAcrossSubdomainsOf = (String)is.readObject();
        logger.info("...as " + this.sharedAcrossSubdomainsOf);
        logger.info("Reading baseUrlForCrossDomainStorage...");
        this.baseUrlForCrossDomainStorage = (String)is.readObject();
        logger.info("...as " + this.baseUrlForCrossDomainStorage);
        logger.info("Reading CORS filter configurations and possibly more...");
        SecurityServiceInitialLoadExtensionsDTO initialLoadExtensions = (SecurityServiceInitialLoadExtensionsDTO)is.readObject();
        ConcurrentMap<String, Util.Pair<Boolean, Set<String>>> newCORSFilterConfigurations = initialLoadExtensions.getCorsFilterConfigurationsByReplicaSetName();
        this.corsFilterConfigurationsByReplicaSetName.putAll(newCORSFilterConfigurations);
        if (initialLoadExtensions.getClientIPBasedTimedLocksForBearerTokenAuthentication() != null) {
            this.clientIPBasedTimedLocksForBearerTokenAuthentication.putAll(initialLoadExtensions.getClientIPBasedTimedLocksForBearerTokenAuthentication());
        }
        if (initialLoadExtensions.getClientIPBasedTimedLocksForUserCreation() != null) {
            this.clientIPBasedTimedLocksForUserCreation.putAll(initialLoadExtensions.getClientIPBasedTimedLocksForUserCreation());
        }
        logger.info("Triggering SecurityInitializationCustomizers upon replication ...");
        this.customizers.forEach(c -> c.customizeSecurityService(this));
        logger.info("Done filling SecurityService");
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.cacheManager);
        objectOutputStream.writeObject(this.store);
        objectOutputStream.writeObject(this.accessControlStore);
        objectOutputStream.writeObject(this.sharedAcrossSubdomainsOf);
        objectOutputStream.writeObject(this.baseUrlForCrossDomainStorage);
        objectOutputStream.writeObject(new SecurityServiceInitialLoadExtensionsDTO(this.corsFilterConfigurationsByReplicaSetName, this.clientIPBasedTimedLocksForBearerTokenAuthentication, this.clientIPBasedTimedLocksForUserCreation));
    }

    @Override
    public boolean migrateOwnership(WithQualifiedObjectIdentifier identifier) {
        return this.migrateOwnership(identifier.getIdentifier(), identifier.getName());
    }

    @Override
    public boolean migrateOwnership(QualifiedObjectIdentifier identifier, String displayName) {
        return this.migrateOwnership(identifier, null, true, displayName);
    }

    @Override
    public void migrateUser(User user) {
        if (this.migrateOwnership(user.getIdentifier(), user, false, user.getName())) {
            String tenantNameForUsername = this.getDefaultTenantNameForUsername(user.getName());
            if (user.getDefaultTenant(ServerInfo.getName()) == null && this.getUserGroupByName(tenantNameForUsername) == null) {
                try {
                    UserGroup tenantForUser = this.getOrCreateTenantForUser(user);
                    this.setDefaultTenantForCurrentServerForUser(user.getName(), tenantForUser.getId());
                }
                catch (UserGroupManagementException e) {
                    logger.log(Level.SEVERE, "Error during migration while creating tenant for user: " + user, e);
                }
                this.addUserRoleToUser(user);
                RoleDefinition adminRoleDefinition = this.getRoleDefinition(AdminRole.getInstance().getId());
                for (Role roleOfUser : user.getRoles()) {
                    if (!roleOfUser.getRoleDefinition().equals(adminRoleDefinition)) continue;
                    UserGroup serverGroup = this.getServerGroup();
                    if (roleOfUser.getQualifiedForTenant() != null && !((UserGroup)roleOfUser.getQualifiedForTenant()).equals(serverGroup)) continue;
                    this.addUserToUserGroup(serverGroup, user);
                    if (!ADMIN_DEFAULT_PASSWORD.equals(user.getName())) continue;
                    this.setDefaultTenantForCurrentServerForUser(user.getName(), this.getServerGroup().getId());
                }
            }
        }
    }

    @Override
    public void migratePermission(User user, WildcardPermission permissionToMigrate, Function<WildcardPermission, WildcardPermission> permissionReplacement) {
        WildcardPermission effectivePermission;
        WildcardPermission replacementPermissionOrNull = permissionReplacement.apply(permissionToMigrate);
        if (replacementPermissionOrNull != null) {
            String username = user.getName();
            this.removePermissionFromUser(username, permissionToMigrate);
            this.addPermissionForUser(username, replacementPermissionOrNull);
            effectivePermission = replacementPermissionOrNull;
        } else {
            effectivePermission = permissionToMigrate;
        }
        TypeRelativeObjectIdentifier associationTypeIdentifier = PermissionAndRoleAssociation.get((WildcardPermission)effectivePermission, (User)user);
        QualifiedObjectIdentifier associationQualifiedIdentifier = SecuredSecurityTypes.PERMISSION_ASSOCIATION.getQualifiedObjectIdentifier(associationTypeIdentifier);
        this.migrateOwnership(associationQualifiedIdentifier, associationQualifiedIdentifier.toString());
    }

    private boolean migrateOwnership(QualifiedObjectIdentifier identifier, User userOwnerToSet, boolean setServerGroupAsOwner, String displayName) {
        boolean wasNecessaryToMigrate = false;
        OwnershipAnnotation owner = this.getOwnership(identifier);
        if (owner == null || ((Ownership)owner.getAnnotation()).getTenantOwner() == null && ((Ownership)owner.getAnnotation()).getUserOwner() == null) {
            UserGroup tenantOwnerToSet = setServerGroupAsOwner ? this.getServerGroup() : null;
            logger.info("missing Ownership fixed: Setting ownership for: " + identifier + " to tenant: " + tenantOwnerToSet + "; user: " + userOwnerToSet);
            this.setOwnership(identifier, userOwnerToSet, tenantOwnerToSet, displayName);
            wasNecessaryToMigrate = true;
        }
        this.migratedHasPermissionTypes.add(identifier.getTypeIdentifier());
        return wasNecessaryToMigrate;
    }

    @Override
    public void migrateServerObject() {
        QualifiedObjectIdentifier serverIdentifier = SecuredSecurityTypes.SERVER.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()}));
        this.migrateOwnership(serverIdentifier, serverIdentifier.toString());
    }

    @Override
    public void checkMigration(Iterable<? extends HasPermissions> allInstances) {
        Class<?> clazz = ((HasPermissions)Util.first(allInstances)).getClass();
        boolean allChecksSucessful = true;
        for (HasPermissions hasPermissions : allInstances) {
            if (this.migratedHasPermissionTypes.contains(hasPermissions.getName())) continue;
            logger.severe("ensure Ownership failed: Did not check Ownerships for " + clazz.getName() + " missing: " + hasPermissions);
            allChecksSucessful = false;
        }
        if (allChecksSucessful) {
            logger.info("Ownership checks finished: Sucessfully checked all types in " + clazz.getName());
        }
    }

    @Override
    public boolean hasCurrentUserReadPermission(WithQualifiedObjectIdentifier object) {
        return object == null ? true : SecurityUtils.getSubject().isPermitted(object.getPermissionType().getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.READ, object));
    }

    @Override
    public boolean hasCurrentUserUpdatePermission(WithQualifiedObjectIdentifier object) {
        return object == null ? true : SecurityUtils.getSubject().isPermitted(object.getPermissionType().getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, object));
    }

    @Override
    public boolean hasCurrentUserDeletePermission(WithQualifiedObjectIdentifier object) {
        return object == null ? true : SecurityUtils.getSubject().isPermitted(object.getPermissionType().getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.DELETE, object));
    }

    @Override
    public boolean hasCurrentUserExplicitPermissions(WithQualifiedObjectIdentifier object, HasPermissions.Action ... actions) {
        boolean isPermitted = true;
        if (object != null) {
            int i = 0;
            while (i < actions.length) {
                isPermitted &= SecurityUtils.getSubject().isPermitted(object.getPermissionType().getStringPermissionForObject(actions[i], object));
                ++i;
            }
        }
        return isPermitted;
    }

    @Override
    public boolean hasCurrentUserOneOfExplicitPermissions(WithQualifiedObjectIdentifier object, HasPermissions.Action ... actions) {
        boolean result;
        boolean bl = result = object == null;
        if (object != null) {
            HasPermissions.Action[] actionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                HasPermissions.Action action = actionArray[n2];
                if (this.hasCurrentUserExplicitPermissions(object, action)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public void checkCurrentUserReadPermission(WithQualifiedObjectIdentifier object) {
        if (object != null) {
            SecurityUtils.getSubject().checkPermission(object.getPermissionType().getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.READ, object));
        }
    }

    @Override
    public void checkCurrentUserUpdatePermission(WithQualifiedObjectIdentifier object) {
        if (object != null) {
            SecurityUtils.getSubject().checkPermission(object.getPermissionType().getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, object));
        }
    }

    @Override
    public void checkCurrentUserDeletePermission(WithQualifiedObjectIdentifier object) {
        if (object != null) {
            SecurityUtils.getSubject().checkPermission(object.getPermissionType().getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.DELETE, object));
        }
    }

    @Override
    public void checkCurrentUserDeletePermission(QualifiedObjectIdentifier identifier) {
        if (identifier != null) {
            SecurityUtils.getSubject().checkPermission(identifier.getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.DELETE));
        }
    }

    @Override
    public void checkCurrentUserExplicitPermissions(WithQualifiedObjectIdentifier object, HasPermissions.Action ... actions) {
        if (object != null) {
            int i = 0;
            while (i < actions.length) {
                SecurityUtils.getSubject().checkPermission(object.getPermissionType().getStringPermissionForObject(actions[i], object));
                ++i;
            }
        }
    }

    @Override
    public void checkCurrentUserHasOneOfExplicitPermissions(WithQualifiedObjectIdentifier object, HasPermissions.Action ... actions) {
        if (object != null) {
            boolean isPermitted = false;
            int i = 0;
            while (i < actions.length) {
                if (SecurityUtils.getSubject().isPermitted(object.getPermissionType().getStringPermissionForObject(actions[i], object))) {
                    isPermitted = true;
                    break;
                }
                ++i;
            }
            if (!isPermitted) {
                throw new AuthorizationException();
            }
        }
    }

    @Override
    public void assumeOwnershipMigrated(String typeName) {
        this.migratedHasPermissionTypes.add(typeName);
    }

    @Override
    public boolean hasUserAllWildcardPermissionsForAlreadyRealizedQualifications(RoleDefinition role, Iterable<WildcardPermission> permissionsToCheck) {
        Util.Pair qualificationsToCheck = this.store.getExistingQualificationsForRoleDefinition(role);
        Iterable<Object> effectiveQualificationsToCheck = Boolean.TRUE.equals(qualificationsToCheck.getA()) ? Collections.singletonList(null) : (Iterable)qualificationsToCheck.getB();
        for (WildcardPermission permission : permissionsToCheck) {
            for (Ownership ownership : effectiveQualificationsToCheck) {
                if (this.hasCurrentUserMetaPermission(permission, ownership)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public <T> T getPreferenceObject(String username, String key) {
        return (T)this.store.getPreferenceObject(username, key);
    }

    @Override
    public <T> Map<String, T> getPreferenceObjectsByKey(String key) {
        return this.store.getPreferenceObjectsByKey(key);
    }

    @Override
    public void setDefaultTenantForCurrentServerForUser(String username, UUID defaultTenantId) {
        String serverName = ServerInfo.getName();
        this.apply(new SetDefaultTenantForServerForUserOperation(username, defaultTenantId, serverName));
    }

    @Override
    public Void internalSetDefaultTenantForServerForUser(String username, UUID defaultTenantId, String serverName) {
        User user = this.getUserByName(username);
        UserGroup newDefaultTenant = this.getUserGroup(defaultTenantId);
        this.store.setDefaultTennantForUserAndUpdate(user, newDefaultTenant, serverName);
        return null;
    }

    @Override
    public void copyUsersAndRoleAssociations(UserGroup source, UserGroup destination, SecurityService.RoleCopyListener callback) {
        for (User user : source.getUsers()) {
            this.addUserToUserGroup(destination, user);
        }
        for (Map.Entry entry : source.getRoleDefinitionMap().entrySet()) {
            this.putRoleDefinitionToUserGroup(destination, (RoleDefinition)entry.getKey(), (Boolean)entry.getValue());
        }
        for (Util.Pair pair : this.store.getRolesQualifiedByUserGroup(source)) {
            Role existingRole = (Role)pair.getB();
            Role copyRole = new Role(existingRole.getRoleDefinition(), destination, (User)existingRole.getQualifiedForUser(), existingRole.isTransitive());
            this.addRoleForUser((User)pair.getA(), copyRole);
            callback.onRoleCopy((User)pair.getA(), existingRole, copyRole);
        }
    }

    @Override
    public <T> T doWithTemporaryDefaultTenant(UserGroup tenant, Callable<T> action) {
        UserGroup previousValue = this.temporaryDefaultTenant.get();
        this.temporaryDefaultTenant.set(tenant);
        try {
            T t = action.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.temporaryDefaultTenant.set(previousValue);
        }
    }

    public void clearState() throws Exception {
        this.clientIPBasedTimedLocksForBearerTokenAuthentication.clear();
        this.clientIPBasedTimedLocksForUserCreation.clear();
    }

    @Override
    public void storeSession(String cacheName, Session session) {
        PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory().storeSession(cacheName, session);
    }

    @Override
    public void removeSession(String cacheName, Session session) {
        PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory().removeSession(cacheName, session);
    }

    @Override
    public void removeAllSessions(String cacheName) {
        PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory().removeAllSessions(cacheName);
    }

    @Override
    public boolean isInitialOrMigration() {
        return this.isInitialOrMigration;
    }

    @Override
    public boolean isNewServer() {
        return this.isNewServer;
    }

    @Override
    public String getSharedAcrossSubdomainsOf() {
        return this.sharedAcrossSubdomainsOf;
    }

    @Override
    public String getBaseUrlForCrossDomainStorage() {
        return this.baseUrlForCrossDomainStorage;
    }

    @Override
    public void registerCustomizer(SecurityInitializationCustomizer customizer) {
        this.customizers.add(customizer);
        customizer.customizeSecurityService(this);
    }

    @Override
    public void updateUserSubscription(String username, Subscription newSubscription) throws UserManagementException {
        User user = this.getUserByName(username);
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        this.apply(new UpdateUserSubscriptionOperation(username, newSubscription));
    }

    @Override
    public Void internalUpdateSubscription(String username, Subscription newSubscription) throws UserManagementException {
        User user = this.getUserByName(username);
        if (user != null) {
            this.lockSubscriptionsForUser(user);
            try {
                String newSubscriptionPlanId = newSubscription.getPlanId();
                Subscription currentSubscription = user.getSubscriptionByPlan(newSubscriptionPlanId);
                if (this.shouldProcessNewSubscription(currentSubscription, newSubscription)) {
                    Subscription[] newSubscriptions;
                    logger.info(() -> "Update user subscription for plan " + newSubscriptionPlanId);
                    logger.info(() -> "Current user plan subscription: " + (currentSubscription != null ? currentSubscription.toString() : "null"));
                    logger.info(() -> "New plan subscription: " + (newSubscription != null ? newSubscription.toString() : "null"));
                    if (currentSubscription != null && newSubscription != null && newSubscription.getSubscriptionId() != null && newSubscription.getSubscriptionId().equals(currentSubscription.getSubscriptionId())) {
                        if (currentSubscription.getTransactionStatus() != null && newSubscription.getTransactionStatus() == null) {
                            newSubscription.patchTransactionData(currentSubscription);
                        }
                        if (currentSubscription.getInvoiceId() != null && newSubscription.getInvoiceId() == null) {
                            newSubscription.patchInvoiceData(currentSubscription);
                        }
                    }
                    if (this.shouldUpdateUserRolesForSubscription(user, currentSubscription, newSubscription)) {
                        this.updateUserRolesOnSubscriptionChange(user, currentSubscription, newSubscription);
                    }
                    if ((newSubscriptions = this.buildNewUserSubscriptions(user, newSubscription)) != null) {
                        user.setSubscriptions(newSubscriptions);
                    }
                    this.store.updateUser(user);
                } else {
                    logger.info(() -> "New subscription has been ignored: " + newSubscription);
                }
                return null;
            }
            finally {
                this.unlockSubscriptionsForUser(user);
            }
        }
        throw new UserManagementException("User does not exist");
    }

    private boolean shouldProcessNewSubscription(Subscription currentSubscription, Subscription newSubscription) {
        boolean shouldProcess = !newSubscription.hasPlan() ? true : (this.subscriptionPlanProvider.getAllSubscriptionPlans().get(newSubscription.getPlanId()) != null ? (currentSubscription == null ? true : (!newSubscription.hasSubscriptionId() ? newSubscription.isUpdatedMoreRecently(currentSubscription) : newSubscription.getSubscriptionCreatedAt().asMillis() >= currentSubscription.getSubscriptionCreatedAt().asMillis())) : false);
        return shouldProcess;
    }

    private Subscription[] buildNewUserSubscriptions(User user, Subscription newSubscription) {
        Subscription[] newUserSubscriptions = null;
        Iterable subscriptions = user.getSubscriptions();
        if (newSubscription != null) {
            if (subscriptions == null || !subscriptions.iterator().hasNext()) {
                newUserSubscriptions = new Subscription[]{newSubscription};
            } else if (!newSubscription.hasPlan()) {
                ArrayList<Subscription> newSubscriptionList = new ArrayList<Subscription>();
                for (Subscription subscription : subscriptions) {
                    if (subscription.getProviderName().equals(newSubscription.getProviderName())) continue;
                    newSubscriptionList.add(subscription);
                }
                newSubscriptionList.add(newSubscription);
                newUserSubscriptions = newSubscriptionList.toArray(new Subscription[0]);
            } else {
                ArrayList<Subscription> newSubscriptionList = new ArrayList<Subscription>();
                boolean foundCurrentSubscription = false;
                for (Subscription subscription : subscriptions) {
                    if (!foundCurrentSubscription && (!subscription.hasPlan() && subscription.getProviderName().equals(newSubscription.getProviderName()) || subscription.getPlanId().equals(newSubscription.getPlanId()))) {
                        newSubscriptionList.add(newSubscription);
                        foundCurrentSubscription = true;
                        continue;
                    }
                    newSubscriptionList.add(subscription);
                }
                if (!foundCurrentSubscription) {
                    newSubscriptionList.add(newSubscription);
                }
                newUserSubscriptions = newSubscriptionList.toArray(new Subscription[0]);
            }
        }
        return newUserSubscriptions;
    }

    private void updateUserRolesOnSubscriptionChange(User user, Subscription currentSubscription, Subscription newSubscription) throws UserManagementException {
        logger.info(() -> "Update user subscription roles for user " + user.getName());
        Map allSubscriptionPlans = this.subscriptionPlanProvider.getAllSubscriptionPlans();
        if (newSubscription != null && !newSubscription.hasPlan()) {
            Collection plans = allSubscriptionPlans.values();
            for (SubscriptionPlan plan : plans) {
                this.removeUserPlanRoles(user, plan, true);
            }
        } else {
            assert (currentSubscription == null || newSubscription == null || currentSubscription.getPlanId().equals(newSubscription.getPlanId()));
            if (currentSubscription != null && currentSubscription.hasPlan() && currentSubscription.isActiveSubscription() && newSubscription != null && !newSubscription.isActiveSubscription()) {
                SubscriptionPlan currentPlan = (SubscriptionPlan)allSubscriptionPlans.get(currentSubscription.getPlanId());
                this.removeUserPlanRoles(user, currentPlan, true);
            }
            if (newSubscription != null && newSubscription.hasPlan() && newSubscription.isActiveSubscription()) {
                SubscriptionPlan newPlan = (SubscriptionPlan)allSubscriptionPlans.get(newSubscription.getPlanId());
                this.addUserPlanRoles(user, newPlan);
            }
        }
    }

    private void removeUserPlanRoles(User user, SubscriptionPlan plan, boolean checkOverlappingRoles) throws UserManagementException {
        if (plan != null) {
            logger.info(() -> "Remove user roles of subscription plan " + plan.getId());
            Role[] rolesToRemove = checkOverlappingRoles ? this.getSubscriptionPlanUserRolesWithoutOverlapping(user, plan) : this.getSubscriptionPlanUserRoles(user, plan);
            logger.info(() -> "Removing the following roles of subscription plan " + plan.getId() + " from user " + user.getName() + ": " + Arrays.asList(rolesToRemove));
            Role[] roleArray = rolesToRemove;
            int n = rolesToRemove.length;
            int n2 = 0;
            while (n2 < n) {
                Role role = roleArray[n2];
                this.store.removeRoleFromUser(user.getName(), role);
                ++n2;
            }
        }
    }

    private void addUserPlanRoles(User user, SubscriptionPlan plan) throws UserManagementException {
        if (plan != null) {
            logger.info(() -> "Add user roles for subscription plan " + plan.getId());
            Role[] roles = this.getSubscriptionPlanUserRoles(user, plan);
            logger.info(() -> "Adding the following roles of subscription plan " + plan.getId() + " to user " + user.getName() + ": " + Arrays.asList(roles));
            Role[] roleArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                Role role = roleArray[n2];
                this.addRoleForUserAndSetUserAsOwner(user, role);
                ++n2;
            }
        }
    }

    @Override
    public Role[] getSubscriptionPlanUserRoles(User user, SubscriptionPlan plan) {
        ArrayList<Role> roles = new ArrayList<Role>();
        SubscriptionPlanRole[] subscriptionPlanRoleArray = plan.getRoles();
        int n = subscriptionPlanRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubscriptionPlanRole planRole = subscriptionPlanRoleArray[n2];
            roles.add(this.getSubscriptionPlanUserRole(user, planRole));
            ++n2;
        }
        return roles.toArray(new Role[0]);
    }

    private Role[] getSubscriptionPlanUserRolesWithoutOverlapping(User user, SubscriptionPlan plan) {
        HashSet<Role> otherPlanRoles = new HashSet<Role>();
        Iterable subscriptions = user.getSubscriptions();
        for (Subscription subscription : subscriptions) {
            if (!subscription.isActiveSubscription() || subscription.getPlanId().equals(plan.getId())) continue;
            SubscriptionPlan otherPlan = (SubscriptionPlan)this.subscriptionPlanProvider.getAllSubscriptionPlans().get(subscription.getPlanId());
            SubscriptionPlanRole[] subscriptionPlanRoleArray = otherPlan.getRoles();
            int n = subscriptionPlanRoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                SubscriptionPlanRole planRole = subscriptionPlanRoleArray[n2];
                otherPlanRoles.add(this.getSubscriptionPlanUserRole(user, planRole));
                ++n2;
            }
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        SubscriptionPlanRole[] subscriptionPlanRoleArray = plan.getRoles();
        int n = subscriptionPlanRoleArray.length;
        int n3 = 0;
        while (n3 < n) {
            SubscriptionPlanRole planRole = subscriptionPlanRoleArray[n3];
            Role role = this.getSubscriptionPlanUserRole(user, planRole);
            if (!otherPlanRoles.contains(role)) {
                roles.add(role);
            }
            ++n3;
        }
        return roles.toArray(new Role[0]);
    }

    private Role getSubscriptionPlanUserRole(User user, SubscriptionPlanRole planRole) {
        Role result;
        User qualifiedUser = this.getSubscriptionPlanRoleQualifiedUser(user, planRole);
        UserGroup qualifiedTenant = this.getSubscriptionPlanRoleQualifiedTenant(user, qualifiedUser, planRole);
        RoleDefinition roleDefinition = this.getRoleDefinition(planRole.getRoleId());
        if (roleDefinition == null) {
            logger.severe("Role with ID " + planRole.getRoleId() + " for user " + user.getName() + " not found.");
            result = null;
        } else {
            result = new Role(roleDefinition, qualifiedTenant, qualifiedUser, Boolean.valueOf(false));
        }
        return result;
    }

    private User getSubscriptionPlanRoleQualifiedUser(User user, SubscriptionPlanRole planRole) {
        User qualifiedUser = planRole.getUserQualificationMode() != null && planRole.getUserQualificationMode() == SubscriptionPlanRole.UserQualificationMode.SUBSCRIBING_USER ? user : (planRole.getExplicitUserQualification() != null && !planRole.getExplicitUserQualification().isEmpty() ? this.getUserByName(planRole.getExplicitUserQualification()) : null);
        return qualifiedUser;
    }

    private UserGroup getSubscriptionPlanRoleQualifiedTenant(User subscriptionUser, User qualifiedUser, SubscriptionPlanRole planRole) {
        Object qualifiedForGroup;
        SubscriptionPlanRole.GroupQualificationMode groupQualificationMode = planRole.getGroupQualificationMode();
        if (groupQualificationMode != null && groupQualificationMode != SubscriptionPlanRole.GroupQualificationMode.NONE) {
            User u;
            switch (groupQualificationMode) {
                case DEFAULT_QUALIFIED_USER_TENANT: {
                    if (qualifiedUser != null) {
                        u = qualifiedUser;
                        break;
                    }
                    u = null;
                    break;
                }
                case SUBSCRIBING_USER_DEFAULT_TENANT: {
                    if (subscriptionUser != null) {
                        u = subscriptionUser;
                        break;
                    }
                    u = null;
                    break;
                }
                default: {
                    u = null;
                }
            }
            qualifiedForGroup = u != null ? this.getUserGroupByName(this.getDefaultTenantNameForUsername(u.getName())) : null;
        } else {
            qualifiedForGroup = planRole.getIdOfExplicitGroupQualification() != null ? this.getUserGroup(planRole.getIdOfExplicitGroupQualification()) : null;
        }
        return qualifiedForGroup;
    }

    private boolean shouldUpdateUserRolesForSubscription(User user, Subscription currentSubscription, Subscription newSubscription) {
        boolean result;
        if (currentSubscription == null && newSubscription == null) {
            result = false;
        } else if (newSubscription == null) {
            result = false;
        } else if (!newSubscription.hasPlan()) {
            boolean isUserInPossessionOfRoles = false;
            for (SubscriptionPlan subscriptionPlan : this.getAllSubscriptionPlans().values()) {
                isUserInPossessionOfRoles = subscriptionPlan.isUserInPossessionOfRoles(user);
                if (isUserInPossessionOfRoles) break;
            }
            result = isUserInPossessionOfRoles;
        } else if (currentSubscription == null || currentSubscription.getPlanId() == null) {
            SubscriptionPlan subscriptionPlanById = this.getSubscriptionPlanById(newSubscription.getPlanId());
            result = subscriptionPlanById == null ? false : newSubscription.isActiveSubscription() || subscriptionPlanById.isUserInPossessionOfRoles(user);
        } else {
            SubscriptionPlan subscriptionPlanById;
            assert (currentSubscription.getPlanId().equals(newSubscription.getPlanId()));
            result = newSubscription.isActiveSubscription() != currentSubscription.isActiveSubscription() ? true : !(subscriptionPlanById = this.getSubscriptionPlanById(newSubscription.getPlanId())).isUserInPossessionOfRoles(user);
        }
        return result;
    }

    @Override
    public void addPermissionChangeListener(WildcardPermission permission, PermissionChangeListener listener) {
        this.permissionChangeListeners.addPermissionChangeListener(permission, listener);
    }

    @Override
    public void removePermissionChangeListener(WildcardPermission permission, PermissionChangeListener listener) {
        this.permissionChangeListeners.removePermissionChangeListener(permission, listener);
    }

    @Override
    public void updateSubscriptionPlanPrices(Map<String, BigDecimal> itemPrices) {
        this.apply(new UpdateItemPriceOperation(itemPrices));
    }

    @Override
    public Void internalUpdateSubscriptionPlanPrices(Map<String, BigDecimal> updatedItemPrices) {
        Map<Serializable, SubscriptionPlan> allSubscriptionPlans = this.getAllSubscriptionPlans();
        for (SubscriptionPlan subscriptionPlan : allSubscriptionPlans.values()) {
            for (SubscriptionPrice subscriptionPrice : subscriptionPlan.getPrices()) {
                BigDecimal updatedPrice = updatedItemPrices.get(subscriptionPrice.getPriceId());
                if (updatedPrice == null) continue;
                logger.log(Level.INFO, "Setting ItemPrice for SubscriptionPrice " + subscriptionPrice.getPriceId());
                subscriptionPrice.setPrice(updatedPrice);
            }
        }
        return null;
    }

    @Override
    public Role createRoleFromIDs(UUID roleDefinitionId, UUID qualifyingTenantId, String qualifyingUsername, boolean transitive) throws UserManagementException {
        UserGroup group;
        User user;
        if (qualifyingUsername == null || qualifyingUsername.trim().isEmpty()) {
            user = null;
        } else {
            user = this.getUserByName(qualifyingUsername);
            if (user == null) {
                throw new UserManagementException("User " + qualifyingUsername + " not found for role qualification");
            }
        }
        if (qualifyingTenantId == null) {
            group = null;
        } else {
            group = this.getUserGroup(qualifyingTenantId);
            if (group == null) {
                throw new UserManagementException("Group with ID " + qualifyingTenantId + " not found for role qualification");
            }
        }
        RoleDefinition roleDefinition = this.getRoleDefinition(roleDefinitionId);
        if (roleDefinition == null) {
            throw new UserManagementException("Role definition with ID " + roleDefinitionId + " not found");
        }
        return new Role(roleDefinition, group, user, Boolean.valueOf(transitive));
    }

    @Override
    public Role getOrThrowRoleFromIDsAndCheckMetaPermissions(UUID roleDefinitionId, UUID tenantId, String userQualifierName, boolean transitive) throws UserManagementException {
        Role role = this.createRoleFromIDs(roleDefinitionId, tenantId, userQualifierName, transitive);
        if (!this.hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(role.getRoleDefinition(), role.getQualificationAsOwnership())) {
            throw new UserManagementException("You are not allowed to take this role to the user.");
        }
        return role;
    }

    @Override
    public void lockSubscriptionsForUser(User user) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)subscriptionLocksForUsers.computeIfAbsent(user, u -> new NamedReentrantReadWriteLock("Subscriptions lock for user " + user.getName(), false)));
    }

    @Override
    public void unlockSubscriptionsForUser(User user) {
        LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)subscriptionLocksForUsers.computeIfAbsent(user, u -> new NamedReentrantReadWriteLock("Subscriptions lock for user " + user.getName(), false)));
    }

    @Override
    public void fileTakedownNotice(TakedownNoticeRequestContext takedownNoticeRequestContext) throws MailException {
        String SUPPORT_MAIL_ADDRESS = "support@sapsailing.com";
        User user = this.getUserByName(takedownNoticeRequestContext.getUsername());
        String email = user.getEmail();
        StringBuilder sb = new StringBuilder().append("User ").append(takedownNoticeRequestContext.getUsername()).append(" with e-mail ").append(email).append(" requests that the media with URL ").append(takedownNoticeRequestContext.getContentUrl()).append(" used in context ").append(messages.get(Locale.ENGLISH, takedownNoticeRequestContext.getContextDescriptionMessageKey(), new String[]{takedownNoticeRequestContext.getContextDescriptionMessageParameter()})).append(" on page ").append(takedownNoticeRequestContext.getPageUrl()).append(" be removed from the site. The user provides the following comment:\n\n").append("   \"").append(takedownNoticeRequestContext.getReportingUserComment()).append("\"\n\n").append("The claim is of nature ").append(takedownNoticeRequestContext.getNatureOfClaim()).append(".");
        if (!Util.isEmpty((Iterable)takedownNoticeRequestContext.getSupportingURLs())) {
            sb.append("\n\nThe user provided the following additional URLs to substantiate or prove the claim:\n");
            for (String url : takedownNoticeRequestContext.getSupportingURLs()) {
                sb.append(" - ");
                sb.append(url);
                sb.append("\n");
            }
        }
        String message = sb.toString();
        this.getMailService().sendMail("support@sapsailing.com", "Media Take-Down Request", message);
        this.getMailService().sendMail(email, "Media Take-Down Request Confirmation", messages.get(user.getLocaleOrDefault(), "takedownRequestConfirmation", new String[]{Util.hasLength((String)user.getFullName()) ? user.getFullName() : user.getName(), "support@sapsailing.com", message}));
    }

    @Override
    public Iterable<User> getUsersToInformAboutReplicaSet(String serverName, Optional<HasPermissions.Action> alsoSendToAllUsersWithThisPermissionOnReplicaSet) {
        User serverOwner;
        QualifiedObjectIdentifier serverIdentifier = SecuredSecurityTypes.SERVER.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{serverName}));
        OwnershipAnnotation serverOwnership = this.getOwnership(serverIdentifier);
        HashSet<User> usersToSendMailTo = new HashSet<User>();
        if (serverOwnership != null && serverOwnership.getAnnotation() != null && (serverOwner = (User)((Ownership)serverOwnership.getAnnotation()).getUserOwner()) != null) {
            usersToSendMailTo.add(serverOwner);
        }
        alsoSendToAllUsersWithThisPermissionOnReplicaSet.ifPresent(serverAction -> this.getUsersWithPermissions(serverIdentifier.getPermission(serverAction)).forEach(usersToSendMailTo::add));
        return usersToSendMailTo;
    }

    @Override
    public void internalReleaseUserCreationLockOnIp(String ip) {
        if (this.clientIPBasedTimedLocksForUserCreation.containsKey(ip)) {
            this.clientIPBasedTimedLocksForUserCreation.remove(ip);
        }
    }

    @Override
    public void internalReleaseBearerTokenLockOnIp(String ip) {
        if (this.clientIPBasedTimedLocksForBearerTokenAuthentication.containsKey(ip)) {
            this.clientIPBasedTimedLocksForBearerTokenAuthentication.remove(ip);
        }
    }
}

