/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.impl;

import com.sap.sse.common.Named;
import com.sap.sse.security.impl.Activator;
import com.sap.sse.security.impl.ReplicableSecurityService;
import com.sap.sse.security.operations.ClearReplicatingCacheOperation;
import com.sap.sse.security.operations.PutToReplicatingCacheOperation;
import com.sap.sse.security.operations.RemoveFromReplicatingCacheOperation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.session.Session;

public class ReplicatingCache<K, V>
implements Cache<K, V>,
Named {
    private static final Logger logger = Logger.getLogger(ReplicatingCache.class.getName());
    private static final long serialVersionUID = 6628512191363526330L;
    private transient ReplicableSecurityService securityService;
    private final String name;
    private final ConcurrentMap<K, V> cache;

    public ReplicatingCache(ReplicableSecurityService securityService, String name) {
        this.securityService = securityService;
        this.name = name;
        this.cache = new ConcurrentHashMap();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.securityService = (ReplicableSecurityService)Activator.getSecurityService();
    }

    public String getName() {
        return this.name;
    }

    public V get(K key) throws CacheException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("get(" + key + ") on " + this.name + "@" + System.identityHashCode(this) + "=" + this.cache.get(key));
        }
        return this.cache.get(key);
    }

    public V put(K key, V value) throws CacheException {
        return this.put(key, value, true);
    }

    public V put(K key, V value, boolean store) throws CacheException {
        Session session;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("put(" + key + ", " + value + ") into cache " + this.name + "@" + System.identityHashCode(this));
            if (value instanceof Session) {
                Session session2 = (Session)value;
                this.logSession(session2);
            }
        }
        V result = this.cache.put(key, value);
        if (store && value instanceof Session && !(session = (Session)value).getAttributeKeys().isEmpty()) {
            this.securityService.replicate(new PutToReplicatingCacheOperation<K, V>(this.getName(), key, value));
            this.securityService.storeSession(this.getName(), (Session)value);
        }
        return result;
    }

    private void logSession(Session session) {
        StringBuilder sb = new StringBuilder();
        for (Object key : session.getAttributeKeys()) {
            sb.append("  ");
            sb.append(key);
            sb.append("=");
            sb.append(session.getAttribute(key));
            sb.append("\n");
        }
        logger.finer("Session:\n" + sb.toString());
    }

    public V remove(K key) throws CacheException {
        Object result = this.cache.remove(key);
        this.securityService.replicate(new RemoveFromReplicatingCacheOperation<K>(this.getName(), key));
        if (result instanceof Session) {
            this.securityService.removeSession(this.getName(), (Session)result);
        }
        return result;
    }

    public void clear() throws CacheException {
        this.cache.clear();
        this.securityService.replicate(new ClearReplicatingCacheOperation(this.getName()));
        this.securityService.removeAllSessions(this.getName());
    }

    public int size() {
        return this.cache.size();
    }

    public Set<K> keys() {
        return this.cache.keySet();
    }

    public Collection<V> values() {
        return this.cache.values();
    }
}

