/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.security.impl.Activator;
import com.sap.sse.security.impl.PermissionConverter;
import com.sap.sse.security.interfaces.AccessControlStore;
import com.sap.sse.security.interfaces.UserStore;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.osgi.framework.BundleContext;

public abstract class AbstractCompositeAuthorizingRealm
extends AuthorizingRealm {
    private static final Logger logger = Logger.getLogger(AbstractCompositeAuthorizingRealm.class.getName());
    private final Future<UserStore> userStore;
    private final Future<AccessControlStore> accessControlStore;
    private static UserStore testUserStore;
    private static AccessControlStore testAccessControlStore;

    public static void setTestStores(UserStore theTestUserStore, AccessControlStore theTestAccessControlStore) {
        testUserStore = theTestUserStore;
        testAccessControlStore = theTestAccessControlStore;
    }

    public AbstractCompositeAuthorizingRealm() {
        this.setCachingEnabled(false);
        this.setPermissionResolver(wildcardString -> new org.apache.shiro.authz.permission.WildcardPermission(wildcardString, true));
        BundleContext context = Activator.getContext();
        if (context != null) {
            this.userStore = ServiceTrackerFactory.createServiceFuture((BundleContext)context, UserStore.class);
            this.accessControlStore = ServiceTrackerFactory.createServiceFuture((BundleContext)context, AccessControlStore.class);
        } else {
            this.userStore = null;
            this.accessControlStore = null;
        }
    }

    protected UserStore getUserStore() {
        UserStore result;
        if (testUserStore != null) {
            result = testUserStore;
        } else {
            try {
                result = this.userStore.get();
            }
            catch (InterruptedException | ExecutionException e) {
                result = null;
                logger.log(Level.SEVERE, "Error retrieving user store", e);
            }
        }
        return result;
    }

    protected AccessControlStore getAccessControlStore() {
        AccessControlStore result;
        if (testAccessControlStore != null) {
            result = testAccessControlStore;
        } else {
            try {
                result = this.accessControlStore.get();
            }
            catch (InterruptedException | ExecutionException e) {
                result = null;
                logger.log(Level.SEVERE, "Error retrieving access control list store", e);
            }
        }
        return result;
    }

    public boolean isPermitted(PrincipalCollection principals, Permission perm) {
        boolean result;
        String username = (String)principals.getPrimaryPrincipal();
        User user = this.getUserStore().getUserByName(username);
        WildcardPermission wildcardPermission = new PermissionConverter().getWildcardPermission(perm);
        List parts = wildcardPermission.getParts();
        if (parts.size() > 2 && !((Set)parts.get(2)).isEmpty()) {
            boolean allChecksPassed = true;
            for (QualifiedObjectIdentifier objectIdentifier : wildcardPermission.getQualifiedObjectIdentifiers()) {
                AccessControlListAnnotation acl;
                OwnershipAnnotation ownership = this.getAccessControlStore().getOwnership(objectIdentifier);
                allChecksPassed = this.isPermittedForUser(wildcardPermission, user, ownership, acl = this.getAccessControlStore().getAccessControlList(objectIdentifier));
                if (!allChecksPassed) break;
            }
            result = allChecksPassed;
        } else {
            result = this.isPermittedForUser(wildcardPermission, user, null, null);
        }
        return result;
    }

    private boolean isPermittedForUser(WildcardPermission wildcardPermission, User user, OwnershipAnnotation ownership, AccessControlListAnnotation acl) {
        User allUser = this.getUserStore().getUserByName("<all>");
        return PermissionChecker.isPermitted((WildcardPermission)wildcardPermission, (SecurityUser)user, (SecurityUser)allUser, (AbstractOwnership)(ownership == null ? null : (Ownership)ownership.getAnnotation()), acl == null ? null : (AccessControlList)acl.getAnnotation());
    }

    public boolean[] isPermitted(PrincipalCollection principals, List<Permission> permissions) {
        boolean[] result = new boolean[permissions.size()];
        int i = 0;
        while (i < permissions.size()) {
            result[i] = this.isPermitted(principals, permissions.get(i));
            ++i;
        }
        return result;
    }

    public boolean isPermittedAll(PrincipalCollection principals, Collection<Permission> permissions) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                if (this.isPermitted(principals, permission)) continue;
                return false;
            }
        }
        return true;
    }

    public void checkPermission(PrincipalCollection principals, Permission permission) throws AuthorizationException {
        if (!this.isPermitted(principals, permission)) {
            String msg = "User is not permitted [" + permission + "]";
            throw new UnauthorizedException(msg);
        }
    }

    public void checkPermissions(PrincipalCollection principals, Collection<Permission> permissions) throws AuthorizationException {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.checkPermission(principals, permission);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRole(PrincipalCollection principals, String roleName) {
        String user = (String)principals.getPrimaryPrincipal();
        try {
            Role role;
            Iterator iterator = this.getUserStore().getRolesFromUser(user).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(role = (Role)iterator.next()).getName().equals(roleName));
            return true;
        }
        catch (UserManagementException e) {
            logger.log(Level.SEVERE, "User " + user + " does not exist.", e);
            return false;
        }
    }

    public boolean[] hasRoles(PrincipalCollection principals, List<String> roleIdentifiers) {
        boolean[] result = new boolean[roleIdentifiers.size()];
        int i = 0;
        while (i < roleIdentifiers.size()) {
            result[i] = this.hasRole(principals, roleIdentifiers.get(i));
            ++i;
        }
        return result;
    }

    public boolean hasAllRoles(PrincipalCollection principals, Collection<String> roleIdentifiers) {
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            for (String role : roleIdentifiers) {
                if (this.hasRole(principals, role)) continue;
                return false;
            }
        }
        return true;
    }

    public void checkRole(PrincipalCollection principals, String role) throws AuthorizationException {
        if (!this.hasRole(principals, role)) {
            String msg = "User does not have role [" + role + "]";
            throw new UnauthorizedException(msg);
        }
    }

    public void checkRoles(PrincipalCollection principals, Collection<String> roles) throws AuthorizationException {
        if (roles != null && !roles.isEmpty()) {
            for (String role : roles) {
                this.checkRole(principals, role);
            }
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        throw new UnsupportedOperationException("Call to doGetAuthorizationInfo(PrincipalCollection principals. This should never happen!)");
    }
}

