/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.declination.impl.DeclinationRecordForExactTimePoint;
import com.sap.sailing.declination.impl.Geomagnetism;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.TreeMap;

public class WMMCalculatorDeclinationService
implements DeclinationService {
    private final TreeMap<TimePoint, Geomagnetism> worldMagneticModelsByIssueTimePoint;

    public WMMCalculatorDeclinationService() {
        String[] modelNames = new String[]{"/WMM2010.COF", "/WMM2015.COF", "/WMM2020.COF", "/WMM2025.COF"};
        this.worldMagneticModelsByIssueTimePoint = new TreeMap();
        try {
            String[] stringArray = modelNames;
            int n = modelNames.length;
            int n2 = 0;
            while (n2 < n) {
                String modelFileName = stringArray[n2];
                Geomagnetism model = new Geomagnetism(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(modelFileName))));
                this.worldMagneticModelsByIssueTimePoint.put(model.getStartOfValidity(), model);
                ++n2;
            }
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Declination getDeclination(TimePoint timePoint, Position position, long timeoutForOnlineFetchInMilliseconds) throws IOException, ParseException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(timePoint.asMillis());
        Geomagnetism.Result wmmResult = this.worldMagneticModelsByIssueTimePoint.floorEntry(timePoint).getValue().calculate(position.getLngDeg(), position.getLatDeg(), 0.0, calendar);
        return new DeclinationRecordForExactTimePoint(position, timePoint, (Bearing)new DegreeBearingImpl(wmmResult.getDeclination()));
    }

    @Override
    public Declination getDeclination(TimePoint timePoint, Position position, Distance maxDistance, long timeoutForOnlineFetchInMilliseconds) throws IOException, ParseException {
        return this.getDeclination(timePoint, position, timeoutForOnlineFetchInMilliseconds);
    }
}

