/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.declination.impl.DeclinationImporter;
import com.sap.sailing.declination.impl.DeclinationStore;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.quadtree.QuadTree;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import java.io.IOException;
import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class DeclinationServiceImplWithStore
implements DeclinationService {
    private final Distance defaultMaxDistance;
    private final DeclinationStore persistentStore;
    private final DeclinationImporter declinationImporter;
    private final Map<Integer, QuadTree<Declination>> yearStore;
    private final Map<Integer, QuadTree<Declination>> importerCache;

    public DeclinationServiceImplWithStore(Distance defaultMaxDistance, DeclinationImporter declinationImporter) {
        this.declinationImporter = declinationImporter;
        this.defaultMaxDistance = defaultMaxDistance;
        this.yearStore = new HashMap<Integer, QuadTree<Declination>>();
        this.persistentStore = new DeclinationStore(declinationImporter);
        this.importerCache = new HashMap<Integer, QuadTree<Declination>>();
    }

    @Override
    public Declination getDeclination(TimePoint timePoint, Position position, long timeoutForOnlineFetchInMilliseconds) throws IOException, ParseException {
        return this.getDeclination(timePoint, position, this.defaultMaxDistance, timeoutForOnlineFetchInMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Declination getDeclination(TimePoint timePoint, Position position, Distance maxDistance, long timeoutForOnlineFetchInMilliseconds) throws IOException, ParseException {
        QuadTree<Declination> quadTree;
        QuadTree<Declination> set;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(timePoint.asDate());
        Declination result = null;
        double minDistance = Double.MAX_VALUE;
        int step = -1;
        int year = cal.get(1);
        while ((set = this.getYearStore(year)) != null) {
            double distance;
            Declination resultForYear;
            quadTree = set;
            synchronized (quadTree) {
                resultForYear = (Declination)set.get(position);
            }
            Distance spatialDistance = resultForYear.getPosition().getDistance(position);
            if (spatialDistance.compareTo((Object)maxDistance) <= 0 && (distance = DeclinationServiceImplWithStore.timeAndSpaceDistance(spatialDistance, resultForYear.getTimePoint(), timePoint)) < minDistance) {
                result = resultForYear;
                minDistance = distance;
            }
            year += step;
            step = -step - (int)Math.signum(step);
        }
        if (result == null) {
            QuadTree importerCacheForYear = this.importerCache.get(year);
            if (importerCacheForYear != null) {
                quadTree = importerCacheForYear;
                synchronized (quadTree) {
                    result = (Declination)importerCacheForYear.get(position);
                }
                if (result.getPosition().getDistance(position).compareTo((Object)maxDistance) <= 0) {
                    return result;
                }
            }
            if ((result = this.declinationImporter.getDeclination(position, timePoint, timeoutForOnlineFetchInMilliseconds)) != null) {
                if (importerCacheForYear == null) {
                    importerCacheForYear = new QuadTree();
                    this.importerCache.put(year, (QuadTree<Declination>)importerCacheForYear);
                }
                quadTree = importerCacheForYear;
                synchronized (quadTree) {
                    importerCacheForYear.put(result.getPosition(), (Object)result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuadTree<Declination> getYearStore(int year) throws IOException, ParseException {
        QuadTree<Declination> result = this.yearStore.get(year);
        if (result == null) {
            DeclinationServiceImplWithStore declinationServiceImplWithStore = this;
            synchronized (declinationServiceImplWithStore) {
                result = this.yearStore.get(year);
                if (result == null && (result = this.persistentStore.getStoredDeclinations(year)) != null) {
                    this.yearStore.put(year, result);
                }
            }
        }
        return result;
    }

    static double timeAndSpaceDistance(Distance spatialDistance, TimePoint t1, TimePoint t2) {
        double nauticalMileDistance = spatialDistance.getNauticalMiles();
        long millisDistance = Math.abs(t1.asMillis() - t2.asMillis());
        return (double)millisDistance / 1000.0 / 3600.0 / 24.0 / 186.0 + nauticalMileDistance / 60.0;
    }
}

